indexing

   title:       "The project-wide universal properties: the class is an",
                "ancestor to the classes of The Ordering Machine (TOM) -",
                "the supplier of all kinds of linear orders used in USCL";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         guide, the_ordering_machine;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "is_pool_.e"

deferred class SIMPLE_POOL

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Operations

      extend (increment: INTEGER) is
            -- allocates memory for new slots
         require
            positive_increment: increment > 0
         local
            used, pos: INTEGER

         do
            if increment > 0 then

               used := capacity;
               resizing (used + increment);

               -- ... 'capacity' already keeps the updated value

               from
                  pos := capacity
               variant
                  increment + pos - capacity
               until
                  pos = used
               loop
                  next.put (pos - 1, pos);
                  pos := pos - 1
               end;

               next.put (first_free, pos + 1);
               first_free := capacity

            else
               target.halt (Current, "extend")
            end

         ensure
            well_done: (count = old count) and then
                       (capacity = old capacity + increment)
         end;

      get_free is
            -- finds a free slot and saves it in 'free'
         require
            real_pool: capacity > 0

         do
            free := first_free;
            if first_free /= 0 then
               first_free := next.item (first_free)
            end

         ensure
            well_done: (free >= 0 and then free <= capacity) and then
                       (free /= 0 implies stock = old stock - 1)
         end;

      make (host: SIMPLE_CONTAINER; init_size: INTEGER) is
            -- sets initial values of the guide: 'host' is the structure
            -- the guide belongs to and 'init_size' - the initial amount
            -- of slots to be allocated
         require
            valid_target:  host /= Void;
            positive_size: init_size > 0

         deferred
         ensure
            well_done: (target /= Void) and then
                       (stock = init_size) and then (stock = capacity)
         end;

      put (pos: INTEGER) is
            -- puts the new entry in order of the guide
         require
            proper_position: pos > 0 and then pos <= capacity;
            proper_sequence: pos = free

         deferred
         ensure
            well_done: count = old count + 1
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Queries

      free: INTEGER;             -- set by 'get_free' most recently to be used
                                 -- by the 'put' routine which must follow ...

      target: SIMPLE_CONTAINER;  -- the container attached to the ordering
                                 -- structure (the guide) and which keeps
         -- real data (at least elements or items) but not keys in case of
         -- two element entries like in any tables ...

      capacity: INTEGER is
            -- gives the total amount of slots currently allocated in the guide
         do
            Result := next.count
         end;

      stock: INTEGER is
            -- gives the amount of still unused slots in the guide
         require
            real_pool: capacity > 0

         local
            pos: INTEGER

         do
            from
               pos := first_free
            invariant
               pos >= 0 and then pos <= capacity
            variant
               capacity - Result
            until
               pos = 0
            loop
               Result := Result + 1;
               pos := next.item (pos)
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      first_free: INTEGER;   -- keeps the position of the first free slot

      next: ARRAY [INTEGER]; -- references to free and used slots (the next
                             -- entries) in two different chains

      resizing (new_size: INTEGER) is
            -- changes the amount of slots allocated
         require
            proper_argument: new_size > capacity

         deferred
         ensure
            well_done: capacity = new_size
         end

   ---------------------------------------------------------------------------
   invariant

      proper_free:  first_free >= 0 and then  first_free <= capacity;
      proper_stock: stock >= 0 and then  stock <= capacity

end -- deferred class SIMPLE_POOL