indexing

   title:       "Specific facilities of the guide for class SORTED_TABLE";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "is_or_wk.e"

class SIMPLE_ORDER_WITH_KEYS [H -> COMPARABLE]

   inherit
      SIMPLE_ORDER [H]
         redefine
            resizing
         end;

      WITH_KEYS_FOR_ORDERING [H]
         end

   creation {SIMPLE_CONTAINER}
      make

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      out_marker: INTEGER is
            -- gives zero once and forever ...
         once
         end;

      resizing (new_size: INTEGER) is
            -- changes the amount of slots allocated
         do
            keys.resize (1, new_size);
            left.resize (1, new_size);
            right.resize (1, new_size);
            color.resize (0, new_size);
            parent.resize (0, new_size)
         end

end -- class SIMPLE_ORDER_WITH_KEYS [H -> COMPARABLE]