indexing

   title:       "Specific facilities of the guide for class SORTED_LIST";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "is_or_oi.e"

class SIMPLE_ORDER_ON_ITEMS [G -> COMPARABLE]

   inherit
      SIMPLE_ORDER [G]
         redefine
            target
         end;

      ON_ITEMS_FOR_ORDERING [G]
         end

   creation {SORTED_LIST}
      make

   ---------------------------------------------------------------------------
   feature {SORTED_LIST} -- Operations

      make (host: SORTED_LIST [G]; init_size: INTEGER) is
            -- sets initial values of the guide: 'host' is the structure
            -- the guide belongs to and 'init_size' - the initial amount
            -- of slots to be allocated
         local
            pos: INTEGER

         do
            target := host;
            !!right.make (1, init_size);
            first_free := right.count;

            from
               pos := first_free
            until
               pos = 0
            loop
               right.put (pos - 1, pos);
               pos := pos - 1
            end;

            subsequent_init (init_size)
         end

   ---------------------------------------------------------------------------
   feature {SORTED_LIST} -- Queries

      target: SORTED_LIST [G] -- the structure the guide belongs to

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      out_marker: INTEGER is
            -- gives zero once and forever ...
         once
         end

end -- class SIMPLE_ORDER_ON_ITEMS [G -> COMPARABLE]