indexing

   title:       "Specific facilities of the guide for class SIMPLE_LIST";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         singly_linked_list;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "is_chn__.e"

class SIMPLE_CHAIN

   inherit
      SIMPLE_CHAIN_CORE
         end

   creation {SIMPLE_CONTAINER}
      make

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Operations

      make (host: SIMPLE_CONTAINER; init_size: INTEGER) is
            -- sets initial values of the guide: 'host' is the structure
            -- the guide belongs to and 'init_size' - the initial amount
            -- of slots to be allocated
         local
            pos: INTEGER

         do
            target := host;
            !!next.make (1, init_size);
            first_free := next.count;

            from
               pos := first_free
            until
               pos = 0
            loop
               next.put (pos - 1, pos);
               pos := pos - 1
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE}

      resizing (new_size: INTEGER) is
            -- increases the amount of slots allocated
         do
            next.resize (1, new_size)
         end

end -- class SIMPLE_CHAIN