indexing

   title:       "Universal facilities of the guide for class SIMPLE_LIST";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         singly_linked_list;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "is_chn_c.e"

deferred class SIMPLE_CHAIN_CORE

   inherit
      SIMPLE_POOL
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Operations

      put (pos: INTEGER) is
            -- puts the new entry in order of the guide
         do
            if pos = free then

               if entrance = 0 then
                  next.put (- pos, pos)

               else
                  next.put (next.item (entrance), pos);
                  next.put (pos, entrance);
                  check
                     positive: next.item (entrance) > 0
                  end
               end;

               entrance := pos;
               check
                  negative: next.item (entrance) < 0
               end

            else
               target.halt (Current, "put")
            end
         end;

      remove (pos: INTEGER) is
            -- brings the entry out of the order of the guide
         require
            proper_position: pos > 0 and then pos <= capacity;
            not_empty:       count > 0
         local
            prev_pos, next_pos, counter: INTEGER

         do
            from
               next_pos := - next.item (entrance)
            invariant
               next_pos > 0 and then next_pos <= capacity
            variant
               count - counter
            until
               next_pos = pos
            loop
               prev_pos := next_pos;
               next_pos := next.item (prev_pos);
               counter  := counter + 1
            end;

            if prev_pos = 0 then
               -- the first item is removing ...

               if entrance /= pos then
                  -- there are some other items in the list

                  next.put (- next.item (pos), entrance)

               else
                  -- the first item is the only item in the list

                  entrance := 0
               end

            else
               -- not the first item is removing ...

               if entrance = pos then
                  -- the last item is to be removed

                  next.put (next.item (pos), prev_pos);
                  entrance := prev_pos

               else
                  -- not the last item is to be removed

                  next.put (next.item (pos), prev_pos)
               end
            end;

            frozen_put_in_stock (pos)

         ensure
            well_done: count = old count - 1
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Queries

      count: INTEGER is
            -- gives the number of used slots
         local
            pos: INTEGER

         do
            from
               pos := first
            variant
               capacity - Result
            until
               pos = 0
            loop
               Result := Result + 1;
               pos := forth (pos)
            end
         end;

      first: INTEGER is
            -- gives the position of the first entry
         require
            real_pool: capacity > 0

         do
            if entrance /= 0 then
               Result := - next.item (entrance)
            else
               Result := 0
            end

         ensure
            well_done: Result >= 0 and then Result <= capacity
         end;

      forth (pos: INTEGER): INTEGER is
            -- gives the position of the next (about 'pos') entry
         require
            proper_position: pos > 0 and then pos <= capacity;
            not_empty:       first > 0

         do
            Result := next.item (pos)

            if Result < 0 then
               Result := 0
            end

         ensure
            well_done: Result >= 0 and then Result <= capacity
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      entrance: INTEGER; -- keeps the position of the last slot used

      put_in_stock, frozen frozen_put_in_stock (pos: INTEGER) is
            -- marks the slot as unused one
         require
            proper_position: pos > 0 and then pos <= capacity

         do
            next.put (first_free, pos);
            first_free := pos

         ensure
            well_done: stock >= old stock
         end

   ---------------------------------------------------------------------------
   invariant

      proper_count:    count >= 0 and then  count <= capacity;
      proper_entrance: entrance >= 0 and then entrance <= capacity

end -- deferred class SIMPLE_CHAIN_CORE