indexing

   title:       "An example of how HASH_TABLE might be used";
   cluster:     "containers/examples/hsh_table [contners/examples/hsh_tabl]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "(C) Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    26,Sep,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         hash_table_demo;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "hst_demo.e"

class HASH_TABLE_DEMO

   inherit
      INPUT_OUTPUT
         redefine
            error_message, error_the_second, the_second_upper_bound
         end;

      USCL_IO
         end

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      make is
            -- ...
         local
            found,
            err,
            out: BOOLEAN;
            i  : INTEGER;
            spl: SAMPLE;
            slr: SAMPLE_SUPPLIER;
            csr,
            ptr: CURSOR;
            lst: LIST [SAMPLE];
            tmp: HASH_TABLE [SAMPLE, SAMPLE]

         do
            !!slr.make;
            source := slr.sample_set_a;

            -- SELECT ONLY ONE PROPER 'make' OF THE FOLLOWING TWO !!!

            -- !!target.make (true, 7);
            !!target.make (false, 7);

            from
               show (csr, position);
               io.put_string ("%NDemo: ...%N");
               get_a_string ("Demo> ")

            until
               the_character = 'q'

            loop
               message := o_k_;
               command := Void;
               err := false;

               inspect

                  the_character

               when 'a' then                                     -- remove_all
                  if the_first > 0 and then the_second = 0 then
                     if target.has_key (source.item (the_first)) then
                        if target.is_protected then
                           message := table_is_protected
                        else
                           target.remove_all (source.item (the_first))
                        end
                     else
                        message := key_not_found
                     end
                  else
                     err := true
                  end

               when 'b' then                                           -- back
                  if the_first = 0 and then the_second = 0 then
                     if csr /= Void then
                        csr.back;
                        if csr.is_finished then
                           position := 0
                        else
                           position := position - 1
                        end
                     else
                        message := csr_not_created
                     end
                  else
                     err := true
                  end

               when 'c' then                                      -- cursor_at
                  if the_first /= 0 and then the_second /= 0 then
                     if csr /= Void and then not csr.is_finished then
                        csr.stop;
                        position := 0
                     end;
                     csr := target.cursor_at (source.item (the_first),
                               source.item (the_second));
                     if csr = Void then
                        if target.count = 0 then
                           message := table_is_empty
                        else
                           message := item_not_found
                        end
                     else
                        -- proper 'position' should be found ...

                        from
                           position := 1;
                           found   := false;
                           ptr    := target.cursor
                        until
                           found or else ptr.is_finished
                        loop
                           if target.key_at (ptr).is_equal
                                 (source.item (the_second)) and then
                              target.item_at (ptr).is_equal
                                 (source.item (the_first)) then

                              found := true
                           else
                              ptr.forth;
                              position := position + 1
                           end
                        end;
                        ptr.stop;
                        if not found then
                           message := unexpected_error;
                           position := 0
                        end
                     end
                  else
                     err := true
                  end

               when 'd' then                                           -- stop
                  if the_first = 0 and then the_second = 0 then
                     if csr /= Void then
                        if csr.is_finished then
                           message := csr_is_stopped
                        else
                           csr.stop;
                           position := 0
                        end
                     else
                        message := csr_not_created
                     end
                  else
                     err := true
                  end

               when 'h' then                                        -- has_key
                  if the_first > 0 and then the_second = 0 then
                     found := target.has_key (source.item (the_first));
                     command := has_key;
                     if found then
                        message := true_str
                     else
                        message := false_str
                     end
                  else
                     err := true
                  end

               when 'i' then                                   -- items_at_key
                  if the_first > 0 and then the_second = 0 then
                     lst := target.items_at_key (source.item (the_first));
                     if lst.empty then
                        message := key_not_found
                     else
                        print_list (lst);
                        out := true
                     end
                  else
                     err := true
                  end

               when 'k' then                                   -- current_keys
                  if the_first = 0 and then the_second = 0 then
                     lst := target.current_keys;
                     if lst.empty then
                        message := table_is_empty
                     else
                        print_list (lst);
                        out := true
                     end
                  else
                     err := true
                  end

               when 'l' then                                           -- last
                  if the_first = 0 and then the_second = 0 then
                     if csr /= Void then
                        csr.last;
                        if csr.is_finished then
                           message := table_is_empty
                        else
                           position := target.count
                        end
                     else
                        message := csr_not_created
                     end
                  else
                     err := true
                  end

               when 'm' then                                          -- merge
                  if the_first = 0 and then the_second = 0 then
                     if not target.is_protected then
                        !!tmp.make (target.unique_keys, 7);
                        from
                           i := 7
                        until
                           i > source.count
                        loop
                           tmp.put (source.item (i), source.item (i));
                           i := i + 7
                        end;
                        target.merge (tmp)
                     else
                        message := table_is_protected
                     end
                  else
                     err := true
                  end

               when 'n' then                                          -- forth
                  if the_first = 0 and then the_second = 0 then
                     if csr /= Void then
                        if not csr.is_finished then
                           csr.forth;
                           if csr.is_finished then
                              position := 0
                           else
                              position := position + 1
                           end
                        else
                           message := csr_is_stopped
                        end
                     else
                        message := csr_not_created
                     end
                  else
                     err := true
                  end

               when 'o' then                                       -- count_of
                  if the_first > 0 and then the_second = 0 then
                     command := count_of;
                     message := get_concatenated
                        (1, <<target.count_of (source.item (the_first))>>)
                  else
                     err := true
                  end

               when 'p' then                                            -- put
                  if the_first > 0 and then the_second > 0 then
                     if target.is_protected then
                        message := table_is_protected
                     else
                        target.put
                           (source.item (the_first), source.item (the_second))
                     end
                  else
                     err := true
                  end

               when 'r' then                                         -- remove
                  if the_first > 0 and then the_second > 0 then
                     if target.is_protected then
                        message := table_is_protected
                     else
                        lst := target.items_at_key (source.item (the_second));
                        if lst.has_item (source.item (the_first)) then
                           target.remove (source.item (the_first),
                                          source.item (the_second))
                        else
                           message := item_not_found
                        end
                     end
                  else
                     err := true
                  end

               when 's' then                                         -- search
                  if the_first > 0 and then the_second = 0 then
                     target.search (source.item (the_first));
                  else
                     err := true
                  end

               when 't' then                                          -- first
                  if the_first = 0 and then the_second = 0 then
                     if csr /= Void then
                        csr.first;
                        if csr.is_finished then
                           message := table_is_empty
                        else
                           position := 1
                        end
                     else
                        message := csr_not_created
                     end
                  else
                     err := true
                  end

               when 'w' then                                       -- wipe_out
                  if the_first = 0 and then the_second = 0 then
                     if target.is_protected then
                        message := table_is_protected
                     else
                        target.wipe_out
                     end
                  else
                     err := true
                  end

               when 'x' then                              -- allocate_manually
                  if the_first > 0 and then the_second = 0 then
                     if target.is_protected then
                        message := table_is_protected
                     else
                        target.allocate_manually (the_first)
                     end
                  else
                     err := true
                  end

               when 'y' then                                         -- cursor
                  if the_first = 0 and then the_second = 0 then
                     if csr /= Void and then not csr.is_finished then
                        csr.stop;
                        position := 0
                     end;
                     csr := target.cursor;
                     if csr.is_finished then
                        message := table_is_empty
                     else
                        position := 1
                     end
                  else
                     err := true
                  end

               when 'z' then                         -- allocate_automatically
                  if the_first = 0 and then the_second = 0 then
                     target.allocate_automatically
                  else
                     err := true
                  end

               when '/' then
                  -- used only to put the picture on the screen again
                  -- and again toggling between up or down ...
                  if down then
                     down := false
                  else
                     down := true
                  end;

               else
                  message := unknown_command
               end;

               if err then
                  message := syntax_error
               end;

               if not out then
                  show (csr, position)
               else
                  out := false
               end;

               io.put_string ("%NDemo: ");
               io.put_string (the_string);
               io.put_string (" -> ");

               if command /= Void then
                  io.put_string (command);
                  io.put_string (" = ")
               end;

               io.put_string (message);
               io.put_new_line;

               get_a_string ("Demo> ")
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      o_k_:      STRING is "done";
      true_str:  STRING is "true ";
      false_str: STRING is "false";

      error_str: STRING is "! ERROR !";
      empty_str: STRING is "         ";

      count_of:  STRING is "count_of (...)";
      has_key:   STRING is "has_key (...)";

      csr_is_stopped:     STRING is "cursor is 'stop'ped ...";
      csr_not_created:    STRING is "no cursor created ...";
      item_not_found:     STRING is "item not found ...";
      key_not_found:      STRING is "key not found ...";
      table_is_empty:     STRING is "table is empty ...";
      table_is_protected: STRING is "table is protected ...";
      unexpected_error:   STRING is "unexpected error ...";
      unknown_command:    STRING is "unknown command ...";
      syntax_error:       STRING is "syntax error ...";

      command:  STRING;
      down:     BOOLEAN;
      message:  STRING;
      position: INTEGER;
      pool:     ARRAY [STRING];
      source:   ARRAY [SAMPLE];
      target:   HASH_TABLE [SAMPLE, SAMPLE];

      show (ext_csr: CURSOR; index: INTEGER) is
            -- prints the main picture, if 'ext_csr /= Void' then
            -- "=>" indicates the current entry in the table on screen ...
         local
            i:        INTEGER;
            tmp, txt: STRING;
            int_csr:  CURSOR

         do
            io.put_string ("-- Samples --(HC)");
            from
               i := 1;
               int_csr := target.cursor;
               if target.empty or down then
                  io.put_string ("        Your Table       ")
               else
                  io.put_string ("  Table item, ___key___  ")
               end;
               io.put_string ("------------- Commands -------------%N")

            until
               i > source.count

            loop
               tmp := get_concatenated
                         (2, <<i, "  ", source.item (i).base, ',',
                         source.item (i).hash_code \\ target.capacity + 1,
                         "  ">>);

               if not int_csr.is_finished and then (not down or else
                     (down and then (i > 21 - target.count))) then

                  if not down and then i = index or else
                        (down and then (i = 21 - target.count + index)) then

                     tmp := get_united (tmp, "=>")
                  else
                     tmp := get_united (tmp, "  ")
                  end;
                  tmp := get_concatenated (0, <<tmp,
                            adjust_right (target.item_at (int_csr).base),
                            ", ", target.key_at (int_csr).base, "  ">>);
                  int_csr.forth
               else
                  tmp := get_united (tmp, "                        ");
               end;

               io.put_string (tmp);

               inspect
                  i
               when 1 then
                  io.put_string ("? = Help,    / = Refresh,  q = Quit")
               when 2 then
                  io.put_string ("b - back,    y - cursor,   t - first")
               when 3 then
                  io.put_string ("n - forth,   l - last,     d - stop")
               when 4 then
                  io.put_string ("")
               when 5 then
                  io.put_string ("X or K below - any number of Sample:")
               when 6 then
                  io.put_string ("oK   - count_of (k: H): INTEGER")
               when 7 then
                  io.put_string ("cX,K - cursor_at (x: G; k: H): ...")
               when 8 then
                  io.put_string ("k    - current_keys: LIST [H]")
               when 9 then
                  io.put_string ("hK   - has_key (k: H): BOOLEAN")
               when 10then
                  io.put_string ("iK   - items_at_key (k: H): LIST [G]")
               when 11 then
                  io.put_string ("m    - merge (...)")
               when 12 then
                  io.put_string ("pX,K - put (x: G; k: H)")
               when 13 then
                  io.put_string ("rX,K - remove (x: G; k: H)")
               when 14 then
                  io.put_string ("aK   - remove_all (k: H)")
               when 15 then
                  io.put_string ("sK   - search (k: H)")
               when 16 then
                  io.put_string ("w    - wipe_out")
               when 17 then
                  io.put_string ("------------------- HASH_TABLE LIVE:")
               when 18 then
                  io.put_string ("key_at : ");
                  if ext_csr /= Void and then not ext_csr.is_finished then
                     if target.key_at (ext_csr) /= Void then
                        io.put_string (target.key_at (ext_csr).base)
                     else
                        io.put_string (error_str)
                     end
                  else
                     io.put_string (empty_str)
                  end;
                  io.put_string (", empty = ");
                  if target.empty then
                     txt := true_str
                  else
                     txt := false_str
                  end;
                  io.put_string (txt)

               when 19 then
                  io.put_string ("item_at: ");
                  if ext_csr /= Void and then not ext_csr.is_finished then
                     if target.item_at (ext_csr) /= Void then
                        io.put_string (target.item_at (ext_csr).base)
                     else
                        io.put_string (error_str)
                     end
                  else
                     io.put_string (empty_str)
                  end;
                  io.put_string (", count = ");
                  io.put_string (get_concatenated (2, <<target.count>>))

               when 20 then
                  io.put_string ("found = ");
                  if target.found then
                     txt := true_str
                  else
                     txt := false_str
                  end;
                  io.put_string (txt);
                  io.put_string (", found_item: ");
                  if target.found then
                     if target.found_item /= Void then
                        io.put_string (target.found_item.base)
                     else
                        io.put_string (error_str)
                     end
                  end

               when 21 then
                  io.put_string ("capacity = ");
                  io.put_string (get_concatenated (4, <<target.capacity>>));
                  io.put_string (", unique_keys = ");
                  if target.unique_keys then
                     txt := true_str
                  else
                     txt := false_str
                  end;
                  io.put_string (txt)
               end;

               io.put_new_line;
               i := i + 1
            end;

            if down and then not target.empty then
               io.put_string ("-----------------  Table item, ___key___ ");
            else
               io.put_string ("-----------------------------------------");
            end;
            io.put_string (" is_protected = ");
            if target.is_protected then
               txt := true_str
            else
               txt := false_str
            end;
            io.put_string (txt);

            if not int_csr.is_finished then
               int_csr.stop
            end
         end;

      error_message is
            -- prints the error message in case of unqualified error ...
         do
            io.put_string (prompt);
            io.put_string ("the first symbol typed must be a letter%
                           % following one or two optional%N");
            io.put_string (prompt);
            io.put_string ("number(s through a comma) without blanks%
                           % between:  ? - help, q - exit%N")
         end;

      error_the_second is
            -- prints the error message (concerning the second number
            -- which can be inputted at any command ...
         do
            error_the_first
         end;

      the_second_upper_bound: INTEGER is
            -- gives the maximum possible value of 'the_second'
         once
            Result := 21
         end

end -- class HASH_TABLE_DEMO