indexing

   title:       "Hash tables: containers which store its two element entries",
                "(element or item itself and the associated key) widely",
                "using the ability of keys to be transformed into integers";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         hash_table, hash_value, two_way_traversable;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "hsh_tabl.e"

class HASH_TABLE [G, H -> HASHABLE]

   inherit
      TABLE [G, H]
         rename
            make as table_make
         export {NONE}
            table_make
         redefine
            default_size, extend, find_next, guide, table_make,
         end

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      make (is_unique: BOOLEAN; initial_capacity: INTEGER) is
            -- tells the container if its entries must be unigue and sets
            -- the initial amount of slots to be allocated for storing entries
         require
            proper_initial_slots: initial_capacity > 0

         do
            unique_keys := is_unique;
            if store = Void then
               default_size := initial_capacity
            end;
            !!store.make (1, initial_capacity);
            !!guide.make (Current, initial_capacity)
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      default_size: INTEGER; -- the amount of slots allocated at creation time

      guide: HASHING_WITH_KEYS [H]; -- the ordering structure of the container

      extend (new_capacity: INTEGER) is
            -- allocates memory for new slots
         do
            if new_capacity = 0 then
               if not no_reallocation then
                  -- ...
                  restructure (capacity * 2)
               end
            else
               restructure (new_capacity)
            end
         end;

      find_next (k: H; pos: INTEGER): INTEGER is
            -- finds the next entry (the current one is storing at 'pos')
            -- the element or item of which is associated with key 'k';
            -- traversal is towards the end of the table
         local
            done: BOOLEAN;
            key:  H

         do
            from
               Result := pos
            until
               Result = 0 or else done
            loop
               Result := guide.forth (Result);

               if Result > 0 then
                  key := guide.get_key (Result);
                  if k.hash_code /= key.hash_code then
                     Result := 0
                  elseif k.is_equal (key) then
                     done := true
                  end
               end
            end
         end;

      table_make (is_unique: BOOLEAN) is
            -- ..
         do
            make (is_unique, default_size + counterweight)
         end

end -- class HASH_TABLE [G, H -> HASHABLE]