indexing

   title:       "Hash lists: containers which store its one element entries",
                "widely using their ability to be associated with integers";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         hash_table, hash_value, two_way_traversable;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "hsh_list.e"

class HASH_LIST [G -> HASHABLE]

   inherit
      LIST [G]
         rename
            make as list_make
         export {NONE}
            list_make
         redefine
            default_size, extend, find_first, find_next, guide, list_make
         end

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      make (is_unique: BOOLEAN; initial_capacity: INTEGER) is
            -- tells the container if its entries must be unigue and sets
            -- the initial amount of slots to be allocated for storing entries
         require
            proper_initial_slots: initial_capacity > 0

         do
            unique_items := is_unique;
            if store = Void then
               default_size := initial_capacity
            end;

            !!store.make (1, initial_capacity);
            !!guide.make (Current, initial_capacity)
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      default_size: INTEGER; -- the amount of slots allocated at creation time

      guide: HASHING_ON_ITEMS [G]; -- the ordering structure of the container

      extend (new_capacity: INTEGER) is
            -- allocates memory for new slots
         do
            if new_capacity = 0 then
               if not no_reallocation then
                  -- ...
                  restructure (capacity * 2)
               end
            else
               restructure (new_capacity)
            end
         end;

      list_make (is_unique: BOOLEAN) is
            -- ...
         do
            make (is_unique, default_size + counterweight)
         end;

      find_first (x: G): INTEGER is
            -- finds the first copy of the entry in the list
         do
            Result := guide.search (x)
         end;

      find_next (x: G; pos: INTEGER): INTEGER is
            -- finds the duplicates of the entry which is stored at 'pos';
            -- traversal is towards the end of the list
         local
            done: BOOLEAN;
            item: G

         do
            from
               Result := pos
            until
               Result = 0 or else done
            loop
               Result := guide.forth (Result);

               if Result > 0 then
                  item := store.item (Result);
                  if x.hash_code /= item.hash_code then
                     Result := 0
                  elseif x.is_equal (item) then
                     done := true
                  end
               end
            end
         end

end -- class HASH_LIST [G -> HASHABLE]