indexing

   title:       "The project-wide universal properties: error handling",
                "facilities - the class may be used as ancestor by classes",
                "needing its facilities or as a supplier of them";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         exception, error_code, error_type;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "err_hdlr.e"

class ERROR_HANDLER

   inherit
      MISCELLANEOUS
         end;

      USCL_IO
         end

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      make is
            -- might be used by descendants and for initializing
            -- the proper 'error_types' also ...
         do
         end;

      err_report (name, msg: STRING; code: INTEGER; xobject: ANY) is
            -- builds error report according to the actual argument list,
            -- prints it and raises a user defined exception: if proper
            -- 'error_types.item (code)' is defined it'll be used as a 'msg'
            -- supplement otherwise only numeric 'code' is appended to ...
            --
         require
            valid_name:  name /= Void

         local
            error,
            injn1,
            injn2,
            stype: STRING;
            width: INTEGER

         do
            -- Building the final error message ...

            if msg /= Void and then msg.count > 0  then
               injn1 := " (";
               injn2 := ")"
            end;

            if error_types /= Void
                  and then error_types.item (code) /= Void
                  and then error_types.item (code).count > 0 then

               stype := error_types.item (code)
            else
               width := 1
            end;

            error := get_concatenated
                        (width, <<msg, injn1, "code ", stype, code, injn2>>);

            -- Printing out the error report ...

            io.put_string ("%NError: ");
            io.put_string (error);
            io.put_string (" at ");
            io.put_string (name);
            io.put_new_line;

            -- Stopping the execution ...

            shutdown (name, error, code, xobject)
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      error_types: ARRAY [STRING]

end -- class ERROR_HANDLER