indexing

   title:       "Cursors: tools for traversing all the ancestors",
                "of class TRAVERSABLE (a class of USCL)";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         traversal, tool, expert, two_way_traversable;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "cursor.e"

class CURSOR

   inherit
      SIMPLE_CURSOR
         redefine
            target
         end

   creation {TRAVERSABLE}
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      back is
            -- moves one item backwards
         require
            still_inside: not is_finished

         do
            -- if the beginning is reached the cursor will be 'stop'-ed
            target.back (Current)
         end;

      last is
            -- positions on the last item
         do
            activate;
            -- if the structure is empty the cursor will be 'stop'-ed
            target.last (Current)
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      target: TRAVERSABLE -- the structure the cursor belongs to

end -- class CURSOR