indexing

   title:       "The supplier of the USCL specific error handling facilities";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         error_code, error_message, error_type;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "cntr_err.e"

class CONTAINER_ERROR_HANDLER

   inherit
      ERROR_HANDLER
         redefine
            make
         end

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      make is
            -- ...
         do
            error_types := << "SCIE", "SCFL", "SCXX", "SCIP", "SCNF",
                              "SCNF", "SCDN", "SCDN", "SCLD", "SCOR" >>;

            messages := << "container is empty",
                           "container is full",
                           "unexpected error",
                           "container is protected",
                           "key is not found",
                           "item is not found",
                           "key duplucation",
                           "item duplication",
                           "possible loss of data",
                           "cursor is out of range" >>
         ensure then
            well_done: messages.count = error_types.count and then
                       messages.count = sc_max_error_code
         end;

      stop (first, second: ANY; routine_name: STRING; error_code: INTEGER) is
            -- builds the proper "where it happened" report depending on
            -- 'first' and 'second' for subsequent calling 'err_report' to
            -- build the error report in full and to stop the execution later
            --
         require
            valid_object:  first /= Void;
            valid_routine: routine_name /= Void;
            proper_error:  error_code > 0 and then
                           error_code <= sc_max_error_code
         local
            src_a, src_b: STRING;
            injn1, injn2: CHARACTER

         do
            src_a := get_class_name (first);
            src_b := get_class_name (second);

            if src_a = Void or else src_a.count = 0 then
               src_a := "???"
            end;

            if src_b /= Void and then src_b.count > 0 then
               injn1 := '(';
               injn2 := ')'
            end;

            src_a := get_concatenated
                        (0, <<src_a, injn1, src_b, injn2, '.', routine_name>>);

            err_report (src_a, messages.item (error_code), error_code, first)
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      sc_is_empty        : INTEGER is 1;
      sc_is_full         : INTEGER is 2;
      sc_unexpected      : INTEGER is 3;
      sc_is_protected    : INTEGER is 4;
      sc_key_not_found   : INTEGER is 5;
      sc_item_not_found  : INTEGER is 6;
      sc_key_duplication : INTEGER is 7;
      sc_item_duplication: INTEGER is 8;
      sc_loss_of_data    : INTEGER is 9;
      sc_out_of_range    : INTEGER is 10;

      sc_max_error_code  : INTEGER is 10; -- the constant should be equal the
                                          -- biggest one in the list above
                                          -- even after any possible change ...
      messages: ARRAY [STRING]

end -- class CONTAINER_ERROR_HANDLER