'                       ANALYZE'S FORMAT FINDER

'Written with QuickBasic 4.5
'The program is used to determine the start and length of name and response
'fields, and to write a filename.ini file so that ANALYZE will correctly
'interpret the file.             Copyright Dec., 1993 by Christopher King

DECLARE SUB NoLineFeeds (CheckString$, length%)
DECLARE SUB Help ()
DECLARE SUB Comline (NumArgs%, MaxArgs%)
DECLARE SUB Contents (AString$, length%, Title$)
DECLARE SUB Init ()
DEFINT A-Z
DIM SHARED Record(10) AS STRING, RecLen(10)
DIM SHARED InFile AS STRING, InitFile AS STRING
DIM SHARED MaxLines, LinesPrinted, location, exist
DIM SHARED NameStart, NameLength, Response1Start, Response1Length
DIM SHARED Response2Start, Response2Length, difference
CONST false = 0, true = NOT false, Start = "", Ending = ""
ON ERROR GOTO ErrorHandler:
CLS
CALL Comline(NumArgs, 2)
CALL Help

COLOR 11
PRINT "Use 43 lines per screen [Yes]? ";        'choose lines per screen
DO
    ch$ = INKEY$
LOOP WHILE ch$ = ""
ch$ = UCASE$(MID$(ch$, 1, 1))
IF ch$ = "Y" OR ASC(ch$) = 13 OR ASC(ch$) = 32 THEN
    WIDTH , 43
    location = 42
    HowMany = 37
    MaxLines = 35
ELSE
    location = 24
    HowMany = 19
    MaxLines = 18
END IF
PRINT

IF InFile = "" THEN                                 'Read input file
    INPUT "Name of Input File:  ", InFile
    'InFile = "\work\data4"
END IF
OPEN InFile FOR INPUT AS 1
N = 0
DO
    N = N + 1
    LINE INPUT #1, Record(N)
    RecLen(N) = LEN(Record(N))
    CALL NoLineFeeds(Record(N), RecLen(N))
LOOP UNTIL N = 10 OR EOF(1)
CLOSE 1

N = 0
DO                                              'Estimate parameter values
    N = N + 1
    ch = ASC(MID$(Record(3), N, 1))
    IF (ch > 64 AND ch < 91) OR (ch > 96 AND ch < 123) THEN EXIT DO
LOOP UNTIL N = RecLen(3) - 21
NameStart = N
NameLength = 21
ch = ASC(MID$(Record(3), NameStart + NameLength - 1, 1))
IF ch = 42 OR (ch > 48 AND ch < 54) THEN NameLength = 20
Response1Start = NameStart + NameLength
IF ABS(RecLen(2) - RecLen(1)) <= 3 THEN
    Response2Length = 0
    Response1Length = ((RecLen(3) - NameStart - NameLength + 1) \ 25) * 25
    'make it a multiple of 25
    IF Response1Length > 200 THEN Response1Length = 200
ELSE
    Response1Length = 125
    Response2Length = 75
END IF
Response2Start = 0

difference = RecLen(3) - RecLen(1)                  'User can set ShortFirst
PRINT "Let the parameter ShortFirst be determined automatically [Yes]?";
DO
    ch$ = INKEY$
LOOP WHILE ch$ = ""
PRINT
ch$ = UCASE$(MID$(ch$, 1, 1))
IF ch$ = "N" THEN
    INPUT "Difference between third & first records:  ", difference
END IF

COLOR 7                                                  'Setup screen
CLS
LOCATE 1, 1
LengthInFile = LEN(InFile)      'this centers filename
position = (35 - LengthInFile) \ 2
PRINT "     ANALYZE'S FORMAT FINDER";
PRINT TAB(35); "1st ="; RecLen(1); TAB(50); "Record Lengths"; TAB(70); "2nd ="; RecLen(2)
PRINT SPC(position); InFile; TAB(35); "3rd ="; RecLen(3);
PRINT TAB(51); "Dif(3-1) ="; TAB(70); "4th ="; RecLen(4)
PRINT " Junk1";
COLOR 10
PRINT "NAME";
COLOR 7
PRINT "Junk2RESPONSES1Junk3   Junk4RESPONSES2Junk5     "
PRINT

DO                                                      'Loop until quit
   
    '*********************** Evaluate Parameters for Reasonableness *********
    IF difference <> 0 THEN
        IF Response2Start < 2 THEN Response2Start = 2
    END IF
    'Restrict Names to less than 22; keep from extending beyound end of record
    IF NameLength > 21 THEN NameLength = 21
    IF NameStart + NameLength - 1 > RecLen(3) THEN
         NameStart = RecLen(3) - NameLength + 1
    END IF
   
    'Don't let Response1 start inside the Name field.
    FirstValidPosition = NameStart + NameLength
    IF Response1Start < FirstValidPosition THEN
        Response1Start = FirstValidPosition
    END IF

    'In case Response1 starts before Name
    IF Response1Length > 200 THEN Response1Length = 200
   
    'Keep Response1 & Response2 from extending beyond the end of a record
    IF Response1Start + Response1Length - 1 > RecLen(3) THEN
         Response1Length = RecLen(3) - Response1Start + 1
    END IF
    SecondValidPosition = Response1Start + Response1Length
   
    IF Response2Length > 200 - Response1Length THEN Response2Length = 200 - Response1Length
    IF Response2Start + Response2Length - 1 > RecLen(4) THEN
         Response2Length = RecLen(4) - Response2Start + 1
    END IF

    dif = difference            'Print the parameters used this time
    LOCATE 2, 61
    PRINT dif
    LOCATE 4, 1
    COLOR 15
    PRINT USING "Start:###"; NameStart;
    COLOR 7
    PRINT TAB(11); NameLength;
    COLOR 15
    PRINT TAB(22); Response1Start;
    COLOR 7
    PRINT TAB(29); Response1Length;
    COLOR 15
    PRINT TAB(53); Response2Start;
    COLOR 7
    PRINT TAB(60); Response2Length;
    NewRun = true
    CleanLine$ = SPACE$(80)
    FOR N = 1 TO HowMany: PRINT CleanLine$: NEXT N
    LOCATE 6, 1

    '********************** Evaluate The File *******************************
    K = 0
    LinesPrinted = 0
    FOR N = 1 TO 5
        K = K + 1
        COLOR 15
                                                        
        IF NameStart > 1 THEN                                   'Junk1
            IF LinesPrinted < MaxLines THEN
                LinesPrinted = LinesPrinted + 1
                PRINT SPC(6); "Junk1";
                COLOR 7
                JunkLength = NameStart - 1 - dif
                Junk1$ = MID$(Record(K), 1, JunkLength)
                CALL Contents(Junk1$, JunkLength, "Junk1")
            END IF
        END IF

        PRINT SPC(7); "Name";                                   'NAME
        COLOR 10
        IF LinesPrinted < MaxLines THEN
            LinesPrinted = LinesPrinted + 1
            PRINT Start; MID$(Record(K), NameStart - dif, NameLength); Ending
        END IF
        COLOR 7

        JunkLength = Response1Start - FirstValidPosition        'Junk2
        IF JunkLength > 0 THEN
            IF LinesPrinted < MaxLines THEN
                LinesPrinted = LinesPrinted + 1
                PRINT SPC(6); "Junk2";
                COLOR 7
                Junk2$ = MID$(Record(K), FirstValidPosition - dif, JunkLength)
                CALL Contents(Junk2$, JunkLength, "Junk2")
            END IF
        END IF

        IF Response1Length > 0 THEN                             'RESPONSE1
            IF LinesPrinted < MaxLines THEN
                LinesPrinted = LinesPrinted + 1
                Response1$ = MID$(Record(K), Response1Start - dif, Response1Length)
                PRINT "  Response1"; '-a";
                CALL Contents(Response1$, Response1Length, "Response1")
            END IF
        END IF
       
        JunkLength = RecLen(K) - (SecondValidPosition - dif) + 1     'Junk3
        IF JunkLength > 0 THEN
            IF LinesPrinted < MaxLines THEN
                LinesPrinted = LinesPrinted + 1
                PRINT SPC(6); "Junk3";
                Junk3$ = MID$(Record(K), SecondValidPosition - dif, JunkLength)
                CALL Contents(Junk3$, JunkLength, "Junk3")
            END IF
        END IF
        dif = 0
        
        IF Response2Length > 0 THEN                 'Process a second record.      
            K = K + 1

            JunkLength = Response2Start - 1                     'Junk4
            IF JunkLength > 0 THEN
                IF LinesPrinted < MaxLines THEN
                    LinesPrinted = LinesPrinted + 1
                    PRINT SPC(6); "Junk4";
                    Junk4$ = MID$(Record(K), 1, JunkLength)
                    CALL Contents(Junk4$, JunkLength, "Junk4")
                END IF
            END IF
          
                                                                'RESPONSE2
            Response2$ = MID$(Record(K), Response2Start, Response2Length)
            IF LinesPrinted < MaxLines THEN
                LinesPrinted = LinesPrinted + 1
                PRINT "  Response2";
                CALL Contents(Response2$, Response2Length, "Response2")
            END IF

            Junk5Start = Response2Start + Response2Length      'Junk5
            Junk5Length = RecLen(K) - Junk5Start + 1
            IF Junk5Length > 0 THEN
                IF LinesPrinted < MaxLines THEN
                    LinesPrinted = LinesPrinted + 1
                    Junk5$ = MID$(Record(K), Junk5Start, Junk5Length)
                    PRINT SPC(6); "Junk5";
                    CALL Contents(Junk5$, Junk5Length, "Junk5")
                END IF
            END IF

        END IF
        IF LinesPrinted < MaxLines THEN
            LinesPrinted = LinesPrinted + 1
            PRINT
        END IF
        IF LinesPrinted + ((LinesPrinted) \ N - 1) > MaxLines THEN EXIT FOR
    NEXT N
    
    '********************** Quit or Change Parameters ***********************
    LOCATE location, 1
    COLOR 11
    INPUT ; "Quit [No]"; Quit$
    COLOR 7
    ch$ = UCASE$(MID$(Quit$, 1, 1))
    IF ch$ = "Y" THEN EXIT DO
    LOCATE location, 1
    PRINT "              ";         'Covers "quit?" querry
    LOCATE location, 1
    COLOR 14
    PRINT "Name: ";
    COLOR 7
    INPUT ; "Start ", temp1$
        IF NOT temp1$ = "" THEN NameStart = VAL(temp1$)
        IF NameStart - difference < 1 THEN NameStart = difference + 1
    LOCATE location, 16
    INPUT ; "Length ", temp1$
        IF NOT temp1$ = "" THEN NameLength = VAL(temp1$)
    LOCATE location, 26
    COLOR 14
    PRINT "Rspns1: ";
    COLOR 7
    INPUT ; "Start ", temp1$
        IF NOT temp1$ = "" THEN Response1Start = VAL(temp1$)
    LOCATE location, 43
    INPUT ; "Length ", temp1$
        IF NOT temp1$ = "" THEN Response1Length = VAL(temp1$)
    LOCATE location, 53
    COLOR 14
    PRINT "Rspns2: ";
    COLOR 7
    INPUT ; "Start ", temp1$
        IF NOT temp1$ = "" THEN Response2Start = VAL(temp1$)
    LOCATE location, 70
    INPUT ; "Length ", temp1$
        IF NOT temp1$ = "" THEN Response2Length = VAL(temp1$)
LOOP

CALL Init                                               'Make .ini file
COLOR 7
END


' error handling routine handles only "Bad File Name", "Path Not Found",
' and "File Not Found"; aborts on most other errors
'
CONST FileNotFound = 53
CONST BadPath = 76
CONST BadFileName = 52
CONST BadFileName2 = 64
ErrorHandler:
    'Error handler for input file names.
    Number = ERR
    IF Number = FileNotFound OR Number = BadFileName OR Number = BadFileName2 THEN
            PRINT "File not found (or bad file name); try again."
        INPUT "Name of Input File:  ", InFile      'Get input file
    ELSEIF Number = BadPath THEN
        PRINT "Path not found; try again."
        INPUT "Name of Input File:  ", InFile      'Get input file
    ELSE
        ' some other error, so print message and abort
        COLOR 7
        PRINT "Unrecoverable error--"; ERR
        ON ERROR GOTO 0
    END IF
    RESUME

CheckIfExist:                           'used for .ini file
    'Error handler for .ini file name.
    Number = ERR
    IF Number = FileNotFound THEN
        'File does not exist
        exist = false
        RESUME NEXT
    ELSEIF Number = BadFileName OR Number = BadFileName2 THEN
        PRINT "File not found (or bad file name); try again."
        INPUT "Name of .ini File:  ", InitFile      'Get .ini file
    ELSEIF Number = BadPath THEN
        PRINT "Path not found; try again."
        INPUT "Name of .ini File:  ", InitFile      'Get .ini file
    ELSE
        'some other error, so print message and abort
        COLOR 7
        PRINT "Unrecoverable error--"; ERR
        ON ERROR GOTO 0
    END IF
    InitFile = InitFile + ".ini"
    RESUME

SUB Comline (NumArgs, MaxArgs) STATIC
'This allows ANALYZFF /? to display help,
'and allows  ANALYZFF Infilename filename.ini to be used to start program.
   NumArgs = 0: in = false
   ' Get the command line using the COMMAND$ function.
   cl$ = COMMAND$
   L = LEN(cl$)
   ' Insure that a blank preceeds any "/" except the first character.
   J = INSTR(2, cl$, "/")
   ' Go through the command line a character at a time.
   FOR I = 1 TO L
      C$ = MID$(cl$, I, 1)
      'Test for character being a blank or a tab.
      IF (C$ <> " " AND C$ <> CHR$(9)) THEN
                            ' Neither blank nor tab.
          IF C$ = "/" THEN in = false
                            ' Test to see if you're already
                            ' inside an argument.
             IF NOT in THEN
                            ' You've found the start of a new argument.
                            ' Test for too many arguments.
                IF NumArgs = MaxArgs THEN EXIT FOR
                NumArgs = NumArgs + 1
                in = true
             END IF
                            ' Add the character to the current argument.
             Args$(NumArgs) = Args$(NumArgs) + C$
      ELSE
                            ' Found a blank or a tab.
                            ' Set "Not in an argument" flag to FALSE.
             in = false
      END IF
   NEXT I

IF Args$(1) = "?" OR Args$(1) = "HELP" OR Args$(1) = "/?" THEN
    CLS
    CALL Help
    END
END IF

FoundInFile = false
FoundInitFile = false
IF NumArgs > 0 THEN
    FOR N = 1 TO NumArgs
        IF MID$(Args$(N), 1, 1) = "/" THEN
            PRINT "Unrecognized switch on command line."
            END
        ELSEIF NOT FoundInFile THEN
            InFile = Args$(N)
            FoundInFile = true
        ELSEIF NOT FoundInitFile THEN
            InitFile = Args$(N)
            FoundInitFile = true
        ELSE
            PRINT "WARNING:  Too Many Parameters on command line."
            END
        END IF
    NEXT N
END IF
END SUB

SUB Contents (AString$, length, Title$)
'The first title is expected to have been printed.  The responses and
'additional titles are printed.
DIM Title2  AS STRING * 11, Title3 AS STRING * 11
    COLOR 7
    ShortString$ = MID$(AString$, 1, 67)
    PRINT Start; ShortString$; Ending
    IF LinesPrinted < MaxLines THEN
        IF length > 67 THEN
            LinesPrinted = LinesPrinted + 1
            RSET Title2 = Title$ '+ "-b"
            ShortString$ = MID$(AString$, 68, 67)
            PRINT Title2; Start; ShortString$; Ending
            IF length > 134 THEN
                IF LinesPrinted < MaxLines THEN
                    LinesPrinted = LinesPrinted + 1
                    RSET Title3 = Title$ '+ "-c"
                    ShortString$ = MID$(AString$, 135)
                    PRINT Title3; Start; ShortString$; Ending
                END IF
            END IF
        END IF
    END IF
END SUB

SUB Help
'This prints the introductory screen
PRINT TAB(27); "ANALYZE'S FORMAT FINDER"
PRINT "USAGE:"
PRINT "     ANALYZFF /?             displays this help screen"
PRINT "     ANALYZFF InputFile InitFile.ini"
PRINT "                             InputFile and InitFile.ini are optional"
PRINT "                             InitFile.ini must be the second filename given."
PRINT
PRINT "     This program will help you define the structure of data files to be used"
PRINT "with ANALYZE.  The input file only needs to contain 4 score sheets (just 2"
PRINT "can be used, but starting parameter estimates may not be as good).  You adjust"
PRINT "the starting position and length of two or three fields:  NAME, RESPONSES1,"
PRINT "and RESPONSES2.  When you finish, you will be asked if the program should make"
PRINT "an initialization file, and, if so, what filename to use.  If you're lucky,"
PRINT "the program's starting parameter estimates will be correct, and you won't have"
PRINT "to adjust anything!"

PRINT
COLOR 11
PRINT "Press any key to continue";
SLEEP
ch$ = INKEY$        'clears keyboard buffer, or something like that
CLS

COLOR 7
PRINT TAB(35); "THE SCREEN"
PRINT
PRINT " Junk1";
COLOR 10
PRINT "NAME";
COLOR 7
PRINT "Junk2RESPONSES1Junk3   Junk4RESPONSES2Junk5     "
COLOR 15
PRINT "Start: 2";
COLOR 7
PRINT TAB(11); 21;
COLOR 15
PRINT TAB(22); 23;
COLOR 7
PRINT TAB(29); 125;
COLOR 15
PRINT TAB(53); 2;
COLOR 7
PRINT TAB(60); 0
PRINT
PRINT "     Current parameters for the three main fields are displayed with starting"
PRINT "positions in bright white and lengths in normal white."
PRINT
COLOR 15
PRINT SPC(5); "Junk1";
COLOR 7
PRINT ""; CHR$(8); ""
PRINT "      Name";
COLOR 10
PRINT "JAMAL MOHAMAD A      ";
COLOR 7
PRINT " Response13441431232212323234534145133315312125542134121341333152124314332251"
PRINT " Response1433214332222355415341531335323332412514242122131245       "
PRINT
PRINT "The name of the first field in each score sheet is in bright white.  "
PRINT Start; "The field contents are inside these things."; Ending
PRINT "Linefeeds and carriage returns appear as "; CHR$(8); "."
PRINT
COLOR 11
PRINT "Press any key to continue";
SLEEP
ch$ = INKEY$        'clears keyboard buffer, or something like that
CLS
COLOR 7

PRINT TAB(36); "STRATEGY"
PRINT "     1) First, fit the name in the NAME field by adjusting the start and "
PRINT "length of that field.  The other parameters can be left as they are.  Press "
PRINT "enter to leave a parameter unchanged. NAME is limited to 21 characters.  Extra"
PRINT "name characters will go in a Junk field and not be used.  Note that "; CHR$(34); "ShortFirst"; CHR$(34);
PRINT "(which is 3rd record length - 1st) is automatically determined, though you can"
PRINT "change the value when the program first starts."
PRINT "     If your score sheets are on two records, NAME may only be correct on every"
PRINT "other sheet at this point.  That's OK for now (wait to step 3 to fix that)."
PRINT "     2) Next, fit the first set of responses in the RESPONSES1 field by "
PRINT "adjusting the start and length of that field.  An easy way to set the start"
PRINT "of RESPONSES1 is to set it to start in the middle of the NAME field.  The"
PRINT "program will change it to start immediately after the NAME field.  The"
PRINT "maximum length of RESPONSES1 is 200.  If this places it beyond the end of the "
PRINT "record, its length is reduced automatically.  A restriction of this program is "
PRINT "that RESPONSES1 must come after NAME.  (That restriction is not present in the "
PRINT "ANALYZE program, however.)                 "
PRINT "     3) Finally, adjust the start and length of RESPONSES2 so that the rest "
PRINT "of the responses fit in that field.  This may not be necessary if all the "
PRINT "responses are in the first record.  In that case leave RESPONSES2 set at "
PRINT "zero.  An easy way to set the length of this field is to set it to, say, "
PRINT "300.  The sum of RESPONSES2 and RESPONSES1 cannot be greater than 200, so "
PRINT "RESPONSES2 is reduced accordingly.  "
END SUB

SUB Init
'************************* Construct an Init file **************************
LOCATE location, 1
PRINT SPACE$(80);
LOCATE location, 1
COLOR 11
ON ERROR GOTO CheckIfExist:
INPUT "Make a FILENAME.ini file [No]"; ch$
IF location = 42 THEN WIDTH , 25
IF UCASE$(MID$(ch$, 1, 1)) = "Y" THEN
    DO
        IF InitFile = "" THEN
            INPUT "Enter FILENAME (.ini will be added): ", InitFile
            IF NOT INSTR(InitFile, ".ini") THEN InitFile = InitFile + ".ini"
        END IF
        Safe = true
        exist = true
        OPEN InitFile FOR INPUT AS 1
        IF exist THEN
            Safe = false
            CLOSE 1
            PRINT InitFile; " already exists; overwrite? [No]"
            DO
                ch$ = INKEY$
            LOOP WHILE ch$ = ""
                IF UCASE$(MID$(ch$, 1, 1)) = "Y" THEN
                    Safe = true
                ELSE
                    InitFile = ""
            END IF
        END IF
    LOOP UNTIL Safe
    OPEN InitFile FOR OUTPUT AS 1
    PRINT #1, "F1Default = 1  ' 0 = no item analysis,    1 = analysis,     2 = analysis only"
    PRINT #1, "F2Default = 1  ' 0 = no personal reports, 1 = make reports, 2 = reports only"
    PRINT #1, "F3Default = 1  ' 0 = no responses,        1 = responses,    2 = responses only"
    PRINT #1, "F4Default = 0  ' 0 = no text,             1 = text ,        2 = text only"
    PRINT #1, "F5DefaultPrintWide = false        ' if true then wide output is default"
    PRINT #1, "LinesPerNormalPage = 66           ' valid numbers are 25 to 200"
    PRINT #1, "NoGraphicsWhenNormalWidth = false ' true if can't print extended characters."
    PRINT #1, "LinesPerWidePage = 80             ' valid numbers are 25 to 200"
    PRINT #1, "ColumnsPerWidePage = 132          ' valid numbers are 80 to 300"
    PRINT #1, "CommandLinesIfWideOutput = true   ' If false, prints wide on default printer"
    PRINT #1, "CommandLine1 = cd\kermit"
    PRINT #1, "CommandLine2 = kermit"
    PRINT #1, "Info1 = INFO:  The answer key can contain blanks, which are not scored, and asterisks,"
    PRINT #1, "Info3 = which cause all responses to be scored as correct.  (An item is marked with an "
    PRINT #1, "Info3 = asterisk by marking more than one response.)  If the answer key contains a"
    PRINT #1, "Info4 = mistake, it is not necessary to rescan the students' response sheets.  Just"
    PRINT #1, "Info5 = correct the key and rescan it."
   
    'User can enter a description here
    PRINT "Enter a one-line description of the input data file."
    INPUT "     ' ", AString$
    PRINT #1, "     ' "; AString$
   
    PRINT #1, "Format1Length1 ="; RecLen(1)
    PRINT #1, "Format1Length2 ="; RecLen(2)
    PRINT #1, "Format1NameStart ="; NameStart
    PRINT #1, "Format1NameLength ="; NameLength
    PRINT #1, "Format1ResponseStart ="; Response1Start
    PRINT #1, "Format1ResponseLength ="; Response1Length
    PRINT #1, "Format1ShortFirst ="; difference
    PRINT #1, "Format1Response2Start ="; Response2Start
    PRINT #1, "Format1Response2Length ="; Response2Length
    CLOSE 1
    PRINT
    PRINT "Initialization parameters written to "; InitFile
END IF
END SUB

SUB NoLineFeeds (CheckString$, length)
FunnyLooking$ = CHR$(8)
FOR M = 1 TO length
    K = ASC(MID$(CheckString$, M, 1))
    IF (K = 13 OR K = 10 OR K = 9) THEN MID$(CheckString$, M, 1) = FunnyLooking$
    IF K = 26 THEN PRINT "End of File Character Detected; quiting": SLEEP: END
NEXT M
END SUB

