' Frankenstein word game programme originating as PC-SIG no 18
' Rewrite by John Calder,Box 41-076, Auckland 3, NZ, ph 8282612, Nov 1992
' adding colours and CLUEs
' Further rewrite using PowerBASIC April 1993 to Oct 1994
' You should be able to play with it using QBASIC.
'
' NOTE that in rigorous computer programming terms this is now a mongrel
' being my improvements written in the modern structured style
' grafted on to the earlier original code.
'
' diary 18/9/94 .. * LCASE$ and REMOVE$ blanks on game words for some kind
'                    of OK operation when kids write their own
'
' update 20/3/94   * make programme a little easier to read for exhibition.
'                  * add auto shut off after 120 sec inactivity to save
'                    Stan's generously loaned screen from fade-out!
'
' update 8/9/93... * change "play again Y/N" question to "press ENTER..."
'                    as words with "n" were causing premature stop
'                  * define F3 key as EXIT for compatiblity with GRAPHs
'                    and simpler progs using "input" .  ESC still operates
'
' update 2/9/93... * change use of timer with output displays
'                  * ADD markcard with new variables MARK and NQU
'
'

15  REM
20  REM ************************  Documentation ******************************
22  REM   NW       = number of words read by SUB 1000 on prog startup
24  REM   CU$      = control of display in answer space
27  REM   A        = control of display of the alphabet and letters used
30  REM   H$( )    = word chosen from word list by random selection
31  REM   L        = length of H$
32  REM   CLUE$( ) = clue to H$
34  REM              NOTE word list data is in form H$ CLUE$ H$ CLUE$ ...
36  REM   W$( )    = letters of that word, usual subscript is X
37  REM   W( )     = associated flag, starts at 0, becomes 1 on correct guess
'***      MARK     = number correct
'***      NQU      = number attempted
'***
40  REM   SUB 1000   Sort through words and count them to get NW
41  REM
42  REM
44  REM   SUB 3020   monster appearing bit by bit with wrong guesses
45  REM              up to line 3720
47  REM   SUB 3810   Monster animates arm flap
48  REM
49  REM   SUB 4000   correct answer reaction and offer signoff routine
50  REM
51  REM
52  REM   SUB 59950  TIMEOUT routine for timing pauses
54  REM   SUB 59990  direct input routine using INKEY$ allows analysis
'                    of each character

55  REM Programme setup
60      WIDTH 80 : CLS : DEFINT A-S,U-Z : CU$="     "
        key 2,""      '*** chr$(176) see lines 180+2 and 230 for usage
        key 3,chr$(27) '*** F3 as exit
        key 7,chr$(27) '*** F7 as exit like WordPerfect which our kids use
        mark = 0 : nqu = 0

74  DIM H$(325) , H(150), A$(150), A(150), W$(150), W(150), U$(50)
    DIM U(50), CLUE$(325)
75  RANDOMIZE TIMER
'***   REWRITE APRIL 1993 takes data from separate sequential file
       open "i",#1, "frank.txt"
       nw = 0
       do until eof(1)
	  nw = nw + 1
	  line input #1, h$(nw)
	  line input #1, clue$(nw)
	  h$(nw) = LCASE$(h$(nw))          '***** 18/9/94 emergency rewrite
	  h$(nw) = REMOVE$( h$(nw) , " ")  'for better write-your-own word
       loop
       close #1



'*** gosub 3000 for setup of ASCII graphics of Frankenstein's lab
76     z = 0  : GOSUB 3000
78     FOR X=13 TO 15: LOCATE X,1: PRINT STRING$(80,"");: NEXT X
80     FOR X=1 TO NW:IF H(X)=0 THEN 100 ELSE NEXT X
90     FOR X=1 TO NW:H(X)=0:NEXT X:H=INT(RND*NW+1):GOTO 110
100    FOR T=1 TO 5:H=INT(RND*NW+1):IF H(H)=0 THEN 110 ELSE NEXT T:H=X
110    H$=H$(H): H(H)=1
120    L=LEN(H$)
130    FOR X=1 TO L: W$(X)=MID$(H$,X,1): W(X)=0: NEXT X
140   LOCATE 14,39-cint(L/2): PRINT STRING$(L+2," ");
145   LOCATE 14,40-cint(L/2): COLOR 10: PRINT STRING$(L,"-");: COLOR 7
148     REM
149   REM ******  set up the alphabet line  NOTE my change to lower case ***
150     FOR X=97 TO 122: A$(X)=CHR$(X): NEXT X
160   LOCATE 16,1: PRINT SPACE$(80);: LOCATE 16,1: PRINT"What's your letter?";

165   COLOR 12
170   LOCATE 18,5:PRINT STRING$(70,"");
175   COLOR 7
180   LOCATE 20,14: FOR X=97 TO 122: PRINT A$(X)" ";: NEXT X
      locate 24,1
      color 15,4 : print"F2"; : color 11: print"=guess whole word    ";
      color 15   : print" F3"; : color 11: print"=exit    ";
      color 15   : print"ENTER";
      color 11   : print"=zap past messages                    ";
190   CU=22

200   COLOR 10,0                                  'change 14/9/93 overcomes
      LOCATE 16,42 : PRINT "CLUE:  " + CLUE$(H)   'prob of rubout of long
      color 7                                     'clues printed on line 17
      IKEY$="": LOCATE 16,CU : PRINT CU$;
      locate 16,cu,1
      if flag = 1 then         'this little lot is the new routine 2/9/93
          ikey$ = ikal$        'to allow quick players to zap past the timeout.
          flag = 0             'IKAL$ is the Input Key ALternative inkey$ by
      else                     'zappers in timeout routine 59950 gosub-ed
          GOSUB 59990          'from line 370 which is end of this main loop
      end if
      beep

230   IF IKEY$="" THEN 2000
240   A = ASC(IKEY$) : IF A<91 THEN A=A+32 : IKEY$=CHR$(A)
250   IF INSTR("abcdefghijklmnopqrstuvwxyz",IKEY$)=0 THEN 200
260   LOCATE 16,CU : PRINT IKEY$;
270   IF A$(A)=" " THEN
         LOCATE 17,1,0 : PRINT"You've already used "IKEY$"!";
         TIMEOUT=2.8 : flag=1 : GOSUB 59950
         LOCATE 17,1 : PRINT SPACE$(50);:GOTO 200
      end if
280   S=0:NC=0:FOR X=1 TO L
290   IF W$(X)=IKEY$ THEN W(X)=1:S=S+1
300   IF W(X)=1 THEN NC=NC+1
310   NEXT X
320   IF NC=L THEN 340
330      IF S<>0 THEN 340
332      IF Z>=7 THEN 3800
334      LOCATE 17,1,0 :PRINT"The monster gets ";: GOSUB 3000
         TIMEOUT=2: flag = 1 : GOSUB 59950: LOCATE 17,1: PRINT SPACE$(50);
         A$(A)=" ": GOTO 180
340   LOCATE 14,40-L/2,0 : COLOR 10
350   FOR X=1 TO L: IF W(X)=1 THEN PRINT W$(X); ELSE PRINT"-";
360   NEXT X: COLOR 7: A$(A)=" ": IF NC=L THEN 4000
370   TIMEOUT = 0.9     ' **** note lots of experimenting with this time!
      flag = 1  : GOSUB 59950  :  GOTO 180

'***   Routine for guessing whole word
2000   LOCATE 16,1: PRINT SPACE$(46)
       LOCATE 16,1: PRINT"What's your guess for the word?   ";
       LOCATE 16,39-cint(L/2) : call MonoInput(W$,itype)
       IF itype = 27 THEN 59992   'branch into exit part of inkey$ routine

       IF len(w$) = len(h$) THEN
          '*** Case conversion on word estimate
          W5$ = ""
          FOR I5 = 1 TO LEN(H$)
            A5 = ASC(MID$(W$,I5,1))
            IF A5<91 AND A5>64 THEN A5=A5+32
            W5$ = W5$ + CHR$(A5)
          NEXT I5
          IF W5$=H$ THEN 4000  '*** where student guesses word correctly
          LOCATE 16,1: PRINT SPACE$(33);
          LOCATE 16,1: PRINT"No, there goes ";
          GOSUB 3000 : beep
          TIMEOUT=5 : flag = 1 : GOSUB 59950: GOTO 160
       else
          locate 16,1 : print space$(33)
          locate 16,1 : print "Wrong length, here's ";
          GOSUB 3000 : beep
          TIMEOUT=5 : flag = 1 : GOSUB 59950: GOTO 160
       END IF

'Graphic display section
3000 Z=Z+1:ON Z GOTO 3100, 3200,3300,3400,3500,3600,3700,3800
3010 STOP
3100 LET nqu = nqu + 1 : COLOR 12
     LOCATE 1,1:PRINT STRING$(80,"");:LOCATE 12,1:PRINT STRING$(80,"");
     FOR X=1 TO 12:LOCATE X,1:PRINT"";:LOCATE X,80:PRINT"";:NEXT X
     LOCATE 2,28:COLOR 15:PRINT"F R A N K E N S T E I N";:COLOR 7
     FOR X=6 TO 12
         LOCATE X,10:PRINT STRING$(8,"");
         LOCATE X,62:PRINT STRING$(8,"");
     NEXT X
     LOCATE 5,13:PRINT"";:LOCATE 5,65:PRINT"";
3120 RETURN
3200 PRINT"his body!  ";
3210 COLOR 13
     LOCATE 6,37:PRINT STRING$(7,"")
     locate 7,38:print STRING$(5,"")
     locate 8,39:print STRING$(3,"")
     locate 9,40: print "";
     COLOR 7
3220 RETURN
3300 PRINT"his arm!  ";
3310 COLOR 13
     LOCATE 6,35: PRINT""
     locate 7,35: print""
     locate 8,35: print"";
     COLOR 7
3320 RETURN
3400 PRINT"his other arm!";
     color 13
     LOCATE 6,44: PRINT""
     locate 7,44: print" "
     locate 8,44: print" ";
     COLOR 7
3420 RETURN
3500 PRINT"his leg!  ";
3510 COLOR 13
     LOCATE  9,38 : PRINT" "
     locate 10,38 : print" "
     locate 11,38 : print"";
     COLOR 7
3520 RETURN
3600 PRINT"his other leg!";
3610 COLOR 13
     LOCATE  9,41: PRINT""
     locate 10,41: print""
     locate 11,41: print"";
     COLOR 7
3620 RETURN
3700 PRINT"his head!  ";
3710 COLOR 13
     LOCATE  3,39: PRINT""
     locate  4,39: print""
     locate  5,39: print"";
     COLOR 7
3720 RETURN
3800 LOCATE 16,1:PRINT"     The word was   "; : color 14 : print H$ ;
     TIMEOUT=2 : GOSUB 59950
     color 15  : PRINT"    The MONSTER lives!!!                ";
     color  7  : TIMEOUT=2: GOSUB 59950
'*** animation sequence for waving arms
3810 FOR X=1 TO 10
'*** draw in arms up
     COLOR 13
     locate 4,35: print"" ;
     locate 5,35: print"" ;
     locate 6,35: print"";
     locate 4,44: print" ";
     locate 5,44: print" ";
     locate 6,44: print"";
'*** blank out arms down
     locate 7,35: print" "
     locate 8,35: print" ";
     locate 7,44: print"  "
     locate 8,44: print"  ";
3860 delay 0.1
'*** draw arms down again
     LOCATE 6,35: PRINT""
     locate 7,35: print""
     locate 8,35: print"";
     LOCATE 6,44: PRINT""
     locate 7,44: print" "
     locate 8,44: print" ";
'*** blank out arms up
     locate 5,35: print" ";
     locate 4,35: print" ";
     locate 5,44: print"  ";
     locate 4,44: print"  ";
     delay 0.1
3905 NEXT X
     color 7
3910 LOCATE 17,1 : PRINT SPACE$(80)
     LOCATE 17,1 : PRINT"press ENTER for next word";
3920 GOTO 4010

'*** Correct answer routine
4000 mark = mark + 1
     do : loop until inkey$ = ""        '*** empty keyboard buffer
     LOCATE 16,1 : color 15 : PRINT"Yes!! press ENTER for next word"
'*** I've added line 4005 here to give better feedback to a correct guess and
'*** also to keep the word on screen for learning reinforcement.
4005 LOCATE 14,40-cint(L/2) : COLOR 10: PRINT H$; : COLOR 7
4010 GOSUB 59990
4020 BEEP
     if ikey$ = chr$(27) then call MarkCard else CLS: GOTO 76


59940 REM *** SUB for timing pauses where TIMEOUT is length of pause in seconds
59950 tx = timer
      do until timer - tx >= timeout
      if flag = 1 then
         ikal$ = inkey$
         if ikal$ <> "" then return
      end if
      loop
      flag = 0
      return


59990 REM *** SUB for input with INKEY$ which allows analysis of each character
      REM         as it is typed
      t1 = TIMER
      DO
      ikey$=INKEY$
      IF TIMER - t1 > 140 THEN END
      LOOP UNTIL ikey$ > ""
      IF IKEY$=CHR$(27) THEN
59992     color 11
          locate 21,7 : print"ͻ"
          locate 22,7 : print"                                            "
          locate 23,7 : print"ͼ"
          LOCATE 22, 9: color 12 :print "The word was   ";
          COLOR 14 : PRINT H$(H);: COLOR 12: PRINT "  !"
          TIMEOUT=5: flag = 1 : GOSUB 59950: call MarkCard
      end if
59995 RETURN


'***************************************************************************
SUB MarkCard
SHARED mark, nqu
cls
color 15,2
locate  6,7 : print"ͻ"
locate  7,7 : print"    Progress Report                         "
locate  8,7 : print"                                            "
locate  9,7 : print"    You got        words out of             "
locate 10,7 : print"                                            "
locate 11,7 : print"    That is        per cent                 "
locate 12,7 : print"                                            "
locate 13,7 : print"                                            "
locate 14,7 : print"    Press ENTER key to exit                 "
locate 15,7 : print"                                            "
locate 16,7 : print"ͼ"
locate  9,21 : print mark
locate  9,41 : print nqu
locate 11,20 : print cint(mark/nqu * 100)
locate 18,1
    t1 = TIMER
    do
    ikey$ = inkey$
    IF TIMER - t1 > 30 THEN END
    loop until ikey$ <> ""
color 7,0 : cls
END
END SUB

'***************************************************************************
'*** subroutine with INKEY$ substituting for INPUT
'*** Returns  A which is input string   and  IA  which is final keystroke
'*** causing exit from sub  ..IA = 13 for normal 'ENTER' or 27 for 'ESC'
'*** or for FRANK 8/9/93 IA = 238 for F3

defstr a - e : defint f - n

SUB MonoInput(a, ia)
    DIM DINPUT(50)
    COLOR 14,0
    KSTART = POS : KCOL = KSTART + 1 : KLINE = CSRLIN : a =""
    insflag = 6   '*** 6 for INSERT OFF ; 3 for INSERT ON
    lenfield = 2

start:
if kcol > 80 then kcol = 1 : kline = kline + 1
LOCATE kline, kcol, 1, insflag, 7

'** main input routine with closedown after 120 sec if no input    
    t1 = TIMER
    DO   
    ak = INKEY$ 
    IF TIMER - t1 > 120 THEN END
    LOOP UNTIL ak > ""

    IA = ASC(AK)
    IF IA = 27  THEN color 7,0 : EXIT SUB     '*** Esc F3 F7 keys
    IF IA = 13 THEN AssembleA    '*** input completed on ENTER

'************** start of ARROW KEYS trap and control section *************
IF IA = 0  THEN
   IF ASC(RIGHT$(AK,1)) = 77 THEN                        '*** right arrow
       KCOL = KCOL + 1
   ELSEIF ASC(RIGHT$(AK,1)) = 75 AND KCOL > KSTART THEN  '*** Left Arrow
       KCOL = KCOL - 1
       GOTO start
   ELSEIF ASC(RIGHT$(AK,1)) = 71 THEN                   '*** HOME arrow
       KCOL = KSTART + 1
       GOTO start
   ELSEIF ASC(RIGHT$(AK,1)) = 79 THEN                   '*** END arrow
       KCOL = KSTART + LENFIELD
       GOTO start
   ELSEIF ASC(RIGHT$(AK,1)) = 83 THEN                   '*** Delete key
       FOR J = KCOL - KSTART  TO  LENFIELD + 1
       DINPUT(J) = DINPUT(J+1) : PRINT DINPUT(J) ;
       NEXT J
       PRINT " ";
       GOTO start
   ELSEIF ASC(RIGHT$(AK,1)) = 82 THEN   '*** Insert key procedure & flag
       IF INSFLAG = 3 THEN INSFLAG = 6 ELSE INSFLAG = 3
       GOTO start
   ELSE
       GOTO start
   END IF

END IF
'**************** END of arrow keys control section ************************

       IF IA = 8  THEN              '*** Backspace key
         IF KCOL = KSTART + 1 THEN start
         KCOL = KCOL - 1
         LOCATE KLINE, KCOL,1,5,7
         FOR J = KCOL - KSTART  TO  LENFIELD + 1
         DINPUT(J) = DINPUT(J+1) : PRINT DINPUT(J) ;
         NEXT J
         PRINT " ";
         GOTO start
         END IF
       IF IA = 237 THEN   '*** F7 key for delete to end of input
         FOR J = KCOL-KSTART TO LENFIELD
              DINPUT (J) = ""
              NEXT J
         FOR K = KCOL TO LENFIELD + KSTART
              LOCATE KLINE,K
              PRINT " ";
              NEXT K
         GOTO start
         END IF
       IF IA > 230 THEN EXIT SUB    '*** F-keys

'****  Structured IF statement here is the main input construct
       IF 31 < IA  AND  IA <= 230  THEN
          LOCATE KLINE, KCOL : COLOR 14,0
          PRINT CHR$(IA);
          lenfield = lenfield + 1
          IF INSFLAG = 3 THEN             '*** insert procedure
             FOR J = LENFIELD  TO  KCOL-KSTART+1  STEP  -1
             DINPUT(J) = DINPUT(J-1)
             LOCATE KLINE, J+KSTART : PRINT DINPUT(J) ;
             NEXT J
       END IF
       DINPUT( KCOL-KSTART ) = CHR$(IA)
       KCOL = KCOL + 1
       END IF
       GOTO start

AssembleA:
       FOR i = 1 TO lenfield
       a = a + dinput(i)
       NEXT i
       color 7,0
END SUB

'***************** end of FRANK programme **********************************

