/*************************************************************************
  Expr        Berechnet den Wert eines angegebenen mathematischen Ausdrucks

  Autor:      SemWare

  Datum:      23. Mrz 1994

  bersicht:

  Diese Makro arbeitet wie ein einfacher Taschenrechner und kann mit
  dezimalen und hexadezimalen Zahlen umgehen. Im Falle von dezimalen
  Zahlen werden nur ganze Zahlen akzeptiert.

  Tasten:     (Keine)

  Hinweise zum Gebrauch:

  Dieses Makro hat keine Tastenzuweisungen. Whlen Sie es bei Bedarf
  einfach aus dem Potpourri Men aus.

  Die folgenden Operatoren stehen zur Verfgung:

            >      SHR      (bitwise shift right)
            <      SHL      (bitwise shift left)
            ~      COMP     (2's complement)
            %      MOD      (modulo division)
            &      AND      (bitwise AND)
            |      OR       (bitwise OR)
            ^      XOR      (bitwise eXclusive-OR)
            +      Addition
            -      Subtraktion
            *      Multiplikation
            /      Division

  Hex Zahlen knnen im C Format eingeben werden oder enden auf 'h' oder
  '$'. Auf jeden Fall mu das erste Zeichen numerisch sein.

  Copyright 1992-1994 SemWare Corporation.  Alle Rechte weltweit
  vorbehalten.

  Der Gebrauch, die Abnderung und die Verbreitung dieses SAL Makro wird
  von SemWare ausdrcklich begrt, vorausgesetzt, da dieser Hinweis,
  zusammen mit obigen Copyright Hinweis, nicht entfernt wird und das
  keine Entgelt fr die Verbreitung entgegengenommen wird. Sie drfen
  Ihren eigenen Copyrightvermerk ergnzen, soweit dies Ihre nderungen
  oder Ergnzungen betrifft, aber SemWare bernimmt dafr keinen Support
  und keine Verantwortung.
*************************************************************************/

HelpDef ExprHelp
   "Die folgende Operatoren stehen innerhalb eines Ausdrucks"
   "zur Verfgung:"
   ""
   "Operator        Bedeutung                    Prioritt"
   ""
   "    ()     Unterausdruck                         1"
   ""
   "    ~      Bitwise 2's Complement                2"
   ""
   "    *      Multiplikation                        3"
   "    /      Division                              3"
   "    %      Modulo Division                       3"
   "    ^      Bitwise eXclusive-OR                  3"
   "    >      Bitwise Shift Right                   3"
   "    <      Bitwise Shift Left                    3"
   "    &      Bitwise AND                           3"
   ""
   "    +      Addition                              4"
   "    -      Subtraktion                           4"
   "    |      Bitwise OR                            4"
   ""
   "Hex Zahlen knnen eingegeben werden, indem diese"
   "mit '0x' beginnen oder mit 'h' oder '$' enden. Auf"
   "jeden Fall mu das erste Zeichen numerisch sein."
   ""
end


/*
   Work variables
*/

string  InputLine[80]
integer Col             // current column in InputLine
string  Token[15]       // currently parsed token from InputLine
integer symbol          // numeric "code" representing what token is
string  Ch[1]           // next Char from InputLine

integer hex             // is current symbol hex? used only by GetToken/isHex

forward integer proc SimpleExpression()

proc GetNextChar()
    Ch = Upper(SubStr(inputline, col, 1))
    col = col + 1
end

integer proc isNumeric()
    return (Ch >= '0' and Ch <= '9')
end

integer proc isHexChar()
    if Ch >= 'A' and Ch <= 'F'
        hex = TRUE
        return (TRUE)
    endif
    return (FALSE)
end

/*
   These are "magic" values that GetToken will store in the global variable
   symbol, to indicate what is the next item coming.
*/
constant
    symNumber           = 0,
    symAddition         = 1,
    symSubtraction      = 2,
    symMultiplication   = 3,
    symDivision         = 4,
    symLeftParen        = 5,
    symRightParen       = 6,
    symAND              = 7,
    symOR               = 8,
    symXOR              = 9,
    symCOMP             = 10,
    symMOD              = 11,
    symSHR              = 12,
    symSHL              = 13,
    symEndOfString      = -1,
    symError            = -2

// GetToken _must_ set hex to FALSE on startup and exit.
proc GetToken()
    while ch == " "                     //  Skip over any leading blanks
        GetNextChar()
    endwhile
    token = Ch
    case token
        when ">"      symbol = symSHR
        when "<"      symbol = symSHL
        when "~"      symbol = symCOMP
        when "%"      symbol = symMOD
        when "&"      symbol = symAND
        when "|"      symbol = symOR
        when "^"      symbol = symXOR
        when "+"      symbol = symAddition
        when "-"      symbol = symSubtraction
        when "*"      symbol = symMultiplication
        when "/"      symbol = symDivision
        when "("      symbol = symLeftParen
        when ")"      symbol = symRightParen
        when ""       symbol = symEndOfString
        otherwise     // if token is numeric, collect rest of digits
            hex = FALSE
            if not isNumeric() and not isHexChar()
                symbol = symError
            else
                symbol = symNumber          // Tag this as an integer value
                GetNextChar()
                if (Ch == "X")              // Allow c-style hex strings
                    hex = TRUE
                    GetNextChar()
                endif
                while isNumeric() or isHexChar()
                    token = token + ch
                    GetNextChar()
                endwhile
                if Ch == 'H' or Ch == '$'   // Allow assembly/Turbo Pascal hex strings
                    hex = TRUE
                    GetNextChar()
                endif
                if hex
                    token = token + 'H'
                endif
            endif
            hex = FALSE
            return ()
    endcase
    GetNextChar()
end

//
//  Set up globals so SimpleExpression starts off on the right foot
//
proc SyntaxError()
    Warn("Syntaxfehler im Ausdruck")
    Halt
end

proc ParenError()
    Warn("Die rechte Klammer fehlt")
    Halt
end

integer proc Factor()
    integer result, base = 10

    case symbol
        when symNumber                  // found a number
            if token[Length(token)] == 'H'
                token = substr(token, 1, Length(token) - 1)
                base = 16
            endif
            result = Val(token, base)            // get its value
            GetToken()                       // and skip to next
        when symLeftParen               // found a left paren
            GetToken()                       // skip over "("
            result = SimpleExpression()
            if  symbol <> symRightParen      // make sure the right paren exists
                ParenError()
            endif
            GetToken()                       // skip over ")"
        when symCOMP
            GetToken()
            result = ~Factor()
        otherwise
            SyntaxError()                 // not number or paren--error
    endcase
    return  (result)
end

integer proc Term()
    integer result, sym

    result = Factor()
    while  (symbol == symMultiplication) or     // "*" sign, or
           (symbol == symDivision) or           // "/" sign...
           (symbol == symMOD) or                // "%" sign...
           (symbol == symXOR) or                // "^" sign...
           (symbol == symSHR) or                // ">" sign...
           (symbol == symSHL) or                // "<" sign...
           (symbol == symAND)                   // "&" sign...
        sym = symbol
        GetToken()                      // skip over math op
        case sym
            when symMultiplication
                result = result * Factor()    // multiplication
            when symDivision
                result = result / Factor()    // division
            when symAND
                result = result & Factor()
            when symXOR
                result = result ^ Factor()
            when symMOD
                result = result mod Factor()
            when symSHR
                result = result shr Factor()
            when symSHL
                result = result shl Factor()
        endcase
    endwhile
    if symbol == symError
        SyntaxError()
    endif
    return (result)
end

integer proc SimpleExpression()
    integer result, sym

    result = Term()
    while  (symbol == symNumber     ) or       // another integer coming, or
           (symbol == symOR         ) or       // "|" sign, or
           (symbol == symAddition   ) or       // "+" sign, or
           (symbol == symSubtraction)          // "-" sign....
        sym = symbol
        if sym == symNumber            // if another integer came immediately
            sym = symAddition          // then default to adding
        else
            GetToken()                   // else skip over the math op
        endif
        case sym
            when symAddition
                result = result + Term()
            when symSubtraction
                result = result - Term()
            when symOR
                result = result | Term()
        endcase
    endwhile
    if symbol == symError
        SyntaxError()
    endif
    return (result)
end

keydef ExprHelpKey
    <F1>    QuickHelp(ExprHelp)
end

proc PromptStartup()
    Enable(ExprHelpKey)
    UnHook(PromptStartup)
end

proc Main()
    integer result

    loop
        Hook(_PROMPT_STARTUP_, PromptStartup)
        if Ask("Geben Sie den Ausdruck ein: (<F1> hilft)", InputLine) and Length(InputLine)
        // Prime the pump...
            Col   = 1
            Token = ''
            GetNextChar()
            GetToken()

            result = SimpleExpression()
            Message("Das Ergebnis ist: ", result, " (", str(result, 16), "h)")
        else
            break
        endif
    endloop
end
