/*************************************************************************
  Expand      Erweitert das aktuelle Teilwort auf in der Datei gefundene
              Worte

  Autor:      SemWare (Auf Grundlage der Ideen von Mel Hulse und
              Peter Birch)

  Datum:      8 Juli 1994

  bersicht:

  In dieser Makrodatei wird ein Makro bereitgestellt, das wie ein
  eingeschrnkter, dynamischer Schablonenmodus arbeitet. Es erweitert,
  oder vervollstndigt, das Teilwort links vom Cursor entsprechend
  anderer in der Datei vorgefundener Worte. Wenn Sie Expand aus der
  Potpourri Auswahlliste aufrufen, wird das Makro der Taste <Ctrl H>
  zugewiesen.

  Tasten:
              <Ctrl H>  Expand()

  Ist dieses Makro aktiviert, drcken Sie einfach dann <Ctrl H>, wenn
  Sie ein Teilwort unmittelbar vor dem Cursor vervollstndigen wollen.
  Das Makro sucht rckwrts und vorwrts in der Datei nach Worten, die
  mit der gleichen Zeichenkette beginnen, die Sie als Teilwort
  eingetippt haben. Wird nur eine Entsprechung gefunden, wird das
  Teilwort mit diesem ersetzt. Werden mehrere Entsprechungen gefunden,
  zeigt das Makro zuerst eine Auswahlliste gefundener Worte an.
  Plazieren Sie den Cursorbalken auf das gewnschte Wort und drcken Sie
  <Enter>. Ihr Teilwort wird dann mit dem gewhlten Wort ersetzt.

  Copyright 1992-1994 SemWare Corporation.  Alle Rechte weltweit
  vorbehalten.

  Der Gebrauch, die Abnderung und die Verbreitung dieses SAL Makro wird
  von SemWare ausdrcklich begrt, vorausgesetzt, da dieser Hinweis,
  zusammen mit obigen Copyright Hinweis, nicht entfernt wird und das
  keine Entgelt fr die Verbreitung entgegengenommen wird. Sie drfen
  Ihren eigenen Copyrightvermerk ergnzen, soweit dies Ihre nderungen
  oder Ergnzungen betrifft, aber SemWare bernimmt dafr keinen Support
  und keine Verantwortung.
*************************************************************************/

constant
    EXPAND_KEY = <Ctrl h>,
    COMMAND_COMPLETION_KEY = <CtrlShift h>,
    RANGE = 1000

integer work_id, curr_id, maxlen

proc PushString(string s)
    integer i = Length(s)

    while i
        PushKey(Asc(s[i]))
        i = i - 1
    endwhile
end

/************************************************************************
  Gather replacement candidates for abbrev, using the current marked block.
 ************************************************************************/
proc GatherCandidates(string abbrev, string options, integer minlen)
    string s[80]
    integer p

    PushPosition()
    while lFind(abbrev, options)
        p = CurrPos()
        if not Left() or not isWord()
            GotoPos(p + minlen)
            if isWord()
                while isWord() and Right()
                endwhile
                s = GetText(p, CurrPos() - p)
                GotoBufferId(work_id)
                if not lFind(s, "^$g")
                    EndFile()
                    AddLine(s)
                    if Length(s) > maxlen
                        maxlen = Length(s)
                    endif
                endif
                GotoBufferId(curr_id)
            endif
        endif
        GotoPos(p)
    endwhile
    PopPosition()
end

keydef ListKeyDef
<SpaceBar>  Down()
end

proc GrabSpaceBar()
    Enable(ListKeyDef)
    UnHook(GrabSpaceBar)
end

integer proc Expand()
    string abbrev[80], replacement[80]
    integer len, line, ok

    Set(Break, on)
    curr_id = GetBufferId()
    maxlen = 12

    ok = FALSE

// get word to left of cursor
    PushPosition()
    if not Left() or not isWord()
        PopPosition()
        return (ok)
    endif

    PushBlock()
    UnMarkBlock()
    MarkColumn()
    BegWord()
    PushPosition()
    abbrev = GetMarkedText()
    len = Length(abbrev)

// look above
    if CurrLine() > 1
        MarkLine(CurrLine() - RANGE, CurrLine())
        GatherCandidates(abbrev, "bl", len)
    endif

// look below
    if CurrLine() < NumLines()
        MarkLine(CurrLine(), CurrLine() + RANGE)
        GatherCandidates(abbrev, "l+", len)
    endif

    PopPosition()               // at replace point
// Choose which one
    GotoBufferId(work_id)
    if NumLines() == 0
        PopPosition()
        Message("Nichts gefunden...")
    else
        GotoLine(1)
        line = 1
        if NumLines() > 1
            PushString(abbrev)
            Hook(_LIST_STARTUP_, GrabSpaceBar)
            line = List("", maxlen)
        endif
        if line == 0
            PopPosition()
        else
            KillPosition()
            replacement = GetText(1, CurrLineLen())
            GotoBufferId(curr_id)
            ok = lReplace(abbrev, replacement, "1")
        endif
    endif
    EmptyBuffer(work_id)

    PopBlock()
    return (ok)
end

proc WhenLoaded()
    integer id = GetBufferId()

    work_id = CreateTempBuffer()
    GotoBufferId(id)
    if work_id == 0
        PurgeMacro(CurrMacroFilename())
    endif
end

proc WhenPurged()
    AbandonFile(work_id)
end

<EXPAND_KEY>                Expand()
//<COMMAND_COMPLETION_KEY>    CompleteCommand()

