/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 * 
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 * 
 * 
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed 
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * 36 David Road                 Phone:                    +617 3849 7731
 * Holland Park                  http://www.gu.edu.au/gwis/the/markh.html
 * Brisbane                      **** Maintainer PDCurses & REXX/SQL ****
 * QLD 4121                      ************* Author of THE ************
 * Australia                     ************* Member RexxLA ************
 */

/*
$Id: trace.c 2.1 1995/06/24 16:31:34 MH Rel MH $
*/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#ifdef PROTO
void trace_initialise(void);
void trace_function(char *);
void trace_return(void);
void trace_string(char *,...);
#else
void trace_initialise();
void trace_function();
void trace_return();
void trace_string();
#endif

char trace_save_str[40];
char trace_env[40];
FILE *trace_fp;
short trace_number,trace_level=(-1);

#ifdef PROTO
void trace_initialise(void)
#else
void trace_initialise()
#endif
{
 char *trace_env_ptr=getenv("TRACE");

 trace_fp = NULL;
 if (trace_env_ptr == NULL)
    return;
 strcpy(trace_env,trace_env_ptr);
 trace_number = trace_level = 0;
 return;
}

#ifdef PROTO
void trace_function(char *trace_str)
#else
void trace_function(trace_str)
char *trace_str;
#endif
{

 register int i;
 if (trace_level == (-1))
    return;
 if (strcmp(trace_str,trace_save_str) == 0)
   {
    trace_number++;
    trace_level++;
    return;
   }
 trace_fp = fopen(trace_env,"a");
 fprintf(trace_fp,"%5d\n",trace_number);
 for (i=0;i<trace_level;i++)
     fprintf(trace_fp,"  ");
 fprintf(trace_fp,"(%d)%-s",trace_level,trace_str);
 for (i=0;i<60-(trace_level*2)-strlen(trace_str);i++)
     fprintf(trace_fp," ");

 trace_number = 1;
 trace_level++;
 fclose(trace_fp);
 strcpy(trace_save_str,trace_str);
 return;
}

#ifdef PROTO
void trace_return(void)
#else
void trace_return()
#endif
{
 if (trace_level == (-1))
    return;
 trace_level--;
 if (trace_level < 0)
    fprintf(trace_fp,"****** trace level below zero ********");

 return;
}

#ifdef PROTO
void trace_string(char *fmt,...)
#else
void trace_string(fmt)
char *fmt;
#endif
{
 va_list args;

 if (trace_level == (-1))
    return;
 va_start(args,fmt);
 trace_fp = fopen(trace_env,"a");
 vfprintf(trace_fp,fmt,args);
 fclose(trace_fp);
 va_end(args);
 return;
}
