/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * 36 David Road                 Phone:                    +617 3849 7731
 * Holland Park                  http://www.gu.edu.au/gwis/the/markh.html
 * Brisbane                      **** Maintainer PDCurses & REXX/SQL ****
 * QLD 4121                      ************* Author of THE ************
 * Australia                     ************* Member RexxLA ************
 */

/*
$Id: key.h 2.1 1995/06/24 16:30:16 MH Rel MH $
*/

#if defined(USE_EXTCURSES)
# include <cur02.h>
#endif

#include "getch.h"

struct key_values
{
 CHARTYPE *mnemonic;
 int key_value;
};
typedef struct key_values KEYS;

KEYS key_table[] =
{
  {(CHARTYPE *)"A",(int)'a'},
  {(CHARTYPE *)"B",(int)'b'},
  {(CHARTYPE *)"C",(int)'c'},
  {(CHARTYPE *)"D",(int)'d'},
  {(CHARTYPE *)"E",(int)'e'},
  {(CHARTYPE *)"F",(int)'f'},
  {(CHARTYPE *)"G",(int)'g'},
  {(CHARTYPE *)"H",(int)'h'},
  {(CHARTYPE *)"I",(int)'i'},
  {(CHARTYPE *)"J",(int)'j'},
  {(CHARTYPE *)"K",(int)'k'},
  {(CHARTYPE *)"L",(int)'l'},
  {(CHARTYPE *)"M",(int)'m'},
  {(CHARTYPE *)"N",(int)'n'},
  {(CHARTYPE *)"O",(int)'o'},
  {(CHARTYPE *)"P",(int)'p'},
  {(CHARTYPE *)"Q",(int)'q'},
  {(CHARTYPE *)"R",(int)'r'},
  {(CHARTYPE *)"S",(int)'s'},
  {(CHARTYPE *)"T",(int)'t'},
  {(CHARTYPE *)"U",(int)'u'},
  {(CHARTYPE *)"V",(int)'v'},
  {(CHARTYPE *)"W",(int)'w'},
  {(CHARTYPE *)"X",(int)'x'},
  {(CHARTYPE *)"Y",(int)'y'},
  {(CHARTYPE *)"Z",(int)'z'},
  {(CHARTYPE *)"S-A",(int)'A'},
  {(CHARTYPE *)"S-B",(int)'B'},
  {(CHARTYPE *)"S-C",(int)'C'},
  {(CHARTYPE *)"S-D",(int)'D'},
  {(CHARTYPE *)"S-E",(int)'E'},
  {(CHARTYPE *)"S-F",(int)'F'},
  {(CHARTYPE *)"S-G",(int)'G'},
  {(CHARTYPE *)"S-H",(int)'H'},
  {(CHARTYPE *)"S-I",(int)'I'},
  {(CHARTYPE *)"S-J",(int)'J'},
  {(CHARTYPE *)"S-K",(int)'K'},
  {(CHARTYPE *)"S-L",(int)'L'},
  {(CHARTYPE *)"S-M",(int)'M'},
  {(CHARTYPE *)"S-N",(int)'N'},
  {(CHARTYPE *)"S-O",(int)'O'},
  {(CHARTYPE *)"S-P",(int)'P'},
  {(CHARTYPE *)"S-Q",(int)'Q'},
  {(CHARTYPE *)"S-R",(int)'R'},
  {(CHARTYPE *)"S-S",(int)'S'},
  {(CHARTYPE *)"S-T",(int)'T'},
  {(CHARTYPE *)"S-U",(int)'U'},
  {(CHARTYPE *)"S-V",(int)'V'},
  {(CHARTYPE *)"S-W",(int)'W'},
  {(CHARTYPE *)"S-X",(int)'X'},
  {(CHARTYPE *)"S-Y",(int)'Y'},
  {(CHARTYPE *)"S-Z",(int)'Z'},
  {(CHARTYPE *)"0",(int)'0'},
  {(CHARTYPE *)"1",(int)'1'},
  {(CHARTYPE *)"2",(int)'2'},
  {(CHARTYPE *)"3",(int)'3'},
  {(CHARTYPE *)"4",(int)'4'},
  {(CHARTYPE *)"5",(int)'5'},
  {(CHARTYPE *)"6",(int)'6'},
  {(CHARTYPE *)"7",(int)'7'},
  {(CHARTYPE *)"8",(int)'8'},
  {(CHARTYPE *)"9",(int)'9'},
  {(CHARTYPE *)"`",(int)'`'},
  {(CHARTYPE *)"-",(int)'-'},
  {(CHARTYPE *)"=",(int)'='},
  {(CHARTYPE *)"[",(int)'['},
  {(CHARTYPE *)"]",(int)']'},
  {(CHARTYPE *)"\\",(int)'\\'},
  {(CHARTYPE *)";",(int)';'},
  {(CHARTYPE *)"'",(int)'\''},
  {(CHARTYPE *)",",(int)','},
  {(CHARTYPE *)".",(int)'.'},
  {(CHARTYPE *)"/",(int)'/'},
  {(CHARTYPE *)")",(int)')'},
  {(CHARTYPE *)"!",(int)'!'},
  {(CHARTYPE *)"@",(int)'@'},
  {(CHARTYPE *)"#",(int)'#'},
  {(CHARTYPE *)"$",(int)'$'},
  {(CHARTYPE *)"%",(int)'%'},
  {(CHARTYPE *)"^",(int)'^'},
  {(CHARTYPE *)"&",(int)'&'},
  {(CHARTYPE *)"*",(int)'*'},
  {(CHARTYPE *)"(",(int)'('},
  {(CHARTYPE *)"~",(int)'~'},
  {(CHARTYPE *)"_",(int)'_'},
  {(CHARTYPE *)"+",(int)'+'},
  {(CHARTYPE *)"{",(int)'{'},
  {(CHARTYPE *)"}",(int)'}'},
  {(CHARTYPE *)"|",(int)'|'},
  {(CHARTYPE *)":",(int)':'},
  {(CHARTYPE *)"\"",(int)'\"'},
  {(CHARTYPE *)"<",(int)'<'},
  {(CHARTYPE *)">",(int)'>'},
  {(CHARTYPE *)"?",(int)'?'},
  {(CHARTYPE *)"SPACE",(int)' '},

#if defined(DOS) || defined(OS2)
/* normal characters */
  {(CHARTYPE *)"CURU",KEY_CURU},
  {(CHARTYPE *)"CURD",KEY_CURD},
  {(CHARTYPE *)"CURL",KEY_CURL},
  {(CHARTYPE *)"CURR",KEY_CURR},
  {(CHARTYPE *)"ENTER",KEY_RETURN },
  {(CHARTYPE *)"TAB",KEY_TAB },
  {(CHARTYPE *)"ESC",KEY_ESC },
  {(CHARTYPE *)"BKSP",KEY_BKSP },
  {(CHARTYPE *)"F1",KEY_F1},
  {(CHARTYPE *)"F2",KEY_F2},
  {(CHARTYPE *)"F3",KEY_F3},
  {(CHARTYPE *)"F4",KEY_F4},
  {(CHARTYPE *)"F5",KEY_F5},
  {(CHARTYPE *)"F6",KEY_F6},
  {(CHARTYPE *)"F7",KEY_F7},
  {(CHARTYPE *)"F8",KEY_F8},
  {(CHARTYPE *)"F9",KEY_F9},
  {(CHARTYPE *)"F10",KEY_F10},
  {(CHARTYPE *)"F11",KEY_F11},
  {(CHARTYPE *)"F12",KEY_F12},
  {(CHARTYPE *)"HOME",KEY_HOME},
  {(CHARTYPE *)"PGUP",KEY_PGUP},
  {(CHARTYPE *)"PGDN",KEY_PGDN},
  {(CHARTYPE *)"END",KEY_END},
  {(CHARTYPE *)"INS",KEY_INS},
  {(CHARTYPE *)"DEL",KEY_DEL},
  {(CHARTYPE *)"CENTER",KEY_NUMCENTER },
  {(CHARTYPE *)"PLUS",KEY_NUMPLUS},
  {(CHARTYPE *)"MINUS",KEY_NUMMINUS},
  {(CHARTYPE *)"SLASH",KEY_NUMSLASH},
  {(CHARTYPE *)"STAR",KEY_NUMSTAR},
  {(CHARTYPE *)"NUMENTER",KEY_NUMENTER},
/* shifted characters */
  {(CHARTYPE *)"S-TAB",KEY_S_TAB },
  {(CHARTYPE *)"S-F1",KEY_S_F1},
  {(CHARTYPE *)"S-F2",KEY_S_F2},
  {(CHARTYPE *)"S-F3",KEY_S_F3},
  {(CHARTYPE *)"S-F4",KEY_S_F4},
  {(CHARTYPE *)"S-F5",KEY_S_F5},
  {(CHARTYPE *)"S-F6",KEY_S_F6},
  {(CHARTYPE *)"S-F7",KEY_S_F7},
  {(CHARTYPE *)"S-F8",KEY_S_F8},
  {(CHARTYPE *)"S-F9",KEY_S_F9},
  {(CHARTYPE *)"S-F10",KEY_S_F10},
  {(CHARTYPE *)"S-F11",KEY_S_F11},
  {(CHARTYPE *)"S-F12",KEY_S_F12},
  {(CHARTYPE *)"S-HOME",KEY_S_HOME},
  {(CHARTYPE *)"S-PGUP",KEY_S_PGUP},
  {(CHARTYPE *)"S-PGDN",KEY_S_PGDN},
  {(CHARTYPE *)"S-CURU",KEY_S_CURU},
  {(CHARTYPE *)"S-CURD",KEY_S_CURD},
  {(CHARTYPE *)"S-CURL",KEY_S_CURL},
  {(CHARTYPE *)"S-CURR",KEY_S_CURR},
  {(CHARTYPE *)"S-END",KEY_S_END},
  {(CHARTYPE *)"S-INS",KEY_S_INS},
  {(CHARTYPE *)"S-DEL",KEY_S_DEL},
  {(CHARTYPE *)"S-CENTER",KEY_S_NUMCENTER},
  {(CHARTYPE *)"S-NUMSTOP",KEY_S_NUMSTOP},
  {(CHARTYPE *)"S-NUM0",KEY_S_NUM0},
  {(CHARTYPE *)"S-NUM1",KEY_S_NUM1},
  {(CHARTYPE *)"S-NUM2",KEY_S_NUM2},
  {(CHARTYPE *)"S-NUM3",KEY_S_NUM3},
  {(CHARTYPE *)"S-NUM4",KEY_S_NUM4},
  {(CHARTYPE *)"S-NUM6",KEY_S_NUM6},
  {(CHARTYPE *)"S-NUM7",KEY_S_NUM7},
  {(CHARTYPE *)"S-NUM8",KEY_S_NUM8},
  {(CHARTYPE *)"S-NUM9",KEY_S_NUM9},
/* control characters */
  {(CHARTYPE *)"C-2",KEY_C_2  },
  {(CHARTYPE *)"C-6",KEY_C_6  },
  {(CHARTYPE *)"C--",KEY_C_MINUS  },
  {(CHARTYPE *)"C-[",KEY_C_LBRACKET  },
  {(CHARTYPE *)"C-]",KEY_C_RBRACKET  },
  {(CHARTYPE *)"C-\\",KEY_C_BSLASH  },
  {(CHARTYPE *)"C-ENTER",KEY_C_ENTER },
  {(CHARTYPE *)"C-TAB",KEY_C_TAB},
  {(CHARTYPE *)"C-BKSP",KEY_C_BKSP  },
  {(CHARTYPE *)"C-F1",KEY_C_F1},
  {(CHARTYPE *)"C-F2",KEY_C_F2},
  {(CHARTYPE *)"C-F3",KEY_C_F3},
  {(CHARTYPE *)"C-F4",KEY_C_F4},
  {(CHARTYPE *)"C-F5",KEY_C_F5},
  {(CHARTYPE *)"C-F6",KEY_C_F6},
  {(CHARTYPE *)"C-F7",KEY_C_F7},
  {(CHARTYPE *)"C-F8",KEY_C_F8},
  {(CHARTYPE *)"C-F9",KEY_C_F9},
  {(CHARTYPE *)"C-F10",KEY_C_F10},
  {(CHARTYPE *)"C-F11",KEY_C_F11},
  {(CHARTYPE *)"C-F12",KEY_C_F12},
  {(CHARTYPE *)"C-HOME",KEY_C_HOME},
  {(CHARTYPE *)"C-PGUP",KEY_C_PGUP},
  {(CHARTYPE *)"C-PGDN",KEY_C_PGDN},
  {(CHARTYPE *)"C-CURU",KEY_C_CURU},
  {(CHARTYPE *)"C-CURD",KEY_C_CURD},
  {(CHARTYPE *)"C-CURL",KEY_C_CURL},
  {(CHARTYPE *)"C-CURR",KEY_C_CURR},
  {(CHARTYPE *)"C-END",KEY_C_END},
  {(CHARTYPE *)"C-INS",KEY_C_INS},
  {(CHARTYPE *)"C-DEL",KEY_C_DEL},
  {(CHARTYPE *)"C-CENTER",KEY_C_NUMCENTER},
  {(CHARTYPE *)"C-NUMSTOP",KEY_C_NUMSTOP},
  {(CHARTYPE *)"C-NUM0",KEY_C_NUM0},
  {(CHARTYPE *)"C-NUM1",KEY_C_NUM1},
  {(CHARTYPE *)"C-NUM2",KEY_C_NUM2},
  {(CHARTYPE *)"C-NUM3",KEY_C_NUM3},
  {(CHARTYPE *)"C-NUM4",KEY_C_NUM4},
  {(CHARTYPE *)"C-NUM6",KEY_C_NUM6},
  {(CHARTYPE *)"C-NUM7",KEY_C_NUM7},
  {(CHARTYPE *)"C-NUM8",KEY_C_NUM8},
  {(CHARTYPE *)"C-NUM9",KEY_C_NUM9},
  {(CHARTYPE *)"C-PLUS",KEY_C_NUMPLUS},
  {(CHARTYPE *)"C-MINUS",KEY_C_NUMMINUS},
  {(CHARTYPE *)"C-SLASH",KEY_C_NUMSLASH},
  {(CHARTYPE *)"C-STAR",KEY_C_NUMSTAR},
  {(CHARTYPE *)"C-NUMENTER",KEY_C_NUMENTER},
/* alt characters */
  {(CHARTYPE *)"A-A",KEY_A_a},
  {(CHARTYPE *)"A-B",KEY_A_b},
  {(CHARTYPE *)"A-C",KEY_A_c},
  {(CHARTYPE *)"A-D",KEY_A_d},
  {(CHARTYPE *)"A-E",KEY_A_e},
  {(CHARTYPE *)"A-F",KEY_A_f},
  {(CHARTYPE *)"A-G",KEY_A_g},
  {(CHARTYPE *)"A-H",KEY_A_h},
  {(CHARTYPE *)"A-I",KEY_A_i},
  {(CHARTYPE *)"A-J",KEY_A_j},
  {(CHARTYPE *)"A-K",KEY_A_k},
  {(CHARTYPE *)"A-L",KEY_A_l},
  {(CHARTYPE *)"A-M",KEY_A_m},
  {(CHARTYPE *)"A-N",KEY_A_n},
  {(CHARTYPE *)"A-O",KEY_A_o},
  {(CHARTYPE *)"A-P",KEY_A_p},
  {(CHARTYPE *)"A-Q",KEY_A_q},
  {(CHARTYPE *)"A-R",KEY_A_r},
  {(CHARTYPE *)"A-S",KEY_A_s},
  {(CHARTYPE *)"A-T",KEY_A_t},
  {(CHARTYPE *)"A-U",KEY_A_u},
  {(CHARTYPE *)"A-V",KEY_A_v},
  {(CHARTYPE *)"A-W",KEY_A_w},
  {(CHARTYPE *)"A-X",KEY_A_x},
  {(CHARTYPE *)"A-Y",KEY_A_y},
  {(CHARTYPE *)"A-Z",KEY_A_z},
  {(CHARTYPE *)"A-0",KEY_A_0},
  {(CHARTYPE *)"A-1",KEY_A_1},
  {(CHARTYPE *)"A-2",KEY_A_2},
  {(CHARTYPE *)"A-3",KEY_A_3},
  {(CHARTYPE *)"A-4",KEY_A_4},
  {(CHARTYPE *)"A-5",KEY_A_5},
  {(CHARTYPE *)"A-6",KEY_A_6},
  {(CHARTYPE *)"A-7",KEY_A_7},
  {(CHARTYPE *)"A-8",KEY_A_8},
  {(CHARTYPE *)"A-9",KEY_A_9},
  {(CHARTYPE *)"A-`",KEY_A_BQUOTE},
  {(CHARTYPE *)"A--",KEY_A_MINUS},
  {(CHARTYPE *)"A-=",KEY_A_EQUAL},
  {(CHARTYPE *)"A-[",KEY_A_LBRACKET},
  {(CHARTYPE *)"A-]",KEY_A_RBRACKET},
  {(CHARTYPE *)"A-\\",KEY_A_BSLASH},
  {(CHARTYPE *)"A-;",KEY_A_SEMICOLON},
  {(CHARTYPE *)"A-'",KEY_A_FQUOTE},
  {(CHARTYPE *)"A-,",KEY_A_COMMA},
  {(CHARTYPE *)"A-.",KEY_A_STOP},
  {(CHARTYPE *)"A-/",KEY_A_FSLASH},
  {(CHARTYPE *)"A-ENTER",KEY_A_ENTER},
  {(CHARTYPE *)"A-TAB",KEY_A_TAB},
  {(CHARTYPE *)"A-ESC",KEY_A_ESC },
  {(CHARTYPE *)"A-BKSP",KEY_A_BKSP },
  {(CHARTYPE *)"A-F1",KEY_A_F1},
  {(CHARTYPE *)"A-F2",KEY_A_F2},
  {(CHARTYPE *)"A-F3",KEY_A_F3},
  {(CHARTYPE *)"A-F4",KEY_A_F4},
  {(CHARTYPE *)"A-F5",KEY_A_F5},
  {(CHARTYPE *)"A-F6",KEY_A_F6},
  {(CHARTYPE *)"A-F7",KEY_A_F7},
  {(CHARTYPE *)"A-F8",KEY_A_F8},
  {(CHARTYPE *)"A-F9",KEY_A_F9},
  {(CHARTYPE *)"A-F10",KEY_A_F10},
  {(CHARTYPE *)"A-F11",KEY_A_F11},
  {(CHARTYPE *)"A-F12",KEY_A_F12},
  {(CHARTYPE *)"A-HOME",KEY_A_HOME},
  {(CHARTYPE *)"A-PGUP",KEY_A_PGUP},
  {(CHARTYPE *)"A-PGDN",KEY_A_PGDN},
  {(CHARTYPE *)"A-CURU",KEY_A_CURU},
  {(CHARTYPE *)"A-CURD",KEY_A_CURD},
  {(CHARTYPE *)"A-CURL",KEY_A_CURL},
  {(CHARTYPE *)"A-CURR",KEY_A_CURR},
  {(CHARTYPE *)"A-END",KEY_A_END},
  {(CHARTYPE *)"A-INS",KEY_A_INS},
  {(CHARTYPE *)"A-DEL",KEY_A_DEL},
  {(CHARTYPE *)"A-PLUS",KEY_A_NUMPLUS},
  {(CHARTYPE *)"A-MINUS",KEY_A_NUMMINUS},
  {(CHARTYPE *)"A-SLASH",KEY_A_NUMSLASH},
  {(CHARTYPE *)"A-STAR",KEY_A_NUMSTAR},
  {(CHARTYPE *)"A-NUMENTER",KEY_A_NUMENTER},
#else
  {(CHARTYPE *)"CURD"     ,KEY_DOWN },
  {(CHARTYPE *)"CURU"     ,KEY_UP },
  {(CHARTYPE *)"CURL"     ,KEY_LEFT },
  {(CHARTYPE *)"CURR"     ,KEY_RIGHT},
  {(CHARTYPE *)"BACKSPACE",KEY_BACKSPACE},
  {(CHARTYPE *)"HOME"     ,KEY_HOME},
  {(CHARTYPE *)"Help"     ,KEY_Help},
  {(CHARTYPE *)"Do"       ,KEY_Do},
  {(CHARTYPE *)"PF1"      ,KEY_PF1},
  {(CHARTYPE *)"PF2"      ,KEY_PF2},
  {(CHARTYPE *)"PF3"      ,KEY_PF3},
  {(CHARTYPE *)"PF4"      ,KEY_PF4},
  {(CHARTYPE *)"Pad0"     ,KEY_Pad0},
  {(CHARTYPE *)"Pad1"     ,KEY_Pad1},
  {(CHARTYPE *)"Pad2"     ,KEY_Pad2},
  {(CHARTYPE *)"Pad3"     ,KEY_Pad3},
  {(CHARTYPE *)"Pad4"     ,KEY_Pad4},
  {(CHARTYPE *)"Pad5"     ,KEY_Pad5},
  {(CHARTYPE *)"Pad6"     ,KEY_Pad6},
  {(CHARTYPE *)"Pad7"     ,KEY_Pad7},
  {(CHARTYPE *)"Pad8"     ,KEY_Pad8},
  {(CHARTYPE *)"Pad9"     ,KEY_Pad9},
  {(CHARTYPE *)"PadEnter" ,KEY_PadEnter},
  {(CHARTYPE *)"PadMinus" ,KEY_PadMinus},
  {(CHARTYPE *)"PadPeriod",KEY_PadPeriod},
  {(CHARTYPE *)"PadComma" ,KEY_PadComma},
  {(CHARTYPE *)"BackTab"  ,KEY_BackTab},
  {(CHARTYPE *)"Find"     ,KEY_Find},
  {(CHARTYPE *)"InsertHere",KEY_InsertHere},
  {(CHARTYPE *)"Remove"   ,KEY_Remove},
  {(CHARTYPE *)"Select"   ,KEY_Select},
  {(CHARTYPE *)"PrevScreen",KEY_PrevScreen},
  {(CHARTYPE *)"PrevScrn" ,KEY_PrevScrn},
  {(CHARTYPE *)"NextScreen",KEY_NextScreen},
  {(CHARTYPE *)"NextScrn" ,KEY_NextScrn},
  {(CHARTYPE *)"S-F1"     ,KEY_SF1},
  {(CHARTYPE *)"S-F2"     ,KEY_SF2},
  {(CHARTYPE *)"S-F3"     ,KEY_SF3},
  {(CHARTYPE *)"S-F4"     ,KEY_SF4},
  {(CHARTYPE *)"S-F5"     ,KEY_SF5},
  {(CHARTYPE *)"S-F6"     ,KEY_SF6},
  {(CHARTYPE *)"S-F7"     ,KEY_SF7},
  {(CHARTYPE *)"S-F8"     ,KEY_SF8},
  {(CHARTYPE *)"S-F9"     ,KEY_SF9},
  {(CHARTYPE *)"S-F10"    ,KEY_SF10},
  {(CHARTYPE *)"S-F11"    ,KEY_SF11},
  {(CHARTYPE *)"S-F12"    ,KEY_SF12},
  {(CHARTYPE *)"S-F13"    ,KEY_SF13},
  {(CHARTYPE *)"S-F14"    ,KEY_SF14},
  {(CHARTYPE *)"S-F15"    ,KEY_SF15},
  {(CHARTYPE *)"S-Help"   ,KEY_SHelp},
  {(CHARTYPE *)"S-F16"    ,KEY_SF16},
  {(CHARTYPE *)"S-Do"     ,KEY_SDo},
  {(CHARTYPE *)"S-F17"    ,KEY_SF17},
  {(CHARTYPE *)"S-F18"    ,KEY_SF18},
  {(CHARTYPE *)"S-F19"    ,KEY_SF19},
  {(CHARTYPE *)"S-F20"    ,KEY_SF20},
#if defined(USE_EXTCURSES)
  {(CHARTYPE *)"TAB"      ,KEY_TAB},
  {(CHARTYPE *)"ENTER"    ,KEY_NEWL},
#else
  {(CHARTYPE *)"TAB"      ,KEY_C_i},
  {(CHARTYPE *)"ENTER"    ,KEY_RETURN},
#endif
  {(CHARTYPE *)"Escape"   ,Escape},
  {(CHARTYPE *)"Del"      ,Del},
  {(CHARTYPE *)"CSI"      ,CSI},
  {(CHARTYPE *)"BREAK"    ,KEY_BREAK },
  {(CHARTYPE *)"F0"       ,KEY_F0},
  {(CHARTYPE *)"F1"       ,(KEY_F(0)+1)},
  {(CHARTYPE *)"F2"       ,(KEY_F(0)+2)},
  {(CHARTYPE *)"F3"       ,(KEY_F(0)+3)},
  {(CHARTYPE *)"F4"       ,(KEY_F(0)+4)},
  {(CHARTYPE *)"F5"       ,(KEY_F(0)+5)},
  {(CHARTYPE *)"F6"       ,(KEY_F(0)+6)},
  {(CHARTYPE *)"F7"       ,(KEY_F(0)+7)},
  {(CHARTYPE *)"F8"       ,(KEY_F(0)+8)},
  {(CHARTYPE *)"F9"       ,(KEY_F(0)+9)},
  {(CHARTYPE *)"F10"      ,(KEY_F(0)+10)},
  {(CHARTYPE *)"F11"      ,(KEY_F(0)+11)},
  {(CHARTYPE *)"F12"      ,(KEY_F(0)+12)},
  {(CHARTYPE *)"F13"      ,(KEY_F(0)+13)},
  {(CHARTYPE *)"F14"      ,(KEY_F(0)+14)},
  {(CHARTYPE *)"F15"      ,(KEY_F(0)+15)},
  {(CHARTYPE *)"F16"      ,(KEY_F(0)+16)},
  {(CHARTYPE *)"F17"      ,(KEY_F(0)+17)},
  {(CHARTYPE *)"F18"      ,(KEY_F(0)+18)},
  {(CHARTYPE *)"F19"      ,(KEY_F(0)+19)},
  {(CHARTYPE *)"F20"      ,(KEY_F(0)+20)},
  {(CHARTYPE *)"F21"      ,(KEY_F(0)+21)},
  {(CHARTYPE *)"F22"      ,(KEY_F(0)+22)},
  {(CHARTYPE *)"F23"      ,(KEY_F(0)+23)},
  {(CHARTYPE *)"F24"      ,(KEY_F(0)+24)},
  {(CHARTYPE *)"F25"      ,(KEY_F(0)+25)},
  {(CHARTYPE *)"F26"      ,(KEY_F(0)+26)},
  {(CHARTYPE *)"F27"      ,(KEY_F(0)+27)},
  {(CHARTYPE *)"F28"      ,(KEY_F(0)+28)},
  {(CHARTYPE *)"F29"      ,(KEY_F(0)+29)},
  {(CHARTYPE *)"F30"      ,(KEY_F(0)+30)},
  {(CHARTYPE *)"F31"      ,(KEY_F(0)+31)},
  {(CHARTYPE *)"F32"      ,(KEY_F(0)+32)},
  {(CHARTYPE *)"F33"      ,(KEY_F(0)+33)},
  {(CHARTYPE *)"F34"      ,(KEY_F(0)+34)},
  {(CHARTYPE *)"F35"      ,(KEY_F(0)+35)},
  {(CHARTYPE *)"F36"      ,(KEY_F(0)+36)},
  {(CHARTYPE *)"F37"      ,(KEY_F(0)+37)},
  {(CHARTYPE *)"F38"      ,(KEY_F(0)+38)},
  {(CHARTYPE *)"F39"      ,(KEY_F(0)+39)},
  {(CHARTYPE *)"F40"      ,(KEY_F(0)+40)},
  {(CHARTYPE *)"F41"      ,(KEY_F(0)+41)},
  {(CHARTYPE *)"F42"      ,(KEY_F(0)+42)},
  {(CHARTYPE *)"F43"      ,(KEY_F(0)+43)},
  {(CHARTYPE *)"F44"      ,(KEY_F(0)+44)},
  {(CHARTYPE *)"F45"      ,(KEY_F(0)+45)},
  {(CHARTYPE *)"F46"      ,(KEY_F(0)+46)},
  {(CHARTYPE *)"F47"      ,(KEY_F(0)+47)},
  {(CHARTYPE *)"F48"      ,(KEY_F(0)+48)},
  {(CHARTYPE *)"F49"      ,(KEY_F(0)+49)},
  {(CHARTYPE *)"F50"      ,(KEY_F(0)+50)},
  {(CHARTYPE *)"F51"      ,(KEY_F(0)+51)},
  {(CHARTYPE *)"F52"      ,(KEY_F(0)+52)},
  {(CHARTYPE *)"F53"      ,(KEY_F(0)+53)},
  {(CHARTYPE *)"F54"      ,(KEY_F(0)+54)},
  {(CHARTYPE *)"F55"      ,(KEY_F(0)+55)},
  {(CHARTYPE *)"F56"      ,(KEY_F(0)+56)},
  {(CHARTYPE *)"F57"      ,(KEY_F(0)+57)},
  {(CHARTYPE *)"F58"      ,(KEY_F(0)+58)},
  {(CHARTYPE *)"F59"      ,(KEY_F(0)+59)},
  {(CHARTYPE *)"F60"      ,(KEY_F(0)+60)},
  {(CHARTYPE *)"F61"      ,(KEY_F(0)+61)},
  {(CHARTYPE *)"F62"      ,(KEY_F(0)+62)},
  {(CHARTYPE *)"F63"      ,(KEY_F(0)+63)},
  {(CHARTYPE *)"F64"      ,(KEY_F(0)+64)},
  {(CHARTYPE *)"DL"       ,KEY_DL},
  {(CHARTYPE *)"IL"       ,KEY_IL},
  {(CHARTYPE *)"DC"       ,KEY_DC},
  {(CHARTYPE *)"IC"       ,KEY_IC},
  {(CHARTYPE *)"EIC"      ,KEY_EIC},
  {(CHARTYPE *)"CLEAR"    ,KEY_CLEAR},
  {(CHARTYPE *)"EOS"      ,KEY_EOS},
  {(CHARTYPE *)"EOL"      ,KEY_EOL},
  {(CHARTYPE *)"SF"       ,KEY_SF},
  {(CHARTYPE *)"SR"       ,KEY_SR},
  {(CHARTYPE *)"NPAGE"    ,KEY_NPAGE},
  {(CHARTYPE *)"PPAGE"    ,KEY_PPAGE},
  {(CHARTYPE *)"STAB"     ,KEY_STAB},
  {(CHARTYPE *)"CTAB"     ,KEY_CTAB},
  {(CHARTYPE *)"CATAB"    ,KEY_CATAB},
  {(CHARTYPE *)"ENTER"    ,KEY_ENTER},
  {(CHARTYPE *)"S-RESET"  ,KEY_SRESET},
  {(CHARTYPE *)"RESET"    ,KEY_RESET},
  {(CHARTYPE *)"PRINT"    ,KEY_PRINT},
  {(CHARTYPE *)"LL"       ,KEY_LL},
  {(CHARTYPE *)"A1"       ,KEY_A1},
  {(CHARTYPE *)"A3"       ,KEY_A3},
  {(CHARTYPE *)"B2"       ,KEY_B2},
  {(CHARTYPE *)"C1"       ,KEY_C1},
  {(CHARTYPE *)"C3"       ,KEY_C3},
  {(CHARTYPE *)"S-TAB"    ,KEY_BTAB},
  {(CHARTYPE *)"BEG"      ,KEY_BEG},
  {(CHARTYPE *)"CANCEL"   ,KEY_CANCEL},
  {(CHARTYPE *)"CLOSE"    ,KEY_CLOSE},
  {(CHARTYPE *)"COMMAND"  ,KEY_COMMAND},
  {(CHARTYPE *)"COPY"     ,KEY_COPY},
  {(CHARTYPE *)"CREATE"   ,KEY_CREATE},
  {(CHARTYPE *)"END"      ,KEY_END},
  {(CHARTYPE *)"EXIT"     ,KEY_EXIT},
  {(CHARTYPE *)"FIND"     ,KEY_FIND},
  {(CHARTYPE *)"HELP"     ,KEY_HELP},
  {(CHARTYPE *)"MARK"     ,KEY_MARK},
  {(CHARTYPE *)"MESSAGE"  ,KEY_MESSAGE},
  {(CHARTYPE *)"MOVE"     ,KEY_MOVE},
  {(CHARTYPE *)"NEXT"     ,KEY_NEXT},
  {(CHARTYPE *)"OPEN"     ,KEY_OPEN},
  {(CHARTYPE *)"OPTIONS"  ,KEY_OPTIONS},
  {(CHARTYPE *)"PREVIOUS" ,KEY_PREVIOUS},
  {(CHARTYPE *)"REDO"     ,KEY_REDO},
  {(CHARTYPE *)"REFERENCE",KEY_REFERENCE},
  {(CHARTYPE *)"REFRESH"  ,KEY_REFRESH},
  {(CHARTYPE *)"REPLACE"  ,KEY_REPLACE},
  {(CHARTYPE *)"RESTART"  ,KEY_RESTART},
  {(CHARTYPE *)"RESUME"   ,KEY_RESUME},
  {(CHARTYPE *)"SAVE"     ,KEY_SAVE},
  {(CHARTYPE *)"S-BEG"    ,KEY_SBEG},
  {(CHARTYPE *)"S-CANCEL" ,KEY_SCANCEL},
  {(CHARTYPE *)"S-COMMAND",KEY_SCOMMAND},
  {(CHARTYPE *)"S-COPY"   ,KEY_SCOPY},
  {(CHARTYPE *)"S-CREATE" ,KEY_SCREATE},
  {(CHARTYPE *)"S-DC"     ,KEY_SDC},
  {(CHARTYPE *)"S-DL"     ,KEY_SDL},
  {(CHARTYPE *)"SELECT"   ,KEY_SELECT},
  {(CHARTYPE *)"S-END"    ,KEY_SEND},
  {(CHARTYPE *)"S-EOL"    ,KEY_SEOL},
  {(CHARTYPE *)"S-EXIT"   ,KEY_SEXIT},
  {(CHARTYPE *)"S-FIND"   ,KEY_SFIND},
  {(CHARTYPE *)"S-HELP"   ,KEY_SHELP},
  {(CHARTYPE *)"S-HOME"   ,KEY_SHOME},
  {(CHARTYPE *)"S-IC"     ,KEY_SIC},
  {(CHARTYPE *)"S-CURL"   ,KEY_SLEFT},
  {(CHARTYPE *)"S-MESSAGE",KEY_SMESSAGE},
  {(CHARTYPE *)"S-MOVE"   ,KEY_SMOVE},
  {(CHARTYPE *)"S-NEXT"   ,KEY_SNEXT},
  {(CHARTYPE *)"S-OPTIONS",KEY_SOPTIONS},
  {(CHARTYPE *)"S-PREVIOUS",KEY_SPREVIOUS},
  {(CHARTYPE *)"S-PRINT"  ,KEY_SPRINT},
  {(CHARTYPE *)"S-REDO"   ,KEY_SREDO},
  {(CHARTYPE *)"S-REPLACE",KEY_SREPLACE},
  {(CHARTYPE *)"S-CURR"   ,KEY_SRIGHT},
  {(CHARTYPE *)"S-RSUME"  ,KEY_SRSUME},
  {(CHARTYPE *)"S-SAVE"   ,KEY_SSAVE},
  {(CHARTYPE *)"S-SUSPEND",KEY_SSUSPEND},
  {(CHARTYPE *)"S-UNDO"   ,KEY_SUNDO},
  {(CHARTYPE *)"SUSPEND"  ,KEY_SUSPEND},
  {(CHARTYPE *)"UNDO"     ,KEY_UNDO},
  {(CHARTYPE *)"C-CURL"   ,KEY_CLEFT},
  {(CHARTYPE *)"C-CURR"   ,KEY_CRIGHT},
  {(CHARTYPE *)"C-CURU"   ,KEY_CUP},
  {(CHARTYPE *)"C-CURD"   ,KEY_CDOWN},
  {(CHARTYPE *)"C-HOME"   ,KEY_CHOME},
  {(CHARTYPE *)"C-END"    ,KEY_CEND},
  {(CHARTYPE *)"C-PGUP"   ,KEY_CPGUP},
  {(CHARTYPE *)"C-PGDN"   ,KEY_CPGDN},
#endif
  {(CHARTYPE *)"C-A",(int)KEY_C_a},
  {(CHARTYPE *)"C-B",(int)KEY_C_b},
  {(CHARTYPE *)"C-C",(int)KEY_C_c},
  {(CHARTYPE *)"C-D",(int)KEY_C_d},
  {(CHARTYPE *)"C-E",(int)KEY_C_e},
  {(CHARTYPE *)"C-F",(int)KEY_C_f},
  {(CHARTYPE *)"C-G",(int)KEY_C_g},
  {(CHARTYPE *)"C-H",(int)KEY_C_h},
  {(CHARTYPE *)"C-I",(int)KEY_C_i},
  {(CHARTYPE *)"C-J",(int)KEY_C_j},
  {(CHARTYPE *)"C-K",(int)KEY_C_k},
  {(CHARTYPE *)"C-L",(int)KEY_C_l},
  {(CHARTYPE *)"C-M",(int)KEY_C_m},
  {(CHARTYPE *)"C-N",(int)KEY_C_n},
  {(CHARTYPE *)"C-O",(int)KEY_C_o},
  {(CHARTYPE *)"C-P",(int)KEY_C_p},
  {(CHARTYPE *)"C-Q",(int)KEY_C_q},
  {(CHARTYPE *)"C-R",(int)KEY_C_r},
  {(CHARTYPE *)"C-S",(int)KEY_C_s},
  {(CHARTYPE *)"C-T",(int)KEY_C_t},
  {(CHARTYPE *)"C-U",(int)KEY_C_u},
  {(CHARTYPE *)"C-V",(int)KEY_C_v},
  {(CHARTYPE *)"C-W",(int)KEY_C_w},
  {(CHARTYPE *)"C-X",(int)KEY_C_x},
  {(CHARTYPE *)"C-Y",(int)KEY_C_y},
  {(CHARTYPE *)"C-Z",(int)KEY_C_z},
  {(CHARTYPE *)NULL    ,0},
};
