/***********************************************************************/
/* EDIT.C - The body of the program.                                   */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * 36 David Road                 Phone:                    +617 3849 7731
 * Holland Park                  http://www.gu.edu.au/gwis/the/markh.html
 * Brisbane                      **** Maintainer PDCurses & REXX/SQL ****
 * QLD 4121                      ************* Author of THE ************
 * Australia                     ************* Member RexxLA ************
 */

/*
$Id: edit.c 2.1 1995/06/24 16:29:45 MH Rel MH $
*/

#include <stdio.h>
#include <time.h>

#include "the.h"
#include "proto.h"

/*#define TRACE*/
 bool prefix_changed=FALSE;
/***********************************************************************/
#ifdef PROTO
void editor(void)
#else
void editor()
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern VIEW_DETAILS *vd_first;
 extern short file_start;
 extern CHARTYPE *dirfilename;
 extern bool ETMODEx;
 extern CHARTYPE file_disposition;
 extern CHARTYPE *cmd_rec;
 extern LENGTHTYPE cmd_rec_len;
/*--------------------------- local data ------------------------------*/
 register int i=0;
 short rc=RC_OK;
 VIEW_DETAILS *save_vd=vd_current;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("edit.c:    editor");
#endif
/*---------------------------------------------------------------------*/
/* For each view, calculate the current_row value. This has to be done */
/* AFTER initscr() so that the size of the filearea is known.          */
/*---------------------------------------------------------------------*/
 CURRENT_VIEW = vd_first;
 do
   {
    CURRENT_VIEW->current_row = calculate_actual_row(CURRENT_VIEW->current_base,
                                                     CURRENT_VIEW->current_off,
                                                     CURRENT_SCREEN.rows[WINDOW_MAIN]);
    CURRENT_VIEW = NEXT_VIEW;
   }
 while(CURRENT_VIEW);
 CURRENT_VIEW = save_vd;
/*---------------------------------------------------------------------*/
/* whoutrefresh() is called here so that the first call to getch() on  */
/* stdscr does not clear the screen.                                   */
/*---------------------------------------------------------------------*/
 wnoutrefresh(stdscr);

 if (CURRENT_WINDOW_ARROW != (WINDOW *)NULL)
   {
    touchwin(CURRENT_WINDOW_ARROW);
    wnoutrefresh(CURRENT_WINDOW_ARROW);
   }
/*---------------------------------------------------------------------*/
/* Put the cursor into the column between file time and file name for  */
/* the special DIR.DIR file.                                           */
/*---------------------------------------------------------------------*/
 if (strcmp(CURRENT_FILE->fname,dirfilename) == 0)
    wmove(CURRENT_WINDOW_MAIN,CURRENT_VIEW->current_row,file_start-1);
 else
    wmove(CURRENT_WINDOW_MAIN,CURRENT_VIEW->current_row,0);
/*---------------------------------------------------------------------*/
/* Display the current view(s)...                                      */
/*---------------------------------------------------------------------*/
 build_current_screen(); 
 display_current_screen();
 show_footing();
 if (CURRENT_WINDOW_PREFIX != NULL)
    wnoutrefresh(CURRENT_WINDOW_PREFIX);
 if (CURRENT_WINDOW_COMMAND != (WINDOW *)NULL)
   {
    wmove(CURRENT_WINDOW_COMMAND,0,0);
    my_wclrtoeol(CURRENT_WINDOW_COMMAND);
/*---------------------------------------------------------------------*/
/* If the terminal is in ETMODE, display all characters as is, else    */
/* display message with translation of non-displaying characters.      */
/*---------------------------------------------------------------------*/
    if (ETMODEx)
      {
       for (i=0;i<cmd_rec_len;i++)
          mvwaddch(CURRENT_WINDOW_COMMAND,0,i,cmd_rec[i]);
      }
    else
       put_string(CURRENT_WINDOW_COMMAND,0,0,cmd_rec,cmd_rec_len);
    touchwin(CURRENT_WINDOW_COMMAND);
    wnoutrefresh(CURRENT_WINDOW_COMMAND);
   }
 if (file_disposition != FILE_NORMAL)
   {
    switch(file_disposition)
      {
       case FILE_NEW:
                          display_error(0,(CHARTYPE *)"New File...",TRUE);
                          break;
       case FILE_READONLY:
                          display_error(0,(CHARTYPE *)"File is read-only...",FALSE);
                          break;
       default:
                          break;
      }
   }
 wrefresh(CURRENT_WINDOW);

 while (1)
   {
    if (process_key(-1) != RC_OK)
       break;
   }
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
int process_key(int key)
#else
int process_key(key)
int key;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern bool error_on_screen;
 extern CHARTYPE number_of_files;
 extern WINDOW *error_window;
/*--------------------------- local data ------------------------------*/
 unsigned short x=0,y=0;
 short rc=RC_OK;
 CHARTYPE string_key[2];
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("edit.c:    process_key");
#endif
#if defined(USE_EXTCURSES)
 getyx(CURRENT_WINDOW,y,x);
 wmove(CURRENT_WINDOW,y,x);
 wrefresh(CURRENT_WINDOW);
#endif
 if (key == (-1))
    key = my_getch(stdscr);
 if (error_on_screen)
    clear_msgline();
 rc = function_key(key);
 if (number_of_files == 0)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_ENVIRON);
   }

 if (rc >= RAW_KEY)
   {
    if (rc > RAW_KEY)
       key = rc - (RAW_KEY*2);
    if (key < 256 && key >= 0)
      {
       string_key[0] = (CHARTYPE)key;
       string_key[1] = '\0';
       (void)Text(string_key);
      }
   }
 show_footing();
 refresh_current_screen();
 if (error_on_screen)
   {
    getyx(CURRENT_WINDOW,y,x);
    if (error_window != NULL)
      {
       touchwin(error_window);
       wnoutrefresh(error_window);
      }
    wmove(CURRENT_WINDOW,y,x);
    wnoutrefresh(CURRENT_WINDOW);
   }
 doupdate();
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
