/***********************************************************************/
/* BSD.C -                                                             */
/* This file contains pseudo SystemV functions that are missing in BSD.*/
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * 36 David Road                 Phone:                    +617 3849 7731
 * Holland Park                  http://www.gu.edu.au/gwis/the/markh.html
 * Brisbane                      **** Maintainer PDCurses & REXX/SQL ****
 * QLD 4121                      ************* Author of THE ************
 * Australia                     ************* Member RexxLA ************
 */

/*
$Id: bsd.c 2.1 1995/06/24 16:28:37 MH Rel MH $
*/

#include <stdio.h>

#include "the.h"
#include "proto.h"
/*-------------------------- external data ----------------------------*/
extern char current_file;                   /* pointer to current file */
/*---------------------- function definitions -------------------------*/
/***********************************************************************/
int reset_shell_mode()
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
 return(0);
}
/***********************************************************************/
int reset_prog_mode()
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
 return(0);
}
/***********************************************************************/
int doupdate()
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned short y=0,x=0;
/*--------------------------- processing ------------------------------*/
 getyx(CURRENT_WINDOW,y,x);
 refresh();
 wmove(CURRENT_WINDOW,y,x);
 wrefresh(CURRENT_WINDOW);
 return(0);
}
/***********************************************************************/
int wnoutrefresh(win)
WINDOW *win;
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
 wrefresh(win);
 return(0);
}
/***********************************************************************/
int notimeout(win,bf)
WINDOW *win;
bool bf;
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
 return(0);
}
/***********************************************************************/
int wattrset(win,attrs)
WINDOW *win;
long attrs;
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
 if (attrs == A_NORMAL)
    wstandend(win);
 else
    wstandout(win);
 return(0);
}
#ifdef VMS
/***********************************************************************/
FILE *popen(str,mode)
CHARTYPE *str,*mode;
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
 return(FILE *)(0);
}
/***********************************************************************/
int pclose(fp)
FILE *fp;
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
 return(0);
}
#endif
