/*
 * Code generated by MGUI Designer
 */

#include <stdio.h>
#include <stdlib.h>
#include "mgui.h"

/*
 * External User Defined Callbacks
 */
void NewCB(MOBJECT p, void *od, void *ad);
void OpenCB(MOBJECT p, void *od, void *ad);
void InsertFileCB(MOBJECT p, void *od, void *ad);
void RevertCB(MOBJECT p, void *od, void *ad);
void SaveCB(MOBJECT p, void *od, void *ad);
void SaveAsCB(MOBJECT p, void *od, void *ad);
void WriteSelCB(MOBJECT p, void *od, void *ad);
void PrintCB(MOBJECT p, void *od, void *ad);
void CloseCB(MOBJECT p, void *od, void *ad);
void QuitCB(MOBJECT p, void *od, void *ad);
void GoToLineCB(MOBJECT p, void *od, void *ad);
void SearchCB(MOBJECT p, void *od, void *ad);
void SearchNextCB(MOBJECT p, void *od, void *ad);
void SearchPrevCB(MOBJECT p, void *od, void *ad);
void ReplaceCB(MOBJECT p, void *od, void *ad);
void FontSelectCB(MOBJECT p, void *od, void *ad);
void FontSelectCB(MOBJECT p, void *od, void *ad);
void UndoCB(MOBJECT p, void *od, void *ad);
void RedoCB(MOBJECT p, void *od, void *ad);
void TextChangedCB(MOBJECT p, EDIT_CHANGE *od, void *ad);
void CursorPosCB(MOBJECT p, EDIT_CURS *od, void *ad);
void IgnoreCaseCB(MOBJECT p, MVALUE od, void *ad);
void SearchForwardCB(MOBJECT p, void *od, void *ad);
void SearchBackwardCB(MOBJECT p, void *od, void *ad);
void CancelCB(MOBJECT p, void *od, void *ad);
void GotolineEditActCB(MOBJECT p, char *od, void *ad);
void GotolineOkCB(MOBJECT p, void *od, void *ad);
void CancelCB(MOBJECT p, void *od, void *ad);
void ReplaceOneCB(MOBJECT p, void *od, void *ad);
void ReplaceSomeCB(MOBJECT p, void *od, void *ad);
void ReplaceAllCB(MOBJECT p, void *od, void *ad);
void CancelCB(MOBJECT p, void *od, void *ad);
/*
 * Global Variables
 */
MOBJECT main_shell;
MOBJECT menu;
MOBJECT file_pd;
PULLDOWN_ITEM	new_mi;
PULLDOWN_ITEM	open_mi;
PULLDOWN_ITEM	insert_file_mi;
PULLDOWN_ITEM	save_mi;
PULLDOWN_ITEM	write_sel_mi;
PULLDOWN_ITEM	print_mi;
PULLDOWN_ITEM	close_mi;
PULLDOWN_ITEM	quit_mi;
MOBJECT search_pd;
PULLDOWN_ITEM	goto_mi;
PULLDOWN_ITEM	search_mi;
PULLDOWN_ITEM	search_next_mi;
PULLDOWN_ITEM	search_prev_mi;
PULLDOWN_ITEM	replace_mi;
MOBJECT options_pd;
PULLDOWN_ITEM	medium_font_mi;
PULLDOWN_ITEM	large_font_mi;
PULLDOWN_ITEM	small_font_mi;
PULLDOWN_ITEM	invert_color_mi;
PULLDOWN_ITEM	auto_indent_mi;
MOBJECT edit_pd;
PULLDOWN_ITEM	undo_mi;
PULLDOWN_ITEM	redo_mi;
MOBJECT filename_l;
MOBJECT modified_l;
MOBJECT curs_y_l;
MOBJECT curs_x_l;
MOBJECT text_mle;
MOBJECT search_shell;
MOBJECT search_e;
MOBJECT ignore_case_tb;
MOBJECT search_f_pb;
MOBJECT search_b_pb;
MOBJECT search_cancel_pb;
MOBJECT gotoline_shell;
MOBJECT gotoline_e;
MOBJECT gotoline_ok_pb;
MOBJECT gotoline_canc_pb;
MOBJECT replace_shell;
MOBJECT replace_r_e;
MOBJECT replace_w_e;
MOBJECT replace_one_pb;
MOBJECT replace_some_pb;
MOBJECT replace_all_pb;
MOBJECT replace_canc_pb;
/*
 * User Code
 */
#include <string.h>

#include "me.h"
/*
 * END of User Code
 */

/*
 * Shell creation prototypes
 */
MOBJECT MDCreatemain_shell(void);
MOBJECT MDCreatesearch_shell(void);
MOBJECT MDCreategotoline_shell(void);
MOBJECT MDCreatereplace_shell(void);

/*
 * Project Defined Callbacks
 */
void FontSelectCB(MOBJECT p, void *od, void *ud)
{
	FILE_DATA		*pfd;
	MOBJECT			shell;

	shell = (MOBJECT)MObjectGetUserData(p);
	pfd = MObjectGetUserData(shell);
	if (pfd->selected_font)
		MSetItemCheckStatus(p, pfd->selected_font, False);
	pfd->selected_font = od;
	MSetItemCheckStatus(p, od, True);
	MObjectSetFont(pfd->edit, (MTFont)ud, True);
}

void ColorInvertCB(MOBJECT p, void *od, void *ud)
{
	MOBJECT		shell = (MOBJECT)ud;
	FILE_DATA	*pfd = MObjectGetUserData(shell);
	MTColor		bgc = MObjectBackgroundColor(pfd->edit);
	MTColor		fgc = MObjectForegroundColor(pfd->edit);

	MObjectSetColor(pfd->edit, fgc, bgc);
}

void AutoIndentCB(MOBJECT p, void *od, void *ud)
{
	MOBJECT		shell = (MOBJECT)ud;
	FILE_DATA	*pfd = MObjectGetUserData(shell);
	int		status;

	status = MToggleItemCheckStatus(p, od);
	MEditSetAutoIndent(pfd->edit, status);
}


/*
 * Shell creation functions
 */

MOBJECT MDCreatemain_shell(void)
{
	MOBJECT _rowform000;
	MOBJECT _colform000;

	main_shell = MCreateShell("M-Edit 1.2", 0);
	MObjectSetBackgroundRGB(main_shell, 53, 112, 112);

	_rowform000 = MCreateRowForm(main_shell);
	MFormSetSpacing(_rowform000, 0);
	MObjectSetBackgroundRGB(_rowform000, 53, 112, 112);
	MObjectSetShadow(_rowform000, WS_NONE, 0, 0);

	{
	  MOBJECT	pd;
	  PULLDOWN_ITEM	item;

	  menu = MCreateMenuBar(_rowform000, HELV_L_FONT);
	  MMenuSetAcc(menu, F10);
	  file_pd = MCreatePullDown(menu, "File");
	  new_mi = MPullDownAddItem(file_pd, "New Window", NewCB, main_shell);
	  open_mi = MPullDownAddItem(file_pd, "Open ...", OpenCB, main_shell);
	  insert_file_mi = MPullDownAddItem(file_pd, "Insert File ...", InsertFileCB, main_shell);
	  item = MPullDownAddItem(file_pd, "Revert to saved", RevertCB, main_shell);
	  save_mi = MPullDownAddItem(file_pd, "Save", SaveCB, main_shell);
	  item = MPullDownAddItem(file_pd, "Save as ...", SaveAsCB, main_shell);
	  write_sel_mi = MPullDownAddItem(file_pd, "Write Selection ...", WriteSelCB, main_shell);
	  print_mi = MPullDownAddItem(file_pd, "Print ...", PrintCB, main_shell);
	  close_mi = MPullDownAddItem(file_pd, "Close", CloseCB, main_shell);
	  quit_mi = MPullDownAddItem(file_pd, "Quit", QuitCB, main_shell);
	  search_pd = MCreatePullDown(menu, "Search");
	  goto_mi = MPullDownAddItem(search_pd, "Go to Line ...", GoToLineCB, main_shell);
	  search_mi = MPullDownAddItem(search_pd, "Search String ...", SearchCB, main_shell);
	  search_next_mi = MPullDownAddItem(search_pd, "Search Next", SearchNextCB, main_shell);
	  search_prev_mi = MPullDownAddItem(search_pd, "Search Previous", SearchPrevCB, main_shell);
	  replace_mi = MPullDownAddItem(search_pd, "Replace ...", ReplaceCB, main_shell);
	  options_pd = MCreatePullDown(menu, "Options");
	  medium_font_mi = MPullDownAddItem(options_pd, "Medium Font", FontSelectCB, (void *)DEFAULT_FONT);
	  large_font_mi = MPullDownAddItem(options_pd, "Large Font", FontSelectCB, (void *)LARGE_FONT);
	  small_font_mi = MPullDownAddItem(options_pd, "Small Font", FontSelectCB, (void *)SMALL_FONT);
	  invert_color_mi = MPullDownAddItem(options_pd, "Invert Color", ColorInvertCB, main_shell);
	  auto_indent_mi = MPullDownAddItem(options_pd, "Auto Indent", AutoIndentCB, main_shell);
	  edit_pd = MCreatePullDown(menu, "Edit");
	  undo_mi = MPullDownAddItem(edit_pd, "Undo", UndoCB, main_shell);
	  redo_mi = MPullDownAddItem(edit_pd, "Redo", RedoCB, main_shell);
	}
	MObjectSetBackgroundRGB(menu, 160, 192, 144);

	_colform000 = MCreateColForm(_rowform000);
	MFormSetSpacing(_colform000, 1);
	MObjectSetBackgroundRGB(_colform000, 53, 112, 112);
	MObjectSetShadow(_colform000, WS_NONE, 0, 0);

	filename_l = MCreateLabel(_colform000, "", DEFAULT_FONT);
	MLabelSetAlignment(filename_l, LEFT_ALIGN);
	MObjectSetBackgroundRGB(filename_l, 197, 197, 144);
	MObjectSetShadow(filename_l, WS_SHADOW_OUT, 1, 0);

	modified_l = MCreateLabel(_colform000, "N", DEFAULT_FONT);
	MObjectSetBackgroundRGB(modified_l, 197, 197, 144);
	MObjectSetResize(modified_l, False, False);
	MObjectSetShadow(modified_l, WS_SHADOW_OUT, 1, 0);

	curs_y_l = MCreateLabel(_colform000, "    ", DEFAULT_FONT);
	MLabelSetAlignment(curs_y_l, RIGHT_ALIGN);
	MObjectSetBackgroundRGB(curs_y_l, 197, 197, 144);
	MObjectSetResize(curs_y_l, False, False);
	MObjectSetShadow(curs_y_l, WS_SHADOW_OUT, 1, 0);

	curs_x_l = MCreateLabel(_colform000, "    ", DEFAULT_FONT);
	MLabelSetAlignment(curs_x_l, RIGHT_ALIGN);
	MObjectSetBackgroundRGB(curs_x_l, 197, 197, 144);
	MObjectSetResize(curs_x_l, False, False);
	MObjectSetShadow(curs_x_l, WS_SHADOW_OUT, 1, 0);

	text_mle = MCreateScrolledMLEdit(_rowform000, "", 80, 20, SMALL_FONT);
	MEditSetValueChangeCallback(text_mle, TextChangedCB, NULL);
	MEditSetCursorPosCallback(text_mle, CursorPosCB, NULL);
	MObjectSetBackgroundRGB(text_mle, 53, 112, 112);
	MObjectSetForegroundRGB(text_mle, 224, 224, 176);
	MObjectSetResize(text_mle, True, True);
	{
/*
 * This code is added to link edit window Objects
 * to file data structure
 */
	FILE_DATA *pfd;

	pfd = (FILE_DATA *)calloc(1, sizeof(FILE_DATA));
	MObjectSetUserData(main_shell, pfd);
	if (pfd != NULL) {
		pfd->edit = text_mle;
		pfd->curs_x_label = curs_x_l;
		pfd->curs_y_label = curs_y_l;
		pfd->fname_label = filename_l;
		pfd->modified_label = modified_l;
		pfd->ignore_case = False;
	}
	MObjectSetUserData(options_pd, main_shell);
/*
 * Change fonts depending on screen resolution
 */
	if (MGetScreenWidth() > 1024) {
		MObjectSetFont(pfd->edit, LARGE_FONT, False);
		pfd->selected_font = large_font_mi;
	}
	else if (MGetScreenWidth() > 640) {
		MObjectSetFont(pfd->edit, DEFAULT_FONT, False);
		pfd->selected_font = medium_font_mi;
	}
	else {
		pfd->selected_font = small_font_mi;
		MObjectSetFont(menu, HELV_N_FONT, False);
	}
	MSetItemCheckStatus(options_pd, pfd->selected_font, True);
/*
 * Disable color invert if not enough colors available
 */
	if (MGetNColors() < 256)
		MPullDownSetItemUnsensitive(options_pd, invert_color_mi);
/*
 * Since MGUI Designer does not allow yet to set menu item 
 * accelerators...
 */
	MPullDownSetItemAccel(file_pd, new_mi, C_N, "Ctrl+N");
	MPullDownSetItemAccel(file_pd, open_mi, C_O, "Ctrl+O");
	MPullDownSetItemAccel(file_pd, insert_file_mi, C_I, "Ctrl+I");
	MPullDownSetItemAccel(file_pd, save_mi, C_S, "Ctrl+S");
	MPullDownSetItemAccel(file_pd, write_sel_mi, C_W, "Ctrl+W");
	MPullDownSetItemAccel(file_pd, print_mi, C_P, "Ctrl+P");
	MPullDownSetItemAccel(search_pd, goto_mi, F1, "F1");
	MPullDownSetItemAccel(search_pd, search_mi, F2, "F2");
	MPullDownSetItemAccel(search_pd, search_next_mi, F3, "F3");
	MPullDownSetItemAccel(search_pd, search_prev_mi, F4, "F4");
	MPullDownSetItemAccel(search_pd, replace_mi, F5, "F5");
	MPullDownSetItemAccel(edit_pd, undo_mi, C_U, "Ctrl+U");
	MPullDownSetItemAccel(edit_pd, redo_mi, C_R, "Ctrl+R");
	}


	return main_shell;
}

MOBJECT MDCreatesearch_shell(void)
{
	MOBJECT _colform001;

	search_shell = MCreateShell("Search String", 0|SF_MODAL);
	MObjectSetBackgroundRGB(search_shell, 192, 176, 160);

	search_e = MCreateEdit(search_shell, "", 40, DEFAULT_FONT);
	MTopAttach(search_e, F_ATT_FORM, 10, NULL);
	MLeftAttach(search_e, F_ATT_FORM, 10, NULL);

	ignore_case_tb = MCreateTButton(search_shell, "Ignore case", HELV_L_FONT);
	MTButtonSetCallback(ignore_case_tb, IgnoreCaseCB, NULL);
	MTopAttach(ignore_case_tb, F_ATT_OBJ, 10, search_e);
	MObjectSetBackgroundRGB(ignore_case_tb, 192, 176, 160);

	_colform001 = MCreateColForm(search_shell);
	MTopAttach(_colform001, F_ATT_OBJ, 10, ignore_case_tb);
	MObjectSetBackgroundRGB(_colform001, 160, 112, 112);

	search_f_pb = MCreatePButton(_colform001, "Forward", TIMES_L_FONT);
	MPButtonSetMargin(search_f_pb, 8, 2);
	MPButtonSetCallback(search_f_pb, SearchForwardCB, NULL);
	MObjectSetResize(search_f_pb, False, False);

	search_b_pb = MCreatePButton(_colform001, "Backward", TIMES_L_FONT);
	MPButtonSetMargin(search_b_pb, 8, 2);
	MPButtonSetCallback(search_b_pb, SearchBackwardCB, NULL);
	MObjectSetResize(search_b_pb, False, False);

	search_cancel_pb = MCreatePButton(_colform001, "Cancel", TIMES_L_FONT);
	MPButtonSetMargin(search_cancel_pb, 8, 2);
	MPButtonSetCallback(search_cancel_pb, CancelCB, NULL);
	MObjectSetResize(search_cancel_pb, False, False);
MPButtonSetAccelerator(search_cancel_pb, ESC);

	return search_shell;
}

MOBJECT MDCreategotoline_shell(void)
{
	MOBJECT _colform002;

	gotoline_shell = MCreateShell("Go to Line", 0|SF_MODAL);
	MObjectSetBackgroundRGB(gotoline_shell, 112, 128, 112);

	gotoline_e = MCreateEdit(gotoline_shell, "", 6, DEFAULT_FONT);
	MEditSetFilter(gotoline_e, 4, "");
	MEditSetActCallback(gotoline_e, GotolineEditActCB, NULL);
	MTopAttach(gotoline_e, F_ATT_FORM, 10, NULL);

	_colform002 = MCreateColForm(gotoline_shell);
	MTopAttach(_colform002, F_ATT_OBJ, 10, gotoline_e);
	MObjectSetBackgroundRGB(_colform002, 160, 144, 80);

	gotoline_ok_pb = MCreatePButton(_colform002, "Ok", TIMES_L_FONT);
	MPButtonSetMargin(gotoline_ok_pb, 20, 2);
	MPButtonSetCallback(gotoline_ok_pb, GotolineOkCB, NULL);
	MObjectSetResize(gotoline_ok_pb, False, False);

	gotoline_canc_pb = MCreatePButton(_colform002, "Cancel", TIMES_L_FONT);
	MPButtonSetCallback(gotoline_canc_pb, CancelCB, NULL);
	MObjectSetResize(gotoline_canc_pb, False, False);
MPButtonSetAccelerator(gotoline_canc_pb, ESC);


	return gotoline_shell;
}

MOBJECT MDCreatereplace_shell(void)
{
	MOBJECT _colform003;
	MOBJECT _rowform001;
	MOBJECT _label000;
	MOBJECT _label001;
	MOBJECT _rowform002;
	MOBJECT _colform004;

	replace_shell = MCreateShell("Replace", 0|SF_MODAL);
	MObjectSetBackgroundRGB(replace_shell, 112, 165, 160);

	_colform003 = MCreateColForm(replace_shell);
	MObjectSetBackgroundRGB(_colform003, 112, 165, 160);

	_rowform001 = MCreateRowForm(_colform003);
	MObjectSetBackgroundRGB(_rowform001, 112, 165, 160);
	MObjectSetShadow(_rowform001, WS_NONE, 0, 0);

	_label000 = MCreateLabel(_rowform001, "Replace", HELV_L_FONT);
	MLabelSetAlignment(_label000, RIGHT_ALIGN);
	MObjectSetBackgroundRGB(_label000, 112, 165, 160);

	_label001 = MCreateLabel(_rowform001, "With", HELV_L_FONT);
	MLabelSetAlignment(_label001, RIGHT_ALIGN);
	MObjectSetBackgroundRGB(_label001, 112, 165, 160);

	_rowform002 = MCreateRowForm(_colform003);
	MObjectSetBackgroundRGB(_rowform002, 112, 165, 160);
	MObjectSetShadow(_rowform002, WS_NONE, 0, 0);

	replace_r_e = MCreateEdit(_rowform002, "", 40, DEFAULT_FONT);

	replace_w_e = MCreateEdit(_rowform002, "", 40, DEFAULT_FONT);

	_colform004 = MCreateColForm(replace_shell);
	MFormSetSpacing(_colform004, 8);
	MObjectSetBackgroundRGB(_colform004, 53, 112, 112);

	replace_one_pb = MCreatePButton(_colform004, "One", TIMES_L_FONT);
	MPButtonSetCallback(replace_one_pb, ReplaceOneCB, NULL);
	MObjectSetResize(replace_one_pb, False, False);

	replace_some_pb = MCreatePButton(_colform004, "Some", TIMES_L_FONT);
	MPButtonSetCallback(replace_some_pb, ReplaceSomeCB, NULL);
	MObjectSetResize(replace_some_pb, False, False);

	replace_all_pb = MCreatePButton(_colform004, "All", TIMES_L_FONT);
	MPButtonSetCallback(replace_all_pb, ReplaceAllCB, NULL);
	MObjectSetResize(replace_all_pb, False, False);

	replace_canc_pb = MCreatePButton(_colform004, "Cancel", TIMES_L_FONT);
	MPButtonSetCallback(replace_canc_pb, CancelCB, NULL);
	MObjectSetResize(replace_canc_pb, False, False);
MPButtonSetAccelerator(replace_canc_pb, ESC);

	return replace_shell;
}
