From eliz@is.elta.co.ilWed Dec 27 18:42:54 1995
Date: Mon, 25 Dec 1995 18:17:38 +0200 (IST)
From: Eli Zaretskii <eliz@is.elta.co.il>
To: Kevin Gallagher <kgallagh@spdmail.spd.dsccc.com>,
    Marc Fleischeuers <marc@mpi.nl>, Mickey Ferguson <mickeyf@stac.com>,
    Morten Welinder <terra@diku.dk>, Karl Heuer <kwzh@gnu.ai.mit.edu>
Cc: Richard Stallman <rms@gnu.ai.mit.edu>
Subject: find-dired under DOS

The following patch makes `find-dired' work under MS-DOS.  Note that for
`find-dired-grep' to work, you'll need a port of GNU find which implements
``-exec cmd'' predicate in a way that makes the exit code of ``cmd''
available to `find' (running ``cmd'' with a call to `system' which uses ye
old COMMAND.COM won't work). 

If anybody out there uses a shell other than COMMAND.COM under MS-DOS,
please test this and tell me if the code works for you, too.  It should
work both for shells mentioned in `msdos-shells' and for Unix-like shells
(like ms_sh), but I could only test COMMAND.COM. 

Mon Dec 25 17:36:46 1995  Eli Zaretskii  <eliz@is.elta.co.il>

	* find-dired.el (find-ls-option): Under MS-DOS define default
	options as suitable for GNU `find' utility.
	(find-find-command): New user-definable variable, for systems
	where the `find' program is likely to go by another name.
	(find-dired): Compose the command line for `find' in a way which
	works for MS-DOS shells.  Use `call-process' if asynchronous
	processes are unavailable, and simulate `find-dired-sentinel' job
	in this case.
	(find-grep-dired): Compose the command line in a way which works
	with MS-DOS shells.
	(find-dired-process-synchronous-output): New function to be called
	instead of `find-dired-filter' when asynchronous processes are
	unavailable.

*** lisp/find-dired.e~0	Sun Dec 24 13:46:48 1995
--- lisp/find-dired.el	Mon Dec 25 17:35:12 1995
***************
*** 28,36 ****
  
  ;; find's -ls corresponds to these switches.
  ;; Note -b, at least GNU find quotes spaces etc. in filenames
  ;;;###autoload
! (defvar find-ls-option (if (eq system-type 'berkeley-unix) '("-ls" . "-gilsb")
! 			 '("-exec ls -ld {} \\;" . "-ld"))
    "*Description of the option to `find' to produce an `ls -l'-type listing.
  This is a cons of two strings (FIND-OPTION . LS-SWITCHES).  FIND-OPTION
  gives the option (or options) to `find' that produce the desired output.
--- 28,39 ----
  
  ;; find's -ls corresponds to these switches.
  ;; Note -b, at least GNU find quotes spaces etc. in filenames
+ ;; MS-DOS users are assumed to use GNU `find' as default.
  ;;;###autoload
! (defvar find-ls-option
!   (if (memq system-type '(ms-dos berkeley-unix))
!       '("-ls" . "-gilsb")
!     '("-exec ls -ld {} \\;" . "-ld"))
    "*Description of the option to `find' to produce an `ls -l'-type listing.
  This is a cons of two strings (FIND-OPTION . LS-SWITCHES).  FIND-OPTION
  gives the option (or options) to `find' that produce the desired output.
***************
*** 42,47 ****
--- 45,58 ----
  On Berkeley systems, this is `-s'; on Posix, and with GNU grep, `-q' does it.
  On other systems, the closest you can come is to use `-l'.")
  
+ ;; MS-DOS has its own command named `find' which does something entirely
+ ;; different, so MS-DOS users are likely to call `find' by some other
+ ;; name (like e.g. `gfind').
+ ;;;###autoload
+ (defvar find-find-command "find"
+   "*Name of the `find' program to run by \\[find-dired], \\[find-name-dired]
+ and \\[find-grep-dired].")
+ 
  (defvar find-args nil
    "Last arguments given to `find' by \\[find-dired].")
  
***************
*** 70,79 ****
    (erase-buffer)
    (setq default-directory dir
  	find-args args			; save for next interactive call
! 	args (concat "find . "
  		     (if (string= args "")
  			 ""
! 		       (concat "\\( " args " \\) "))
  		     (car find-ls-option)))
    ;; The next statement will bomb in classic dired (no optional arg allowed)
    (dired-mode dir (cdr find-ls-option))
--- 81,99 ----
    (erase-buffer)
    (setq default-directory dir
  	find-args args			; save for next interactive call
! 	args (concat find-find-command " . "
  		     (if (string= args "")
  			 ""
! 		       (progn
! 			 ;; They might use Unix-like shell even under
! 			 ;; MS-DOS, in which case they need the command
! 			 ;; to be escaped a-la Unix.
! 			 (if (and (boundp 'msdos-shells)
! 				  (member (file-name-nondirectory
! 					   shell-file-name)
! 					  msdos-shells))
! 			     (concat args " ")
! 			   (concat "\\( " args " \\) "))))
  		     (car find-ls-option)))
    ;; The next statement will bomb in classic dired (no optional arg allowed)
    (dired-mode dir (cdr find-ls-option))
***************
*** 98,109 ****
    ;; ``wildcard'' line. 
    (insert "  " args "\n")
    ;; Start the find process.
!   (let ((proc (start-process-shell-command "find" (current-buffer) args)))
!     (set-process-filter proc (function find-dired-filter))
!     (set-process-sentinel proc (function find-dired-sentinel))
!     ;; Initialize the process marker; it is used by the filter.
!     (move-marker (process-mark proc) 1 (current-buffer)))
!   (setq mode-line-process '(":%s")))
  
  ;;;###autoload
  (defun find-name-dired (dir pattern)
--- 118,163 ----
    ;; ``wildcard'' line. 
    (insert "  " args "\n")
    ;; Start the find process.
!   (if (fboundp 'start-process)
!       (let ((proc (start-process-shell-command "find" (current-buffer) args)))
! 	(set-process-filter proc (function find-dired-filter))
! 	(set-process-sentinel proc (function find-dired-sentinel))
! 	;; Initialize the process marker; it is used by the filter.
! 	(move-marker (process-mark proc) 1 (current-buffer))
! 	(setq mode-line-process '(":%s")))
!     ;; No asynchronous processes available.  Run synchronouosly.
!     ;; Fake modeline display as if `start-process' were run.
!     (setq mode-line-process ":run")
!     (message (format "Executing `%s'..." args))
!     (sit-for 0);; Force redisplay
!     (let ((status (call-process shell-file-name nil t nil "-c" args))
! 	  state)
!       ;; Format the output of `find' as `find-dired-filter' would.
!       (find-dired-process-synchronous-output)
!       ;; Fake modeline after exit.
!       (setq mode-line-process
! 	    (cond ((numberp status) (format ":exit[%d]" status))
! 		  ((stringp status) (format ":exit[-1: %s]" status))
! 		  (t ":exit[???]")))
!       ;; Finish up the `find' buffer with the same message we
!       ;; would get when async process exits.
!       (setq state
! 	    (if (numberp status)
! 		(if (zerop status)
! 		    "finished\n"
! 		  (format "exited abnormally with code %d\n" status))
! 	      "exited abnormally with code -1\n"))
!       (force-mode-line-update)
!       (save-excursion
! 	(goto-char (point-max))
! 	(insert "\nfind " state)
! 	(forward-char -1)		; back up before \n at end of STATE.
! 	(insert " at " (substring (current-time-string) 0 19))
! 	(forward-char 1)
! 	;; Some hooks might work on the buffer contents, so call them
! 	;; after the buffer is ready.
! 	(run-hooks 'dired-mode-hook))
!     (message "find-dired %s finished." (current-buffer)))))
  
  ;;;###autoload
  (defun find-name-dired (dir pattern)
***************
*** 137,143 ****
    ;; or we could use `grep -l >/dev/null'
    (find-dired dir
  	      (concat "! -type d -exec grep " find-grep-options " "
! 		      args " {} \\\; ")))
  
  (defun find-dired-filter (proc string)
    ;; Filter for \\[find-dired] processes.
--- 191,206 ----
    ;; or we could use `grep -l >/dev/null'
    (find-dired dir
  	      (concat "! -type d -exec grep " find-grep-options " "
! 		      args " {} "
! 		      ;; They might use Unix-like shell even under
! 		      ;; MS-DOS, in which case they need the command
! 		      ;; to be escaped a-la Unix.
! 		      (if (and (boundp 'msdos-shells)
! 			       (member (file-name-nondirectory
! 					shell-file-name)
! 				       msdos-shells))
! 			  "; "
! 			"\\\; "))))
  
  (defun find-dired-filter (proc string)
    ;; Filter for \\[find-dired] processes.
***************
*** 198,203 ****
--- 261,284 ----
  	      (delete-process proc)
  	      (force-mode-line-update)))
  	  (message "find-dired %s finished." (current-buffer))))))
+ 
+ (defun find-dired-process-synchronous-output ()
+   (let ((start (point-min))
+ 	(end (point-max))
+ 	(buffer-read-only nil))
+     (goto-char start)
+     (forward-line 2)
+     (setq start (point))
+     (while (looking-at "^")
+       (insert "  ")			; to make it fit `dired' display
+       (forward-line 1))
+     (goto-char start)
+     (while (search-forward " ./" nil t)
+       (delete-region (point) (- (point) 2)))
+     (dired-insert-set-properties start end)
+     (goto-char start)			; get to the first file in the buffer
+     (dired-move-to-filename)))
+ 
  
  (provide 'find-dired)
  
