From eliz@is.elta.co.ilFri Dec 15 11:13:17 1995
Date: Thu, 14 Dec 1995 20:26:29 +0200 (IST)
From: Eli Zaretskii <eliz@is.elta.co.il>
To: Kevin Gallagher <kgallagh@spdmail.spd.dsccc.com>
Cc: Marc Fleischeuers <marc@mpi.nl>, Mickey Ferguson <mickeyf@stac.com>,
    Morten Welinder <terra@diku.dk>, Richard Stallman <rms@gnu.ai.mit.edu>,
    Karl Heuer <kwzh@gnu.ai.mit.edu>
Subject: Re: display-time in Emacs under DOS


On Thu, 14 Dec 1995, Kevin Gallagher wrote:

> Will it actively erase the last display of the clock from the mode line and
> restore the mode line to its exact format prior to the invocation of
> display-time in the first place?
> 
> I still think it is more trouble than it is worth.

By the time I wrote my message, it was already done, so here it is.  Yes,
it does erase the last displayed time and force redisplay, like you'd
expect.  The patches below will make `display-time' work under DOS.  (I
did quite a bit of digging to find the ways of testing ELisp objects and
calling ELisp functions from C code, so please look carefully at the code
and tell me if there are ways to make it more elegantly than I did.) Note
that the ChangeLog entry for the lisp/ directory is near the end, before
the patch to time.el. 

Thu Dec 14 19:46:21 1995  Eli Zaretskii  <eliz@is.elta.co.il>

	* msdos.c (check_timer): get rid of the DOS-specific menubar clock
	feature; call `display-time-filter' from time.el to display time
	on the modeline instead.  This makes `display-time' work under
	DOS.
	(abort): use our own function instead of the one from the library
	which reverts the console device to cooked mode.
	(syms_of_msdos): `dos-display-time'--a new variable for
	communicating with `display-time'.

	* getloadavg.c (getloadavg) [MSDOS]: return 0 load instead of
	failing the call (required for `display-time' to work with minimal
	changes).

	* dosfns.c (syms_of_dosfns): delete the `dos-menubar-clock' and
	`dos-timer-hooks' variables (the usual modeline time display now
	works and `display-time-hook' can be used under DOS).

	*dosfns.h: delete declarations for `Vdos_menubar_clock' and
	`Vdos_timer_hooks'.

*** src/msdos.c~3	Thu Dec  7 18:39:50 1995
--- src/msdos.c	Thu Dec 14 18:40:46 1995
***************
*** 2387,2452 ****
  sigsetmask (x) int x; { return 0; }
  unrequest_sigio () {}
  
- int run_dos_timer_hooks = 0;
- 
  #ifndef HAVE_SELECT
  #include "sysselect.h"
  
! static int last_ti_sec = -1;
! static int dos_menubar_clock_displayed = 0;
  
  static void
  check_timer (t)
    struct time *t;
  {
    gettime (t);
    
!   if (t->ti_sec == last_ti_sec)
      return;
-   last_ti_sec = t->ti_sec;
  
!   if (!NILP (Vdos_menubar_clock))
      {
!       char clock_str[16];
!       int len;
!       int min = t->ti_min;
!       int hour = t->ti_hour;
! 
!       if (dos_timezone_offset)
! 	{
! 	  int tz = dos_timezone_offset;
! 	  min -= tz % 60;
! 	  if (min < 0)
! 	    min += 60, hour--;
! 	  else
! 	    if (min >= 60)
! 	      min -= 60, hour++;
! 	  
! 	  if ((hour -= (tz / 60)) < 0)
! 	    hour += 24;
! 	  else
! 	    hour %= 24;
! 	}
!       
!       if ((dos_country_info[0x11] & 0x01) == 0) /* 12 hour clock */
  	{
! 	  hour %= 12;
! 	  if (hour == 0) hour = 12;
  	}
  
!       len = sprintf (clock_str, "%2d.%02d.%02d", hour, min, t->ti_sec);
!       dos_direct_output (0, screen_size_X - len - 1, clock_str, len);
!       dos_menubar_clock_displayed = 1;
      }
!   else if (dos_menubar_clock_displayed)
      {
!       /* Erase last displayed time.  */
!       dos_direct_output (0, screen_size_X - 9, "        ", 8);
!       dos_menubar_clock_displayed = 0;
      }
    
!   if (!NILP (Vdos_timer_hooks))
!     run_dos_timer_hooks++;
  }
  
  /* Only event queue is checked.  */
--- 2387,2461 ----
  sigsetmask (x) int x; { return 0; }
  unrequest_sigio () {}
  
  #ifndef HAVE_SELECT
  #include "sysselect.h"
  
! static struct time last_time  = {120, 120, 120, 120};
! static int modeline_time_displayed = 0;
! 
! Lisp_Object Vdos_display_time;
  
  static void
  check_timer (t)
    struct time *t;
  {
+   int sec, min, hour, hund;
+   int time_changed;
+ 
    gettime (t);
+   sec  = t->ti_sec;
+   hund = t->ti_hund;
+   hour = t->ti_hour;
+   min  = t->ti_min;
+ 
+   /* Any chance of not getting here 24 hours or more since last time? */
+   time_changed = hour != last_time.ti_hour ||
+ 		 min  != last_time.ti_min  ||
+ 		 sec  != last_time.ti_sec;
    
!   if (!time_changed)
      return;
  
!   if (!NILP (Vdos_display_time))
      {
!       int interval;
!       Lisp_Object dti = XSYMBOL (Fintern_soft (build_string ("display-time-interval"), Qnil))->value;
!       int delta_time  = (hour - last_time.ti_hour) * 3600 +
! 		        (min  - last_time.ti_min)  * 60   +
! 		         sec  - last_time.ti_sec;
! 
!       /* Who knows, what the user may put into `display-time-interval'?  */
!       if (NILP (dti) || !INTEGERP (dti))
! 	  interval = 60;
!       else
  	{
! 	  interval = XINT (dti);
! 	  if (interval <= 0)
! 	    interval = 60;
  	}
  
!       /* When it's time to renew the display, fake a `wakeup' call.  */
!       if (!modeline_time_displayed || /* first time */
! 	  delta_time >= interval   || /* or if we were busy for a long time */
! 	  interval == 1            || /* and every `interval' seconds hence */
! 	  interval == 60 && sec == 0 ||	/* (usual cases first) */
! 	  (hour * 3600 + min * 60 + sec) % interval == 0)
! 	call2 (intern ("display-time-filter"), Qnil,
! 	       build_string ("Wake up!\n"));
! 
!       modeline_time_displayed = 1;
      }
!   else if (modeline_time_displayed)
      {
!       modeline_time_displayed = 0;
!       Fset (intern ("display-time-string"), build_string (""));
! 
!       /* Force immediate redisplay of modelines.  */
!       update_mode_lines++;
!       redisplay_preserve_echo_area ();
      }
    
!   last_time  = *t;
  }
  
  /* Only event queue is checked.  */
***************
*** 2583,2588 ****
--- 2592,2606 ----
    ScreenSetCursor (2, 0);
    abort ();
  }
+ #else
+ void
+ abort ()
+ {
+   dos_ttcooked ();
+   ScreenSetCursor (10, 0);
+   cputs ("\r\n\nEmacs aborted!\r\n");
+   exit (2);
+ }
  #endif
  
  syms_of_msdos ()
***************
*** 2591,2596 ****
--- 2609,2618 ----
    staticpro (&recent_doskeys);
  
    defsubr (&Srecent_doskeys);
+ 
+   DEFVAR_LISP ("dos-display-time", &Vdos_display_time,
+     "*When non-nil, `display-time' is in effect on DOS systems.");
+   Vdos_display_time = Qnil;
  }
  
  #endif /* MSDOS */
*** src/getloada.c~0	Mon Aug  7 20:46:44 1995
--- src/getloada.c	Wed Dec 13 13:36:56 1995
***************
*** 732,737 ****
--- 732,747 ----
         : (load_ave.tl_avenrun.l[0] / (double) load_ave.tl_lscale));
  #endif	/* OSF_MIPS */
  
+ #if !defined (LDAV_DONE) && defined(MSDOS)
+ #define LDAV_DONE
+ 
+   /* A faithful emulation is going to have to be saved for a rainy day.  */
+   for ( ; elem < nelem; elem++) 
+     {
+       loadavg[elem] = 0.0;
+     }
+ #endif  /* MSDOS */
+ 
  #if !defined (LDAV_DONE) && defined (OSF_ALPHA)
  #define LDAV_DONE
  
*** src/dosfns.c~0	Tue Nov 21 06:48:34 1995
--- src/dosfns.c	Thu Dec 14 19:40:28 1995
***************
*** 312,319 ****
  
  Lisp_Object Vdos_version;
  Lisp_Object Vdos_display_scancodes;
- Lisp_Object Vdos_menubar_clock;
- Lisp_Object Vdos_timer_hooks;
    
  void
  init_dosfns ()
--- 312,317 ----
***************
*** 416,430 ****
  corner of the display (typically at the end of the mode line).\n\
  The output format is: scan code:char code*modifiers.");
    Vdos_display_scancodes = Qnil;
-   
-   DEFVAR_LISP ("dos-menubar-clock", &Vdos_menubar_clock,
-     "*When non-nil, the current time is displayed in the upper right\n\
- corner of the screen (typically at the end of the menu bar).");
-   Vdos_menubar_clock = Qt;
-   
-   DEFVAR_LISP ("dos-timer-hooks", &Vdos_timer_hooks,
-     "List of hooks which are run every second.");
-   Vdos_timer_hooks = Qnil;
    
    DEFVAR_INT ("dos-hyper-key", &dos_hyper_key,
      "*If set to 1, use right ALT key as hyper key.\n\
--- 414,419 ----
*** src/dosfns.h~0	Wed Oct 11 10:35:32 1995
--- src/dosfns.h	Thu Dec 14 19:42:46 1995
***************
*** 34,40 ****
  extern Lisp_Object Vdos_version;
  #ifndef HAVE_X_WINDOWS
  extern Lisp_Object Vdos_display_scancodes;
- extern Lisp_Object Vdos_menubar_clock;
- extern Lisp_Object Vdos_timer_hooks;
  extern Lisp_Object Qmsdos_color_translate;
  #endif
--- 34,38 ----

Thu Dec 14 20:02:15 1995  Eli Zaretskii  <eliz@is.elta.co.il>

	* time.el (display-time): make it work under ms-dos by setting the
	`dos-display-time' variable instead of invoking ``wakeup'' as
	asynchronous process (which doesn't work under ms-dos).

*** lisp/time.e~0	Fri Oct 27 21:45:26 1995
--- lisp/time.el	Thu Dec 14 18:40:40 1995
***************
*** 62,69 ****
  are displayed as well.
  After each update, `display-time-hook' is run with `run-hooks'."
    (interactive)
!   (let ((live (and display-time-process
! 		   (eq (process-status display-time-process) 'run))))
      (if (not live)
  	(progn
  	  (if display-time-process
--- 62,70 ----
  are displayed as well.
  After each update, `display-time-hook' is run with `run-hooks'."
    (interactive)
!   (let ((live (or (and (eq system-type 'ms-dos) dos-display-time)
! 		  (and display-time-process
! 		       (eq (process-status display-time-process) 'run)))))
      (if (not live)
  	(progn
  	  (if display-time-process
***************
*** 73,88 ****
  	      (setq global-mode-string
  		    (append global-mode-string '(display-time-string))))
  	  (setq display-time-string "")
! 	  ;; Using a pty is wasteful, and the separate session causes
! 	  ;; annoyance sometimes (some systems kill idle sessions).
! 	  (let ((process-connection-type nil))
! 	    (setq display-time-process
! 		  (start-process "display-time" nil
! 				 (expand-file-name "wakeup" exec-directory)
! 				 (int-to-string display-time-interval))))
! 	  (process-kill-without-query display-time-process)
! 	  (set-process-sentinel display-time-process 'display-time-sentinel)
! 	  (set-process-filter display-time-process 'display-time-filter)))))
  
  (defun display-time-sentinel (proc reason)
    (or (eq (process-status proc) 'run)
--- 74,95 ----
  	      (setq global-mode-string
  		    (append global-mode-string '(display-time-string))))
  	  (setq display-time-string "")
! 	  (if (eq system-type 'ms-dos)
! 	      (setq dos-display-time t)
! 	    ;; Using a pty is wasteful, and the separate session causes
! 	    ;; annoyance sometimes (some systems kill idle sessions).
! 	    (progn
! 	      (let ((process-connection-type nil))
! 		(setq display-time-process
! 		      (start-process "display-time" nil
! 				     (expand-file-name
! 				      "wakeup" exec-directory)
! 				     (int-to-string display-time-interval))))
! 	      (process-kill-without-query display-time-process)
! 	      (set-process-sentinel display-time-process
! 				    'display-time-sentinel)
! 	      (set-process-filter   display-time-process
! 				    'display-time-filter)))))))
  
  (defun display-time-sentinel (proc reason)
    (or (eq (process-status proc) 'run)
