Mon Dec 18 00:38:40 1995 1995  Marc Fleischeuers  <marc@mpi.nl>

	* files.el: Dos user can choose backup filenames in dos unix-style
 	tilde or dos-style bak. New variable dos-backup-name-method,
 	determines how backup name is generated. make-backup-file-name,
 	backup-file-name-p changed accordingly.
	(make-auto-save-file-name): make name always end in #,
	i.e. overwrite third char in extension.


*** lisp/files.bak	Fri Nov 10 19:10:34 1995
--- lisp/files.el	Mon Dec 18 00:28:44 1995
***************
*** 1586,1607 ****
  	    (substring file 0 (match-beginning 0)))
  	filename))))
  
  (defun make-backup-file-name (file)
    "Create the non-numeric backup file name for FILE.
  This is a separate function so you can redefine it for customization."
    (if (eq system-type 'ms-dos)
        (let ((fn (file-name-nondirectory file)))
  	(concat (file-name-directory file)
! 		(if (string-match "\\([^.]*\\)\\(\\..*\\)?" fn)
! 		    (substring fn 0 (match-end 1)))
! 		".bak"))
      (concat file "~")))
  
  (defun backup-file-name-p (file)
    "Return non-nil if FILE is a backup file name (numeric or not).
  This is a separate function so you can redefine it for customization.
  You may need to redefine `file-name-sans-versions' as well."
!   (if (eq system-type 'ms-dos)
        (string-match "\\.bak$" file)
      (string-match "~$" file)))
  
--- 1586,1614 ----
  	    (substring file 0 (match-beginning 0)))
  	filename))))
  
+ (defvar dos-backup-name-method 'bak 
+   "*Determines how backup files are named on msdos. If set to `bak' (the
+ default), the extension is replaced by \".bak\"; if it is `tilde', a
+ `~' character is appended.")
+ 
  (defun make-backup-file-name (file)
    "Create the non-numeric backup file name for FILE.
  This is a separate function so you can redefine it for customization."
    (if (eq system-type 'ms-dos)
        (let ((fn (file-name-nondirectory file)))
+ 	(string-match "\\`\\([^.]+\\)\\(\\.\\(..?\\)?.?\\|\\)\\'" fn)
  	(concat (file-name-directory file)
! 		(if (eq dos-backup-name-method 'bak) 
! 		    (concat (match-string 1 fn) ".bak")
! 		  (concat (match-string 1 fn) "." (match-string 3 fn) "~"))))
      (concat file "~")))
  
  (defun backup-file-name-p (file)
    "Return non-nil if FILE is a backup file name (numeric or not).
  This is a separate function so you can redefine it for customization.
  You may need to redefine `file-name-sans-versions' as well."
!   (if (and (eq system-type 'ms-dos) 
! 	   (eq dos-backup-name-method 'bak))
        (string-match "\\.bak$" file)
      (string-match "~$" file)))
  
***************
*** 2325,2334 ****
  before calling this function.  You can redefine this for customization.
  See also `auto-save-file-name-p'."
    (if buffer-file-name
        (concat (file-name-directory buffer-file-name)
  	      "#"
  	      (file-name-nondirectory buffer-file-name)
! 	      "#")
  
      ;; Deal with buffers that don't have any associated files.  (Mail
      ;; mode tends to create a good number of these.)
--- 2332,2347 ----
  before calling this function.  You can redefine this for customization.
  See also `auto-save-file-name-p'."
    (if buffer-file-name
+       (if (eq system-type 'ms-dos)
+ 	  (let ((fn (file-name-nondirectory buffer-file-name)))
+ 		(string-match "\\`\\([^.]+\\)\\(\\.\\(..?\\)?.?\\|\\)\\'" fn)
+ 	    (concat (file-name-directory buffer-file-name)
+ 		    "#" (match-string 1 fn) 
+ 		    "." (match-string 3 fn) "#"))
  	(concat (file-name-directory buffer-file-name)
  		"#"
  		(file-name-nondirectory buffer-file-name)
! 		"#"))
  
      ;; Deal with buffers that don't have any associated files.  (Mail
      ;; mode tends to create a good number of these.)
