/* WARNING WARNING WARNING WARNING WARNING
 *
 * This is the MSDOS device driver code for Archive SC402 / SC499R
 * QIC02 tape controllers.
 * 
 * This code is BETA and is known to have:
 *
 * - BUGS (there *has* to be at least one :-)
 * - code 'stolen' from H.H. Bergman's QIC02 device driver for
 *   Linux-386, Doug Braun's SCSI driver, TCDEV.ARC (from Simtel20)
 * - lack of documentation
 * - dirty code
 *
 * This code is dangerous, not only when running but also when looking
 * at it: it is 100% HACKwork (TM) and the result of a hardware guy trying
 * to write software. Perhaps it will work, perhaps not.
 *
 * NEVER use this code to do anything serious like dumping / restoring
 * important data :-)
 *
 * History:
 *
 * 0.0 - initial 'working' version
 * 0.1 - internal
 *       fixed the 'can only write slowly' bug:
 *       fixed read_status & dma_wait routine
 * 0.2 - internal
 *       cleaned up code
 *       changed device name from TAPE to TAPE$
 *       removed printf's to reduce code size
 *       fixed some suspicious pointer conversions
 * 0.3 - limited release
 *       removed alloc mem on 64K DMA wrap since it didn't work
 * 0.4 - added info returned for mt status, e.g. error count
 * 1.0 - ready for public release (at last...)
 * 1.1 - no change to QIC02.C but needed to patch TCDEV.OBJ to already
 *       have the device driver attributes properly set in order to
 *       get things going with an OS/2 DOS box.
 *
 *
 * Eddy Olk
 * email: eddy@duteca.et.tudelft.nl
 *
 *
 * Oh, almost forgot:
 *
 * QIC02 tape device driver for MSDOS
 * Copyright (C) 1993  Eddy Olk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <dos.h>
#include <string.h>
#include <mem.h>
#include <ctype.h>

#include "mtio.h"
#include "qic02.h"

int errno;                      /* to keep the linker happy */

int iobase = 0x220;             /* default IObase = 0x220h */
int dmanr = 3;                  /* default DMA channel = 3 */
int intnr = 7;                  /* default IRQ number = 7 */
                                /* (currently not used) */

#define DUMMY iobase+3          /* dummy I/O port for reading */
                                /* used to get some sort of CPU */
                                /* independant minimum time */

#define VERSION "1.1"
#define DEVICENAME "TAPE$   "

struct srh {
        char len;
        char unit;
        char cmd;
        int status;
        char res[8];
        union {
                struct { /* init */
                        char units;
                        char far *kaddr;
                        char far *baddr;
                } cin;
                struct { /* media check */
                        char media, stat;
                } cmc;
                struct { /* build parameter block. */
                        char media;
                        char far *taddr;
                        char far *baddr;
                } cbpb;
                struct { /* reading and writing */
                        char media;
                        char far *taddr;
                        unsigned count;
                        unsigned start;
                } crw;
                struct { /* nondestructive read no wait */
                        char ch;
                } cic;
        } c;
};

extern char dev_name[9];
extern int dev_attr;

#ifdef USE_PRINTF
char msg[100];
#endif

char buffer[1024];              /* emergency buffer */
char far *abuf;                 /* non 64K crossing 512 byte emergency */
char far *buf;
char far *bufptr;


static char device_open;
static char bytes_transferred;
static char readmode;
static unsigned error_count;
static unsigned underrun_count;
static long fileno = 0;
static long blkno = 0;
static char move_dir = 1;

/* variables for tape status */
static unsigned char statusbyte[6];

/* variables for DMA stuff */
static char far *dptr;
static unsigned dlen;
static unsigned adlen;
static char rwflag;
static unsigned dma_residue;

biosputs(s)
char *s;
{
  static char c;
  static int oldbp;

  while (*s) {
    c = *s++;
    if (c == '\n') {
      oldbp = _BP;
      _AL = '\r';
      _AH = 0x0e;
      _BH = 0;
      geninterrupt(0x10);
      _BP = oldbp;
    }

    oldbp = _BP;
    _AL = c;
    _AH = 0x0e;
    _BH = 0;
    geninterrupt(0x10);
    _BP = oldbp;
  }
}


/* Find out 14 possible exceptions, got these from the Archive docs */
int get_qicerror()
{
  if (errstat(1,ST1)) {
    if (errstat(1,PAR)) {
      if (errstat(0,ST0) && errstat(0,UDE)) {
        return THCerr;          /* 14: Throughcheck error. FATAL on */
                                /* write, CONTINUABLE on read */
      }
      else {
        return PARerr;          /* 13: bus parity error. CONTINUABLE */
      }
    }
    if (errstat(1,POR))         /* 11: Reset occured. FATAL */
      return PORerr;
    if (errstat(1,ILL))         /* 10: Illegal command. FATAL */
      return ILLerr;
    if (errstat(1,MBD)) {
      if (errstat(0,ST0) && errstat(0,FIL))
          return MARerr;        /* 12: Marginal block. CONTINUABLE */
    }
    if (errstat(1,EOD)) {
      if (errstat(0,ST0) && errstat(0,EOM)) {
        return EDMerr;  /* 8: End of data & EOM. CONTINUABLE */
      }
      else {
        return EODerr;  /* 7: End of data. CONTINUABLE */
      }
    }
  }
  if (errstat(0,ST0)) {
    if (errstat(0,FIL))
      return RFMerr;            /* 9: Read file mark. CONTINUABLE */
    if (errstat(0,UDE)) {
      if (errstat(1,ST1) && errstat(1,BOM)) {
        return RWAerr;          /* 4: Read or write abort. FATAL */
      }
      else {
        if (errstat(0,BNL)) {
          return RFBerr;        /* 6: Read error, filler block. */
                                /* CONTINUABLE */
        }
        else {
          return RBBerr;        /* 5: Read error, bad block. */
                                /* CONTINUABLE */
        }
      }
    }
    if (errstat(0,EOM))
      return EOMerr;            /* 3: End Of Media. CONTINUABLE */
    if (errstat(0,CNI))
      return CNIerr;            /* 1: Cartridge not in place. FATAL */
    if (errstat(0,WRP))
      return WRPerr;            /* 2: Write protected cartridge. FATAL */
  }
  return 0;                     /* 0: No errors? Hope we didn't miss one */
}
  
void wait_more_than_usec(int delay)
{
  int i;
  for (i=0; i<delay; i++) {
    inportb(DUMMY);
    inportb(DUMMY);
  }
}

int read_status()
{
  int i;

  wait_stat;                    /* wait for ready or exception */
  outdata(RDSTATUS);            /* write read status command */
  setreq;                       /* set request */
  wait_rdy;                     /* wait for ready, ignore possible */
                                /* still active exception */
  disable();
  resetreq;                     /* reset request */
  wait_nrdy;                    /* wait until ready is (has been) inactive */
  enable();
  while (!(inportb(STATUS) & DIRC)); /* wait for data direction change */
  for (i=0; i<6; i++) {
    wait_stat;                  /* wait for ready, don't hope for exceptions */
    if (is_exception) {
      return DEADerr;           /* unexpected exception, tape drive */
                                /* must be dead */
    }
    statusbyte[i] = indata;     /* get status byte [i] */
    setreq;                     /* set request */
    wait_more_than_usec(20);
    wait_nrdy;
    resetreq;  /* reset request */
  }
  if (errstat(0,ST0) && errstat(0,FIL)) {
    fileno += move_dir;         /* increment or decrement fileno */
    blkno = 0;
  }
  return 0;                     /* return no error */
}

int wait_completion()           /* wait for command to complete */
{
  int i;

  wait_stat;                    /* wait for ready or exception */
  if (is_exception) {           /* completed by exception? */
    i = read_status();          /* get rid of exception */
    if (i==0) i=get_qicerror(); /* get error that caused exception */
    return i;
  }
  return 0;                     /* no exception, was ready, OK */
}


int issue_cmd(unsigned char cmd) /* issue QIC-02 command to drive */
{
  int i;

  i = wait_completion();        /* wait for ready, exception */
  if (i!=0) return i;           /* some error occurred, need not be ours */
  outdata(cmd);                 /* issue command code */
  if ((cmd == BOT) || (cmd == RETENSION) || (cmd == ERASE))
    wait_more_than_usec(1);     /* this is to follow the odd Archive */
                                /* specs */
  setreq;                       /* set request */
  wait_more_than_usec(1);       /* make sure ready is inactive */
  i = wait_completion();        /* wait for ready (or exception) */
  if (i!=0) return i;           /* something wrong here... */
  disable();
  resetreq;                     /* reset request */
  wait_nrdy;                    /* wait for cmd accepted (NOT until it */
                                /* is completed) */
  enable();
  return 0;
}

int read_bytes(unsigned char cmd, int len)
{
  int i;

  i = issue_cmd(cmd);
  if (i) return i;
  while (!(inportb(STATUS) & DIRC)); /* wait for data direction change */
  for (i=0; i<len; i++) {
    wait_stat;                  /* wait for ready, don't hope for exceptions */
    if (is_exception) {
      return DEADerr;           /* unexpected exception, tape drive */
                                /* must be dead */
    }
    buffer[i] = indata;         /* get byte [i] */
    setreq;                     /* set request */
    wait_more_than_usec(20);
    wait_nrdy;
    resetreq;  /* reset request */
  }
  return 0;
}

int tape_not_present()          /* check for tape presence 0=yes, 1=no */
                                /* read status twice to get proper */
                                /* status after power on / reset */
{
  if (read_status())            /* read status from tape */
    return 1;                   /* tape may be present but severe */
                                /* error from read status */
  if (read_status())            /* read status from tape */
    return 1;                   /* tape may be present but severe */
                                /* error from read status */
  return ((errstat(0,CNI)) ? 1 : 0);
}

int tape_write_protected()
{
  if (read_status())            /* read status from tape */
    return 1;                   /* severe error from read status */
  return ((errstat(0,WRP)) ? 1 : 0);
}

int tape_at_filemark()
{
  if (read_status()) return 1;  /* Oops */
  return ((errstat(0,ST0) && errstat(0,FIL)) ? 1 : 0);
}

int tape_at_bom()
{
  if (read_status()) return 1;  /* Oops */
  return ((errstat(1,BOM)) ? 1 : 0);
}

int tape_at_eod()
{
  if (read_status()) return 1;  /* Oops */
  return ((errstat(1,EOD)) ? 1 : 0);
}

int reset_tapedrv()
{
  outportb(CONTROL, RSTSAC);
  wait_more_than_usec(25);
  outportb(RSTDMA, 0);
  read_status();
  return !(errstat(1,ST1) && errstat(1,POR)); /* check if really reset */
}

void setup_dma()
{
  unsigned pseg, poff;  /* physical address segment and offset */

  if (dlen <= 0)
    return;

  poff = (unsigned)((FP_SEG(dptr) << 4) + FP_OFF(dptr));
  pseg = (unsigned)((FP_SEG(dptr) + (FP_OFF(dptr) >> 4)) >> 12);

  if ( poff + dlen < poff) /* wraparound */
    adlen = -poff;  /* # of bytes in current 64k chunk */
  else
    adlen = dlen;

  disable();                    /* disable interrupts */
  outportb(0x0c, 0);            /* clear DMA channel mask */

  /* set DMA mode: single mode, increment, auto. init. r/w */
  outportb(0x0b, (rwflag ? (0x48 | dmanr) : (0x44 | dmanr)));

  /* set DMA start page address */
  switch (dmanr) {
  case 1:
    outportb(0x83, pseg);
    break;
  case 2:
    outportb(0x81, pseg);
    break;
  case 3:
    outportb(0x82, pseg);
    break;
  default:
    biosputs("set dma page: SHOULD NOT HAPPEN\n");
  }

  /* set DMA start offset address */
  outportb(((dmanr & 3) << 1), poff & 0xff);
  outportb(((dmanr & 3) << 1), poff >> 8);

  /* set DMA transfer size */
  outportb(((dmanr & 3) << 1)+ 1, (adlen-1) & 0xff);
  outportb(((dmanr & 3) << 1)+ 1, (adlen-1) >> 8);

  enable();                     /* restore interrupts */

  dptr += adlen;
  dlen -= adlen;
}


/* This loops, waiting for the DMA finish, or for the data to run out.
It has an extra-long timeout. */

int dma_wait()
{
    static long cnt;

    cnt = 2000000L;
    while (cnt--) {
      /* See if we have reached the DMA done */


      if ((inportb(STATUS) & (EXC | DONE)) != EXC) {
        /* DMA done or exception */

        /* clear byte pointer flip-flop and get DMA residue */
        outportb(0x0c, 0);
        dma_residue = inportb(((dmanr & 3) << 1)+ 1) +
                              256*inportb(((dmanr & 3) << 1)+ 1);

        return ( is_exception ? -2 : 1);
      }
    }

/*    biosputs("dma_wait times out\n"); */
    outportb(0x0c, 0); /* clear byte pointer flip-flop */
    dma_residue = inportb(((dmanr & 3) << 1)+ 1) +
                          256*inportb(((dmanr & 3) << 1)+ 1);

    return (-1);                /* DMA time out */
}


void arm_dma()
{
  /* clear mask bit of DMA channel, allowing dma to start */
  outportb(0x0a, dmanr);
}


void disarm_dma()
{
  /* set mask bit of DMA channel */
  outportb(0x0a, dmanr | 4);
}

int do_dma()
{
  static int i;

  i = issue_cmd(rwflag ? WRITE : READ); /* issue read/write command */
  if (i) return i;                      /* return error */

  setup_dma();                  /* setup DMA */

  i = wait_completion();        /* wait for first block ready */
  if (i) return i;              /* something went wrong */

  outportb(DMAGO,0);            /* start DMA on controller */
  arm_dma();                    /* demask DMA channel */

  i = dma_wait();
  disarm_dma();
  outportb(RSTDMA,0);           /* reset 402/499 DMA logic */

  if (i==-1) {                  /* DMA timed out */
  timeout:
    biosputs("DMA timed out, FATAL: resetting drive\n");
    if (reset_tapedrv())
      return 1;
    if (!(tape_not_present())) {
      issue_cmd(BOT);           /* rewind tape */
    }
    return 1;
  }
  if (i<-1) {                   /* exception during DMA */
    return read_status();
  }

  while (dlen > 0) {            /* not sure this will work... */
    setup_dma();
    arm_dma();
    i = dma_wait();
    disarm_dma();
    if (i<0) {                  /* DMA timed out */
      goto timeout;
    }
  }
  return 0;
}

int transfer_block(void) /* read block from tape, put at dptr */
{
  outportb(RSTDMA, 0);          /* reset DMA logic, just to be sure */
  dptr = buf;
  dlen = 512;

  return do_dma();              /* setup DMA, issue READ, DMAGO, */
                                /* arm_dma, transfer data, disarm_dma */

}

device_driver(struct srh far *request)
{
  static int i, status;
  static unsigned count;
  static unsigned poff;
  extern char enddata;

  struct mtop far *mtopptr;
  struct mtget far *mtgetptr;

  switch(request->cmd) {
  case  0: /* init */

    /* get argument pointer */
    abuf = request->c.cin.baddr;

    /* skip device name */
    while ((abuf[0] != 0x0a) && (abuf[0] != ' '))
      abuf++;
    /* try to parse next arguments (if any) */
    if (abuf[0] != 0x0a) {
      /* skip white space */
      while (abuf[0] == ' ')
        abuf++;
      if (isdigit(abuf[0])) {
        iobase = 0;
        while (isxdigit(abuf[0])) {
          i = abuf[0] - '0';
          if (i>9)
            i -= ('A'-'9'-1);
          if (i>0x0f)
            i -= ('a'-'A');
          iobase = iobase * 16 + i;
          abuf++;
        }
        while (abuf[0] == ' ')
          abuf++;
        if (isdigit(abuf[0])) {
          dmanr = abuf[0] - '0';
          abuf++;
          while (abuf[0] == ' ')
            abuf++;
          if (isdigit(abuf[0]))
            intnr = abuf[0] - '0';
        }
      }
    }

#ifdef USE_PRINTF
    sprintf(msg,
            "\nSC402/499 QIC02 driver ver. %s compiled %s %s\n",
            VERSION, __DATE__, __TIME__);
    biosputs(msg);
    sprintf(msg,
            "I/O base = %xh, DMA = %d, IRQ = %d\n",
            iobase, dmanr, intnr);
    biosputs(msg);
#else
    biosputs("SC402/499 QIC02 driver ver. 1.1\n");
#endif

    if (inportb(iobase+1) == 0xff) {
      biosputs("Not installed, controller not found\n\n");
      request->c.cin.kaddr = MK_FP(_CS, 0);
      request->status = 0x810c;
      break;
    }

#ifdef USE_PRINTF
    sprintf(msg,
            "installed at %X:0000\n", _CS);
    biosputs(msg);
#endif

    /* Get non 64K crossing 512 byte buffer */
    abuf = MK_FP(_DS,buffer);
    poff = (unsigned)((FP_SEG(abuf) << 4) + FP_OFF(abuf));
    if ( poff + 512 < poff) /* wraparound */
      abuf += 512;

    if (reset_tapedrv()) {
      biosputs("Resetting of tape drive failed\n");
    }
    else {
      if (!(tape_not_present())) {
        issue_cmd(BOT);
      }
    }

    device_open = 0;
    bytes_transferred = 0;
    error_count = underrun_count = 0;

    /* next two lines actually not necessary since device name and
       attributes are already properly set in the TCDEV object file */
    strcpy(dev_name, DEVICENAME);
    dev_attr = 0xc820;          /* character device, IOCTL, raw mode */
    request->c.cin.kaddr = (char far *) &enddata;
    request->status = 0x0100;  /* ready */

    biosputs("\n");

    break;
  case  1: /* media check */
#ifdef VERBOSE
    biosputs("tape: ignoring media check\n");
#endif
    request->status = 0x0100;  /* ready */
    break;
  case  2: /* build bpb */
#ifdef VERBOSE
    biosputs("tape: ignoring build bpb\n");
#endif
    request->status = 0x0100;  /* ready */
    break;
  case  3: /* input ioctl */
    mtgetptr = (struct mtget far *)request->c.crw.taddr;
    request->c.crw.count = sizeof(struct mtget);
    mtgetptr->mt_type = MT_ISAR;
    mtgetptr->mt_fileno = fileno;
    mtgetptr->mt_blkno = blkno;
    if (read_bytes(RDRESCNT,6) || read_status()) {
      /* error reading status or residue */
      mtgetptr->mt_dsreg = 0;
      mtgetptr->mt_erreg = 0;
      mtgetptr->mt_resid = 0;
      mtgetptr->mt_unrun = 0;
      request->status = 0x810c;  /* device failure for IOCTL read */
    }
    else {
      mtgetptr->mt_dsreg = 256*statusbyte[1]+statusbyte[0];
      mtgetptr->mt_erreg = error_count;
      mtgetptr->mt_unrun = underrun_count;
      error_count = underrun_count = 0;
      mtgetptr->mt_resid = (unsigned) buffer[5];
      request->status = 0x0100;  /* completed IOCTL read */
    }
    break;
  case  4: /* input */
    if (!device_open) {
      biosputs("tape: device not open on input\n");
      request->c.crw.count = 0;
      request->status = 0x8102;
      break;
    }
    if (!bytes_transferred && tape_not_present()) {
      biosputs("tape: cartridge not in place\n");
      request->status = 0x8102;
      break;
    }
    if (bytes_transferred && !readmode) {
      biosputs("tape: can not read in write mode\n");
      request->c.crw.count = 0;
      request->status = 0x810b;
      break;
    }
    if (request->c.crw.count & 0x01ff) {
      biosputs("tape: only 512 byte blocks supported\n");
      request->c.crw.count = 0;
      request->status = 0x810b;
      break;
    }

    if (!bytes_transferred) {
      bytes_transferred = 1;
      readmode = 1;
      rwflag = 0;
      error_count = underrun_count = 0;
      blkno = 0;
    }
    request->status = 0x0100;

    bufptr = request->c.crw.taddr;
    poff = (unsigned)((FP_SEG(bufptr) << 4) + FP_OFF(bufptr));
    if ( poff + request->c.crw.count < poff) { /* 64K DMA wraparound */
      buf = abuf;               /* get non-64K wrapping buffer */
      count = request->c.crw.count / 512;
      request->c.crw.count = 0;
      for(i = 0; i<count; i++) {
        status = transfer_block();
        if (status) {
          bytes_transferred = 0;
          request->status = 0x810b;
          break;
        }
        request->c.crw.count += 512;
        blkno++;
        movedata(FP_SEG(buf), FP_OFF(buf), FP_SEG(bufptr),
                 FP_OFF(bufptr), 512);
        bufptr += 512;
      }
    }
    else {
      outportb(RSTDMA, 0);
      dptr = bufptr;
      dlen = count = dma_residue = request->c.crw.count;

      status = do_dma();

      if (status) {
#ifdef VERBOSE
        biosputs("tape: got error during read\n");
#endif
        request->c.crw.count -= dma_residue;
        request->status = 0x810b;
        bytes_transferred = 0;  /* 'close' read mode */
        blkno += (request->c.crw.count) >> 9;
        break;
      }
      blkno += (request->c.crw.count) >> 9;
    }
    break;
  case  5: /* input check (buffer status) */
#ifdef VERBOSE
    biosputs("tape: error return for input status\n");
#endif
    request->status = 0x8103;  /* unknown command */
    break;
  case  6: /* input status */
#ifdef VERBOSE
    biosputs("tape: error return for input status\n");
#endif
    request->status = 0x8103;  /* unknown command */
    break;
  case  7: /* input flush */
#ifdef VERBOSE
    biosputs("tape: ignoring input flush\n");
#endif
    request->status = 0x0100;  /* ready */
    break;
  case  9: /* output with verify */
/*    biosputs("tape: forwarding write verify to write\n"); */
  case  8: /* output */
    if (!device_open) {
      biosputs("tape: device not open on write\n");
      request->c.crw.count = 0;
      request->status = 0x8102;
      break;
    }
    if (!bytes_transferred && tape_not_present()) {
      biosputs("tape: cartridge not in place\n");
      request->status = 0x8102;
      break;
    }
    if (bytes_transferred && readmode) {
      biosputs("tape: can not write in read mode\n");
      request->c.crw.count = 0;
      request->status = 0x810a;
      break;
    }
    if (!bytes_transferred && tape_write_protected()) {
      biosputs("tape: tape is write protected\n");
      request->c.crw.count = 0;
      request->status = 0x8100;
      break;
    }
    if (request->c.crw.count & 0x01ff) {
      biosputs("tape: only 512 byte blocks supported\n");
      request->c.crw.count = 0;
      request->status = 0x810a;
      break;
    }
    if (!bytes_transferred) {
      bytes_transferred = 1;
      readmode = 0;
      rwflag = 1;
      error_count = underrun_count = 0;
      blkno = 0;
    }
    request->status = 0x0100;

    bufptr = request->c.crw.taddr;
    poff = (unsigned)((FP_SEG(bufptr) << 4) + FP_OFF(bufptr));
    if ( poff + request->c.crw.count < poff) { /* wraparound */
      buf = abuf;
      count = request->c.crw.count / 512;
      request->c.crw.count = 0;
      for(i = 0; i<count; i++) {
        movedata(FP_SEG(bufptr), FP_OFF(bufptr),
                 FP_SEG(buf), FP_OFF(buf), 512);
        bufptr += 512;
        status = transfer_block();
        if (status) {
          request->status = 0x810a;
          bytes_transferred = 0;
          break;
        }
        request->c.crw.count += 512;
        blkno++;
      }
    }
    else {
      outportb(RSTDMA, 0);
      dptr = bufptr;
      dlen = dma_residue = request->c.crw.count;

      status = do_dma();

      if (status) {
#ifdef VERBOSE
        biosputs("tape: got error during write\n");
#endif
        request->c.crw.count -= dma_residue;
        request->status = 0x810a;
        bytes_transferred = 0;
        blkno += (request->c.crw.count) >> 9;
        break;
      }
      blkno += (request->c.crw.count) >> 9;
    }
    break;
  case 10: /* output status */
#ifdef VERBOSE
    biosputs("tape: error return for output status\n");
#endif
    request->status = 0x8103;  /* unknown command */
    break;
  case 11: /* output buffer flush */
#ifdef VERBOSE
    biosputs("tape: ignoring output flush\n");
#endif
    request->status = 0x0100;  /* ready */
    break;
  case 12: /* output ioctl */
    mtopptr = (struct mtop far *)request->c.crw.taddr;
    request->c.crw.count = sizeof(struct mtop);
    request->status = 0x0100;  /* completed IOCTL write */
    switch (mtopptr->mt_op) {
    case MTRESET:
      if (reset_tapedrv())
        request->status = 0x810c; /* general failure */
      goto reset_fileno_blkno;
    case MTFSF:
      for (i=0; i<mtopptr->mt_count; i++) {
        if (issue_cmd(RDMARK)) {
          request->status = 0x810c;
          break;
        }
        if (wait_completion() != RFMerr) {
          request->status = 0x810c;
          break;
        }
      }
      break;
    case MTBSF:
      request->status = 0x8103; /* not supported (yet) */
      break;
    case MTFSR:
      for (i=0; i<mtopptr->mt_count; i++) {
        if (issue_cmd(SPACEFORW)) {
          request->status = 0x810c;
          break;
        }
        if (wait_completion()) {
          request->status = 0x810c;
          break;
        }
        blkno++;
      }
      break;
    case MTBSR:
      move_dir = -1;
      for (i=0; i<mtopptr->mt_count; i++) {
        if (issue_cmd(SPACEREV)) {
          request->status = 0x810c;
          break;
        }
        if (wait_completion()) {
          request->status = 0x810c;
          break;
        }
        blkno--;
      }
      move_dir = 1;
      break;
    case MTWEOF:
      for (i=0; i<mtopptr->mt_count; i++) {
        if (issue_cmd(WRMARK)) {
          request->status = 0x810c;
          break;
        }
        if (wait_completion()) {
          request->status = 0x810c;
          break;
        }
        fileno++;
        blkno = 0;
      }
      break;
    case MTOFFL:
    case MTREW:
      if (issue_cmd(BOT)) {
          request->status = 0x810c;
          break;
        }
wait_tape_movement:
      wait_completion();
      if (!tape_at_bom())
        request->status = 0x810c; /* general failure */
reset_fileno_blkno:
      fileno = blkno = 0;
      break;
    case MTERASE:
      if (issue_cmd(ERASE)) {
          request->status = 0x810c;
          break;
        }
      goto wait_tape_movement;
    case MTRETENSION:
      if (issue_cmd(RETENSION)) {
          request->status = 0x810c;
          break;
        }
      goto wait_tape_movement;
    case MTEOD:
      if (issue_cmd(SEEKEOD)) {
          request->status = 0x810c;
          break;
        }
      wait_completion();
      if (!tape_at_eod())
        request->status = 0x810c; /* general failure */
      fileno = -1;              /* of course this is not correct but */
                                /* how are we to know which file we're at ? */
      blkno = 0;
      break;
    case MTNOP:
      break;
    default:
      request->status = 0x8103;
    }
    break;
  case 13: /* device open */
    bytes_transferred = 0;

    /* Don't check for presence of tape yet,
       just do it when actually transfering data */

    device_open = 1;
    request->status = 0x0100;
    break;
  case 14: /* device close */
#ifdef VERBOSE
    if (!device_open) {
      biosputs("tape: device not open on close\n");
      request->status = 0x810c;
      break;
    }
#endif
    device_open = 0;

    if (!bytes_transferred) {
      request->status = 0x0100;
      break;
    }
    if (readmode) {
      /* first get error count */
      if (read_status()) {
        /* This should normally not happen */
        request->status = 0x810c;
        break;
      }
      else {
        error_count = 256*statusbyte[2] + statusbyte[3];
        underrun_count = 256*statusbyte[4] + statusbyte[5];
      }
#if 0
      /* first check for filemark already read/detected */
      if (!(tape_at_filemark())) {
        /* try to read/seek closing file mark */
        status = issue_cmd(RDMARK);
        if (status!=0) {
          biosputs("tape: couldn't read file mark on device close\n");
          request->status = 0x810c;
          break;
        }
        status = wait_completion();
        if (status != RFMerr) {
          biosputs("tape: error seeking for filemark on device close\n");
          request->status = 0x810c;
          break;
        }
      }
#endif
    }
    else {
      /* first get error count */
      if (read_status()) {
        /* This should normally not happen */
        request->status = 0x810a;
        break;
      }
      else {
        error_count = 256*statusbyte[2] + statusbyte[3];
        underrun_count = 256*statusbyte[4] + statusbyte[5];
      }
      /* write closing filemark */
      status = issue_cmd(WRMARK);
      if (status!=0) {
        biosputs("tape: couldn't write file mark on device close\n");
        request->status = 0x810a;
        break;
      }
      status = wait_completion();
      if (status) {
        biosputs("tape: error writing filemark on device close\n");
        request->status = 0x810a;
        break;
      }
      fileno++;
      blkno = 0;
    }
    request->status = 0x0100;
    break;
  case 15: /* removable media */
#ifdef VERBOSE
    biosputs("tape: ignoring removable media\n");
#endif
    request->status = 0x0100;  /* ready */
    break;
  case 16: /* output busy */
#ifdef VERBOSE
    biosputs("tape: error return for output busy\n");
#endif
    request->status = 0x8103;  /* unknown command */
    break;
  default:
#ifdef USE_PRINTF
    sprintf(msg,"tape: got illegal request %d\n", (int) request->cmd);
    biosputs(msg);
#else
#ifdef VERBOSE
    biosputs("tape: got illegal request\n");
#endif
#endif
    request->status = 0x8103;  /* unknown command */
    break;
  }
}

abort()
{
  biosputs("QIC-02 driver aborted\n");
  for(;;);
}

int _realcvtvector;
