unit Mainform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, TabNotBk, ExtCtrls, Buttons,
  Declares, Globals;

type
  TfrmMain = class(TForm)
    Tab1: TTabbedNotebook;
    Label1: TLabel;
    btnExit: TBitBtn;
    Label2: TLabel;
    cmdStartProgram: TButton;
    cmdEndProgram: TButton;
    cmdGetTimeUsed: TButton;
    cmdIsComputerSame: TButton;
    cmdGetPersonalInfo: TButton;
    cmdWriteVersion: TButton;
    cmdGetVersion: TButton;
    cmdWriteUserInfo: TButton;
    cmdGetUserInfo: TButton;
    cmdWriteOther: TButton;
    cmdGetOther: TButton;
    cmdSetFileTime: TButton;
    cmdFileExist: TButton;
    cmdFindCRC: TButton;
    lblStartProgram: TLabel;
    lblEndProgram: TLabel;
    lblGetTimeUsed: TLabel;
    lblIsComputerSame: TLabel;
    lblGetPersonalInfo: TLabel;
    lblWriteVersion: TLabel;
    lblGetVersion: TLabel;
    lblWriteUserInfo: TLabel;
    lblGetUserInfo: TLabel;
    lblWriteOther: TLabel;
    lblGetOther: TLabel;
    lblSetFileTime: TLabel;
    lblFileExist: TLabel;
    lblFindCRC: TLabel;
    cmdGetSerialNumber: TButton;
    cmdMakeRegNum: TButton;
    cmdCheckRegNum: TButton;
    cmdRegisterProgram: TButton;
    cmdSeeIsRegistered: TButton;
    cmdGetAccCode: TButton;
    cmdMakeRegItFile: TButton;
    Label3: TLabel;
    edtFileName: TEdit;
    Label4: TLabel;
    edtMagicNumber: TEdit;
    Label5: TLabel;
    edtAccessCode: TEdit;
    edtGetAccessCode: TEdit;
    edtMakeRegNum: TEdit;
    edtGetSerialNumber: TEdit;
    lblDays: TLabel;
    lblHours: TLabel;
    lblMinutes: TLabel;
    lblSeconds: TLabel;
    lblRuns: TLabel;
    lblGetPersonalInfo1: TLabel;
    lblGetPersonalInfo2: TLabel;
    edtWriteVersion: TEdit;
    edtGetVersion: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    edtWriteUserInfo1: TEdit;
    edtWriteUserInfo2: TEdit;
    lblGetUserInfo1: TLabel;
    lblGetUserInfo2: TLabel;
    edtWriteOther1: TEdit;
    edtWriteOther2: TEdit;
    edtWriteOther3: TEdit;
    edtWriteOther4: TEdit;
    edtWriteOther5: TEdit;
    Label8: TLabel;
    edtSetFileTime: TEdit;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    edtFileExist: TEdit;
    edtFindCRC: TEdit;
    btnSaveDate: TButton;
    btnCheckDate: TButton;
    btnGetDate: TButton;
    lblGetDate: TLabel;
    Label12: TLabel;
    edtMonth: TEdit;
    edtDay: TEdit;
    edtYear: TEdit;
    edtUsers: TEdit;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    cmdGetExpirationDate: TButton;
    edtExpiration1: TEdit;
    edtExpiration2: TEdit;
    edtExpiration3: TEdit;
    cmdGetNumUsers: TButton;
    edtGetNumUsers: TEdit;
    procedure cmdGetSerialNumberClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure cmdMakeRegNumClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure cmdMakeRegItFileClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cmdCheckRegNumClick(Sender: TObject);
    procedure cmdGetAccCodeClick(Sender: TObject);
    procedure cmdSeeIsRegisteredClick(Sender: TObject);
    procedure cmdRegisterProgramClick(Sender: TObject);
    procedure cmdIsComputerSameClick(Sender: TObject);
    procedure cmdGetPersonalInfoClick(Sender: TObject);
    procedure cmdStartProgramClick(Sender: TObject);
    procedure cmdEndProgramClick(Sender: TObject);
    procedure cmdGetTimeUsedClick(Sender: TObject);
    procedure cmdWriteVersionClick(Sender: TObject);
    procedure cmdGetVersionClick(Sender: TObject);
    procedure cmdWriteUserInfoClick(Sender: TObject);
    procedure cmdGetUserInfoClick(Sender: TObject);
    procedure cmdWriteOtherClick(Sender: TObject);
    procedure cmdGetOtherClick(Sender: TObject);
    procedure cmdSetFileTimeClick(Sender: TObject);
    procedure cmdFileExistClick(Sender: TObject);
    procedure cmdFindCRCClick(Sender: TObject);
    procedure btnSaveDateClick(Sender: TObject);
    procedure btnCheckDateClick(Sender: TObject);
    procedure btnGetDateClick(Sender: TObject);
    procedure cmdGetExpirationDateClick(Sender: TObject);
    procedure cmdGetNumUsersClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

{===================================================}
procedure TfrmMain.FormCreate(Sender: TObject);
begin
     TheFile := StrAlloc(255);
     Tab1.PageIndex := 0;
end;

{==================================================}
procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     Action := caFree;
end;

{===================================================}
procedure TfrmMain.FormDestroy(Sender: TObject);
begin
     StrDispose(TheFile);
end;

{===================================================}
procedure TfrmMain.btnExitClick(Sender: TObject);
begin
     Close;
end;

{==================================================}
{==================================================}
{==================================================}
procedure TfrmMain.cmdGetSerialNumberClick(Sender: TObject);
var
   SerNum: PChar;
begin
try
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);
     SerNum := StrAlloc(17);
     StrPCopy(SerNum, '');
     Return := riGetSerialNumber(TheFile, SerNum, MagicNumber);
     edtGetSerialNumber.Text := StrPas(SerNum);
     cmdGetSerialNumber.Caption := IntToStr(Return);
finally
       StrDispose(SerNum);
end;
end;

{===================================================}
procedure TfrmMain.cmdMakeRegNumClick(Sender: TObject);
var
   SerNum, RegNum: PChar;
   AccessCode: Integer;
   Month, Day, Year, Users: Integer;
Begin
try
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);
     SerNum := StrAlloc(17);
     RegNum := StrAlloc(40);

     Return := riGetSerialNumber (TheFile, SerNum, MagicNumber);

     AccessCode := StrToInt(edtAccessCode.Text);
     Month := StrToInt(edtMonth.Text);
     Day := StrToInt(edtDay.Text);
     Year := StrToInt(edtYear.Text);
     Users := StrToInt(edtUsers.Text);

     Return := riMakeRegNum(SerNum, RegNum, AccessCode, Month, Day, Year, Users);

     edtMakeRegNum.Text := StrPas(RegNum);
     cmdMakeRegNum.Caption := IntToStr(Return);
finally
       StrDispose(SerNum);
       StrDispose(RegNum);
end;
End;

{===================================================}
procedure TfrmMain.cmdMakeRegItFileClick(Sender: TObject);
begin
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);
     Return := riMakeRegItFile(TheFile, MagicNumber);
     cmdMakeRegItFile.Caption := IntToStr(Return);
end;

{===================================================}
procedure TfrmMain.cmdCheckRegNumClick(Sender: TObject);
var
   RegNum: PChar;
begin
try
     RegNum := StrAlloc(40);
     StrPCopy (TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);
     StrPCopy(RegNum, edtMakeRegNum.Text);
     Return := riCheckRegNum(TheFile, RegNum, MagicNumber);
     cmdCheckRegNum.Caption := IntToStr(Return);
finally
       StrDispose(RegNum);
end;
end;

{===================================================}
procedure TfrmMain.cmdGetAccCodeClick(Sender: TObject);
var
   Acc: Integer;
begin
   StrPCopy(TheFile, edtFileName.Text);
   MagicNumber := StrToInt(edtMagicNumber.Text);

   Return := riGetAccCode(TheFile, MagicNumber, Acc);
   cmdGetAccCode.Caption := IntToStr(Return);
   edtGetAccessCode.Text := IntToStr(Acc);
end;

{===================================================}
procedure TfrmMain.cmdSeeIsRegisteredClick(Sender: TObject);
begin
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);

     Return := riSeeIsRegistered(TheFile, MagicNumber);
     cmdSeeIsRegistered.Caption := IntToStr(Return);
end;

{===================================================}
procedure TfrmMain.cmdRegisterProgramClick(Sender: TObject);
var
   RegNum: PChar;
begin
try
     RegNum := StrAlloc(40);
     StrPCopy(RegNum, edtMakeRegNum.Text);
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);

     Return := riRegisterProgram(TheFile, RegNum, MagicNumber);
     cmdRegisterProgram.Caption := IntToStr(Return);
finally
       StrDispose(RegNum);
end;
end;

{===================================================}
{===================================================}
{===================================================}
procedure TfrmMain.cmdIsComputerSameClick(Sender: TObject);
begin
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);

     Return := riIsComputerSame(TheFile, MagicNumber);
     cmdIsComputerSame.Caption := IntToStr(Return);
end;

{===================================================}
procedure TfrmMain.cmdGetPersonalInfoClick(Sender: TObject);
var
   MyPersonalString: PChar;
   MyPersonalNumber: LongInt;
begin
try
     MyPersonalString := StrAlloc(50);
     MyPersonalNumber := riGetPersonalInfo(MyPersonalString);
     lblGetPersonalInfo1.Caption := StrPas(MyPersonalString);
     lblGetPersonalInfo2.Caption := IntToStr(MyPersonalNumber);
finally
       StrDispose(MyPersonalString);
end;
end;

{===================================================}
procedure TfrmMain.cmdStartProgramClick(Sender: TObject);
begin
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);
     Return := riStartProgram(TheFile, MagicNumber);
     cmdStartProgram.Caption := IntToStr(Return);
end;

{===================================================}
procedure TfrmMain.cmdEndProgramClick(Sender: TObject);
begin
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);
     Return := riEndProgram(TheFile, MagicNumber);
     cmdEndProgram.Caption := IntToStr(Return);
end;

{===================================================}
procedure TfrmMain.cmdGetTimeUsedClick(Sender: TObject);
var
   Days, Hours, Minutes, Seconds, Runs: LongInt;
begin
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);
     Return := riGetTimeUsed(TheFile, MagicNumber, Days, Hours, Minutes, Seconds, Runs);
     cmdGetTimeUsed.Caption := IntToStr(Return);
     lblDays.Caption := IntToStr(Days) + ' days';
     lblHours.Caption := IntToStr(Hours) + ' hours';
     lblMinutes.Caption := IntToStr(Minutes) + ' minutes';
     lblSeconds.Caption := IntToStr(Seconds) + ' seconds';
     lblRuns.Caption := IntToStr(Runs) + ' runs';
end;

{===================================================}
{===================================================}
{===================================================}
procedure TfrmMain.cmdWriteVersionClick(Sender: TObject);
var
   Version: Integer;
begin
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);
     Version := StrToInt(edtWriteVersion.Text);
     Return := riWriteVersion(TheFile, MagicNumber, Version);
     cmdWriteVersion.Caption := IntToStr(Return);
end;

{===================================================}
procedure TfrmMain.cmdGetVersionClick(Sender: TObject);
var
   Version: Integer;
begin
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);
     Return := riGetVersion(TheFile, MagicNumber, Version);
     cmdGetVersion.Caption := IntToStr(Return);
     edtGetVersion.Text := IntToStr(Version);
end;

{===================================================}
procedure TfrmMain.cmdWriteUserInfoClick(Sender: TObject);
var
   User, Company: PChar;
begin
try
     User := StrAlloc(25);
     Company := StrAlloc(25);
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);
     StrPCopy(User, edtWriteUserInfo1.Text);
     StrPCopy(Company, edtWriteUserInfo2.Text);
     Return := riWriteUserInfo(TheFile, User, Company, MagicNumber);
     cmdWriteUserInfo.Caption := IntToStr(Return);
finally
       StrDispose(User);
       StrDispose(Company);
end;
end;

{===================================================}
procedure TfrmMain.cmdGetUserInfoClick(Sender: TObject);
var
   User, Company: PChar;
begin
try
     User := StrAlloc(25);
     Company := StrAlloc(25);
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);
     Return := riGetUserInfo(TheFile, User, Company, MagicNumber);
     cmdWriteUserInfo.Caption := IntToStr(Return);
     lblGetUserInfo1.Caption := StrPas(User);
     lblGetUserInfo2.Caption := StrPas(Company);
finally
       StrDispose(User);
       StrDispose(Company);
end;
end;

{===================================================}
procedure TfrmMain.cmdWriteOtherClick(Sender: TObject);
var
   info1, info2, info3, info4, info5: PChar;
begin
try
     info1 := StrAlloc(25);
     info2 := StrAlloc(25);
     info3 := StrAlloc(25);
     info4 := StrAlloc(25);
     info5 := StrAlloc(25);
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);

     StrPCopy(info1, edtWriteOther1.Text);
     StrPCopy(info2, edtWriteOther2.Text);
     StrPCopy(info3, edtWriteOther3.Text);
     StrPCopy(info4, edtWriteOther4.Text);
     StrPCopy(info5, edtWriteOther5.Text);
     Return := riWriteOther(TheFile, info1, info2, info3, info4, info5, MagicNumber);
     cmdWriteOther.Caption := IntToStr(Return);
finally
       StrDispose(info1);
       StrDispose(info2);
       StrDispose(info3);
       StrDispose(info4);
       StrDispose(info5);
       edtWriteOther1.Text := '';
       edtWriteOther2.Text := '';
       edtWriteOther3.Text := '';
       edtWriteOther4.Text := '';
       edtWriteOther5.Text := '';
end;
end;

{===================================================}
procedure TfrmMain.cmdGetOtherClick(Sender: TObject);
var
   info1, info2, info3, info4, info5: PChar;
begin
try
     info1 := StrAlloc(25);
     info2 := StrAlloc(25);
     info3 := StrAlloc(25);
     info4 := StrAlloc(25);
     info5 := StrAlloc(25);
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);

     Return := riGetOther(TheFile, info1, info2, info3, info4, info5, MagicNumber);
     edtWriteOther1.Text := StrPas(info1);
     edtWriteOther2.Text := StrPas(info2);
     edtWriteOther3.Text := StrPas(info3);
     edtWriteOther4.Text := StrPas(info4);
     edtWriteOther5.Text := StrPas(info5);
     cmdGetOther.Caption := IntToStr(Return);
finally
       StrDispose(info1);
       StrDispose(info2);
       StrDispose(info3);
       StrDispose(info4);
       StrDispose(info5);
end;
end;

{===================================================}
procedure TfrmMain.cmdSetFileTimeClick(Sender: TObject);
var
   TheTime: PChar;
begin
try
     TheTime := StrAlloc(20);
     StrPCopy(TheTime, edtSetFileTime.Text);
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);
     Return := riSetFileTime(TheFile, TheTime, MagicNumber);
     cmdSetFileTime.Caption := IntToStr(Return);
finally
       StrDispose(TheTime);
end;
end;

{===================================================}
procedure TfrmMain.cmdFileExistClick(Sender: TObject);
begin
     StrPCopy(TheFile, edtFileExist.Text);
     Return := riFileExist(TheFile);
     cmdFileExist.Caption := IntToStr(Return);
end;

{===================================================}
procedure TfrmMain.cmdFindCRCClick(Sender: TObject);
var
   TheCRC: LongInt;
begin
     StrPCopy(TheFile, edtFileName.Text);
     TheCRC := riFindCRC(TheFile);
     edtFindCRC.Text := IntToHex(TheCRC, 8);
end;

{===================================================}
procedure TfrmMain.btnSaveDateClick(Sender: TObject);
var
   TheDateTime: PChar;
begin
     TheDateTime := StrAlloc(25);
     StrPCopy(TheDateTime, DateTimeToStr(Now));
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);

     Return := riSaveDate(TheFile, TheDateTime, MagicNumber);

     btnSaveDate.Caption := IntToStr(Return);
     StrDispose(TheDateTime);
end;

{===================================================}
procedure TfrmMain.btnCheckDateClick(Sender: TObject);
begin
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);

     Return := riCheckDate(TheFile, MagicNumber);

     btnCheckDate.Caption := IntToStr(Return);
end;

{===================================================}
procedure TfrmMain.btnGetDateClick(Sender: TObject);
var
   TheDate: PChar;
begin
try
     TheDate := StrAlloc(25);
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);

     Return := riGetDate (TheFile, TheDate, MagicNumber);
     btnGetDate.Caption := IntToStr(Return);
     lblGetDate.Caption := StrPas(TheDate);
finally
     StrDispose(TheDate);
end;
end;

{===================================================}
procedure TfrmMain.cmdGetExpirationDateClick(Sender: TObject);
var
   Month, Day, Year: Integer;
begin
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);

     Return := riGetExpirationDate (TheFile, MagicNumber, Month, Day, Year);

     edtExpiration1.Text := IntToStr(Month);
     edtExpiration2.Text := IntToStr(Day);
     edtExpiration3.Text := IntToStr(Year);
     cmdGetExpirationDate.Caption := IntToStr(Return);
end;

{===================================================}
procedure TfrmMain.cmdGetNumUsersClick(Sender: TObject);
var
   Users: Integer;
begin
     StrPCopy(TheFile, edtFileName.Text);
     MagicNumber := StrToInt(edtMagicNumber.Text);

     Return := riGetNumUsers (TheFile, MagicNumber, Users);

     edtGetNumUsers.Text := IntToStr(Users);
     cmdGetNumUsers.Caption := IntToStr(Return);
end;

{===================================================}
end.
