/* Prints 8 pages per page to a DeskJet500 */
/* Version C Copyright Nigel Salt 1994     */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <conio.h>

void main(int argc, char *argv[]);
void usage(char *s);
void prinpage(int pagenum);

/* String for portrait 13 lpi 24 cpi 6 pitch Gothic */
static char tinyfnt[]="&l13d0O(s24h6v6T";

/* Buffer for 4 pages */
static char textbuff[4*66*81+1];

/* Buffer for one line of print */
static char linbuff[200];

/* 80 spaces for padding */
static char spaces[81]=
"                                                                                ";
/* First page on current sheet */
int curpage=0;

/* Destination stream */
FILE *printer;

/* Number of lines per page - default is UK A4 66 lines */
int pagelen=66;

void main(int argc, char *argv[])
{
  int i,j;
  int newpage;
  int startpage;
  int endpage;
  int linlen;
  int printit;
  int somestored=0;
  char *tabpos;
  FILE *inf,*outf;

  startpage=1;
  endpage=32767;
  fprintf(stderr,"\n    8PDJ500 Version C");
  fprintf(stderr,"\nCopyright Nigel Salt 1994");
  fprintf(stderr,"\n-------------------------\n");
  if (argc<2)
    usage("You must specify a file to print");
  
  inf=fopen(argv[1],"r");
  if (inf==NULL)
    {
    sprintf(linbuff,"Cannot open input file '%s'",argv[1]);
    usage(linbuff);
    }

  printer=fopen("PRN","wb");
  if (printer==NULL)
    usage("Cannot open PRN - you may need to use the -d option");
  for (i=2;i<argc;i++) 
    {
    switch (toupper(argv[i][1]))
      {
      case 'P':
        pagelen=atoi(&argv[i][2]);
        if (pagelen<1||pagelen>66)
          {
          sprintf(linbuff,"Invalid option '%s': Page length must be between 1 and 66");
          usage(linbuff);
          }
        break;
      case 'D':
        printer=fopen(&argv[i][2],"wb");
        if (printer==NULL)
          {
          sprintf(linbuff,"Invalid output device '%s'",&argv[i][2]);
          usage(linbuff);
          }
        break;
      case 'S':
        startpage=atoi(&argv[i][2]);
        break;
      case 'E':
        endpage=atoi(&argv[i][2]);
        break;
      default:
        sprintf(linbuff,"Invalid option '%s'",argv[i]);
        usage(linbuff);
        break;
      }
    }
  
  outf=fopen("8pdj500.$$$","w");
  if (outf==NULL)
    usage("Cannot open temporary file '8pdj500.$$$'");

  fprintf(printer,"%s",tinyfnt);

  printit=1;
  while (!feof(inf))
    {
    for (i=0;i<4;i++)
      {
      newpage=0;
      for (j=0;j<pagelen;j++)
        {
        if (newpage||feof(inf))
          strcpy(&textbuff[(i*pagelen+j)*81],spaces);
        else
          {
          if (fgets(linbuff,80,inf)==NULL) linbuff[0]='\0';
          tabpos=strchr(linbuff,'\t');
          while (tabpos!=NULL)
            {
            *tabpos=' ';
            tabpos=strchr(linbuff,'\t');
            }

          linlen=strlen(linbuff);
          if (linbuff[linlen-1]=='\n')
            linbuff[linlen-1]='\0';
          if (linbuff[linlen-2]=='\f')
            {
            newpage=1;
            linbuff[0]='\0';
            }
          linlen=strlen(linbuff);
          strcat(linbuff,&spaces[linlen]);
          strcpy(&textbuff[(i*pagelen+j)*81],linbuff);
          }
        }
      }
    /* Now have 4 pages of text in the buffer space filled on right */
    curpage+=1;
    if (curpage>=startpage && curpage<=endpage)
      {
      if (printit)
        {
        prinpage(curpage);
        printit=0;
        }
      else
        {
        somestored=1;
        fwrite(textbuff,81,4*pagelen,outf);
        printit=1;
        }
      }
    }
  fclose(inf);
  fclose(outf);
  if (somestored)
    {
    inf=fopen("8pdj500.$$$","rb");
    if (inf==NULL)
      usage("Cannot read temporary file '8pdj500.$$$'");
    printf("%c%cRemove paper from output tray\n",7,7);
    printf("Place it printed side up / head first into input tray\n");
    printf("FIRST PAGE SHOULD BE ON TOP\n");
    printf("PRESS ANY KEY WHEN READY\n");
    getch();
    for (i=startpage+1;i<=curpage;i+=2)
      {
      fread(textbuff,81,4*pagelen,inf);
      prinpage(i);
      }
    fclose(inf);
    }
  remove("8pdj500.$$$");
  fprintf(printer,"%cE",27);
  printf("%c%c%cDONE",7,7,7);
  exit(0);
}

void prinpage(int pagenum)
{
  int i,j;
  printf("Printing page %d\n",pagenum); 
  for (i=0;i<2;i++)
    for (j=0;j<pagelen;j++)
      {
      fprintf(printer,"         %s       |       %s\r\n",\
        &textbuff[(i*pagelen+j)*81],&textbuff[((i+2)*pagelen+j)*81]);
      }
  fprintf(printer,"\f");
  fflush(printer);
}

void usage(char *s)
{
  fprintf(stderr,"\n%s\n",s);
  fprintf(stderr,"\nUSAGE:");
  fprintf(stderr,"\n\t8pdj500 filename [-ddestination] [-snn] [-enn] [-pnn]");
  fprintf(stderr,"\n-d   device/file is optional and can be PRN LPT1 LPT2 COM1 etc"); 
  fprintf(stderr,"\n     or a file name. The default is PRN");
  fprintf(stderr,"\n-s   Start at page nn");
  fprintf(stderr,"\n-e   End at page nn");
  fprintf(stderr,"\n-pnn Set page length to nn 1-66 (UK=66=default)");
  fprintf(stderr,"\nPlease note that page numbers refer to 8pdj500 pages");
  fprintf(stderr,"\nSo page 5 of your document is on 8pdj500 page 2");
  exit(1);
}
