/******************************************************************************
* Module    :   Regular Expression Test Driver --- Test the regular expression
*               package.
*
* Author    :   John Stevens
******************************************************************************/

#include    "compiler.h"

#include    "sets.h"
#include    "regexp.h"
#include    "utils.h"

FILE    *ErrFile;

int     main(int    argc,
             char   **argv)
{
    register    int             i;
    auto        REG_EXP_NODE    *ReExpr;
    auto        FILE            *fp;
    auto        char            **SubStrs;
    auto        char            Bfr[256];

    /*  Check command line parameters.  */
    if (argc != 3)
    {
        fprintf(stderr,
                "%s %d : Error - Syntax is: ",
                __FILE__,
                __LINE__);
        fprintf(stderr,
                "%s <regular expression> <file name>\n",
                argv[0]);
        exit( 1 );
    }
    ErrFile = stderr;

    /*  Compile the regular expression. */
    ReExpr = ReCompile( argv[1] );

    /*  Match against a line from a test file.  */
    if ((fp = fopen(argv[2], TXT_READ)) == NULL)
    {
        fprintf(stderr,
                "Error, could not open file '%s' for reading.\n",
                argv[2]);
        exit( 1 );
    }

    /*  Search file for matching regular expressions, and print all
    *   matched sub-strings.
    */
    while (fgets(Bfr, 256, fp) != NULL)
    {
        /*  Attempt match.  */
        SubStrs = NULL;
        if (ReMatch(Bfr, CASE_SENSITIVE, ReExpr, &SubStrs) != 0)
        {
            /*  Print matching line and matching sub-strings.   */
            printf("Line: '%s'\n", Bfr);
            for (i = 0; i < MAX_SUB_EXPRS; i++)
                if ( SubStrs[i] )
                    printf("    #%2d: '%s'\n", i, SubStrs[i]);
        }
    }
    return( 0 );
}
