;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;TITLE:	Z8 EQUATES-Z8EQU.INC
;AUTHOR:JOHN OLSON
;DATE:	12-10-92
;
;  11-Jan-94 JLH add equates for hl, de
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;MODIFICATION HISTORY
;
;
;
;
;
;REGISTER ALLOCATIONS


;EQUIVILENT WORKING REGISTERS FOR SERIAL REGISTERS
;REGISTER FILE %80-%8F

rP3M_save	:=	R0
rSER_char	:=	R1
rSER_tmp1	:=	R2
rSER_tmp2	:=	R3
rSER_put 	:=	R4
rSER_len 	:=	R5
rSER_buf 	:=	R6
rSER_imr 	:=	R7
rSER_cfg	:=	R8
rSER_get 	:=	R9
rSER_flg 	:=	R10
rSERltime	:=	R11
rSERhtime	:=	R12

;SIO		:=	%F0
	;SERIAL TX/RX REGISTER

;TMR		:=	%F1
	;TIMER MODE REGISTER
	;BIT 0   0=NO FUNCTION, 1=LOAD T0
	;BIT 1   0=DISABLE T0, 1=ENABLE T0
	;BIT 2   0=NO FUNCTION, 1=LOAD T1
	;BIT 3   0=DISABLE T1, 1=ENABLE T1
	;BIT 4,5 TIMER INPUT MODE
	;BIT 6,7 TIMER OUTPUT MODE

T0LO		:=	%F4	;TIMER 0 LOW BYTE
	;RD:CURRENT TIMER 0 VALUE
	;WR:TIMER 0 RELOAD VALUE
;PRE0		:=	%F5
	;TIMER 0 PRESCALER
	;BIT 0   0=SINGLE PASS, 1=MODULO N
	;BIT 1   0=EXTERNAL INPUT, 1=INTERNAL
	;BIT 2-7 DIVISOR(1-64)

T1LO		:=	%F2	;TIMER 1 LOW BYTE
	;RD:CURRENT TIMER 1 VALUE
	;WR:TIMER 1 RELOAD VALUE

;PRE1		:=	%F3
	;TIMER 1 PRESCALER
	;BIT 0   0=SINGLE PASS, 1=MODULO N
	;BIT 1   0=EXTERNAL INPUT, 1=INTERNAL
	;BIT 2-7 DIVISOR(1-64)

;P2M		:=	%F6
	;PORT 2 MODE 0=OUTPUT, 1=INPUT

;P2		:=	%02	;PORT 2 REGISTER
rP2		:=	R2

;P3		:=	%03	;PORT 3 REGISTER
rP3		:=	R3

;P3M		:=	%F7	;PORT 3 MODE
	;BIT 0   0=PORT 2 OPEN DRAIN, 1=ACTIVE PULL UPS
	;BIT 1   ALWAYS 0
	;BIT 2   PORTS P32, P35 DEFINITION
	;BIT 3   PORTS P33, P34 DEFINITION
	;BIT 4   ALWAYS 0
	;BIT 5   PORTS P31, P36 DEFINITION
	;BIT 6   PORTS P30, P37 DEFINITION
	;BIT 7   0=PRITY OFF, 1=PARITY ON

;P01M		:=	%F8
	;PORT 0 AND 1 MODE
	;BIT 1,0 1X FOR A8-A11 LINES
	;BIT 2   STACK SELECT 0=EXTERNAL, 1=INTERNAL
	;BIT 4,3 10 FOR AD0-AD7 LINES
	;BIT 5   EXTERNAL MEMORY TIMING 1=EXTENDED, 0=NORMAL
	;BIT 7,6 1X FOR A12-A15 LINES

;IPR		:=	%F9
	;INTERRUPT PRIORITY REGISTER
	;

;IRQ		:=	%FA
	;INTERRUPT REQUEST REGISTER
	;BIT 0	 P3-2 INPUT
	;BIT 1	 P3-3 INPUT
	;BIT 2	 P3-1 INPUT
	;BIT 3	 P3-0 INPUT, SERIAL INPUT
	;BIT 4	 T0 INPUT,SERIAL OUTPUT
	;BIT 5	 T1

;IMR		:=	%FB
	;BIT 0-5 MASK FOR INTERRUPTS IN IRQ REGISTER
	;BIT 7   1=ENABLE INTERRUPTS

;FLAGS		:=	%FC
	;BIT 0   USER FLAG F1
	;BIT 1   USER FLAG F2
	;BIT 2   HALF CARRY
	;BIT 3   DECIMAL ADJUST
	;BIT 4   OVERFLOW
	;BIT 5   SIGN FLAG
	;BIT 6   ZERO FLAG
	;BIT 7   CARRY FLAG

;RP		:=	%FD
	;DEFINES WORKING REGISTERS FOR BOTH REGISTER AND EXPANDED REGS
	;BIT 0-3 DEFINES EXPANDED REG WORKING FILE (0> NO EXP REG)
	;BIT 4-7 DEFINES WORKING REGISTER FILE

;SPH		:=	%FE
;SPL		:=	%FF
	;IF B2 OF P01M IS SET, ONLY SPL IS USED

;
;THE FOLLOWING REGISTERS LIVE IN ERF(A) BANK E
MD0		:=	R0	;MULTIPLY/DIVIDE REGISTERS
MD1		:=	R1
MD2		:=	R2
MD3		:=	R3
MD4		:=	R4
MD5		:=	R5
MDCTL		:=	R6	;MULTIPLY/DIVIDE CONTROL REGISTER

COMP1HI		:=	R12	;COMPARE 1 REGISTERS
COMP1LO		:=	R13

;THE FOLLOWING REGISTERS LIVE IN ERF(A) BANK D

T2M		:=	R1	;TIMER 2 MODE REGISTER
	;BIT 0   0=NO FUNCTION, 1=LOAD T2
	;BIT 1   0=DISABLE T2, 1=ENABLE T2
	;BIT 2   0=SINGLE COUNT, 1=MODULO N
	;BIT 3   1= INTERRUPT ENABLED
	;BIT 4	 1=ENABLE T2 OUT (P35)
	;BIT 6   0=XTAL/8, 1=XTAL/2
	;BIT 7   1=END OF COUNT

T1HI		:=	R2	;TIMER 1 HIGH BYTE
T2PRE		:=	R3	;TIMER 2 PRESCALER
T0HI		:=	R4	;TIMER 0 HIGH BYTE
COMCON		:=	R5	;COMPARE CONTROL REGISTER(SEE MANUAL)
T2HI		:=	R6	;TIMER 2 HIGH BYTE
T2LO		:=	R7	;TIMER 2 LOW BYTE
	;CAPTURE REGISTERS CAPTURE THE  CURRENT VALUE OF TIMER2
	;ON THE FALLING EDGE OF THE LISTED PIN
CAP1HI		:=	R8	;CAPTURE 1 REGISTERS (P33)
CAP1LO		:=	R9
CAP2HI		:=	R10	;CAPTURE 2 REGISTERS (P32)
CAP2LO		:=	R11
CAP3HI		:=	R12	;CAPTURE 3 REGISTERS (P30)
CAP3LO		:=	R13
	;
COMP2HI		:=	R14	;COMPARE 2 REGISTERS
COMP2LO		:=	R15

;THE FOLLOWING REGISTERS LIVE IN ERF(A) BANK C

SPICR		:=	R2	;SPI CONTROL REGISTER
	;BIT 0 1=SPI ENABLE
	;BIT 2,1 00 /2 CLOCK FREQUENCY
	;	 01 /4
	;	 10 /8
	;	 11 /16
	;BIT 3 1=ENABLE INTERRUPT
	;BIT 4 1= RECEIVE CHARACTER AVAILABLE
	;BIT 5 0=XMIT ON FALL RECV ON RISE, 1=XMIT ON RISE RECV FALL
	;BIT 6 0=INTERNAL CLOCK, 1=TIMER 0 =0
	;BIT 7 1=MASTER
SPIDATA		:=	R1
SPICOMP		:=	R0	;SPI COMPARE REGISTER (SLAVE MODE ONLY)
DACCR		:=	R6	;D/A CONVERTER CONTROL REGISTER
	;BIT 1,0 00  1X GAIN
	;	 01  1/2X GAIN
	;	 11  1/4X GAIN
	;BIT 2 1= D/A ENABLE
	;BIT 4 SET TO 1
	;BIT 6,5 SET TO 00
	;BIT 7 PWM CLOCK SELECT 0=XTAL/2, 1=XTAL

DACDATA		:=	R7	;D/A CONVERTER DATA REGISTER
ADCCR0		:=	R8	;A/D CONVERTER CONTROL REG 0
	;BIT 0-2 CHANNEL SELECT
	;BIT 4,3 00  CONVERT SELECTED CHAN 4 TIMES
	;	 01  CONVERT SELECTED CHANNEL ONCE
	;	 10  CONVERT 4 CHANNELS AND STOP
	;	 11  CONVERT 4 CHANNELS CONTINUOUSLY
	;BIT 5-7 A/D PRESCALER (XTAL / 8,16,24,32,40,48,56)

ADCCR1		:=	R9	;A/D CONVERTER CONTROL REG 1
	;BIT 1,0 00  START CONVERSION
	;	 01  START CONVERSION ON RISING EDGE OF P32
	;	 10  START CONVERSION ON FALLING EDGE OF P32
	;	 11  START CONVERSION WHEN TIMER 0 TIMES OUT
	;BIT 2	 1=ENABLE INTERRUPT
	;BIT 3   0=INTERRUPT AFTER 1ST, 1=INTERRUPT AFTER 4TH CONV
	;BIT 4   READ ONLY INTERRUPT PENDING (CLEARED BY ANY WRITE)
	;        READABLE ONLY BY Z8
	;BIT 7   0 DISABLES ALL A/D REGISTERS, 1 ENABLES

ADC_A		:=	R10	;A/D CONVERTER RESULT REGISTERS
ADC_B		:=	R11
ADC_C		:=	R12
ADC_D		:=	R13
PWM		:=	R14	;PULSE WIDTH MODULATOR

;
;THE FOLLOWING REGISTERS LIVE IN ERF(A) AND ERF(B) BANK F
;
DSPSTAT1	:=	R4	;DSP STATUS REGISTER 1
	;BIT 0   OVERFLOW PROTECTION
	;BIT 1   MULTIPLY OUTPUT SHIFTED BY 3
	;BIT 2,3 NOT USED
	;BIT 4   LINK BIT
	;BIT 5   ZERO BIT
	;BIT 6   OVERFLOW BIT
	;BIT 7   NEGATIVE BIT

DSPSTAT0	:=	R5	;DSP STATUS REGISTER 0
	;BIT 0-2 LOOP SIZE
	;BIT 3-7 NOT USED

DSPCR		:=	R8	;DSP CONTROL REGISTER
	;BIT 0   1=PAUSE MODE
	;BIT 1   0=DSP IDLE, 1=DSP BUSY
	;BIT 2   RESET DSP
	;BIT 3   1=DSP EXECUTION ON A/D COMPLETION
	;BIT 4   1=Z8 EXECUTION FROM INTERNAL MEMORY
	;BIT 6,5 ACCESS TO ERF(A-D)00=A,01=B,10=C,11=D
	;BIT 7   NOT USED

RP0		:=	R9	;DSP REGISTER POINTER R0
RP1		:=	R1	;DSP REGISTER POINTER R1
RP2		:=	R2	;DSP REGISTER POINTER R2
RP3		:=	R3	;DSP REGISTER POINTER R3
PC_LO		:=	R6	;DSP PSUEDO PROGRAM COUNTER (LOW)
PC_HI		:=	R10	;DSP PSUEDO PROGRAM COUNTER (HIGH)
INST_REG	:=	R7	;DSP PSEUDO INSTRUCTION REGISTER
SHAD_LO		:=	R12	;DSP SHADOW LATCH (LOW)
SHAD_HI		:=	R13	;DSP SHADOW LATCH (HIGH)
;
;THE FOLLOWING ARE REGISTER ASSIGNMENTS TO AID IN THE CONVERSION OF
;Z80 CODE TO Z8.
a		:=	MONRP + %8
b		:=	MONRP + %A
c		:=	MONRP + %B
d		:=	MONRP + %C
de		:=	MONRP + %C
e		:=	MONRP + %D
h		:=	MONRP + %E
hl		:=	MONRP + %E
l		:=	MONRP + %F
A		:=	R8
B		:=	R10
C		:=	R11
D		:=	R12
E		:=	R13
H		:=	R14
L		:=	R15
HL		:=	RR14
DE		:=	RR12
BC		:=	RR10

