*  MON6805.ASM - 6805 Debug monitor for use with NOICE05
*
*  Copyright (c) 1993-1994 by John Hartman
*
*  Modification History:
*       28-Sep-93 JLH created from HC11 and '740
*       29-Sep-93 JLH continued
*       10-Oct-94 JLH Change STACK_TOP from 1f to 7f for debug under SIM05
*       20-Oct-94 JLH Document family variants prior to release
*       22-Oct-96 JLH Correct mismatch in register reply buffer to NoICE05
*
*============================================================================
*
*  To customize for a given target, you must change code in the
*  hardware equates, the string TSTG, and the routines RESET and REWDT.
*  You may or may not need to change GETCHAR, PUTCHAR, depending on
*  how peculiar your UART is.
*
*  This file has been assembled with the Motorola Freeware assembler
*  available from the Motorola Freeware BBS and elsewhere.
*
*  To add mapped memory support:
*       1) Define map port MAPREG here
*       2) Define or import map port RAM image MAPIMG here if MAPREG is
*          write only.  (The application code must update MAPIMG before
*          outputing to MAPREG)
*       3) Search for and modify MAPREG, MAPIMG, and REG_PAGE usage below
*       4) In TSTG below edit "LOW AND HIGH LIMIT OF MAPPED MEM"
*          to appropriate range (typically 4000H to 07FFFH for two-bit MMU)
*
*============================================================================
*
*  Hardware definitions
*
*  The values of these equates will vay depending on which 6805/68HC05
*  processor you are using, and on where your hardware has off-chip RAM
*
*  For Motorola or Harris 6805E2, ROM_START is 1C00, HARD_VECT is 1FF0,
*  STACK_TOP is 7F.  External addresses in the range 0100 to 1BFF are
*  available for download RAM, NoICE monitor RAM, and UART.
*
*  For Harris CDP6805E3, ROM_START is FC00, HARD_VECT is FFF0,
*  STACK_TOP is 7F.  External addresses in the range 0100 to FBFF are
*  available for download RAM, NoICE monitor RAM, and UART.
*
*  For Harris CDP68HC05C0, ROM_START is FC00, HARD_VECT is FFF0,
*  STACK_TOP is FF.  External addresses in the range 0100 to FBFF are
*  available for download RAM, NoICE monitor RAM, and UART.

CHIP_RAM        EQU     $0000           START OF 6805 ON-CHIP RAM
RAM_START       EQU     $1000           START OF MONITOR RAM (NOT PAGE 0)
RAM_VECT        EQU     $1BF0           START OF USER VECTORS (IN RAM)
*
*  Does your PC have enough bits to get here?  Does it have more?
ROM_START       EQU     $1C00           START OF MONITOR CODE
HARD_VECT       EQU     $1FF0           START OF HARDWARE VECTORS
*
*  Does your SP have enough bits to get here?  May be $FF for some processors
STACK_TOP       EQU     $7F             TOP OF STACK AFTER RSP
*
*  I/O definitions
COPRST          EQU     $1D             COP TIMER (WATCHDOG)
*
*
*  Op-code definitions
JMP_OP          EQU     $CC             JMP EXTENDED
LDAX_OP         EQU     $D6             LDA AAAA,X
STAX_OP         EQU     $D7             STA AAAA,X
RTS_OP          EQU     $81             RTS
        PAGE
*============================================================================
*
*
*============================================================================
*  HARDWARE PLATFORM CUSTOMIZATIONS
*============================================================================
*
*  Put you UART equates here
*  (These are for the DUART on the MC146805E2 Evaluation Board)
DUART           EQU     $17f0
SER_STATUS      EQU     $17f1
SER_RXDATA      EQU     $17f3
SER_TXDATA      EQU     $17f3
RXRDY           EQU     $01
TXRDY           EQU     $04
*
*============================================================================
*  User vector definitions
        ORG     RAM_VECT
COP_VEC         RMB     2       RE-VECTORED FROM XFF0
RES_VEC         RMB     2       RE-VECTORED FROM XFF2
SPI_VEC         RMB     2       RE-VECTORED FROM XFF4
SCI_VEC         RMB     2       RE-VECTORED FROM XFF6
TIMER_VEC       RMB     2       RE-VECTORED FROM XFF8
IRQ_VEC         RMB     2       RE-VECTORED FROM XFFA
*
*  RAM definitions
        ORG     RAM_START
*
*  Save vale of SP, as discovered at entry
SAVESP          RMB     1
REG_STATE       RMB     1
REG_PAGE        RMB     1
*
*  In contrast with other targets, we operate with registers on the stack.
*  Thus, we declare offsets to each register from SP after an interrupt
REG_CC          EQU     1
REG_A           EQU     2
REG_X           EQU     3
REG_PC          EQU     4
*
*  Declare size of register block
TASK_REG_SZ     EQU     8               STATE, PAGE, CC, A, X, PCL, PCH, SP
*
*  Loop counter, and temps
LOOPCT          RMB     1
TEMP1           RMB     1
LS_TEMP         RMB     1       used only by STORE and SET_BYTE
*
*  Since we have no 16 bit registers, do memory access via an
*  instruction built into RAM.  Build instruction and RTS here
CODEBUF         RMB     4       ROOM FOR "LDA AAAA,X, RTS"
*
*  Communications buffer
*  (Must be at least as long as the longer of TASK_REG_SZ or TSTG_SIZE.
*  At least 19 bytes recommended.  Larger values may improve speed of NoICE
*  download and memory move commands.)
COMBUF_SIZE     EQU     128             DATA SIZE FOR COMM BUFFER
COMBUF          RMB     2+COMBUF_SIZE+1 BUFFER ALSO HAS FN, LEN, AND CHECK
*
RAM_END         EQU     *               ADDRESS OF TOP+1 OF RAM
*
*===========================================================================
        ORG     ROM_START
*
*  Power on reset
RESET
*
*  Set CPU mode to safe state
        SEI                             INTERRUPTS OFF (WE MAY JUMP HERE)
*
*  Initialize 6805 hardware
*
        RSP                             CLEAN STACK IS HAPPY STACK
*
*  Initialize your UART here
*  (This is for the 2681 DUART on the MC146805E2 Evaluation Board.  This
*  is copied from ASSIST05.ASM)
        LDA     #$13            MODE1: NO PARITY, 8 DATA
        STA     DUART

        LDA     #$CC            CLOCK SELECT: 19200 BAUD RX AND TX
        STA     DUART+1

        LDA     #$07            MODE2: ONE STOP BIT
        STA     DUART

        LDA     #$80            ACR: COUNTER MODE (ALLOWS 19200 BAUD)
        STA     DUART+4

        LDA     #$00            INT MASK: NONE
        STA     DUART+5

        LDA     #$08            OUTPUT CONFIG: TxCB
        STA     DUART+$D

        LDA     #$15            CMD REGISTER:  ENABLE TX, RX
        STA     DUART+2
*
*----------------------------------------------------------------------------
*
*  Initialize RAM "interrupt vectors"
        LDA     #INT_ENTRY/256          MSB OF DEFAULT HANDLER
        STA     COP_VEC
        STA     RES_VEC
        STA     SPI_VEC
        STA     SCI_VEC
        STA     TIMER_VEC
        STA     IRQ_VEC

        LDA     #INT_ENTRY&255          LSB OF DEFAULT HANDLER
        STA     COP_VEC+1
        STA     RES_VEC+1
        STA     SPI_VEC+1
        STA     SCI_VEC+1
        STA     TIMER_VEC+1
        STA     IRQ_VEC+1
*
*  Initialize memory paging variables and hardware (if any)
	LDA	#0
        STA     REG_PAGE                NO PAGE YET
*;*     STA     MAPIMG
*;*     STA     MAPREG                  set hardware map
*
*  Initialize user registers
        LDA     #0
        STA     REG_STATE               initial state if "RESET"
*
*  Set function code for "GO".  Then if we are here because of a reset
*  (such as a COP timeout) after being told to GO, we will come
*  back with registers so user can see the reset
        LDA     #FN_RUN_TARG
        STA     COMBUF
*
*  Since there is no way to push initial register on the stack,
*  we do an SWI to simulate a breakpoint!  Our registers will be saved,
*  and PC will point here
BOMB    LDA     #$12
        LDX     #$34
        SWI                             PUSH PC, X, A, CC
        JMP     BOMB                    CAN'T "GO" FROM HERE...
*
*===========================================================================
*  Get a character to A
*
*  Return A=char, CY=0 if data received
*         CY=1 if timeout (0.5 seconds)
*
*  Uses 2 bytes of stack including return address
*
GETCHAR LDA     #$55            RESET WATCHDOG TIMER
        STA     COPRST
        LDA     #$AA
        STA     COPRST
*
        LDA     SER_STATUS      READ DEVICE STATUS
        AND     #RXRDY
        BEQ     GETCHAR         NOT READY YET.
*
*  Data received:  return CY=0. data in A
        CLC                     CY=0
        LDA     SER_RXDATA      READ DATA
        RTS
*
*  Timeout:  return CY=1
GC90    SEC                     CY=1
        RTS
*
*===========================================================================
*  Output character in A
*
*  Uses 2 bytes of stack including return address
*
PUTCHAR STA     TEMP1
PC10    LDA     #$55            RESET WATCHDOG TIMER
        STA     COPRST
        LDA     #$AA
        STA     COPRST
*
        LDA     SER_STATUS      CHECK TX STATUS
        AND     #TXRDY          TX READY ?
        BEQ     PC10
        LDA     TEMP1
        STA     SER_TXDATA      TRANSMIT CHAR.
        RTS
*
*======================================================================
*  Response string for GET TARGET STATUS request
*  Reply describes target:
TSTG    FCB     6                       2: PROCESSOR TYPE = 6805
        FCB     COMBUF_SIZE             3: SIZE OF COMMUNICATIONS BUFFER
        FCB     0                       4: NO TASKING SUPPORT
        FCB     0,0                     5,6: BOTTOM OF MAPPED MEM (LSB FIRST)
        FCB     0,0                     7,8: TOP OF MAPPED MEM (LSB FIRST)
        FCB     B1-B0                   9 BREAKPOINT INSTR LENGTH
B0      SWI                             10+ BREKAPOINT INSTRUCTION
B1      FCC     '6805 monitor V1.0'     DESCRIPTION, ZERO
        FCB     0
TSTG_SIZE       EQU     *-TSTG          SIZE OF STRING
*
*======================================================================
*  HARDWARE PLATFORM INDEPENDENT EQUATES AND CODE
*
*  Communications function codes.
FN_GET_STAT     EQU     $FF    reply with device info
FN_READ_MEM     EQU     $FE    reply with data
FN_WRITE_M      EQU     $FD    reply with status (+/-)
FN_READ_RG      EQU     $FC    reply with registers
FN_WRITE_RG     EQU     $FB    reply with status
FN_RUN_TARG     EQU     $FA    reply (delayed) with registers
FN_SET_BYTE     EQU     $F9    reply with data (truncate if error)
FN_IN           EQU     $F8    input from port
FN_OUT          EQU     $F7    output to port
*
FN_MIN          EQU     $F7    MINIMUM RECOGNIZED FUNCTION CODE
FN_ERROR        EQU     $F0    error reply to unknown op-code
*
*===========================================================================
*  Common handler for default interrupt handlers
*  Enter with A=interrupt code = processor state
*  All registers stacked, PC=next instruction
*
*  Uses 7 bytes of stack: 5 for stacked registers, two for return address
*
INT_ENTRY
        STA     REG_STATE       SAVE STATE
*
*  Pitiful little machine can't pop regs, can't look at stack pointer.
*  To find SP, and hence registers, use a trick from Motorola's ASSIST05
*  monitor:  call a subroutine and have it hunt for a known return
*  address!
        JSR     FINDSP          RETURN X = SP, 1 STACKED REGS
I_AM    STX     SAVESP          SAVE IT
*
*  If this is a breakpoint (state = 1), then back up PC to point at SWI
        LDA     REG_STATE
        CMP     #1
        BNE     NOTBP           BR IF NOT A BREAKPOINT
        LDA     REG_PC+1,X      GET LSB OF PC
        SUB     #B1-B0          MINUS SIZE OF BREAKPOINT
        STA     REG_PC+1,X
        LDA     REG_PC,X        GET MSB OF PC
        SBC     #0
        STA     REG_PC,X
NOTBP
*
*  Save memory page
*;*     LDA     MAPIMG          GET CURRENT USER MAP
        LDA     #0              ... OR ZERO IF UNMAPPED TARGET
        STA     REG_PAGE        SAVE USER'S PAGE
*
*  Return registers to master
        JMP     RETURN_REGS
*
*  Subroutine to "find" the stack pointer.  Can only be called from
*  immediately before the label "I_AM" above.  This minimizes stack usage
FINDSP  LDX     #STACK_TOP      TOP+1 OF STACK RAM (SP DECS BEFORE PUSH)
F10     DECX
        LDA     0,X             GET A BYTE OF STACK
        CMP     #I_AM/256       IS IT MSB OF OUR RETURN ADDRESS?
        BNE     F10             LOOP IF NOT
        LDA     1,X             GET A BYTE OF STACK
        CMP     #I_AM&255       IS IT LSB OF OUR RETURN ADDRESS?
        BNE     F10             LOOP IF NOT
*
*  X points at MSB of return address.  Regs are just above.
*  Adjust X to look like SP:  one below lowest reg
        INCX
        RTS
*
*===========================================================================
*  Main loop:  wait for command frame from master
*
*  Uses 2 bytes of stack before jump to handlers
*
MAIN    LDX     #0                              INIT INPUT BYTE COUNT
*
*  First byte is a function code
        JSR     GETCHAR                 GET A FUNCTION
        BCS     MAIN                    JIF TIMEOUT: RESYNC
        CMP     #FN_MIN
        BLO     MAIN                    JIF BELOW MIN: ILLEGAL FUNCTION
        STA     COMBUF,X                SAVE FUNCTION CODE
        INCX
*
*  Second byte is data byte count (may be zero)
        JSR     GETCHAR                 GET A LENGTH BYTE
        BCS     MAIN                    JIF TIMEOUT: RESYNC
        CMP     #COMBUF_SIZE
        BHI     MAIN                    JIF TOO LONG: ILLEGAL LENGTH
        STA     COMBUF,X                SAVE DATA LENGTH
        CMP     #0
        BEQ     MA80                    SKIP DATA LOOP IF LENGTH = 0
*
*  Loop for data
        LDX     #0
MA10    JSR     GETCHAR                 GET A DATA BYTE
        BCS     MAIN                    JIF TIMEOUT: RESYNC
        STA     COMBUF+2,X              SAVE DATA BYTE
        INCX
        CPX     COMBUF+1
        BNE     MA10
*
*  Get the checksum
MA80    JSR     GETCHAR                 GET THE CHECKSUM
        BCS     MAIN                    JIF TIMEOUT: RESYNC
        STA     TEMP1                   SAVE CHECKSUM
*
*  Compare received checksum to that calculated on received buffer
*  (Sum should be 0)
        JSR     CHECKSUM
        ADD     TEMP1
        BNE     MAIN                    JIF BAD CHECKSUM
*
*  Process the message.
        LDA     COMBUF+0                GET THE FUNCTION CODE
        CMP     #FN_GET_STAT
        BEQ     TARGET_STAT
        CMP     #FN_READ_MEM
        BEQ     JREAD_MEM
        CMP     #FN_WRITE_M
        BEQ     JWRITE_MEM
        CMP     #FN_READ_RG
        BEQ     JREAD_REGS
        CMP     #FN_WRITE_RG
        BEQ     JWRITE_REGS
        CMP     #FN_RUN_TARG
        BEQ     JRUN_TARGET
        CMP     #FN_SET_BYTE
        BEQ     JSET_BYTES
        CMP     #FN_IN
        BEQ     JIN_PORT
        CMP     #FN_OUT
        BEQ     JOUT_PORT
*
*  Error: unknown function.  Complain
        LDA     #FN_ERROR
        STA     COMBUF          SET FUNCTION AS "ERROR"
        LDA     #1
        JMP     SEND_STATUS     VALUE IS "ERROR"
*
*  long jumps to handlers
JREAD_MEM       JMP     READ_MEM
JWRITE_MEM      JMP     WRITE_MEM
JREAD_REGS      JMP     READ_REGS
JWRITE_REGS     JMP     WRITE_REGS
JRUN_TARGET     JMP     RUN_TARGET
JSET_BYTES      JMP     SET_BYTES
JIN_PORT        JMP     IN_PORT
JOUT_PORT       JMP     OUT_PORT

*===========================================================================
*
*  Target Status:  FN, len
*
TARGET_STAT
        LDA     #TSTG_SIZE              LENGTH OF REPLY
        STA     COMBUF+1                SET SIZE IN REPLY BUFFER
        LDX     #0                      INDEX IN STRING AND COMBUF
TS10    LDA     TSTG,X                  MOVE REPLY DATA TO BUFFER
        STA     COMBUF+2,X
        INCX
        CPX     #TSTG_SIZE
        BNE     TS10
*
*  Compute checksum on buffer, and send to master, then return
        JMP     SEND

*===========================================================================
*
*  Read Memory:  FN, len, page, Alo, Ahi, Nbytes
*
*  Uses 2 bytes of stack
*
READ_MEM
*
*  Set map
*;      LDA     COMBUF+2
*;      STA     MAPIMG
*;      STA     MAPREG
*
*  Set address of instruction in RAM
        LDA     COMBUF+4                MSB OF ADDRESS
        STA     CODEBUF+1
        LDA     COMBUF+3                LSB
        STA     CODEBUF+2
*
*  Prepare return buffer: FN (unchanged), LEN, DATA
        LDA     COMBUF+5                NUMBER OF BYTES TO RETURN
        STA     COMBUF+1                RETURN LENGTH = REQUESTED DATA
        BEQ     GLP90                   JIF NO BYTES TO GET
*
*  Read the requested bytes from local memory
        LDX     #0                      INDEX INTO COMBUF
GLP     JSR     LOAD                    GET BYTE FROM AAAA,X
        STA     COMBUF+2,X              STORE TO RETURN BUFFER
        INCX
        CPX     COMBUF+1
        BNE     GLP
*
*  Compute checksum on buffer, and send to master, then return
GLP90   JMP     SEND

*===========================================================================
*
*  Write Memory:  FN, len, page, Alo, Ahi, (len-3 bytes of Data)
*
*  Uses 2 bytes of stack
*
WRITE_MEM
*
*  Set map
*;      LDA     COMBUF+2
*;      STA     MAPIMG
*;      STA     MAPREG
*
*  Get address
        LDA     COMBUF+4                MSB OF ADDRESS
        STA     CODEBUF+1
        LDA     COMBUF+3                LSB
        STA     CODEBUF+2
*
*  Prepare return buffer: FN (unchanged), LEN, DATA
        LDA     COMBUF+1                NUMBER OF BYTES TO WRITE
        SUB     #3                      MINUS PAGE AND ADDRESS
        BEQ     WLP50                   JIF NO BYTES TO PUT
        STA     LOOPCT                  SAVE BYTE COUNTER
*
*  Write the specified bytes to local memory
        LDX     #0                      INDEX INTO MEMORY AND COMBUF
WLP     LDA     COMBUF+5,X              GET BYTE TO WRITE
        JSR     STORE                   STORE THE BYTE AT AAAA,X
        INCX
        CPX     LOOPCT
        BNE     WLP
*
*  Compare to see if the write worked
        LDX     #0
WLP20   JSR     LOAD                    GET BYTE JUST WRITTEN
        CMP     COMBUF+5,X
        BNE     WLP80                   BR IF WRITE FAILED
        INCX
        CPX     LOOPCT
        BNE     WLP20
*
*  Write succeeded:  return status = 0
WLP50   LDA     #0                      RETURN STATUS = 0
        BRA     WLP90
*
*  Write failed:  return status = 1
WLP80   LDA     #1
*
*  Return OK status
WLP90   JMP     SEND_STATUS

*===========================================================================
*
*  Read registers:  FN, len=0
*
*  Uses 2 bytes of stack
*
READ_REGS
*
*  Enter here from SWI after "RUN" and "STEP" to return task registers
RETURN_REGS
        LDX     #0                      OFFSET IN REGS AND COMBUF
*
*  Gather the registers.  Order must match that in TRG05.C
        LDA     REG_STATE
        STA     COMBUF+2
        LDA     REG_PAGE
        STA     COMBUF+3
        LDA     SAVESP                  SP BELOW REGISTERS
        ADD     #5                      BYPASS REGS = SP BEFORE MONITOR ENTRY
        STA     COMBUF+4
*
*  Other registers are on the stack
        LDX     SAVESP                  STACK POINTER AT TIME OF ENTRY
        LDA     REG_X,X
        STA     COMBUF+5
        LDA     REG_A,X
        STA     COMBUF+6
        LDA     REG_CC,X
        STA     COMBUF+7
        LDA     REG_PC+1,X              LSB OF PC
        STA     COMBUF+8
        LDA     REG_PC,X                MSB OF PC
        STA     COMBUF+9
*
        LDA     #TASK_REG_SZ            NUMBER OF BYTES OF REGISTERS
        STA     COMBUF+1                SAVE RETURN DATA LENGTH
*
*  Compute checksum on buffer, and send to master, then return
        JMP     SEND

*===========================================================================
*
*  Write registers:  FN, len, (register image)
*
*  Uses 2 bytes of stack
*
WRITE_REGS
*
*  Must write all registers at once
        LDA     COMBUF+1                NUMBER OF BYTES
        CMP     #TASK_REG_SZ            NUMBER OF REGISTERS
        BNE     WRR80                   JIF WRONG NUMBER
*
*  Distribute the registers
        LDA     COMBUF+2
        STA     REG_STATE
        LDA     COMBUF+3
        STA     REG_PAGE
*
*  Other registers are on the stack
        LDX     SAVESP                  STACK POINTER AT TIME OF ENTRY
        LDA     COMBUF+5
        STA     REG_X,X
        LDA     COMBUF+6
        STA     REG_A,X
        LDA     COMBUF+7
        STA     REG_CC,X
        LDA     COMBUF+8
        STA     REG_PC+1,X              LSB OF PC
        LDA     COMBUF+9
        STA     REG_PC,X                MSB OF PC
*
*  Since we have no way of resetting the SP with registers intact,
*  ignore any attempt to set SP.  Since the user may have tried, return
*  our current registers
WRR80   JMP     RETURN_REGS

*===========================================================================
*
*  Run Target:  FN, len
*
RUN_TARGET
*
*  Restore user's map
*;      LDA     REG_PAGE                USER'S PAGE
*;      STA     MAPIMG                  SET IMAGE
*;      STA     MAPREG                  SET MAPPING REGISTER
*
*  Return to user
        RTI
*
*===========================================================================
*
*  Set target byte(s):  FN, len { (page, alow, ahigh, data), (...)... }
*
*  Return has FN, len, (data from memory locations)
*
*  If error in insert (memory not writable), abort to return short data
*
*  This function is used primarily to set and clear breakpoints
*
*  Uses 2 bytes of stack
*
SET_BYTES
        LDA     COMBUF+1                LENGTH = 4*NBYTES
        BEQ     SB90                    JIF NO BYTES
        STA     LOOPCT                  SAVE AS LOOP COUNTER
*
*  Loop on inserting bytes
        LDX     #0                      INDEX INTO INPUT BUFFER
        STX     COMBUF+1                SAVE AS RETURN LENGTH/INDEX
SB10:
*
*  Set map
*;      LDA     COMBUF+2,X
*;      STA     MAPIMG
*;      STA     MAPREG
*
*  Set address
        LDA     COMBUF+4,X              MSB OF ADDRESS
        STA     CODEBUF+1
        LDA     COMBUF+3,X              LSB
        STA     CODEBUF+2
*
*  Read current data at byte location
        STX     TEMP1                   SAVE INPUT BUFFER INDEX
        LDX     #0
        JSR     LOAD                    GET BYTE AT AAAA,X
        LDX     COMBUF+1                GET RETURN COUNT/INDEX
        STA     COMBUF+2,X              SAVE BYTE IN RETURN BUFFER
*
*  Insert new data at byte location
        LDX     TEMP1                   INPUT BUFFER INDEX
        LDA     COMBUF+5,X              BYTE TO WRITE
        LDX     #0
        JSR     STORE                   STORE BYTE (AND COPY TO LS_TEMP)
*
*  Verify write
        JSR     LOAD                    READ BACK BYTE JUST WRITTEN
        CMP     LS_TEMP
        BNE     SB90                    BR IF INSERT FAILED: ABORT
*                                       COMBUF+1 HAS RETURN COUNT
*
*  Loop for next byte
        LDA     COMBUF+1                COUNT ONE INSERTED BYTE
        INCA
        STA     COMBUF+1
        LDX     TEMP1                   INPUT BUFFER INDEX
        INCX                            STEP TO NEXT BYTE SPECIFIER
        INCX
        INCX
        INCX
        CPX     LOOPCT
        BNE     SB10                    LOOP FOR ALL BYTES
*
*  Return buffer with data from byte locations.  COMBUF+1 has count
SB90
*
*  Compute checksum on buffer, and send to master, then return
SB99    JMP     SEND

*===========================================================================
*
*  Input from port:  FN, len, PortAddressLo, PAhi (=0)
*
*  While the 6805 has no input or output instructions, we retain these
*  to allow write-without-verify
*
IN_PORT
*
*  Set "port" address
        LDA     COMBUF+3                MSB OF ADDRESS
        STA     CODEBUF+1
        LDA     COMBUF+2                LSB
        STA     CODEBUF+2
*
*  Read the requested byte from local memory
        LDX     #0
        JSR     LOAD                    GET BYTE AT AAAA,X
*
*  Return byte read as "status"
        JMP     SEND_STATUS

*===========================================================================
*
*  Output to port:  FN, len, PortAddressLo, PAhi (=0), data
*
OUT_PORT
*
*  Set "port" address
        LDA     COMBUF+3                MSB OF ADDRESS
        STA     CODEBUF+1
        LDA     COMBUF+2                LSB
        STA     CODEBUF+2
*
*  Get data
        LDA     COMBUF+4
*
*  Write value to port
        LDX     #0
        JSR     STORE                   STORE DATA AT AAAA,X
*
*  Do not read port to verify (some I/O devices don't like it)
*
*  Return status of OK
        LDA     #0
        JMP     SEND_STATUS

*===========================================================================
*  Build status return with value from "A"
*
SEND_STATUS
        STA     COMBUF+2                SET STATUS
        LDA     #1
        STA     COMBUF+1                SET LENGTH
        BRA     SEND

*===========================================================================
*  Append checksum to COMBUF and send to master
*
SEND    JSR     CHECKSUM                GET A=CHECKSUM, X->checksum location
        NEGA
        STA     COMBUF,X                STORE NEGATIVE OF CHECKSUM
*
*  Send buffer to master
        INCX                            PLUS ONE FOR CHECKSUM...
        STX     LOOPCT                  BECOMES LOOP COUNT
        LDX     #0                      DATA INDEX
SND10   LDA     COMBUF,X
        JSR     PUTCHAR                 SEND A BYTE
        INCX
        CPX     LOOPCT
        BNE     SND10
*
        JMP     MAIN                    BACK TO MAIN LOOP

*===========================================================================
*  Compute checksum on COMBUF.  COMBUF+1 has length of data,
*  Also include function byte and length byte
*
*  Returns:
*       A = checksum
*       X = index to next byte in buffer (checksum location)
*
CHECKSUM
        LDA     COMBUF+1                LENGTH OF MESSAGE
        ADD     #2                      PLUS FUNCTION, LENGTH
        STA     LOOPCT                  SAVE AS LOOP COUNT
        LDA     #0                      INIT CHECKSUM TO 0
        LDX     #0                      INDEX INTO TO BUFFER
CHK10   ADD     COMBUF,X
        INCX
        CPX     LOOPCT
        BNE     CHK10                   LOOP FOR ALL
        RTS                             RETURN WITH CHECKSUM IN A

*===========================================================================
*  Fetch byte with address at CODEBUF+1,X
*
*  Build "LDA  AAAA,X" in RAM
LOAD    LDA     #LDAX_OP
        STA     CODEBUF+0
*
*  Set return after LDA
        LDA     #RTS_OP
        STA     CODEBUF+3
*
*  Call load instruction, and return with byte in A
        JMP     CODEBUF

*===========================================================================
*  Store byte from A to address at CODEBUF+1,X
*
*  Build "STA  AAAA,X" in RAM
STORE   STA     LS_TEMP                 SAVE A
        LDA     #STAX_OP
        STA     CODEBUF+0
*
*  Set return after LDA
        LDA     #RTS_OP
        STA     CODEBUF+3
*
*  Call store instruction, and return
        LDA     LS_TEMP                 GET VALUE TO STORE
        JMP     CODEBUF

***********************************************************************
*
*  Interrupt handlers to catch unused interrupts and traps
*  Registers are stacked.  Jump through RAM vector with type in A
*
*  This will affect only interrupt routines looking for register values!
*
*  Our default handler uses the code in "A" as the processor state to be
*  passed back to the host.
*
COP_ENTRY       LDA     #JMP_OP         BUILD A JMP INSTRUCTION
                STA     CODEBUF
                LDA     COP_VEC
                STA     CODEBUF+1
                LDA     COP_VEC+1
                STA     CODEBUF+2
                LDA     #7              COP STATE
                JMP     CODEBUF
*
RES_ENTRY       LDA     #JMP_OP         BUILD A JMP INSTRUCTION
                STA     CODEBUF
                LDA     RES_VEC
                STA     CODEBUF+1
                LDA     RES_VEC+1
                STA     CODEBUF+2
                LDA     #6              RESERVED STATE
                JMP     CODEBUF
*
SPI_ENTRY       LDA     #JMP_OP         BUILD A JMP INSTRUCTION
                STA     CODEBUF
                LDA     SPI_VEC
                STA     CODEBUF+1
                LDA     SPI_VEC+1
                STA     CODEBUF+2
                LDA     #5              SPI STATE
                JMP     CODEBUF
*
SCI_ENTRY       LDA     #JMP_OP         BUILD A JMP INSTRUCTION
                STA     CODEBUF
                LDA     SCI_VEC
                STA     CODEBUF+1
                LDA     SCI_VEC+1
                STA     CODEBUF+2
                LDA     #4              SCI STATE
                JMP     CODEBUF
*
TIMER_ENTRY     LDA     #JMP_OP         BUILD A JMP INSTRUCTION
                STA     CODEBUF
                LDA     TIMER_VEC
                STA     CODEBUF+1
                LDA     TIMER_VEC+1
                STA     CODEBUF+2
                LDA     #3              TIMER STATE
                JMP     CODEBUF
*
IRQ_ENTRY       LDA     #JMP_OP         BUILD A JMP INSTRUCTION
                STA     CODEBUF
                LDA     IRQ_VEC
                STA     CODEBUF+1
                LDA     IRQ_VEC+1
                STA     CODEBUF+2
                LDA     #2              IRQ STATE
                JMP     CODEBUF
*
*  Non-RAM vectored
SWI_ENTRY       LDA     #1              1FFC
                JMP     INT_ENTRY
*
*  INTERRUPT VECTORS
        ORG     HARD_VECT

        FDB     COP_ENTRY               1FF0 COP (Harris)
        FDB     RES_ENTRY               1FF2 reserved (Harris)
        FDB     SPI_ENTRY               1FF4 SPI
        FDB     SCI_ENTRY               1FF6 SCI
        FDB     TIMER_ENTRY             1FF8 timer
        FDB     IRQ_ENTRY               1FFA IRQ
        FDB     SWI_ENTRY               1FFC SWI
        FDB     RESET                   1FFE reset
*
        END     RESET
