(* ----------------------------------------------------------- *(
**  randtest.pas -- Random sequence test program               **
** ------------------------------------------------------------**
**                                                             **
** ------------------------------------------------------------**
**     Copyright (c) 1993 by Tom Swan. All rights reserved.    **
)* ----------------------------------------------------------- *)

{ $DEFINE DEBUG}    { Delete space before $ for debugging }

{$N+,E+}  { Required for 8087 mode }
{$R+}     { Halt on range errors }

program RandTest;

uses Dos;

const
  degree = 100;     { Test range is 0 .. degree - 1 }

var
  Data: array[0 .. degree - 1] of LongInt;

{$IFDEF DEBUG}

const
  a: LongInt = 0;

{ Degenerate generator }
function Rand: Word;
begin
  inc(a);
  Rand := a;
end;

{ Degenerate randomizer }
procedure Scramble;
begin
  a := -1
end;

{$ELSE}

{ Call Borland Pascal's Random function }
function Rand: Word;
begin
  Rand := Random(65535)
end;

{ Call Borland Pascal's Randomize function }
procedure Scramble;
begin
  Randomize
end;

{$ENDIF}

{ Return a word at random in the range 0 to M-1 }
function RandMod(M: Word): Word;
begin
  RandMod := Rand MOD M
end;

{ Perform Chi-Square analysis of counts in Data array }
function ChiSquare(N: LongInt; R: Word): Double;
var
  V, P: Double;
  K: Word;
  I: Integer;
begin
  V := 0;     { Initialize result }
  P := 1 / R; { Probability of RandMod(R) }
  for I := 0 to R - 1 do
    V := V + (Sqr(Data[I]) / P);
  ChiSquare := ((1.0 / N) * V) - N
end;

var 
  N: LongInt;     { Number of tests to perform }
  I: LongInt;     { For-loop control variable }
  E: Integer;     { Error result for val function }

begin
  if ParamCount = 0 then
  begin
    Writeln;
    Writeln('Random Sequence Test');
    Writeln('(C) 1993 by Tom Swan');
    Writeln;
    Writeln('Enter number of tests to perform.');
    Writeln;
    Writeln('ex. randtest 10000')
  end else
  begin
    Scramble;
    val(ParamStr(1), N, E);
    if E <> 0 then
    begin
      Writeln(ParamStr(1));
      Writeln('^':E, '--- Error!')
    end else 
    begin
      if N < 10 * degree then
      begin
        Writeln;
        Writeln('WARNING: For accurate results, run program');
        Writeln(' with at least ', 10 * degree, ' tests.')
      end;
      Writeln;
      Writeln('Test range: 0 to ', degree - 1);
      Write('Performing ', N, ' tests...');
      for I := 0 to degree - 1 do
        Data[I] := 0;
      for I := 1 to N do
        Inc(Data[RandMod(degree)]);
      Writeln;
      Writeln('Chi-Square result = ', 
        ChiSquare(N, degree):0:4)
    end
  end
end.


(*
// ---------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 09/01/1993   Time: 01:29 pm
*)
