(* ----------------------------------------------------------- *(
**  chisquare.pas -- Algorithm #14: Chi-Square Distribution    **
** ------------------------------------------------------------**
**                                                             **
** ------------------------------------------------------------**
**     Copyright (c) 1993 by Tom Swan. All rights reserved.    **
)* ----------------------------------------------------------- *)

const
  degree = 100;  { Test range is 0 .. degree - 1 }

var
  Data: array[0 .. degree - 1] of LongInt;

function ChiSquare(N: LongInt; R: Word): Double;
var
  V, P: Double;
  I: Integer;
begin
  V := 0;     { Initialize result }
  P := 1 / R; { Probability of Random(R) }
  for I := 0 to R - 1 do
    V := V + (Sqr(Data[I]) / P);
  ChiSquare := ((1.0 / N) * V) - N
end;


(*
// ---------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 09/01/1993   Time: 01:29 pm
*)


