/* 
VXDFUNC.H -- list of VxDs, VxD functions
Andrew Schulman, September 1993
CIS 76320,302

Could turn this into VxD equivalent of Interrupt List
*/

char *VMM_Tbl[] = {
	"Get_VMM_Version", 
	"Get_Cur_VM_Handle", 
	"Test_Cur_VM_Handle", 
	"Get_Sys_VM_Handle",
	"Test_Sys_VM_Handle",
	"Validate_VM_Handle",
	"Get_VMM_Reenter_Count",
	"Begin_Reentrant_Execution",
	"End_Reentrant_Execution",
	"Install_V86_Break_Point",
	"Remove_V86_Break_Point",
	"Allocate_V86_Call_Back",
	"Allocate_PM_Call_Back",
	"Call_When_VM_Returns",
	"Schedule_Global_Event",
	"Schedule_VM_Event",
	"Call_Global_Event",
	"Call_VM_Event",
	"Cancel_Global_Event",
	"Cancel_VM_Event",
	"Call_Priority_VM_Event",
	"Cancel_Priority_VM_Event",
	"Get_NMI_Handler_Addr",
	"Set_NMI_Handler_Addr",
	"Hook_NMI_Event",
	"Call_When_VM_Ints_Enabled",
	"Enable_VM_Ints",
	"Disable_VM_Ints",
	"Map_Flat",
	"Map_Lin_To_VM_Addr",
	"Adjust_Exec_Priority",
	"Begin_Critical_Section",
	"End_Critical_Section",
	"End_Crit_And_Suspend",
	"Claim_Critical_Section",
	"Release_Critical_Section",
	"Call_When_Not_Critical",
	"Create_Semaphore",
	"Destroy_Semaphore",
	"Wait_Semaphore",
	"Signal_Semaphore",
	"Get_Crit_Section_Status",
	"Call_When_Task_Switched",
	"Suspend_VM",
	"Resume_VM",
	"No_Fail_Resume_VM",
	"Nuke_VM",
	"Crash_Cur_VM",
	"Get_Execution_Focus",
	"Set_Execution_Focus",
	"Get_Time_Slice_Priority",
	"Set_Time_Slice_Priority",
	"Get_Time_Slice_Granularity",
	"Set_Time_Slice_Granularity",
	"Get_Time_Slice_Info",
	"Adjust_Execution_Time",
	"Release_Time_Slice",
	"Wake_Up_VM",
	"Call_When_Idle",
	"Get_Next_VM_Handle",
	"Set_Global_Time_Out",
	"Set_VM_Time_Out",
	"Cancel_Time_Out",
	"Get_System_Time",
	"Get_VM_Exec_Time",
	"Hook_V86_Int_Chain",
	"Get_V86_Int_Vector",
	"Set_V86_Int_Vector",
	"Get_PM_Int_Vector",
	"Set_PM_Int_Vector",
	"Simulate_Int",
	"Simulate_Iret",
	"Simulate_Far_Call",
	"Simulate_Far_Jmp",
	"Simulate_Far_Ret",
	"Simulate_Far_Ret_N",
	"Build_Int_Stack_Frame",
	"Simulate_Push",
	"Simulate_Pop",
	"_HeapAllocate",
	"_HeapReAllocate",
	"_HeapFree",
	"_HeapGetSize",
	"_PageAllocate",
	"_PageReAllocate",
	"_PageFree",
	"_PageLock",
	"_PageUnLock",
	"_PageGetSizeAddr",
	"_PageGetAllocInfo",
	"_GetFreePageCount",
	"_GetSysPageCount",
	"_GetVMPgCount",
	"_MapIntoV86",
	"_PhysIntoV86",
	"_TestGlobalV86Mem",
	"_ModifyPageBits",
	"_CopyPageTable",
	"_LinMapIntoV86",
	"_LinPageLock",
	"_LinPageUnLock",
	"_SetResetV86Pageable",
	"_GetV86PageableArray",
	"_PageCheckLinRange",
	"_PageOutDirtyPages",
	"_PageDiscardPages",
	"_GetNulPageHandle",
	"_GetFirstV86Page",
	"_MapPhysToLinear",
	"_GetAppFlatDSAlias",
	"_SelectorMapFlat",
	"_GetDemandPageInfo",
	"_GetSetPageOutCount",
	"Hook_V86_Page",
	"_Assign_Device_V86_Pages",
	"_DeAssign_Device_V86_Pages",
	"_Get_Device_V86_Pages_Array",
	"MMGR_SetNULPageAddr",
	"_Allocate_GDT_Selector",
	"_Free_GDT_Selector",
	"_Allocate_LDT_Selector",
	"_Free_LDT_Selector",
	"_BuildDescriptorDWORDs",
	"_GetDescriptor",
	"_SetDescriptor",
	"_MMGR_Toggle_HMA",
	"Get_Fault_Hook_Addrs",
	"Hook_V86_Fault",
	"Hook_PM_Fault",
	"Hook_VMM_Fault",
	"Begin_Nest_V86_Exec",
	"Begin_Nest_Exec",
	"Exec_Int",
	"Resume_Exec",
	"End_Nest_Exec",
	"Allocate_PM_App_CB_Area",
	"Get_Cur_PM_App_CB",
	"Set_V86_Exec_Mode",
	"Set_PM_Exec_Mode",
	"Begin_Use_Locked_PM_Stack",
	"End_Use_Locked_PM_Stack",
	"Save_Client_State",
	"Restore_Client_State",
	"Exec_VxD_Int",
	"Hook_Device_Service",
	"Hook_Device_V86_API",
	"Hook_Device_PM_API",
	"System_Control",
	"Simulate_IO",
	"Install_Mult_IO_Handlers",
	"Install_IO_Handler",
	"Enable_Global_Trapping",
	"Enable_Local_Trapping",
	"Disable_Global_Trapping",
	"Disable_Local_Trapping",
	"List_Create",
	"List_Destroy",
	"List_Allocate",
	"List_Attach",
	"List_Attach_Tail",
	"List_Insert",
	"List_Remove",
	"List_Deallocate",
	"List_Get_First",
	"List_Get_Next",
	"List_Remove_First",
	"_AddInstanceItem",
	"_Allocate_Device_CB_Area",
	"_Allocate_Global_V86_Data_Area",
	"_Allocate_Temp_V86_Data_Area",
	"_Free_Temp_V86_Data_Area",
	"Get_Profile_Decimal_Int",
	"Convert_Decimal_String",
	"Get_Profile_Fixed_Point",
	"Convert_Fixed_Point_String",
	"Get_Profile_Hex_Int",
	"Convert_Hex_String",
	"Get_Profile_Boolean",
	"Convert_Boolean_String",
	"Get_Profile_String",
	"Get_Next_Profile_String",
	"Get_Environment_String",
	"Get_Exec_Path",
	"Get_Config_Directory",
	"OpenFile",
	"Get_PSP_Segment",
	"GetDOSVectors",
	"Get_Machine_Info",
	"GetSet_HMA_Info",
	"Set_System_Exit_Code",
	"Fatal_Error_Handler",
	"Fatal_Memory_Error",
	"Update_System_Clock",
	"Test_Debug_Installed",
	"Out_Debug_String",
	"Out_Debug_Chr",
	"In_Debug_Chr",
	"Debug_Convert_Hex_Binary",
	"Debug_Convert_Hex_Decimal",
	"Debug_Test_Valid_Handle",
	"Validate_Client_Ptr",
	"Test_Reenter",
	"Queue_Debug_String",
	"Log_Proc_Call",
	"Debug_Test_Cur_VM",
	"Get_PM_Int_Type",
	"Set_PM_Int_Type",
	"Get_Last_Updated_System_Time",
	"Get_Last_Updated_VM_Exec_Time",
	// following for 3.1 -- where did these come from?
	// don't seem to be in \ddk\inc31\vmm.inc!!!
    "Test_DBCS_Lead_Byte",
    "_AddFreePhysPage",
    "_PageResetHandlePAddr",
    "_SetLastV86Page",
    "_GetLastV86Page",
    "_MapFreePhysReg",
    "_UnmapFreePhysReg",
    "_XchgFreePhysReg",
    "_SetFreePhysRegCalBk",
    "Get_Next_Arena",
    "Get_Name_Of_Ugly_TSR",
    "Get_Debug_Options",
    "Set_Physical_HMA_Alias",
    "_GetGlblRng0V86IntBase",
    "_Add_Global_V86_Data_Area",
    "GetSetDetailedVMError",
    "Is_Debug_Chr",
    "Clear_Mono_Screen",
    "Out_Mono_Chr",
    "Out_Mono_String",
    "Set_Mono_Cur_Pos",
    "Get_Mono_Cur_Pos",
    "Get_Mono_Chr",
    "Locate_Byte_In_ROM",
    "Hook_Invalid_Page_Fault",
    "Unhook_Invalid_Page_Fault",
    "Set_Delete_On_Exit_File",
	"Close_VM",
	"Enable_Touch_1st_Meg",			// debugging
	"Disable_Touch_1st_Meg",		// debugging
	"Install_Exception_Handler",	// ef
	"Remove_Exception_Handler",		// f0
	"Get_Crit_Status_No_Block",		// f1
} ;

char *VPICD_Tbl[] = {
	"!Version",
	"~Virtualize_IRQ",
	"~Set_Int_Request",
	"~Clear_Int_Request",
	"~Phys_EOI",
	"!Complete_Status",
	"!Status",
	"~Test_Phys_Request",
	"~Physically_Mask",
	"~Physically_Unmask",
	"~Set_Auto_Masking",
	"!IRQ_Complete_Status",
	"~Convert_Handle_To_IRQ",
	"~Convert_IRQ_To_Int",
	"~Convert_Int_To_IRQ",
	"~Call_When_Hw_Int",
	"~Force_Default_Owner",
	"~Force_Default_Behavior",
	"~Auto_Mask_At_Inst_Swap",		// 3.1
	"~Begin_Inst_Page_Swap",		// 3.1
	"~End_Inst_Page_Swap",			// 3.1
} ; 

char *DOSMGR_Tbl[] = {
	"!Version",
	"_DOSMGR_Set_Exec_VM_Data",
	"~Copy_VM_Drive_State",
	"_DOSMGR_Exec_VM",
	"!IndosPtr",
	"~Add_Device",
	"~Remove_Device",
	"~Instance_Device",
	"!DOS_Crit_Status",
	"~Enable_Indos_Polling",
    // following for 3.1+
    "~BackFill_Allowed",
    "~LocalGlobalReg",
} ;

char *DOSNET_Tbl[] = {
	"!Version",
	"~Send_FILESYSCHANGE",
	"~Do_PSP_Adjust",
} ;

char *EBIOS_Tbl[] = {
	"!Version",
	// following is for 3.1+
	"!Unused_Mem",
} ;

char *PageSwap_Tbl[] = {
	"!Version",
	"~Test_Create",
	"~Create",
	"~Destroy",
	"~In",
	"~Out",
	"~Test_IO_Valid",
} ;

char *SHELL_Tbl[] = {
	"!Version",
	"~Resolve_Contention",
	"~Event",
	"~SYSMODAL_Message",
	"~Message",
	// following is for 3.1+
	"~GetVMInfo",
} ;

char *V86MMGR_Tbl[] = {
     "!Version",
     "~Allocate_V86_Pages",
     "~Set_EMS_XMS_Limits",
     "!EMS_XMS_Limits",
     "~Set_Mapping_Info",
     "!Mapping_Info",
     "~Xlat_API",
     "~Load_Client_Ptr",
     "~Allocate_Buffer",
     "~Free_Buffer",
     "!Xlat_Buff_State",
     "~Set_Xlat_Buff_State",
     "!VM_Flat_Sel",
     "~Map_Pages",
     "~Free_Page_Map_Region",
	 // following for 3.1+
     "~LocalGlobalReg",
     "~GetPgStatus",
	 "~SetLocalA20",
     "~ResetBasePages",
	 "~SetAvailMapPgs",
	 "~NoUMBInitCalls",
} ;

char *VCD_Tbl[] = {
	"!Version",
	"~Set_Port_Global",
	"!Focus",
	"~Virtualize_Port",
} ;

char *VDD_Tbl[] = {
	"!Version",
	"~PIF_State",
	"!GrabRtn",
	"~Hide_Cursor",
	"~Set_VMType",
	"!ModTime",
	"~Set_HCurTrk",
	"~Msg_ClrScrn",
	"~Msg_ForColor",
	"~Msg_BakColor",
	"~Msg_TextOut",
	"~Msg_SetCursPos",
	"~Query_Access",
	"~Check_Update_Soon",	// 3.1
} ;

// VDD2 is probably bogus; will usually be LoadHi (EMM386, 386MAX, QEMM)
// except MS-DOS 6.0 MONOUMB.386 is "Win386 dummy VDD2 Device" (#1C)
char *VDD2_Tbl[] = {
	"VDD2_Get_Version",
} ;

char *LoadHi_Tbl[] = {
	"LoadHi_Get_Version",
} ;

char *VMCPD_Tbl[] = {
	"!Version",
	"!Virt_State",
	"~Set_Virt_State",
	} ;

/*
	or, VMCPD (Virtual Math Coprocessor Device) may have????
		VMCPD_SysInit
		VMCPD_INT_7
*/			

char *VDMAD_Tbl[] = {
	"!Version",
	"~Virtualize_Channel",
	"!Region_Info",
	"~Set_Region_Info",
	"!Virt_State",
	"~Set_Virt_State",
	"~Set_Phys_State",
	"~Mask_Channel",
	"~UnMask_Channel",
	"~Lock_DMA_Region",
	"~Unlock_DMA_Region",
	"~Scatter_Lock",
	"~Scatter_Unlock",
	"~Reserve_Buffer_Space",
	"~Request_Buffer",
	"~Release_Buffer",
	"~Copy_To_Buffer",
	"~Copy_From_Buffer",
	"~Default_Handler",
	"~Disable_Translation",
	"~Enable_Translation",
	"!EISA_Adr_Mode",
	"~Set_EISA_Adr_Mode",
	"~Unlock_DMA_Region_No_Dirty",
} ;

char *VKD_Tbl[] = {
	"!Version",
	"~Define_Hot_Key",
	"~Remove_Hot_Key",
	"~Local_Enable_Hot_Key",
	"~Local_Disable_Hot_Key",
	"~Reflect_Hot_Key",
	"~Cancel_Hot_Key_State",
	"~Force_Keys",
	"!Kbd_Owner",
	"~Define_Paste_Mode",
	"~Start_Paste",
	"~Cancel_Paste",
	"!Msg_Key",
	"~Peek_Msg_Key",
	"~Flush_Msg_Key_Queue",
} ;

// VHD may be gone -- see BlockDev!
char *VHD_Tbl[] = {
    "!Version",
    "~Allocate_Handle",
    "~Read",
    "~Write",
    "!Status",
} ;

char *BlockDev_Tbl[] = {
    "!Version",
    "~Register_Device",
    "~Find_Int13_Drive",
    "!Device_List",
    "~Send_Command",
    "~Command_Complete",
    "~Synchronous_Command",
} ;

char *VMD_Tbl[] = {
	"!Version",
	"~Set_Mouse_Type",
	"!Mouse_Owner",
} ;

char *VMPoll_Tbl[] = {
	"!Version",
	"~Enable_Disable",
    // following for 3.1+
    "~Reset_Detection",
} ;

char *VNETBIOS_Tbl[] = {
	"!Version",
} ;

char *VSD_Tbl[] = {
	"!Version",
	"~Bell",
} ;

char *VTD_Tbl[] = {
	"!Version",
	"~Update_System_Clock",
	"!Interrupt_Period",
	"~Begin_Min_Int_Period",
	"~End_Min_Int_Period",
	"~Disable_Trapping",
	"~Enable_Trapping",
	// following probably 3.1+
	"!Real_Time",
} ;

char *INT13_Tbl[] = {
	"!Version",
	"~Device_Registered",
	"~Translate_VM_Int",
	"~Hooking_BIOS_Int",
	"~Unhooking_BIOS_Int",
} ; 

char *PageFile_Tbl[] = {
	"!Version",
	"~Init_File",
	"~Clean_Up",
	"~Grow_File",
	"~Read_Or_Write",
	"~Cancel",
	"~Test_IO_Valid",
} ; 

typedef struct {
	void *tbl;
	unsigned size;
	char *name;
	char *desc;
	} VxD_Tbl_Desc; 
	
#define TBL_SIZE(tbl)		((sizeof(tbl) / sizeof(char*)))

VxD_Tbl_Desc VxD_Tbl[] = {
	/* 0000 */				0, 0, "",		0,
	/* 0001 = VMM */		VMM_Tbl, TBL_SIZE(VMM_Tbl), "VMM",
		"Virtual Machine Manager",
	/* 0002 = Debug */		0, 0, "Debug", "Win386 Debug Device",
	/* 0003 = VPICD */		VPICD_Tbl, TBL_SIZE(VPICD_Tbl), "VPICD",
		"Virtual Programmable Interrupt Controller (PIC) Device",
	/* 0004 = VDMAD */		VDMAD_Tbl, TBL_SIZE(VDMAD_Tbl), "VDMAD",
		"Virtual Direct Memory Access (DMA) Device",
	/* 0005 = VTD */		VTD_Tbl, TBL_SIZE(VTD_Tbl), "VTD",
		"Virtual Timer Device",
	/* 0006 = V86MMGR */	V86MMGR_Tbl, TBL_SIZE(V86MMGR_Tbl), "V86MMGR",
		"Virtual 8086 (V86) Mode Memory Manager Device",
	/* 0007 = PageSwap */	PageSwap_Tbl, TBL_SIZE(PageSwap_Tbl), "PageSwap",
		"Demand Paging Swap Device Services",
	/* 0008 = Parity */		0, 0, "Parity",	0,
	/* 0009 = Reboot */		0, 0, "Reboot",	0,
	/* 000A = VDD */		VDD_Tbl, TBL_SIZE(VDD_Tbl), "VDD",	
		"Virtual Display Device",
	/* 000B = VSD */		VSD_Tbl, TBL_SIZE(VSD_Tbl), "VSD",
		"Virtual Sound Device",
	/* 000C = VMD */		VMD_Tbl, TBL_SIZE(VMD_Tbl), "VMD",
		"Virtual Mouse Device",
	/* 000D = VKD */		VKD_Tbl, TBL_SIZE(VKD_Tbl), "VKD",
		"Virtual Keyboard Device",
	/* 000E = VCD */		VCD_Tbl, TBL_SIZE(VCD_Tbl), "VCD",
		"Virtual COMM Device",
	/* 000F = VPD */		0, 0, "VPD", "Virtual Printer Device",
#ifndef USE_WIN30_NAMES
	// Windows 3.1+
	/* 0010 = BlockDev */	BlockDev_Tbl, TBL_SIZE(BlockDev_Tbl), "BLOCKDEV",
		"Block Device (formerly VHD)",
#else
	// Windows 3.0
	/* 0010 = VHD */		VHD_Tbl, TBL_SIZE(VHD_Tbl), "VHD",
		"Virtual Hard Disk Device",
#endif			
	/* 0011 = VMCPD */		VMCPD_Tbl, TBL_SIZE(VMCPD_Tbl), "VMCPD",
		"Virtual Math Coprocessor (MCP) Device",
	/* 0012 = EBIOS */		EBIOS_Tbl, TBL_SIZE(EBIOS_Tbl), "EBIOS", 0,
	/* 0013 = BIOSXlat */	0, 0, "BIOSXlat", 0,
	/* 0014 = VNETBIOS */	VNETBIOS_Tbl, TBL_SIZE(VNETBIOS_Tbl), "VNETBIOS",
		"Virtual NetBIOS Device",
	/* 0015 = DOSMGR */		DOSMGR_Tbl, TBL_SIZE(DOSMGR_Tbl), "DOSMGR",	0,
	/* 0016 = WINLOAD */	0, 0, "WINLOAD",		0,
	/* 0017 = SHELL */		SHELL_Tbl, TBL_SIZE(SHELL_Tbl), "SHELL", 0,
	/* 0018 = VMPoll */		VMPoll_Tbl, TBL_SIZE(VMPoll_Tbl), "VMPOLL",	0,
	/* 0019 = VPROD */		0, 0, "VPROD",		0,
	/* 001A = DOSNET */		DOSNET_Tbl, TBL_SIZE(DOSNET_Tbl), 
		"DOSNET",	0,  /* example: Novell Virtual NetWare dev. for WfW */
	/* 001B = VFD */		0, 0, "VFD",		"Virtual Floppy Device",
#ifndef USE_WIN30_NAMES
	/* 001C = LoadHi */		LoadHi_Tbl, TBL_SIZE(LoadHi_Tbl), "LoadHi",	0,
#else
	/* 001C = VDD2 */		VDD2_Tbl, TBL_SIZE(VDD2_Tbl), "VDD2",
		"Virtual Secondary Display Driver",	  /* example: DOS 6 MONOUMB.386 */
#endif			
	/* 001D = WINDEBUG */	0, 0, "WINDEBUG", 0, /* example: TDDEBUG.386 */
	/* 001E = TSRLoad */	0, 0, "TSRLoad",  "TSR instance utility",
	/* 001F = BiosHook */	0, 0, "BiosHook", "BIOS interrupt hooker VxD",
	/* 0020 = INT13 */		INT13_Tbl, TBL_SIZE(INT13_Tbl), "INT13", 0,
	/* 0021 = PageFile */	PageFile_Tbl, TBL_SIZE(PageFile_Tbl), "PageFile",
		"Demand Paging Swap Device Services",
	/* 0022 = SCSI */		0, 0, "SCSI",	0,	/* also Chicago APIX.386 */
	/* 0023 = MCA_POS */	0, 0, "MCA_POS",
		"Microchannel Architecture Programmable Option Select",
	/* 0024 = SCSIFD */		0, 0, "SCSIFD",	"SCSI FastDisk",
	/* 0025 = VPEND */		0, 0, "VPEND",	"Virtual Pen Device",
	/* 0026 = VPOWERD */	0, 0, "APM",	"Power Management Device",
	/* 0027 = VXDLDR */		0, 0, "VXDLDR",	"Chicago VxD Loader",
	/* 0028 = ??? */		0, 0, "", 0,
	/* 0029 = ??? */		0, 0, "", 0,
	/* 002A = VWIN32 */		0, 0, "VWIN32",	"Chicago VWIN32 Device",
	/* 002B = VCOMM */		0, 0, "VCOMM",	"Chicago VCOMM Device",
	/* 002C = ??? */		0, 0, "", 0,
	/* 002D = W32S */		0, 0, "W32S",   "Win32s Device",
	} ;
		
#define NUM_DEV		(sizeof(VxD_Tbl) / sizeof(VxD_Tbl_Desc))

/*
Some additional VxDs:
	0031 -- Win386 Virtual NETBEUI Device (VNB; WfW)
	0032 -- Win386 Int21 File Server (WfW)
	0033 -- CONFIGMG (Chicago; loads early)
	0036 -- DOS386 VFBACKUP Device (Chicago)
	0038 -- DOS386 VCOND Device (Chicago)
	0051 -- DOS386 ISAPNP Device (Chicago)
	008D -- ESDI_506 (Chicago)
	0090 -- DOS386 voltrack Device (Chicago)
	00FD -- DOS386 FAKEIDE Device (Chicago)
	0102 -- Win386 CV1 Device (Nu-Mega CV/1; used by Microsoft)
	0200 -- VIPX (Virtual IPX Device; Novell)
	0205 -- Bounds-Checker/W Device (BCW; Nu-Mega)
	0442 -- VTDAPI (MMSys Virtual Timer Device; Multimedia)
	0445 -- VSBD (MMSys Win386 VSBD Device; SoundBlaster; Multimedia)
	0450 -- DOS386 Gateway Device (Chicago)
	0454 -- DOS386 Splitter Device (Chicago)
	0460 -- DOS386 UNIMODEM Device (Chicago)
	0480 -- Win386 Virtual Net Support (VNetSup; WfW)
	0481 -- Win386 Virtual Redirector (WfW)
	0482 -- Win386 Virtual Browser (WfW)
	0483 -- DOS386 VSHARE Device (WfW; Chicago)
	0484 -- IFS Manager (Chicago IFSMGR)
	0486 -- Chicago FAT File System Driver (VFAT)
	048B -- DOS386 VCACHE Device (Chicago)
	1020 -- Win386 VCV Device (Microsoft C 7.0; CodeView?)
	1021 -- Win386 vmb Device (Microsoft C 7.0; virtual message buffer?)
	1022 -- Win386 vpfd Device (Microsoft C 7.0)
	1025 -- Win386 MMD Device (Visual C++)
	2200 -- Win386 Vfintd Device (VFINTD; MS-DOS 6.0)
	2540 -- DOS 6.0 INTERLNK.EXE (VFXD; VILD)

Note!  Some important VxDs don't have ID numbers, because they work
transparently rather than providing an API of some sort.
*/

