/*
VXDCHAIN.H -- Functions to manipulate Windows VxD chain
Andrew Schulman, September 1993
CIS 76320,302
*/

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;

#pragma pack(1)

typedef struct {
    DWORD DDB_Next;                  // addr of next VxD in chain, or 0
    WORD DDB_SDK_Version;
    WORD DDB_Req_Device_Number;		 // the VxD ID number
    BYTE DDB_Dev_Major_Version;
    BYTE DDB_Dev_Minor_Version;
    WORD DDB_Flags;
    BYTE DDB_Name[8];				 // padded with spaces
    DWORD DDB_Init_Order;			 // also order within list (SHELL last)
    DWORD DDB_Control_Proc;
    DWORD DDB_V86_API_Proc;
    DWORD DDB_PM_API_Proc;
    void (far *DDB_V86_API_CSIP)();	 // V86 mode seg:ofs callback addr
    void (far *DDB_PM_API_CSIP)();	 // prot mode sel:ofs callback addr
    DWORD DDB_Reference_Data;
    DWORD DDB_Service_Table_Ptr;
    DWORD DDB_Service_Table_Size;
    } DDB;							 // from ddk include/vmm.inc
		
#pragma pack()		
    
int Get_First_VxD(DWORD *proot);
int Get_Next_VxD(DWORD vxd, DWORD *pnext);
int Find_VxD(char *name, DWORD *pvxd);
int Find_VxD_ID(WORD id, DWORD *pvxd);
int Get_VxD(DWORD vxd, DDB far* *ppddb);
int Free_VxD(DDB far *pddb);
int Get_VxD_Proc_Name(WORD id, WORD func, char *buffer, int bufsize);
int Get_VxD_Desc(WORD id, char *buffer, int bufsize);

#define SUCCESS					0
#define ERROR_CANT_FIND_VMM		1
#define ERROR_CANT_MAP_LINEAR	2
#define ERROR_CANT_FIND_VXD		3
#define ERROR_END_OF_CHAIN		4
#define ERROR_NAME_UNKNOWN		5
#define ERROR_BUFFER_TOO_SHORT	6

