/*
VXDCHAIN.C -- Functions to manipulate Windows VxD chain
Protected mode only!
Andrew Schulman, September 1993
CIS 76320,302
*/

#include <stdlib.h>
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#ifdef DPMI_APP
#include "dpmishel.h"
#else
#include "windows.h"
#endif
#include "map_lin.h"
#include "vxdfunc.h"
#include "vxdchain.h"

#define VMM_STR     "VMM     "      // 5 spaces after name

// look for first occurrence of string inside block of memory
char far *_fmemstr(char far *fp, char far *str, WORD len)
{
    int c = str[0];
    char far *fp2 = fp;
    WORD len2 = len;
    while (fp2 = (char far *) _fmemchr(fp2, c, len2))
    {
        if (_fstrstr(fp2, str))
            return fp2;
        else
        {
            fp2++;  // skip past character
            len2 = len - (fp2 - fp);
        }
    }
    /* still here */
    return NULL;
}

int Get_First_VxD(DWORD *proot)
{
    DWORD vmm_ddb_lin = 0;
    DWORD lin;
    DDB far *pddb;
    char far *vmm_str;  
    unsigned char far *fp;
    
    // try to find string "VMM     " in first megabyte
    // can't start at 0x800000000L: page fault!
    for (lin=0x80001000L; lin<0x80400000L; lin += 0x10000L)
    {
        if (! (fp = (char far *) map_linear(lin, 0x10000L)))
			return ERROR_CANT_MAP_LINEAR;
        if (vmm_str = _fmemstr(fp, VMM_STR, 0xFFFF))
        {
            // back up to get linear address of possible VMM_DDB
            vmm_ddb_lin = lin + (vmm_str - fp) - offsetof(DDB, DDB_Name);
            free_mapped_linear(fp);
            
            // map VMM_DDB (hopefully) into our address space
            if (! (pddb = (DDB far *) map_linear(vmm_ddb_lin, sizeof(DDB))))
				return ERROR_CANT_MAP_LINEAR;

            // make sure it really is VMM_DDB
            if ((_fstrncmp(pddb->DDB_Name, VMM_STR, 8) == 0) &&
                (pddb->DDB_Req_Device_Number == 1) &&
				(pddb->DDB_Init_Order == 0) &&	// VMM_Init_Order
                (pddb->DDB_Next > 0x80000000L) &&
                (pddb->DDB_Control_Proc > 0x80000000L))
            {
                Free_VxD(pddb);
                *proot = vmm_ddb_lin;
				return SUCCESS;
            }
        }
        // still here:  keep looking
        free_mapped_linear(fp);
    }
    
    // still here: didn't find it
    return ERROR_CANT_FIND_VMM;
}

int Get_Next_VxD(DWORD vxd, DWORD *pnext)
{
	DDB far *pddb;
	DWORD next;
	int err;

	if ((err = Get_VxD(vxd, &pddb)) != 0)
		return err;
	next = pddb->DDB_Next;	// should verify with an Is_VxD() function?
	Free_VxD(pddb);
	*pnext = next;
	return next ? SUCCESS : ERROR_END_OF_CHAIN;
}

// should this be case-insensitive?
int find_vxd_name_or_id(char *name, WORD id, DWORD *pvxd)
{
	DDB far *pddb;
	DWORD vxd;
	int err;
	
	if ((err = Get_First_VxD(&vxd)) != 0)
		return err;
	for (;;)
	{
		if ((err = Get_VxD(vxd, &pddb)) != 0)
			return err;
		if ((name && (_fstrncmp(pddb->DDB_Name, name, 8) == 0)) ||
			(id && (pddb->DDB_Req_Device_Number == id)))
		{
			free_mapped_linear(pddb);
			*pvxd = vxd;
			return SUCCESS;
		}
		vxd = pddb->DDB_Next;	// quicker than Get_Next_VxD
		free_mapped_linear(pddb);
		if (vxd == 0)			// end of VxD chain
			return ERROR_CANT_FIND_VXD;
	}
}

int Find_VxD(char *name, DWORD *pvxd)
{
	return find_vxd_name_or_id(name, 0, pvxd);
}

int Find_VxD_ID(WORD id, DWORD *pvxd)
{
	return find_vxd_name_or_id((char *) 0, id, pvxd);
}

int Get_VxD(DWORD vxd, DDB far* *ppddb)
{
	if (*ppddb = (DDB far *) map_linear(vxd, sizeof(DDB)))
		return SUCCESS;
	else
		return ERROR_CANT_MAP_LINEAR;
}

int Free_VxD(DDB far *pddb)
{
	free_mapped_linear(pddb);
	return SUCCESS;
}

int Get_VxD_Proc_Name(WORD id, WORD func, char *buffer, int bufsize)
{
	static char my_buff[128];
    VxD_Tbl_Desc *vxd_tab_desc;
	char **vxd_tab;
	char *s;
	int len, c;
	
	if ((id >= NUM_DEV) || (! (vxd_tab_desc = &VxD_Tbl[id])))
		return ERROR_NAME_UNKNOWN;
		
	if ((func >= vxd_tab_desc->size) ||
		(! (vxd_tab = (char **) vxd_tab_desc->tbl)))
		return ERROR_NAME_UNKNOWN;
	
	c = *vxd_tab[func];
	if ((c == '~') || (c == '!'))	// expand some simple tokens
	{
		len = sprintf(my_buff, 
			(c == '~') ? "%s_%s" : "%s_Get_%s", 
			vxd_tab_desc->name, vxd_tab[func] + 1);
		if (len < bufsize)
			strcpy(buffer, my_buff);
		else
			return ERROR_BUFFER_TOO_SHORT;
	}
	else if (strlen(vxd_tab[func]) < bufsize)
		strcpy(buffer, vxd_tab[func]);
	else
		return ERROR_BUFFER_TOO_SHORT; // dumb: should tell them needed len
	
	return SUCCESS;
}

int Get_VxD_Desc(WORD id, char *buffer, int bufsize)
{
    VxD_Tbl_Desc *vxd_tab_desc;
	int len;
	if ((id >= NUM_DEV) || (! (vxd_tab_desc = &VxD_Tbl[id])))
		return ERROR_NAME_UNKNOWN;
	if ((len = strlen(vxd_tab_desc->desc)) == 0)
		return ERROR_NAME_UNKNOWN;
	else if (len < bufsize)
		strcpy(buffer, vxd_tab_desc->desc);
	else
		return ERROR_BUFFER_TOO_SHORT; // dumb: should tell them needed len
	return SUCCESS;
}

