/* 
MAP_LIN.C
Andrew Schulman, September 1993
CIS 76320,302
*/

#include <stdlib.h>
#include <string.h>
#include <dos.h>
#ifdef DPMI_APP
#include "dpmishel.h"
#else
#include "windows.h"
#endif
#include "map_lin.h"

void far *map_linear(DWORD lin_addr, DWORD num_bytes)
{
    WORD sel;
    
    /* allocate a selector similar to our current DS 
       (i.e., a data selector) */
    _asm mov sel, ds
    if ((sel = AllocSelector(sel)) == 0)
        fail("Cannot allocate a selector!");
    
    /* set the base and limit of the new selector */
    SetSelectorBase(sel, lin_addr);
    SetSelectorLimit(sel, num_bytes - 1);   
    
    /* turn into a far pointer */
    return MK_FP(sel, 0);
}

void free_mapped_linear(void far *fp)
{
    FreeSelector(FP_SEG(fp));
}

