/*
DPMISHEL.C
Shell to run a simple C program in protected mode under DPMI
Andrew Schulman, September 1993
CIS 76320,302
*/

/* flag used by PROTMODE.H */
#define DPMI_APP

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef int BOOL;

#define AllocSelector(x)        dpmi_alloc_selector()
#define FreeSelector(x)         dpmi_free_selector(x)
#define SetSelectorBase(x,y)    dpmi_set_selector_base((x), (y))
#define SetSelectorLimit(x,y)   dpmi_set_selector_limit((x), (y))
#define GetSelectorBase(x)      dpmi_get_selector_base(x)
#define GetSelectorLimit(x)     dpmi_get_selector_limit(x)

WORD dpmi_alloc_selector(void);
WORD dpmi_free_selector(WORD sel);
WORD dpmi_set_selector_base(WORD sel, DWORD base);
WORD dpmi_set_selector_limit(WORD sel, DWORD limit);
DWORD dpmi_get_selector_base(WORD sel);
DWORD dpmi_get_selector_limit(WORD sel);

#ifdef __BORLANDC__
#define _dos_allocmem(x,y)  (allocmem(x,y) != -1)
#endif

void _dos_exit(int retval);
int dpmi_present(void);
int dpmi_init(void);

/* unfortunately, the app has to check Ctrl-C itself! */
extern int ctrl_c_hit;

/* these functions to be defined by app */
extern int v86_main(int argc, char *argv[]);
extern int pmode_main(int argc, char *argv[]);
extern void fail(const char *s);  // app's fail() must call _dos_exit()

