program phone;
uses
    IPXUNIT, crt;
const
     Socket           =  $5678;                   { I/O Socket Number}
var
   EcbSend, EcbRead   :  Ecb;                     { Definition of ECBs        }
   SendIpxHeader,
   ReadIpxHeader      :  IpxHeader;               { Definition of IPX Headers }
   SendData, ReadData :  array [1..5] of byte;    { Data area of packets      }
   ConNbrRec          :  ConNbrArr;               { Connection Number Struc   }
   NetNod             :  NetWrkAdr;               { Structure for InterNetwork
                                                    addresses                 }
   LocalTarget        :  NodType;                 { Node Address              }
   I                  :  word;
   readflg            :  boolean;                 { Flag to signal received
                                                    packets                   }
   myx,myy,rx,ry      :  byte;                    {  ViewPorts cursor position}
{-----------------------------------------------------------------------------}
{$F+$S-}                                          {Far proc, No stack checking}
Procedure EsrHandler;
begin
     inline($06                                     { push  es                }
           /$1f                                     { pop   ds                }
           );
     readflg:=true;
end;
{-----------------------------------------------------------------------------}
procedure ZeroHeader(var Header : IpxHeader);
var
   Hseg, Hofs,i : word;
begin
     Hseg:=seg(Header);
     Hofs:=ofs(Header);
     for i:=0 to sizeof(Header)-1 do mem[Hseg:Hofs+i]:=0;
end;
{-----------------------------------------------------------------------------}
procedure ZeroEcb(var EcbBlk : Ecb);
var
   Hseg, Hofs,i : word;
begin
     Hseg:=seg(EcbBlk);
     Hofs:=ofs(EcbBlk);
     for i:=0 to sizeof(EcbBlk)-1 do mem[Hseg:Hofs+i]:=0;
end;
{-----------------------------------------------------------------------------}
procedure Send;
var
   i   :  word;
begin
     ZeroHeader(SendIpxHeader);                              {Clear IPX Header}
     with SendIpxHeader do
       begin
         PacketType:=IPX_PACKET_TYPE;                        {Assign Pack Type}
         Destination.NetworkNumber:=NetNod.NetworkNumber;    {Fill in Internet}
         Destination.NodeAddress  :=NetNod.NodeAddress;      {address         }
         DestinationSocket:=Swap(Socket);                    {Fill in DSOCKET }
       end;
     ZeroEcb(ECbSend);                                       {Clear Ecb       }
     with EcbSend do
       begin
         SocketNumber:=Swap(Socket);                         {Fill in Socket, }
         for i:=1 to 6 do
             ImmediateAddress[i]:=LocalTarget[i];            {Immediate Addr, }
         FragmentCount:=2;                                   {And fragments   }
         FragmentDescriptor[1].Adr:=Addr  (SendIpxHeader);
         FragmentDescriptor[1].Len:=sizeof(SendIpxHeader);
         FragmentDescriptor[2].Adr:=Addr  (SendData);
         FragmentDescriptor[2].Len:=sizeof(SendData);
       end;
     IpxSendPacket(EcbSend);                                 { Send packet    }
end;
{-----------------------------------------------------------------------------}
procedure Listen;
begin
     ZeroHeader(ReadIpxHeader);                              {Clear IPX Header}

     ZeroEcb(EcbRead);                                       {Clear Ecb       }
     with EcbRead do
       begin
         EventServiceRoutine:=addr(EsrHandler);              {Establish ESR   }
         SocketNumber:=Swap(Socket);                         {Fill in socket, }
         FragmentCount:=2;                                   {and fragments   }
         FragmentDescriptor[1].Adr:=Addr  (ReadIpxHeader);
         FragmentDescriptor[1].Len:=sizeof(ReadIpxHeader);
         FragmentDescriptor[2].Adr:=Addr  (ReadData);
         FragmentDescriptor[2].Len:=sizeof(ReadData);
       end;
     IpxReadPacket(EcbRead);
end;
{-----------------------------------------------------------------------------}
function TestConnection : boolean;
var
   i : byte;
begin
     TestConnection:=TRUE;
     for i:=1 to 6 do
       begin
         if ReadIpxHeader.Source.NodeAddress[i] <>
            SendIpxHeader.Destination.NodeAddress[i]
            then TestConnection:=FALSE;
       end;
end;
{-----------------------------------------------------------------------------}
procedure HandShake;
const
     Progress  :  array [1..4] of char = ('/','','\','|');
var
   Cnt         :  integer;
   message     :  string;
   ConInfoRec  :  ConnInfo;
   i           :  byte;
   x,y         :  byte;
   ptr, car    :  byte;
   h, m,s,hund :  Word;
   ConnUp      :  boolean;
   UserID      :  string;
begin
     UserID:=paramstr(1);
     for i:=1 to Length(UserID) do UserID[i]:=upcase(UserID[i]);
     Writeln('Calling User ',UserID);
     Write('Press <ESC> to cancel [ ]');
     x:=wherex-2; y:=wherey;
     Userinfo(LocalConnectionNumber,ConInfoRec);
     Message:='User ';
     Cnt:=1;
     while ConInfoRec.ObjectName[Cnt] <> 0 do
       begin
         message:=message+chr(ConInfoRec.ObjectName[Cnt]);
         inc(Cnt);
       end;
     Message:=Message+' is phoning you........... [';
     Message:=Message+Time+']';
     Cnt:=0; Ptr:=1;

     SendMessage(ConNbrRec.Connections[1],message);
     Listen;
     car:=$ff;
     ConnUp:=False;
     repeat
       gotoxy(x,y);
       write(Progress[ptr]);
       inc(ptr);
       if ptr > 4 then
         begin
           ptr:=1;
           SendData[1]:=LocalConnectionNumber;
           Send;
         end;
       inc(Cnt);
       if Cnt = 30 then
         begin
           SendMessage(ConNbrRec.Connections[1],message);
           Cnt:=0;
         end;
       delay(1000);
       if readflg then
         begin
              if not TestConnection then
                 begin
                   readflg:=false;
                   Listen;
                 end
              else ConnUp:=TRUE;
         end;
       if keypressed then car:=ord(readkey);
     until (car = $1b) or ConnUp;
     if car = $1b then
       begin
         Writeln;
         Write('Wait...');
         Delay(5000);
         SendData[1]:=$1b;
         Send;
         message:='The user phoning you canceled the call... ['+Time+']';
         SendMessage(ConNbrRec.Connections[1],message);
         IpxDeleteSocket(Socket);
         halt(1);
       end;
     Writeln;
     Write('User ',Paramstr(1),' answered your call......!');
     delay(1200);
     ReadFlg:=false;
end;
{-----------------------------------------------------------------------------}
procedure MyWindow;
begin
     Window(1,5,80,12);
     gotoxy(myx,myy);
end;
{-----------------------------------------------------------------------------}
procedure RemoteWindow;
begin
     Window(1,17,80,24);
     gotoxy(rx,ry);
end;
{-----------------------------------------------------------------------------}
procedure InitWindows;
var
   i          :  integer;
   LocalNode  :  NetWrkAdr;
   ConInfoRec :  ConnInfo;
begin
     ClrScr;
     myx:=1; myy:=1;
     rx:=1;  ry:=1;
     gotoxy(1,1);
     write(''); for i:=2 to 79 do write(''); write('');
     write(''); for i:=2 to 79 do write(' '); write('');
     write(''); for i:=2 to 79 do write(''); write('');

     GetInternetAddress(LocalConnectionNumber,LocalNode);
     UserInfo(LocalConnectionNumber,ConInfoRec);
     gotoxy(3,2);
     Write('User: ');
     for i:=1 to 10 do write(chr(ConInfoRec.ObjectName[i]));
     Write('  Node: ');
     for i:=1 to 6 do
       begin
         WriteHexByte(LocalNode.NodeAddress[i]);
         if i <> 6 then write('.');
       end;
     Write('  Net: ');
     for i:=1 to 4 do
       begin
         WriteHexByte(LocalNode.NetworkNumber[i]);
         if i <> 4 then write ('.');
       end;
     Write('  Connection: '); write(LocalConnectionNumber);

     gotoxy(1,13);
     write(''); for i:=2 to 79 do write(''); write('');
     write(''); for i:=2 to 79 do write(' '); write('');
     write(''); for i:=2 to 79 do write(''); write('');

     UserInfo(ConNbrRec.Connections[1],ConInfoRec);
     gotoxy(3,14);
     Write('User: ');
     for i:=1 to 10 do write(chr(ConInfoRec.ObjectName[i]));
     Write('  Node: ');
     for i:=1 to 6 do
       begin
         WriteHexByte(NetNod.NodeAddress[i]);
         if i <> 6 then write('.');
       end;
     Write('  Net: ');
     for i:=1 to 4 do
       begin
         WriteHexByte(NetNod.NetworkNumber[i]);
         if i <> 4 then write ('.');
       end;
     Write('  Connection: '); write(ConNbrRec.Connections[1]);

     gotoxy(26,25);
     Write(' Phone Utility ');
     gotoxy(1,1);
     RemoteWindow;
     MyWindow;
     HighVideo;
end;
{-----------------------------------------------------------------------------}
procedure Talk;
begin
     InitWindows;
     Listen;
     repeat
           if keypressed then
             begin
                  MyWindow;
                  SendData[1]:=ord(Readkey);
                  if SendData[1]=13 then writeln
                  else write(chr(SendData[1]));
                  myx:=wherex; myy:=wherey;
                  send;
             end;
           if readflg then
             begin
                  If TestConnection then
                    begin
                       RemoteWindow;
                       if ReadData[1]=13 then writeln
                       else write(chr(ReadData[1]));
                       rx:=wherex; ry:=wherey;
                    end;
                  readflg:=false;
                  Listen;
             end;
     until (ReadData[1]=$1b) or (SendData[1]=$1b);
     SendData[1]:=$1b; send;
     IpxDeleteSocket(Socket);
     Writeln; Writeln;
     writeln('<Hanging Up...........>');
     Delay(3000);
     Window(1,1,80,25);
     LowVideo;
     gotoxy(80,25);
end;
{-----------------------------------------------------------------------------}
procedure Setup;
begin
     readflg:=false;
     if not IpxPresent then writeln('IPX Not Installed');
     if not IpxCreateSocket(Socket) then writeln('Error Opening Socket');
end;
{-----------------------------------------------------------------------------}
procedure CallUser;
begin
     GetInternetAddress(ConNbrRec.Connections[1],NetNod);
     GetLocalTarget(NetNod,Socket,LocalTarget);
     HandShake;
     Talk;
end;
{-----------------------------------------------------------------------------}

procedure Process_Input_Command;
var
   ConNbr  :  byte;
   Code    :  integer;
   UserID  :  String;
   i       :  integer;
begin
     UserID:=paramstr(1);
     for i:=1 to length(UserID) do UserID[i]:=upcase(UserID[i]);
     Case ParamCount of
         0  : begin
                Listen;
                Delay(6000);
                If not readflg then
                  begin
                       Writeln;
                       Writeln('Nobody is Calling you..........');
                       IpxDeleteSocket(Socket);
                       halt(1);
                  end
                else
                  begin
                       readflg:=false;
                       ConNbrRec.Connections[1]:=ReadData[1];
                       GetInternetAddress(ConNbrRec.Connections[1],NetNod);
                       GetLocalTarget(NetNod,Socket,LocalTarget);
                       SendData[1]:=LocalConnectionNumber;
                       Send;
                       Talk;
                  end;
              end;

         1  : begin
                GetConnections(UserID,ConNbrRec);
                if ConNbrRec.Count = 0 then
                  begin
                    Writeln;
                    Writeln('User ID not available......');
                    IpxDeleteSocket(Socket);
                    halt(1);
                  end;
                if (ConNbrRec.Count = 1) and
                   (ConNbrRec.Connections[1] =  LocalConnectionNumber) then
                  begin
                    Writeln;
                    Writeln('Phoning YourSelf ????');
                    IpxDeleteSocket(Socket);
                    halt(1);
                  end;
                if ConNbrRec.Count = 1 then CallUser
                else
                  begin
                       Writeln;
                       Writeln('User ',Paramstr(1),' has multiple sessions');
                       Writeln('Please specify Connection Number..........');
                       IpxDeleteSocket(Socket);
                       halt(1);
                  end;
              end;
         2  : begin
                val(paramstr(2),ConNbr,Code);
                if code <> 0 then
                  begin
                    Writeln;
                    Writeln('Invalid Connection Number Entered.....');
                    halt(1);
                  end;
                GetConnections(UserID,ConNbrRec);
                if ConNbrRec.Count = 0 then
                  begin
                    Writeln;
                    Writeln('User ID not available......');
                    IpxDeleteSocket(Socket);
                    halt(1);
                  end;
                for code:=1 to ConNbrRec.Count do
                  begin
                    if ConNbrRec.Connections[code] = ConNbr then
                       ConNbrRec.Connections[1]:=ConNbr;
                  end;
                if (ConNbrRec.Connections[1] =  LocalConnectionNumber) then
                  begin
                    Writeln;
                    Writeln('Phoning YourSelf ????');
                    IpxDeleteSocket(Socket);
                    halt(1);
                  end;
                if ConNbrRec.Connections[1] = ConNbr then CallUser
                else
                  begin
                    Writeln;
                    Writeln('Connection: ',paramstr(2),' does not exist');
                    IpxDeleteSocket(Socket);
                    halt(1);
                  end;
              end;
         else
              begin
                Writeln;
                Writeln;
                Writeln('Phone Utility Command Syntax: ');
                Writeln;
                Writeln('Phone [[UserId] [Connection Number]]');
                halt(1);
              end;
     end; {Case}
end;
{-----------------------------------------------------------------------------}
{-----------------------------------------------------------------------------}
begin
     Setup;
     Process_Input_Command;
end.