/*|*********************************************************
|* 'ipxint.c'
|*
|* DOS IPX interface.
|*
|* -93     PS    Created
|*
|**********************************************************/

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include "ipxint.h"


/******************* Local data ***************************/
static bool _IPXCall=0;


/*$*********************************************************
$*
$* Check if IPX is installed.
$*
$**********************************************************/
int  IPXInitialize(void)
{
CREGS regs;
int   Fretval;

  Fretval=IPX_NOT_INSTALLED;
  _IPXCall=0;
  regs.x.ax=0x7A00;
  (void)int86(0x2f,&regs,&regs);
  if(regs.h.al==0xFF)
  {
    _IPXCall=1;
    Fretval=IPX_OK;
  }
  return(Fretval);
} /* IPXInitialize */


/*$*********************************************************
$*
$* Open an IPX socket.
$*
$**********************************************************/
int  IPXOpenSocket(u16 *socket,u8 socketType)
{
int   Fretval;
CREGS regs;

  Fretval=IPX_NOT_INSTALLED;
  if(_IPXCall)
  {
    regs.x.bx=IPXCMD_OPEN_SOCKET;
    regs.x.dx=Swap16(*socket);
    regs.h.al=socketType;
    (void)int86(IPXINT,&regs,&regs);
    if(*socket==0)
      *socket=Swap16(regs.x.dx);
    Fretval=regs.h.al;
  }
  return(Fretval);
} /* IPXOpenSocket */


/*$*********************************************************
$*
$* Close IPX socket.
$*
$**********************************************************/
void  IPXCloseSocket(u16 socket)
{
CREGS regs;

  if(_IPXCall)
  {
    regs.x.bx=IPXCMD_CLOSE_SOCKET;
    regs.x.dx=Swap16(socket);
    (void)int86(IPXINT,&regs,&regs);
  }
  return;
} /* IPXCloseSocket */


/*$*********************************************************
$*
$* Get router address for a specified IPX address.
$*
$**********************************************************/
int IPXGetLocalTarget(IPXADDRESS *IPXAddress,u8 *routerNode,
                      u16 *ticks)
{
CREGS regs;
CSEGS segs;
int   Fretval;

  Fretval=IPX_NOT_INSTALLED;
  if(_IPXCall)
  {
    segread(&segs);
    regs.x.bx=IPXCMD_GET_LOCAL_TARGET;
    segs.es=FP_SEG(IPXAddress);
    regs.x.si=FP_OFFSET(IPXAddress);
    regs.x.di=FP_OFFSET(routerNode);
    (void)int86x(IPXINT,&regs,&regs,&segs);
    Fretval=regs.h.al;
    *ticks=regs.x.cx;
  }
  return(Fretval);
} /* IPXGetLocalTarget */


/*$*********************************************************
$*
$* Send IPX packet.
$*
$**********************************************************/
void  IPXSendPacket(const ECB *eventControlBlock)
{
CREGS regs;
CSEGS segs;

  if(_IPXCall)
  {
    segread(&segs);
    regs.x.bx=IPXCMD_SEND_PACKET;
    segs.es=FP_SEG(eventControlBlock);
    regs.x.si=FP_OFFSET(eventControlBlock);
    (void)int86x(IPXINT,&regs,&regs,&segs);
  }
  return;
} /* IPXSendPacket */


/*$*********************************************************
$*
$* Start listening for IPX packet.
$*
$**********************************************************/
void  IPXListenForPacket(const ECB *eventControlBlock)
{
CREGS regs;
CSEGS segs;

  if(_IPXCall)
  {
    segread(&segs);
    regs.x.bx=IPXCMD_LISTEN_FOR_PACKET;
    segs.es=FP_SEG(eventControlBlock);
    regs.x.si=FP_OFFSET(eventControlBlock);
    (void)int86x(IPXINT,&regs,&regs,&segs);
  }
  return;
} /* IPXListenForPacket */


/*$*********************************************************
$*
$* Let IPX run.
$*
$**********************************************************/
void  IPXRelinquishControl(void)
{
CREGS regs;

  if(_IPXCall)
  {
    regs.x.bx=IPXCMD_RELINQUISH_CONTROL;
    (void)int86(IPXINT,&regs,&regs);
  }
  return;
} /* IPXRelinquishControl */


/*$*********************************************************
$*
$* End using IPX.
$*
$**********************************************************/
void IPXTerminate(void)
{
  _IPXCall=0;
  return;
} /* IPXTerminate */


/*$*********************************************************
$*
$* Reverse byte/word order of 16/32 bits.
$*
$**********************************************************/
u16 Swap16(u16 x)
{
  u16 y;

  y=(x&0xFF00u)>>8;
  y+=(x&0xFFu)<<8;
  return(y);
} /* Swap16 */


u32 Swap32(u32 y)
{
  u32 x;

  x=(y&0xFF000000uL)>>24;
  x+=(y&0xFF0000uL)>>8;
  x+=(y&0xFF00uL)<<8;
  x+=(y&0xFFuL)<<24;
  return(x);
} /* Swap32 */


