/***************************************************************
  DBGTRACE.C---

  NOTE: Remember to add  dbg_DebugWndProc to your .DEF file!!!
  NOTE: Remember to #define RV_DEBUG if you want actual debug code ON.

  Has been ported to Win32 (Windows/NT).

  Tab stops in my editor are set at 8 spaces.
  
****************************************************************/

#include "config.h" /*this enables debug code via "#define RV_DEBUG"*/


#ifdef DEBUG_TRACE_ENABLED


#include <windows.h>
#ifdef WIN32
#include "win32prt.h"
#endif
#include "std_defs.h"
#include "dbgtrace.h"

/*******************************************************************/

PRIVATE VOID dbg_PutLine(LPSTR msg);

typedef short PIXEL;

PRIVATE PIXEL widthDebugWindow;
PRIVATE PIXEL depthDebugWindow;
PRIVATE PIXEL theRowIncrement;

PRIVATE RECT  theDebugWndSize;

PRIVATE BOOL  is_output_enabled;
PRIVATE BOOL  is_window_created;

PRIVATE HWND  hDebugWindow;
PRIVATE int   extra_bytes_used;

PRIVATE VOID  dbg_UpdateWindowSize    (VOID);
PRIVATE VOID  dbg_OutputToScreen      (LPSTR);
PRIVATE VOID  dbg_RawTextOut          (PIXEL,PIXEL,LPSTR);
PRIVATE VOID  dbg_ClearScreen         (VOID);
PRIVATE VOID  dbg_GoTopOfScreen	      (VOID);


/****************************************************************/
PUBLIC VOID dbg_Trace(LPSTR msg)
{
    dbg_PutLine(msg);
}
/****************************************************************/
PRIVATE VOID dbg_PutLine(LPSTR msg)
{
      if (is_output_enabled) dbg_OutputToScreen(msg);
}

/****************************************************************/

PUBLIC BOOL dbg_CreateDebugWindow(
    HINSTANCE app_instance,
    HWND hParentWindow,
    int  value_of_extra_bytes)
{
    int  cxScreen = GetSystemMetrics(SM_CXSCREEN);
    int  cyScreen = GetSystemMetrics(SM_CYSCREEN);
    int  top,left,width,depth;
    RECT r;

    if(is_window_created) return TRUE;
    else is_window_created = TRUE;
     
    GetClientRect(hParentWindow, &r);

    /*----the following are hard-wired "magic" numbers for VGA----*/
    theRowIncrement = 15;
    left = 25;
    top = (cyScreen - (cyScreen/3));
    width = cxScreen - 50;
    depth = (cyScreen/3)-25;
    /*-----above vars should be set dynamically at run-time------*/

    hDebugWindow = CreateWindow(
        "Debug",  /* class name */
         "Debug Trace Window", /* window title */
         WS_POPUP | WS_CAPTION | WS_SYSMENU | WS_SIZEBOX
         | WS_CLIPSIBLINGS | WS_VISIBLE | WS_BORDER, 
        left,top,width,depth,
        hParentWindow,
        (HMENU)NULL,
        app_instance,
        NULL
        );

    if(!hDebugWindow) return FALSE;
     
    if (extra_bytes_used)
        SetWindowWord(hDebugWindow,0,value_of_extra_bytes);

    ShowWindow(hDebugWindow, SHOW_OPENWINDOW);
    BringWindowToTop(hDebugWindow);
    UpdateWindow(hDebugWindow);
    return TRUE;
}
/*******************************************************************/
PRIVATE VOID dbg_UpdateWindowSize(VOID)
{
    if(hDebugWindow)
    {
	RECT r; /*MS-Windows RECT rather than our RECT structure */

	GetClientRect(hDebugWindow, &r);
	theDebugWndSize.top    = r.top;
	theDebugWndSize.left   = r.left;
	theDebugWndSize.right  = r.right;
	theDebugWndSize.bottom = r.bottom;
	widthDebugWindow     = theDebugWndSize.right  - theDebugWndSize.left;
	depthDebugWindow     = theDebugWndSize.bottom - theDebugWndSize.top;
    }
}
/****************************************************************/
PRIVATE VOID dbg_ClearScreen(VOID)
{
    HBRUSH  hOldBrush;
    HPEN hOldPen;
    HDC     hDC;
    if(hDebugWindow)
    {
    hDC = GetDC(hDebugWindow);

    SetBkMode(hDC, OPAQUE);
    /*SetBkColor( hDC, WHITE );*/

    hOldPen   = SelectObject(hDC, GetStockObject(WHITE_PEN));
    hOldBrush = SelectObject(hDC, GetStockObject(WHITE_BRUSH));

    SetROP2(hDC, R2_COPYPEN);

    Rectangle(hDC,
    	 theDebugWndSize.left,  theDebugWndSize.top,
    	 theDebugWndSize.right, theDebugWndSize.bottom);

    SelectObject(hDC, hOldPen);
    SelectObject(hDC, hOldBrush);

    ReleaseDC(hDebugWindow, hDC);
    }
    dbg_GoTopOfScreen();
}
/****************************************************************/
PRIVATE VOID  dbg_RawTextOut( PIXEL   x, PIXEL   y, LPSTR  s)
{
    if(hDebugWindow && is_output_enabled)
    {
	HDC   hDC = GetDC(hDebugWindow);
	TextOut(hDC,x,y,  s, lstrlen(s));
	ReleaseDC(hDebugWindow, hDC);
     }
}
/****************************************************************/
PUBLIC BOOL dbg_RegisterDebugWindow(HANDLE hInstance, int num_extra_bytes)
{
    WNDCLASS wc;

#ifdef WIN32
    memset(&wc,0,sizeof(WNDCLASS));
#endif
     /* Now set up the class structure contents */
     wc.hCursor       = (HANDLE) NULL;
     wc.hIcon         = (HANDLE) NULL;
     wc.lpszMenuName  =   NULL;
     wc.lpszClassName =  "Debug";
     wc.hbrBackground = GetStockObject( WHITE_BRUSH );
     wc.hInstance     = hInstance;
     wc.style         = CS_VREDRAW | CS_HREDRAW;
     wc.lpfnWndProc   = dbg_DebugWndProc;
     wc.cbClsExtra    = 0;
     wc.cbWndExtra    = num_extra_bytes;

     extra_bytes_used = (num_extra_bytes > 0);

     if (!RegisterClass( &wc ) )
     {
               return FALSE;
     }
     return TRUE;
}
/*******************************************************************/
PUBLIC LONG EXPORTED dbg_DebugWndProc(
     HWND	hWnd,
     UINT	message,
     WPARAM wParam,
     LPARAM lParam)
{
    PAINTSTRUCT ps;

    hDebugWindow = hWnd;
    switch (message)
    {
        case WM_DESTROY:
	{
	    is_output_enabled = FALSE;
	} break;

	case WM_CREATE:
	{
	    is_output_enabled = TRUE;
	    dbg_UpdateWindowSize();
	    dbg_PutLine("debugProc: WM_CREATE");
	} break;
    
	case WM_MOVE:
	{
	    dbg_UpdateWindowSize();
	    dbg_PutLine("debugProc: WM_MOVE");
	} break;	

	case WM_PAINT:
	{
	    BeginPaint(hWnd, (LPPAINTSTRUCT) & ps);
	    EndPaint(  hWnd, (LPPAINTSTRUCT) & ps);
	    dbg_UpdateWindowSize();
	} break;

	case WM_LBUTTONDOWN:
	{
	    BringWindowToTop(hDebugWindow);
	} break;

	case WM_LBUTTONUP:
	{
	    dbg_PutLine(fmtStr("DebugWndProc: lbuttonup  h=%d v=%d",
    		 (short) LOWORD(lParam), (short) HIWORD(lParam)));
	} break;
    }
    return DefWindowProc(hWnd, message, wParam, lParam);
}

/*****************************************************************
LOWER LEVEL FUNCTIONS
******************************************************************/

#define LEFT_MARGIN 5
#define TOP_MARGIN 15
#define X_INCR 320

PRIVATE PIXEL currentX;
PRIVATE PIXEL currentY;

/****************************************************************/
PRIVATE VOID dbg_GoTopOfScreen(VOID)
{
    currentX = LEFT_MARGIN; currentY = TOP_MARGIN;
}

/****************************************************************/
PRIVATE VOID  dbg_OutputToScreen(LPSTR p)
{
     dbg_RawTextOut(currentX, currentY, p);

     currentY += theRowIncrement;

     if (currentY + TOP_MARGIN > (depthDebugWindow - theRowIncrement))
     {
    	currentX += X_INCR;     currentY = TOP_MARGIN;
     }
     if (currentX > widthDebugWindow - 190)
     {
    	currentX = LEFT_MARGIN;    dbg_ClearScreen();
     }
}



/****************************************************************
    TIMER STUFF
*****************************************************************/    

PRIVATE DWORD theTicks;

PUBLIC VOID
dbg_StartTimer(VOID)
{
    theTicks = GetTickCount();
}

PUBLIC VOID
dbg_StopTimer(LPSTR msg)
{
    DWORD t = GetTickCount();
    t = t - theTicks;
    dbg_PutLine(msg);
    dbg_PutLine(fmtStr("Time=%ld",(long)t));
}


#endif /*DEBUG_TRACE_ENABLED */
