/*-----------------------------------------------------------------------
| intexamp.c - Demonstrate how to communicate with Int Monitor          |
-----------------------------------------------------------------------*/
#include <stdio.h>
#include <bios.h>
#include <dos.h>
#include <graph.h>
#include <ctype.h>

#define VIDEO 0x10                              //Software interrupt 0x10   
#define WRITE_ATTR_CHAR 9                       //Function     
#define ENABLE_ALL 2
#define ENAB_LOG_BRK 3
#define USER_INT 0x61

enum {FALSE, TRUE};



void do_data_entry(struct scntrl *);
void disp_screen(struct _scrn *, unsigned short);
unsigned int edit_yorn (unsigned char *);


struct _scrn	{
		char	*chrs;
		char	cw;
		char	rw;
		char	att;
		};
struct _scrn screen_intexamp[]={

	{"ͻ",10,3,31},
	{"                ",10,4,31},
	{"Int Monitor Control Interface",27,4,121},
	{"               ",56,4,31},
	{"                                                            ",10,5,31},
	{"      Enable ALL logging (y/n):                             ",10,6,31},
	{"  Enable ALL breakpoints (y/n):                             ",10,7,31},
	{" Interrupt for ALL breakpoints:                             ",10,8,31},
	{"                                                            ",10,9,31},
	{"              Interrupt number:                             ",10,10,31},
	{"                                                            ",10,11,31},
	{" Enable log on interrupt (y/n):                             ",10,12,31},
	{"                                                            ",10,13,31},
	{"Enable break on interrupt (y/n):                            ",10,14,31},
	{"                                                            ",10,15,31},
	{" Conditions for logging or breaking on this interrupt       ",10,16,31},
	{"                                                            ",10,17,31},
	{"    Conditional value in AL (ff for none):                  ",10,18,31},
	{"    Conditional value in Ah (ff for none):                  ",10,19,31},
	{"                                                            ",10,20,31},
	{"            (C) Copyright ASMicro Co. 1991, 1992            ",10,21,31},
	{"ͼ",10,22,31},
	{"\0",0,0,0}
	};


struct  scntrl  {
                char    row;                    
                char    col;
                char    *format;
                unsigned char *assign_to;
                unsigned int (*wedit) ();
                };

union REGS inregs_func2, inregs_func3, outregs;

struct scntrl cntrl_data[]={
                        { 6, 43, "%c", &inregs_func2.h.al, edit_yorn},
                        { 7, 43, "%c", &inregs_func2.h.dl, edit_yorn},
                        { 8, 43, "%2x", &inregs_func3.h.bl, (int(*)()) NULL},
                        {10, 43, "%2x", &inregs_func3.h.al, (int(*)()) NULL},
                        {12, 43, "%c", &inregs_func3.h.dl, edit_yorn}, 
                        {14, 44, "%c", &inregs_func3.h.bh, edit_yorn},
                        {18, 54, "%2x", &inregs_func3.h.cl, (int(*)()) NULL},        
                        {19, 54, "%2x", &inregs_func3.h.ch, (int(*)()) NULL},        
                        {0,0,"", "", (int(*)()) NULL}
                        };

long color_back_grnd= 1;          //All screens will use a blue background  
int     wint;

main()
{
unsigned far * vector_ptr;

        vector_ptr=(unsigned far *) ((USER_INT << 2) + 2);    //cs of user isr  
        if ( *vector_ptr == 0)          //if user int not installed
        {
                puts ("INTM not installed.");
                exit(1);
        }

        do_data_entry(cntrl_data);



        inregs_func2.h.ah=ENABLE_ALL;         //function to set global on/off

       	int86 ( USER_INT, &inregs_func2, &outregs );  //do user int

        inregs_func3.h.ah=ENAB_LOG_BRK ;      //function to set specific ints

       	int86 ( USER_INT, &inregs_func3, &outregs );  //do user int


}

void do_data_entry(struct scntrl * cntrl_dat)
{

        disp_screen(screen_intexamp, TRUE);

        while( cntrl_dat->row  || *(cntrl_dat->format) )
        {
                fflush(stdin);                  //flush buffer
                       
                _settextposition( (short) cntrl_dat->row, (short) cntrl_dat->col);

                if (scanf(cntrl_dat->format, &wint) < 1) continue; 

                if ( *(cntrl_dat->wedit) )
                {
                        if ( ( *(cntrl_dat->wedit))(cntrl_dat->assign_to) ) continue; //edit
                }
                else *(cntrl_dat->assign_to) = (unsigned char) wint;
                        
                ++cntrl_dat;
        }        

 }

/*-----------------------------------------------------------
| edit_yorn - Ensure that unsigned char, from passed ptr,   |
|             is either 'y' or 'n'.  If it isn't, return    |
|             TRUE.                                         |
|                                                           |
|             If it is, assign 1 if 'y' and 0 if 'n' and    |
|             return FALSE.                                 |
------------------------------------------------------------*/
unsigned int edit_yorn(unsigned char * uc_ptr)

{

        wint=isupper(wint) ? tolower(wint) : wint ;
        if ( (char) wint != 'y' && (char) wint != 'n' ) return(TRUE);
        *uc_ptr=((char) wint == 'y') ? 1 : 0;
        return(FALSE);
}


/*-----------------------------------------------------------
| disp_screen - Use ptr passed to array of structures       |
|               containing &text; col; row; and attribute.  |
|               Use BIOS int 10h function 9 to display the  |
|               data.                                       |
|                                                           |
|               If cls_flag is TRUE, clear the screen before|
|               displaying the data.  When clearing the     |
|               screen, use the attribute defined in the    |
|               variable color_back_grnd                    |
------------------------------------------------------------*/

void disp_screen(struct _scrn *p, unsigned short cls_flag)
{
char work;
char wrow;
char wcol;
char * wsptr;

union REGS inregs, outregs;


        if (cls_flag)
        {
                _setbkcolor(color_back_grnd);
                _clearscreen(_GCLEARSCREEN);
        }

	inregs.h.ah = WRITE_ATTR_CHAR;  		//print char and attribute  
	inregs.x.cx = 1;				//Print 1 char  

	while ( *(p->chrs) )
	{
		wsptr=p->chrs;				//Get ptr to string  
		wcol=p->cw;

		inregs.h.bh = 0;		   	//Video page 0  
		inregs.h.bl = p->att;         	   	//Attribute to use   

		while (inregs.h.al = *wsptr++)          //Char to print  
		{

                        /*Position the cursor*/

			_settextposition( (short) p->rw, (short) wcol++);             

			int86 ( VIDEO, &inregs, &outregs ); //Print with BIOS  
		}

		p++;
	}
}

