/*-----------------------------------------------------------------------
| intdisp.c - Display data captured with Int Monitor                    |
|            (must compile with -Zp to pack structures)                 |
-----------------------------------------------------------------------*/
#include <stdio.h>
#include <bios.h>
#include <dos.h>

#define USER_INT 0x61
#define BUFFER_SIZE 4096

enum {FALSE, TRUE};

struct buf_record       {
        		unsigned char  buf_int;     
	        	unsigned short buf_ax;      
	        	};
main()
{
struct buf_record far * buf_ptr;
unsigned far * vector_ptr;
union REGS inregs, outregs;
register unsigned x;

        vector_ptr=(unsigned far *) ((USER_INT << 2) + 2);    //cs of user isr  
        if ( *vector_ptr == 0)          //if user int not installed
        {
                puts ("INTM not installed.");
                exit(1);
        }

        inregs.h.ah=0;          //function to return ptr             
       	int86 ( USER_INT, &inregs, &outregs );  //do user int
        FP_SEG(buf_ptr)=outregs.x.dx;
        FP_OFF(buf_ptr)=outregs.x.bx;

                puts ("Int     AX Value ");
        for (x=0;x< ( BUFFER_SIZE  / sizeof(struct buf_record)) && \
             (buf_ptr->buf_int || buf_ptr->buf_ax );x++,buf_ptr++)
        {               
                printf (" %2x \t  %04x \n", buf_ptr->buf_int, buf_ptr->buf_ax);
        }
}






