/********************************************************
 * h_check -- Check the heap log file and match 	*
 *		malloc/free pairs.  Very useful for	*
 *		find memory leaks			*
 *							*
 * Usage:						*
 *	h_check 					*
 *							*
 * Report is written to standard out.			*
 ********************************************************/
#include <stdio.h>
#include <alloc.h>
#include <stdlib.h>
#include <string.h>

#define LOG "MEM.LOG"
/*
 * Size of the list of currently open items
 */
#define N_ITEMS 3000	

struct log_entry {	/* An entry in the log file */
   int ret1, ret2;	/* The return address parts 1 & 2 */
   int ptr1, ptr2;	/* The pointer parts 1 & 2 */
};

static struct log_entry *allocated;	/* List of stuff allocated */
static int n_allocated = 0;		/* Number of items in list */

/* This list contains things freed, but never allocated */
static struct log_entry *un_alloc;	/* List of stuff unallocated */
static int n_un_alloc = 0;		/* Number of things in list */

/********************************************************
 * cmp_log -- compare two log entries			*
 *							*
 * Parameters						*
 *	L1, L2 -- log entries 				*
 *							*
 * Returns						*
 *	L1 - L2						*
 ********************************************************/
static int cmp_log(const void *L1, const void *L2)
{
#define l1 ((struct log_entry *)L1)    
#define l2 ((struct log_entry *)L2)
    int result;

    result = l1->ret1 - l2->ret1;
    if (result != 0) return (result);

    result = l1->ret2 - l2->ret2;
    if (result != 0) return (result);

    result =  (l1->ptr1 - l2->ptr1);
    if (result != 0) return (result);

    result =  (l1->ptr1 - l2->ptr1);
    return (result);
}

main(int argc, char *argv[])
{
    FILE *in_file;	/* File to read data from */
    int i,j;		/* Loop indices */
    int ptr1, ptr2;	/* Pointer from line */
    int ret1, ret2;	/* Return address from line */
    char type[30];	/* Type of i/o from line */
    char line[80];	/* Line from log file */
    long int in_line_number = 0;	/* Input line number */

    allocated = malloc(sizeof(struct log_entry) * N_ITEMS);
    un_alloc = malloc(sizeof(struct log_entry) * N_ITEMS);

    if ((allocated == NULL) || (un_alloc == NULL)) {
	fprintf(stderr,"Out of memory\n");
	abort();
    }

    fprintf(stderr,"Allocation size %d\n", sizeof(struct log_entry) * N_ITEMS);

    in_file = fopen((argc == 1) ? LOG : argv[1], "r");
    if (in_file == NULL) {
	fprintf(stderr,"Error: Unable to find %s\n", 
		(argc == 1) ? LOG : argv[1]);
        exit (8);
    }

    /*
     * Loop while we have more memory */
    while (coreleft() > 5000L) {
top:
	in_line_number++;
	if ((in_line_number % 1000) == 0) {
	    fprintf(stderr,
		"Progress line %ld alloc %d un_alloc %d core %ld\n",
		in_line_number, n_allocated, n_un_alloc, coreleft());
	    fflush(stderr);
        }

	if (fgets(line, sizeof(line), in_file) == NULL)
	    break;

	if (line[0] == '#')
	    continue;		/* Skip comments */

	sscanf(line, "%s %x:%x %x:%x\n",
		type, &ret1, &ret2, &ptr1, &ptr2);

	/*
	 * If it is a free, check for allocated
	 */
	if (strcmp(type, "free") == 0) {
	    for (i = 0; i < n_allocated; i++) {
		if ((allocated[i].ptr1 == ptr1) &&
		    (allocated[i].ptr2 == ptr2)) {
		    for (j = i; j < n_allocated; j++) {
		       allocated[j] = allocated[j+1];
		    }
		    n_allocated--;
		    goto top;
		}
	    }
	    /* We didn't find it */
	    un_alloc[n_un_alloc].ptr1 = ptr1;
	    un_alloc[n_un_alloc].ptr2 = ptr2;
	    un_alloc[n_un_alloc].ret1 = ret1;
	    un_alloc[n_un_alloc].ret2 = ret2;
	    n_un_alloc++;

	} else if (strcmp(type, "malloc") == 0) {

	    allocated[n_allocated].ptr1 = ptr1;
	    allocated[n_allocated].ptr2 = ptr2;
	    allocated[n_allocated].ret1 = ret1;
	    allocated[n_allocated].ret2 = ret2;
	    n_allocated++;
	} else
	    fprintf(stderr,"Error: Strange allocate type %s\n", type);

    }

    qsort(allocated, n_allocated, sizeof(struct log_entry), cmp_log);
    for (i = 0; i < n_allocated; i++) {
	printf("Never Freed Ptr: 0x%04x:0x%04x Ret: %04x:%04x\n",
		allocated[i].ptr1,
		allocated[i].ptr2,
		allocated[i].ret1,
		allocated[i].ret2);
    }

    qsort(un_alloc, n_un_alloc, sizeof(struct log_entry), cmp_log);
    for (i = 0; i < n_un_alloc; i++) {
	printf("Never Alloc Ptr: 0x%04x:0x%04x Ret: %04x:%04x\n",
		un_alloc[i].ptr1,
		un_alloc[i].ptr2,
		un_alloc[i].ret1,
		un_alloc[i].ret2);
    }
    return (0);
}
