(* ----------------------------------------------------------- *(
**  palpak.pas -- Algorithm #13: Palindrome Encryption         **
** ------------------------------------------------------------**
**                                                             **
**  Demonstrates a data encryption technique for producing     **
**  keys or signatures. Microsoft Calendar files, for example, **
**  begin with signature bytes formed by applying the          **
**  algorithm to the word Calendar. There is no known recovery **
**  method for restoring text encrypted using this method.     **
**                                                             **
** ------------------------------------------------------------**
**     Copyright (c) 1993 by Tom Swan. All rights reserved.    **
)* ----------------------------------------------------------- *)

program PalPak;
var S1, S2: String;

function Uch(C: Char): Integer;
begin
  if (C in ['a' .. 'z']) then
    Uch := Ord(C) - 32
  else
    Uch := Ord(C)
end;

function Lch(C: Char): Integer;
begin
  if (C in ['A' .. 'Z']) then
    Lch := Ord(C) + 32
  else
    Lch := Ord(C)
end;

procedure Encrypt(S: String);
var I, E, C: Integer;
begin
  I := 1;
  E := Length(S);
  while (I <= Length(S)) do
  begin
    C := Uch(S[I]) + Lch(S[E]);
    Write(C, ' ');
    I := I + 1;
    E := E - 1
  end
end;

var S: String;

begin
  repeat
    Write('Enter a string: ');
    Readln(S);
    if Length(S) > 0 then
    begin
      Write('Encrypted string: ');
      Encrypt(S);
      Writeln
    end
  until Length(S) = 0;
end.


(*
// ---------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 08/06/1993   Time: 09:31 am
*)

