/* ----------------------------------------------------------- *\
**  decomp5.cpp -- Decompress file compressed with comp5.      **
** ----------------------------------------------------------- **
**                                                             **
** ----------------------------------------------------------- **
**   Copyright (c) 1993 by Chuck Guzis. All rights reserved.   **
\* ----------------------------------------------------------- */

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <ctype.h>

#define LINE_MAX 128              // Length of the longest line
typedef unsigned char UCHAR;      // Define a UCHAR
typedef unsigned int UINT;        // Define a UINT
FILE *in;                         // Input file
FILE *out;                        // Output file

//  Our 5-bit alphabet.
char Alphabet[] = "abcdefghijklmnopqrstuvwxyz ,.;- ";

//  Function prototypes.
void main( int, char **);          // Main function
void Error( char *, char *);       // Error routine
void Decompress( void);            // Decompress

void main( int argc, char *argv[])
{
  in = NULL;
  out = NULL;

//  Open the files, give an error if problems arise.
  if ( argc != 3)
    Error( "Command form is - DECOMP5 <in-file> <out-file>\n", NULL);
  if ( !(in = fopen( argv[1], "rb")) )
    Error( "Can\'t open %s.\n", argv[1]);
  if ( !(out = fopen( argv[2], "w")) )
    Error( "Can\'t create %s.\n", argv[2]);

//  Read the input file, decode it.
  Decompress();
  fclose(in);
  fclose( out);
  exit(0);
}  // End of main

//  Decompress - Read and decompress the data.
//  ------------------------------------------
//  This routine does all of the work. Single-character I/O is done
//  in the interest of simplicity.

void Decompress( void)
{
  UCHAR ch;             // Current character
  UINT k;               // Scratch word cell

  while( !feof(in))
  { // Read and decode
    ch = (UCHAR) fgetc( in);
    if ( ch & 0x80)
    { // Special flagging, packed 5 bits
      k = (ch << 8);
      ch = (UCHAR) fgetc( in);
      k |= ch;           // Form a word
      fputc( Alphabet[ (k >> 10) & 31], out);
      fputc( Alphabet[ (k >> 5) & 31], out);
      fputc( Alphabet[ k & 31], out);   // Unpack all three
    }
    else
    {
      if ( ch == 0)
      { // Escape or repeated byte
    ch = (UCHAR) fgetc( in);
    if ( ch < 128)
    { // Repeated byte
      k = ch;
      ch = (UCHAR) fgetc( in);  // Get the actual byte
      while (k--)
        fputc( ch, out);        // Write the repeated byte
    }
    else
      fputc( ch, out);      // Not repeated, but just quoted
      }
      else
    fputc( ch, out);        // Just an ordinary character
    } // If not flagged
  } // Read the input
  return;
} // Decompress

//  Error - Give an error and a message, then exit.
//  -----------------------------------------------
//  A string argument may be given, if desired.

void Error( char *msg, char *str)
{
  if ( in)
    fclose(in);         // Close files if still open
  if ( out)
    fclose( out);
  if ( str)
    fprintf( stderr, msg, str);
  else
    fprintf( stderr, msg);
  exit(1);
} // Error
