/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	error;
include	regexp;
include	filesys;
include	file;

Pattern:	searchPattern;

main:	entry	() =
	{
	Pattern = [ TRUE ];
	if	(ArgumentCount >= 2){
		if	(!Pattern compile(getNextArgument())){
			printf("Improper pattern\n");
			return;
			}
		while	(ArgumentCount)
			expandsubpath(getNextArgument());
		}
	else
		printf("Use is: GREP pattern file(s)\n");
	}

expandsubpath:	(filename: [:] char) =
	{
	ff:	finder;
	dir:	[:] char;
	pat:	[:] char;

	dir = getDirectory(filename);
	pat = stripDirectory(filename);
	if	(ff open(dir, pat, 0) != SUCCESS)
		printf("Could not open %s\n", filename);
	else	{
		while	(ff next() == SUCCESS)
			grepFile(ff.pathname);
		}
//	ff close();
	}

grepFile:	(s: [:] char) =
	{
	fd:	stream;
	cp:	* byte;
	data:	* byte;
	buf:	[:] byte;
	len:	long;

	if	(fd open(s, AR_READ) != SUCCESS){
		printf("Couldn't open %S\n", s);
		return;			// Shouldn't happen
		}
	len = fd seek(0, SEEK_END);
	fd seek(0, SEEK_ABS);
	cp = alloc(len);
	if	(cp == 0){
		printf("Not enough memory for %S\n", s);
		fd close();
		return;
		}
	data = cp;
	buf = cp[:len];
	len = fd read(buf);
//	printf("|buf = %d len = %d\n", |buf, len);
	fd close();

	endp:	* char;

	endp = cp + len;
	while	(cp < endp){
		foundLen:	int;
		match:		* char;
		lineLen:	int;
		line:		* char;

		foundLen = Pattern search(cp, endp, &match);
//		printf("foundLen = %d\n", foundLen);
		if	(foundLen == -1)
			break;
		line = match;
		while	(match > cp){
			if	(*match == '\n'){
				match++;
				break;
				}
			match--;
			}
		cp = line;
		lineLen = cp - match;
		while	(cp < endp){
			if	(*cp == '\n'){
				cp++;
				break;
				}
			cp++;
			lineLen++;
			}
		printf("%S: %.*s\n", s, lineLen, match);
		}
	free(data);
	}
