/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	file;
include	filesys;
include	error;
include	alys;

ListDetail:	int = 1;
TotalSize:	unsigned;
Directory:	[:] char;

main:	entry	() =
	{
	arg:	[:] char;
	listed:	int;
	files:	int;

	listed = 0;
	files = 0;
	while	(ArgumentCount){
		arg = getNextArgument();
		if	(arg[0] == '-'){
			if	(arg[1] == 'l'){
				if	(arg[2] == '-')
					ListDetail = 0;
				else
					ListDetail = 1;
				}
			}
		else	{
			files += listName(arg);
			listed++;
			}
		}
	if	(listed == 0){
		arg = "*";
		files += listName(arg);
		}
	if	(ListDetail){
		if	(files == 0)
			printf("  No files");
		else	{
			printf("%4d File", files);
			if	(files > 1)
				printf("s");
			else
				printf(" ");
			}
		printf(" %10u Bytes Used", TotalSize);
		if	(listed <= 1){
			dx:	drive_t;

			if	(|Directory == 0)
				Directory = ".";
			dx = FileSystem getDriveInfo(Directory);
			printf(" %10u Bytes Free", 
					dx.freeSectors * dx.sectorSize);
			}
		printf("\n");
		}
	}

listName:	(path: [:] char) int =
	{
	hour:	int;
	c:	char;
	fCount:	int;
	arg:	* char;
	i:	int;
	fdir:	[:] char;
	fpattern:	[:] char;
	fext:	[:] char;
	patha:	static	[MAXPATH] char;
	pathb:	static	[MAXPATH] char;
	xp:	* char;
	fp:	* char;
	f:	finder;
	fs:	file_t;

	fs = FileSystem stat(path);
//	printf("path = %S\nfs = [ attr %x, sz %d, time %x user %d group %d id %d ]\n",
//			path, fs.attributes, fs.size, fs.ftime, fs.user, fs.group, fs.id);
	if	(fs.id != -1 &&
		 fs.attributes & FA_DIR){
		fdir = path;
		fpattern = "*";
//		printf("%S is a directory\n", path);
		}
	else	{
		fdir = getDirectory(path);
		fpattern = stripDirectory(path);
		}
	fCount = 0;
	i = f open(fdir, fpattern, FA_DIR);
	Directory = fdir;
	if	(i){
		printf("%s\n", cmdError(i));
		return 0;
		}
	while	(f next() == 0){
		if	(ListDetail){
			if	(f.attrib & FA_NETNODE)
				printf("  <node>");
			else if	(f.attrib & FA_DIR)
				printf("   <dir>");
			else
				printf("%8d", f.size);
			if	(f.attrib & (FA_DIR|FA_WRITE) == 0)
				printf("r");
			else
				printf(" ");
			hour = f.ftime >> 11 & 0x1f;
			if	(hour >= 12){
				c = 'p';
				hour -= 12;
				}
			else
				c = 'a';
			printf(" %2d-%02d-%02d %2d:%02d%c   ",
				f.ftime >> 21 & 0x0f,
				f.ftime >> 16 & 0x1f, 
				((f.ftime >> 25 & 0x7f) + 80) % 100,
				hour, f.ftime >> 5 & 0x3f, 
				c);
			TotalSize += f.size;
			}
		printf("%S\n", f.pathname);
		fCount++;
		}
	f close();
	return fCount;
	}
