/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	file;

include	parser;
include	hash;
include	errmsg;
include	sbuffer;
include	symtab;
include	types;
include	backend;
include	ptree, xtree, xcall;
include	target;
include	addrmode;
include	alloctmp;

errorStmt_x:	public	type	inherit	stmt_x	{
	public:

	offset:		fileOffset;

create:	factory	(o: fileOffset) ref errorStmt_x =
	{
	return new errorStmt_x[ O_ERROR, o ];
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	}

	};

funcExit_x:	public	type	inherit	stmt_x	{
	public:

create:	factory	() ref funcExit_x =
	{
	self = alloc(sizeof funcExit_x);
	self = [ O_EXIT ];
	return self;
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	}

	};

block_x:	public	type	inherit stmt_x {
	public:

	stmts:		* stmt_x;

		// Assigned information

	scope:		blockScope;

constructor:	(x: ref stmt_x) =
	{
	super constructor(O_BLOCK);
	stmts = x;
	scope = [ 0, 0 ];
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	sym:	ref symbol_s;

	for	(sym = scope.symbols; sym; sym = sym->next){
		printf("%*c%S: ", indent + INDENT_AMOUNT, ' ',
						 sym->name spelling());
		if	(sym->dtype)
			sym->dtype display(FALSE);
		printf("\n");
		}
	s:	ref stmt_x;

	for	(s = stmts; s; s = s->next)
		s display(indent + INDENT_AMOUNT);
	}

fold:	dynamic	() ref tree_p =
	{
	s:	ref stmt_x;

	for	(s = stmts; s; s = s->next){
//		if	(s->operator != O_BLOCK)
//			s display(0);
		s fold();
		}
	return self;
	}

computeBenefits:	dynamic	(int) =
	{
	s:	ref stmt_x;

	for	(s = stmts; s; s = s->next)
		s computeBenefits(nestingLevel);
	}

markTemps:	dynamic	() =
	{
	s:	ref stmt_x;

	TargetData.currentScope = &scope;
	for	(s = stmts; s; s = s->next)
		s markTempsAndSpills();
	}

assignTypes:	dynamic	(s: ref scope_s, boolean) ref tree_p =
	{
	st:	ref stmt_x;
	nst:	ref stmt_x;

	scope = [ s, 0 ];
	for	(st = stmts; st; st = st->next)
		st gatherDeclarations(&scope);
	scope constructInterfaces();
	scope constructValues();
	for	(st = stmts; st; st = st->next){
//		if	(st->operator != O_BLOCK)
//			st display(0);
		st assignTypes(&scope, FALSE);
		}
	sym:	ref symbol_s;

	for	(sym = scope.symbols; sym; sym = sym->next)
		if	(sym->var)
			sym->var->dtype = sym->dtype getType();
	return self;
	}

	};

assert_x:	public	type	inherit stmt_x {
	public:

	test:		* tree_p;
	source:		textRange;

create:	factory	(x: ref tree_p, s: textRange) ref assert_x =
	{
	if	(x == 0)
		return 0;
	self = alloc(sizeof assert_x);
	self = [ O_ASSERT, x ];
	source = s;
	return self;
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	if	(test)
		test display(indent + INDENT_AMOUNT);
	}

fold:	dynamic	() ref tree_p =
	{
	test = test fold();
	test sethiUllman();
	return self;
	}

computeBenefits:	dynamic	(int) =
	{
	test computeBenefits(nestingLevel);
	}

assignTypes:	dynamic	(s: ref scope_s, boolean) ref tree_p =
	{
	if	(test){
		test = test assignTypes(s, TRUE);
		}
	return self;
	}

markTemps:	dynamic	() =
	{
	markAddressModes(test);
	assignTempRegisters(test, operator);
	}

generateC:	dynamic	() =
	{
	if	(test){
		Project.outputFd printf("assert(");
		test generateCode();
		Project.outputFd printf(");\n");
		}
	}

	};

expr_x:	public	type	inherit stmt_x {
	public:

	expr:		* tree_p;
	source:		textRange;

constructor:	(x: ref tree_p, s: textRange) = 
	{
	super constructor(O_STMT);
	expr = x;
	source = s;
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	if	(expr)
		expr display(indent + INDENT_AMOUNT);
	}

fold:	dynamic	() ref tree_p =
	{
	expr = expr fold();
	CurrentContext.offset = source.start;
	expr = expr checkForNoEffect();
	if	(expr)
		expr sethiUllman();
	return self;
	}

computeBenefits:	dynamic	(int) =
	{
	if	(expr)
		expr computeBenefits(nestingLevel);
	}

markTemps:	dynamic	() =
	{
	markAddressModes(expr);
	assignTempRegisters(expr, operator);
	}

assignTypes:	dynamic	(s: ref scope_s, boolean) ref tree_p =
	{
	if	(expr)
		expr = expr assignTypes(s, FALSE);
	else
		expr = ErrorTree;
	return self;
	}

	};

endExcept_x:	public	type	inherit stmt_x {
	public:

	myTry:		ref try_x;

create:	factory	(m: ref try_x) ref endExcept_x =
	{
	self = alloc(sizeof endExcept_x);
	self = [ O_ENDEX, m ];
	return self;
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	}

assignTypes:	dynamic	(ref scope_s, boolean) ref tree_p =
	{
	return self;
	}

	};

continueExcept_x:	public	type	inherit stmt_x {
	public:

create:	factory	() ref continueExcept_x =
	{
	return new continueExcept_x[ O_CONTEX ];
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	}

assignTypes:	dynamic	(ref scope_s, boolean) ref tree_p =
	{
	return self;
	}

	};

return_x:	public	type	inherit stmt_x {
	public:

	expr:		* tree_p;
	source:		textRange;

create:	factory	(x: ref tree_p, s: textRange) ref return_x =
	{
	return new return_x[ O_RETURN, x, s ];
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	if	(expr)
		expr display(indent + INDENT_AMOUNT);
	}

fold:	dynamic	() ref tree_p =
	{
	if	(expr){
		expr = expr fold();
		expr sethiUllman();
		}
	return self;
	}

computeBenefits:	dynamic	(int) =
	{
	if	(expr)
		expr computeBenefits(nestingLevel);
	}

markTemps:	dynamic	() =
	{
	markAddressModes(expr);
	assignTempRegisters(expr, operator);
	}

assignTypes:	dynamic	(s: ref scope_s, boolean) ref tree_p =
	{
	t:	ref type_s;

	t = s returnTypeOf();
	if	(expr){
		expr = expr assignTypes(s, TRUE);
		if	(t){
			CurrentContext.offset = source.start;
			if	(t->topType == T_VOID){
				error(ErrVoidReturn);
				return ErrorTree;
				}
			else
				expr = cast_x createCheck(t, expr);
			}
		if	(expr->operator == O_SCONST)
			expr = expr sconstTemp(s, t);
		if	(TargetData.funcType->callingConvention == FC_GATE &&
			 TargetData.funcSymbol->qualifier & DQ_MEMBERFUNC &&
			 expr != ErrorTree){
			symbol:	ref symbol_s;

			symbol = s lookup(hash("replyGeneric"), s);
			if	(symbol == 0 ||
				 symbol->qualifier & DQ_MEMBERFUNC == 0){
				CurrentContext.offset = source.start;
				error(ErrUndefReply);
				expr = ErrorTree;
				return self;
				}
			extra:	ref tree_p;
			if	(expr->operator == O_CAST)
				expr = ref cast_x(expr)->opnd;
			if	(expr->operator != O_LITERAL &&
				 expr->operator != O_SLICE &&
				 !expr isLvalue()){
				sym:	ref symbol_s;
				tmp:	ref tree_p;
				b:	ref binary_x;

				sym = s unnamedLocal(expr->dtype);
				tmp = Func auto(sym);
				b = Func binary(O_ASG, tmp, expr, source.start);
				extra = b processAssignment(s, FALSE);
				expr = Func auto(sym);
				}
			else
				extra = 0;

			f, args, e, len:	ref tree_p;

			if	(expr->dtype->topType == T_DESCRIPTOR &&
				 t->topType == T_ARRAY){
				if	(expr->operator == O_SLICE){
					sl:	ref slice_x;

					sl = ref slice_x(expr);
					len = sl->right;
					e = sl->arrayRef;
					}
				else	{
					len = structRef(expr, 
							DescrBoundOffset * 
							BYTEBITS, IntType);
					e = expr;
					}
				e->dtype = refTo(t elementOf());
				}
			else	{
				len = Func icon(expr->dtype sizeOf(), INTBITS);
				e = expr takeAddress(expr->dtype);
				}
			args = Func argument(e, len, 0);
			e = Func auto(Project.selfSymbol);
			expr = methodCall_x createKnown(e, symbol, args,
						CurrentContext.offset,
						0, TRUE, s);
			if	(extra)
				expr = binop(O_SEQ, expr->dtype, extra, expr);
			}
		else if	(expr->dtype->topType == T_ARRAY){
			error(ErrUnfinished);
			expr = ErrorTree;
			}
		else if	(expr->dtype->topType == T_DESCRIPTOR){
			e:	ref tree_p;

			e = Func auto(TargetData.indirectReturn);
			e = Func binary(O_IND, e, 0, source.start);
			if	(expr->operator == O_CAST)
				expr = ref cast_x(expr)->opnd;
			e = Func binary(O_ASG, e, expr, source.start);
			expr = e assignTypes(s, FALSE);
			}
		else if	(expr->dtype->topType == T_STRUCT){
			if	(expr->dtype sizeOf() > 4){
				e:	ref tree_p;

				e = Func auto(TargetData.indirectReturn);
				e = Func binary(O_IND, e, 0, source.start);
				e = Func binary(O_ASG, e, expr, source.start);
				expr = e assignTypes(s, FALSE);
				}
			}
		}
	else if	(t &&
		 t->topType != T_VOID)
		warn(WarnReturnNeeded);
	return self;
	}

generateC:	dynamic	() =
	{
	Project.outputFd printf("return ");
	if	(expr)
		expr generateCode();
	Project.outputFd printf(";\n");
	}

traceLabels:	dynamic	() =
	{
	if	(next->operator == O_EXIT)
		super traceLabels();
	}

	};

reply_x:	public	type	inherit stmt_x {
	public:

	expr:		* tree_p;
	source:		textRange;

create:	factory	(x: ref tree_p, s: textRange) ref reply_x =
	{
	if	(x == 0)
		return 0;
	self = alloc(sizeof reply_x);
	self = [ O_REPLY, x ];
	source = s;
	return self;
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	expr display(indent + INDENT_AMOUNT);
	}

fold:	dynamic	() ref tree_p =
	{
	if	(expr){
		expr = expr fold();
		expr sethiUllman();
		}
	return self;
	}

computeBenefits:	dynamic	(int) =
	{
	if	(expr)
		expr computeBenefits(nestingLevel);
	}

markTemps:	dynamic	() =
	{
	markAddressModes(expr);
	assignTempRegisters(expr, operator);
	}

assignTypes:	dynamic	(s: ref scope_s, boolean) ref tree_p =
	{
	t:	ref type_s;

	if	(TargetData.funcType->callingConvention != FC_GATE ||
		 TargetData.funcSymbol->qualifier & DQ_MEMBERFUNC == 0){
		error(ErrNotGate);
		expr = ErrorTree;
		return self;
		}
	t = s returnTypeOf();
	if	(expr){
		expr = expr assignTypes(s, TRUE);
		if	(t){
			CurrentContext.offset = source.start;
			if	(t->topType == T_VOID){
				error(ErrVoidReply);
				expr = ErrorTree;
				}
			else
				expr = cast_x createCheck(t, expr);
			}
		symbol:	ref symbol_s;

		symbol = s lookup(hash("replyGeneric"), s);
		if	(symbol == 0 ||
			 symbol->qualifier & DQ_MEMBERFUNC == 0){
			CurrentContext.offset = source.start;
			error(ErrUndefReply);
			expr = ErrorTree;
			return self;
			}
		extra:	ref tree_p;
		if	(expr->operator == O_CAST)
			expr = ref cast_x(expr)->opnd;
		if	(expr->operator != O_LITERAL &&
			 expr->operator != O_SLICE &&
			 !expr isLvalue()){
			sym:	ref symbol_s;
			tmp:	ref tree_p;
			b:	ref binary_x;

			sym = s unnamedLocal(expr->dtype);
			tmp = Func auto(sym);
			b = Func binary(O_ASG, tmp, expr, source.start);
			extra = b processAssignment(s, FALSE);
			expr = Func auto(sym);
			}
		else
			extra = 0;

		f, args, e, len:	ref tree_p;

		if	(expr->dtype->topType == T_DESCRIPTOR &&
			 t->topType == T_ARRAY){
			if	(expr->operator == O_SLICE){
				sl:	ref slice_x;

				sl = ref slice_x(expr);
				len = sl->right;
				e = sl->arrayRef;
				}
			else	{
				len = structRef(expr, DescrMaxBoundOffset * 
							BYTEBITS, IntType);
				e = expr;
				}
			e->dtype = refTo(t elementOf());
			}
		else	{
			len = Func icon(expr->dtype sizeOf(), INTBITS);
			e = expr takeAddress(expr->dtype);
			}
		args = Func argument(e, len, 0);
		e = Func auto(Project.selfSymbol);
		expr = methodCall_x createKnown(e, symbol, args,
						CurrentContext.offset,
						0, TRUE, s);
		if	(extra)
			expr = binop(O_SEQ, expr->dtype, extra, expr);
		}
	else if	(t &&
		 t->topType != T_VOID)
		warn(WarnReplyNeeded);
	return self;
	}

	};

endTry_x:	public	type	inherit stmt_x {
	public:

	tryStmt:	ref try_x;
	source:		textRange;

create:	factory	(x: ref try_x) ref endTry_x =
	{
	self = alloc(sizeof endTry_x);
	self = [ O_ENDTRY, x ];
	return self;
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf(" (%x)\n", tryStmt);
	}

markTemps:	dynamic	() =
	{
	assignTempRegisters(0, operator);
	}

assignTypes:	dynamic	(ref scope_s, boolean) ref tree_p =
	{
	return self;
	}

	};

decl_x:	public	type	inherit stmt_x {
	public:

	declaration:	* declaration_p;
	source:		textRange;

	initTree:	* tree_p;

create:	factory	(d: ref declaration_p, s: textRange) ref decl_x =
	{
	if	(d == 0)
		return 0;
	self = alloc(sizeof decl_x);
	self = [ O_DECL, d ];
	source = s;
	initTree = 0;
	return self;
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	if	(initTree)
		initTree display(indent + INDENT_AMOUNT);
//	declaration display(???);
	}

markTemps:	dynamic	() =
	{
	if	(initTree){
		markAddressModes(initTree);
		assignTempRegisters(initTree, operator);
		}
	}

gatherDeclarations:	dynamic	(s: ref blockScope) =
	{
	s addDeclaration(declaration);
	}

fold:	dynamic	() ref tree_p =
	{
	if	(initTree){
		initTree = initTree fold();
		initTree sethiUllman();
		}
	return self;
	}

computeBenefits:	dynamic	(int) =
	{
	if	(initTree)
		initTree computeBenefits(nestingLevel);
	}

assignTypes:	dynamic	(s: ref scope_s, boolean) ref tree_p =
	{
	if	(declaration->initializer.start == 0)
		return self;
	if	(declaration->storageClass != SC_AUTO)
		return self;
	if	(declaration->idList == 0)
		return self;

	src:		ref sourceParser;

	src = s getSourceBuffer();
	if	(src == 0)
		return self;

	t:		ref tree_p;

	t = src parseWholeExpression(declaration->initializer);
	if	(t == 0)
		return self;

	n:	ref tree_p;

	n = Func iden(0, 0, declaration->idList->name, 
					declaration->idList->offset);
	initTree = Func binary(O_INIT, n, t, 
					declaration->initializer.start);
	initTree = initTree assignTypes(s, FALSE);
	return self;
	}

generateC:	dynamic	() =
	{
	if	(declaration->initializer.start == 0)
		return;
	if	(declaration->storageClass != SC_AUTO)
		return;
	if	(declaration->idList == 0)
		return;
	Project.outputFd printf("%S = ", 
					declaration->idList->name spelling());
	if	(initTree)
		initTree generateCode();
	Project.outputFd printf(";\n");
	}

	};

goto_x:	public	type	inherit stmt_x {
	public:

	tag:		ref identifier;
	source:		textRange;

	target:		ref label_x;

create:	factory	(id: ref identifier, s: textRange) ref goto_x =
	{
	self = alloc(sizeof goto_x);
	self = [ O_GOTO, id ];
	source = s;
	return self;
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("%S (%d:%d)\n", tag spelling(), source.start, source.end);
	}

assignTypes:	dynamic	(s: ref scope_s, boolean) ref tree_p =
	{
	target = s findLabel(tag);
	if	(target == 0){
		CurrentContext.offset = source.start;
		error(ErrUndefSym, tag spelling());
		}
	return self;
	}

	};

test_x:	public	type	inherit stmt_x {
	public:

	test:		* tree_p;
	target:		ref label_x;
	source:		textRange;
//	jumpCond:	jumpCondition;
//	extraJump:	signedByte;

constructor:	(t: ref tree_p, destination: ref label_x, 
					s: textRange) =
	{
	super constructor(O_TEST);
	test = t;
	target = destination;
	source = s;
//	jumpCond = JC_NOOP;
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf(" (%d:%d) -> %x nextSpill %x\n", source.start, source.end, target, nextSpill);
	if	(test)
		test display(indent + INDENT_AMOUNT);
	}

fold:	dynamic	() ref tree_p =
	{
	if	(test){
		test = test fold();
		test sethiUllman();
		}
	return self;
	}

computeBenefits:	dynamic	(int) =
	{
	if	(test)
		test computeBenefits(nestingLevel);
	}

cleanupLabels:	dynamic	() =
	{
	target = target lastLabel();
	}

traceLabels:	dynamic	() =
	{
	super traceLabels();
	if	(asmLabel &&
		 target->asmLabel == 0){
		target->asmLabel = 1;
		TargetData.changed = TRUE;
		}
	}

assignTypes:	dynamic	(s: ref scope_s, boolean) ref tree_p =
	{
	if	(test)
		test = test assignTypes(s, TRUE);
	else
		test = ErrorTree;
//	jumpCond = assignTestTemps(self);
//	extraJump = extraTestJump(self);
	return self;
	}

markTemps:	dynamic	() =
	{
	if	(test){
		markAddressModes(test);
		assignTempRegisters(test, O_STMT);
		}
	}

	};

