/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	backend, xtree, xstmt;
include	value;
include	symtab;
include	types;
include	addrmode, alloctmp;
include	ptree;
include	target;
include	encoder;
include	asmcode, objcode;
include	function;
include	pswitch;
include	funcout;
include	allocreg;
include	jumpopt;
/*
	This function generates code for a function represented by the
	expression tree x.  The resulting code and fixups are generated
	in the value object v.

	The expression tree x has already been checked for errors, locals
	have been parsed and initializers created appropriately.  Static
	objects have also been fully generated.
 */
generateCode:	public	(sc: ref blockScope, v: ref value, x: ref stmt_x) =
	{

		// Gate methods need to add code to relocate any descriptor
		// arguments

	if	(TargetData.funcSymbol->qualifier &
			 (DQ_MEMBERFUNC|DQ_FACTORY) == DQ_MEMBERFUNC &&
		 TargetData.funcType->callingConvention == FC_GATE){
		}

	TargetData.funcValue = v;
/*
	if	(Project.optimize){
		x = optimizeJumps(x);
		optimizeAndOrXor();
		findLoops();
		commonSubExpressions();
		analyzeLiveRanges();
		inductionVariables();
		analyzeLiveRanges();
		splitLiveRanges();
		}
 */
	IncomingRegs = 0;
	OutgoingRegs = 0;
	if	(TargetData.funcType->callingConvention == FC_NORMAL ||
		 TargetData.funcType->callingConvention == FC_GATE)
		allocateParmRegisters();
	while	(markTemps(x) &&
		 Project.optimize)
		;
	if	(Project.optimize)
		x = optimizeJumps(x);
/*
	allocateStackTemps();
	if	(Project.optimize){
		tailMerge();
		loadSuppression();
		}
 */
	TargetData.autoCount = 0;
	TargetData.rootScope locateAutos(0, FALSE);
	TargetData.rootScope locateAutos(-TargetData.autoCount, TRUE);
	m:	int;
	m = TargetData.autoCount % StackFrameAlign;
	if	(m)
		TargetData.autoCount += StackFrameAlign - m;
	sizeParms();
	if	(Project.outputAs & OM_ASM)
		Encoder = &AsmEncoder;
	else
		Encoder = &UnitEncoder;
	Encoder openValue(v);
	functionPreamble(sc);
	if	(generateInstructions(x))
		functionPostamble();
	generateSwitchTables();
	Encoder closeValue();
//	cleanupFloat();
	TargetData.floatTempsUsed = FALSE;
	TargetData.spills = 0;
	}

markTemps:	(x: ref stmt_x) boolean =
	{
	TargetData.spills = 0;
	TargetData.lastSpill = 0;
//	x display(0);
	x markTempsAndSpills();
	TargetData clearBenefitCounts();
	x computeBenefits(1);			// 1 is the 'nesting level'
	return assignRegisterVariables();
	}

regneeds:	public	(t: ref tree_p) int =
	{
	i:	int;

	if	(t->dtype)
		i = t->dtype->topType;
	else
		i = T_VOID;
	return SethiUllmanTable[SethiUllmanClass[t->operator]][i];
	}

SethiUllmanTable:	[][12 /*T_TYPE + 1*/ ] char = [
	[ 0 ],						// Free operators
	[ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],		// Cheap operators
	[ 1, 1, 2, 2, 1, 2, 2, 2, 2, 1, 1, 1 ],		// Expensive operators
	[ 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 ],		// Function calls
	];

SethiUllmanClass:	[] char = [

	    /* Leaf node operator id's */

	0,				// O_ERROR

	0,				/* O_ID */
	0,				/* O_ICON */
	0,				/* O_FCON */
	0,				// O_SELF
	0,				// O_SUPER
	0,				// O_TOS
	0,				// O_REG
	0,				/* O_AUTO */
	0,				/* O_DYNAMIC */
	0,				// O_REMOTE
	0,				// O_TYPE
	0,				/* O_SCONST */
	0,				/* O_LITERAL */
	0,				/* O_ELLIPSIS */

	    /* Binary operators */

	1,				/* O_ADD */
	1,				/* O_SUB */
	2,				/* O_MUL */
	2,				/* O_DIV */
	2,				/* O_MOD */
	2,				/* O_LSH */
	2,				/* O_RSH */
	1,				/* O_AND */
	1,				/* O_OR */
	1,				/* O_XOR */
	1,				/* O_ASG */
	1,				/* O_ADA */
	1,				/* O_SBA */
	2,				/* O_MUA */
	2,				/* O_DVA */
	2,				/* O_MOA */
	2,				/* O_LSA */
	2,				/* O_RSA */
	1,				/* O_ANA */
	1,				/* O_ORA */
	1,				/* O_XRA */
	1,				/* O_EQ */
	1,				/* O_NE */
	1,				/* O_GT */
	1,				/* O_LT */
	1,				/* O_GE */
	1,				/* O_LE */
	1,				// O_ORD,			// <>=
	1,				// O_UNORD,		// !<>=
	1,				// O_NLT,			// !<
	1,				// O_NLE,			// !<=
	1,				// O_NGT,			// !>
	1,				// O_NGE,			// !>=
	1,				// O_LT_GT,		// <>
	1,				// O_NLT_GT,		// !<>
	1,				/* O_INA */
	1,				/* O_DEA */
	1,				/* O_QUES */
	1,				/* O_LAND */
	1,				/* O_LOR */
	0,				/* O_SEQ */
	0,				/* O_ARG */
	0,				/* O_IOARROW */
	1,				// O_INIT

	   /* Unary operators */

	1,				/* O_NEG */
	0,				// O_PLUS
	1,				/* O_COM */
	1,				/* O_NOT */
	1,				/* O_IND */
	1,				/* O_ADR */

	   /* Special operators */

	1,				// O_FLD
	1,				/* O_CAST */
	3,				/* O_SCALL */
	3,				/* O_MCALL */
	3,				/* O_RCALL */
	0,				/* O_DOT */
	0,				/* O_ARROW */
	0,				/* O_SUBSCRIPT */
	0,				// O_SLICE
	0,				// O_BOUND
	0,				// O_MBOUND
	0,				/* O_SIZEOF */

		/* Code generation operations */

	1,				//	O_INTRPT,		/* Interrupt instruction */
	2,				//	O_ABS,			/* Absolute value */
	1,				//	O_OUT,			/* OutportByte */
	1,				//	O_IN,			/* InportByte */
	0,				//	O_EMIT,			/* Emit */
	5,				//	O_MSCAN,		/* MemScan */
	5,				//	O_MCOPY,		/* MemCopy */
	5,				//	O_MSET,			/* MemSet */
	1,				//	O_ROL,			/* RotateLeft */
	1,				//	O_ROR,			/* RotateRight */
	1,				//	O_FABS,			/* Fabs */
	1,				//	O_XCHG,			/* exchange */
	1,				//	O_RNDINT
	1,				//	O_CVTBCD
	1,				//	O_TST,			/* test */
	0,				//	O_ALLOCTOS
	0,				//	O_NEW
	0,				//	O_TYPELEN
	0,				//	O_OFFSETOF
	0,				//	O_TYPEOF
	0,				//	O_SEND
	0,				//	O_BLOCK
	0,				//	O_DECL
	0,				//	O_GOTO
	0,				//	O_ASSERT
	0,				//	O_LABEL
	0,				//	O_RETURN
	0,				//	O_ENDTRY
	0,				//	O_REPLY
	0,				//	O_JUMP
	0,				//	O_TEST
	0,				//	O_STMT
	0,				//	O_SWITCH
	0,				//	O_TRY
	0,				//	O_EXCEPT
	0,				//	O_ENDEX
	];

adjustDescriptorArguments:	public	(sc: ref blockScope) =
	{
	sym:	ref symbol_s;
	d:	ref type_s;
	x:	ref tree_p;
	y:	ref tree_p;

	for	(sym = sc->symbols; sym; sym = sym->next){
		if	(sym->storageClass != SC_BASED)
			continue;
		d = sym->dtype getType();
		if	(d->topType != T_DESCRIPTOR)
			continue;
		x = Func auto(TargetData.gateArgsSymbol);
		if	(sym->bitOffset){
			s:	ref tree_p;

			s = Func icon(sym->bitOffset, INTBITS);
			x = binop(O_ADD, TargetData.gateArgsSymbol->dtype, x, s);
			}
		y = x dup(0);
		x = binop(O_IND, IntType, x, 0);
		x = binop(O_ADA, IntType, x, y);
		markAddressModes(x);
		assignTempRegisters(x, O_STMT);
		generateQ(x);
		}
	}
