/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	file;
include	filesys;

include	parser;
include	symtab, types;
include	sbuffer, ptree, hash;
include	backend, real;
include	xcall, xstmt, xtree;
include	target;

enableCbackend:	public	() =
	{
	Func = &CFunc;
	}

CFunc:	inherit	functionBody	{
	Cfd:	stream;

startValue:	dynamic	(u: ref unit_s) =
	{
	fpath:	[MAXPATH] char;
	f:	[:] char;

	if	(Project.outputAs & OM_C){
		f = makePath(fpath, "", u->name spelling(), ".c");
		if	(Cfd create(f, AR_WRITE|AR_READ)){
			printf("Couldn't create '%S'\n", f);
			return;
			}
		Project.outputFd = &Cfd;
		}

	}

endValue:	dynamic	() =
	{
	if	(Project.outputAs & OM_C){
		Cfd close();
		Project.outputFd = 0;
		}
	}

generateCode:	dynamic	(sym: ref symbol_s, x: ref stmt_x, 
						sc: ref blockScope) =
	{
	x computeBenefits(0);
	sym->dtype outputHeaderPrefix(&Cfd);
	sym outputHeaderName(&Cfd);
	sym->dtype outputHeaderSuffix(&Cfd);
	Cfd printf("\n");
	x generateCode();
	Cfd printf("\n");
	}

generateData:	dynamic	(sym: ref symbol_s) =
	{
	x:		ref tree_p;
	y:		ref tree_p;
	u:		ref tree_p;
	t:		ref type_s;
	initTree:	ref tree_p;

	t = sym->dtype getType();
	if	(t == 0){
		printf("t = %x name = %S dtype = ", t, sym->name spelling());
		sym->dtype display(TRUE);
		printf("\n");
		return;
		}
	if	(sym->qualifier & DQ_CONST){
		if	(sym->initBase &&
			 sym->storageClass != SC_INTRINSIC)
			y = Func icon(sym->initBase, INTBITS);
		else
			y = 0;
		x = y;
		if	(sym->initializer.start ||
			 y){
			sym->currentValue registerType();
			if	(sym->initializer.start){
				src:		ref sourceParser;

				src = sym->enclosing getSourceBuffer();
				if	(src == 0)
					return;
				x = src parseWholeExpression(sym->initializer);
				if	(x == 0)
					return;
				if	(y)
					x = Func binary(O_ADD, x, y, sym->offset);
				x = x assignTypes(sym->enclosing, FALSE);
				if	(x == 0)
					return;
				x = x fold();
				}
			sym->currentValue initialize(x);
			}
		else
			sym->currentValue recordValueSize();
		}
	else	{
		sym->dtype outputHeaderPrefix(&Cfd);
		sym outputHeaderName(&Cfd);
		sym->dtype outputHeaderSuffix(&Cfd);
		if	(sym->initBase &&
			 sym->storageClass != SC_INTRINSIC)
			y = Func icon(sym->initBase, INTBITS);
		else
			y = 0;
		x = y;
		if	(sym->initializer.start ||
			 y){
			if	(sym->initializer.start){
				src:		ref sourceParser;

				src = sym->enclosing getSourceBuffer();
				if	(src == 0)
					return;
				x = src parseWholeExpression(sym->initializer);
				if	(x == 0)
					return;
				if	(y)
					x = Func binary(O_ADD, x, y, sym->offset);
				x = x assignTypes(sym->enclosing, FALSE);
				if	(x == 0)
					return;
				x = x fold();
				}
			Cfd printf(" = ");
			x generateCode();
			}
		Cfd printf(";\n");
		}
	}

argument:	dynamic	(l: ref tree_p, r: ref tree_p, 
				o: fileOffset) ref tree_p =
	{
	return new argument_C[ l, r, o ];
	}

assert_:	dynamic	(x: ref tree_p, s: textRange) ref stmt_x =
	{
	return assert_x create(x, s);
	}

auto:	dynamic	(sym: ref symbol_s) ref auto_x =
	{
	return new auto_C[ sym ];
	}

binary:	dynamic	(op: operators, l: ref tree_p, 
				r: ref tree_p, 
				o: fileOffset) ref binary_x =
	{
	return new binary_C[ op, l, r, o ];
	}

block:	dynamic	(x: ref stmt_x) ref stmt_x =
	{
	return new block_C[ x ];
	}

cast:	dynamic	(d: ref type_p, t: ref tree_p, o: fileOffset) ref tree_p =
	{
	return new cast_C[ d, t, o ];
	}

conditional:	dynamic	(t: ref tree_p, tp: ref tree_p, 
				fp: ref tree_p, 
				o: fileOffset) ref tree_p =
	{
	return conditional_x create(t, tp, fp , o);
	}

continueExcept:	dynamic	() ref stmt_x =
	{
	return continueExcept_x create();
	}

decl:	dynamic	(d: ref declaration_p, s: textRange) ref stmt_x =
	{
	return decl_x create(d, s);
	}

ellipsis:	dynamic	() ref tree_p =
	{
	return ellipsis_x create();
	}

endExcept:	dynamic	(m: ref try_x) ref stmt_x =
	{
	return endExcept_x create(m);
	}

endTry:	dynamic	(x: ref try_x) ref stmt_x =
	{
	return endTry_x create(x);
	}

error:	dynamic	() ref tree_p =
	{
	return error_x create();
	}

errorStmt:	dynamic	(o: fileOffset) ref stmt_x =
	{
	return errorStmt_x create(o);
	}

expr:	dynamic	(x: ref tree_p, s: textRange) ref stmt_x =
	{
	return new expr_C[ x, s ];
	}

fcon:	dynamic	(v: ref real, w: int) ref tree_p =
	{
	return fcon_x create(v, w);
	}

goto_:	dynamic	(id: ref identifier, s: textRange) ref stmt_x =
	{
	return goto_x create(id, s);
	}

icon:	dynamic	(v: long, w: int) ref tree_p =
	{
	return new icon_C[ v, w ];
	}

iden:	dynamic	(unitName: ref identifier, uno: fileOffset,
		 id: ref identifier, o: fileOffset) ref tree_p =
	{
	return new iden_C[ unitName, uno, id, o ];
	}

jump:	dynamic	(t: ref label_x, s: textRange) ref jump_x =
	{
	return new jump_C[ t, s ];
	}

label_:	dynamic	() ref label_x =
	{
	return new label_C[ O_LABEL, 0, 0 ];
	}

literal:	dynamic	() ref literal_x =
	{
	return literal_x create();
	}

methodCall:	dynamic	(l: ref tree_p, id: ref identifier,
				r: ref tree_p,
				o: fileOffset) ref tree_p =
	{
	return methodCall_x create(l, id, r, o);
	}

namedLabel:	dynamic	(id: ref identifier, o: fileOffset) ref label_x =
	{
	return new label_C[ O_LABEL, id, o ];
	}

new_:	dynamic	(d: ref type_p, t: ref tree_p, o: fileOffset) ref tree_p =
	{
	return new_x create(d, t, o);
	}

offsetof_:	dynamic	(d: ref type_p, id: ref identifier) ref tree_p =
	{
	return offsetof_x create(d, id);
	}

reference:	dynamic	(op: operators, l: ref tree_p, 
				id: ref identifier,
				o: fileOffset) ref tree_p =
	{
	return reference_x create(op, l, id, o);
	}

reply_:	dynamic	(x: ref tree_p, s: textRange) ref stmt_x =
	{
	return reply_x create(x, s);
	}

return_:	dynamic	(x: ref tree_p, s: textRange) ref stmt_x =
	{
	return return_x create(x, s);
	}

sconst:	dynamic	(c: ref tree_p, o: fileOffset) ref tree_p =
	{
	return sconst_x create(c, o);
	}

self_:	dynamic	(op: operators, o: fileOffset) ref tree_p =
	{
	return self_x create(op, o);
	}

sizeof_:dynamic	(d: ref type_p) ref tree_p =
	{
	return sizeof_x create(d);
	}

slice:	dynamic	(t: ref tree_p, l: ref tree_p, r: ref tree_p, o: fileOffset)
							ref tree_p =
	{
	return slice_x create(t, l, r, o);
	}

staticCall:	dynamic	(l: ref tree_p, r: ref tree_p,
				o: fileOffset) ref tree_p =
	{
	return new staticCall_C[ l, r, o ];
	}

switch_:	dynamic	(x: ref tree_p, s: textRange) ref switch_x =
	{
	return switch_x create(x, s);
	}

test:	dynamic	(t: ref tree_p, destination: ref label_x, 
					s: textRange) ref stmt_x =
	{
	return new test_C[ t, destination, s ];
	}

testFalse:	dynamic	(t: ref tree_p, destination: ref label_x, 
					s: textRange) ref stmt_x =
	{
	switch	(t->operator){
	case	O_EQ:
	case	O_NE:
	case	O_LT:
	case	O_GT:
	case	O_LE:
	case	O_GE:
	case	O_ORD:
	case	O_UNORD:
	case	O_NLT:
	case	O_NLE:
	case	O_NGT:
	case	O_NGE:
	case	O_LT_GT:
	case	O_NLT_GT:
		t->operator = negateCondition(t->operator);
		break;

	default:
		t = binary(O_EQ, t, icon(0L, INTBITS), s.start);
		break;

	case	O_NOT:
		t = ref binary_x(t)->left;
		break;

	case	O_LAND:
	case	O_LOR:
		t = binary(O_NOT, t, 0, s.start);
		}
	return test(t, destination, s);
	}

try_:	dynamic	(x: ref label_x) ref try_x =
	{
	return try_x create(x);
	}

	};

argument_C:	type	inherit	argument_x {

generateCode:	dynamic	() =
	{
	if	(left == 0){
		if	(right)
			right generateCode();
		}
	else	{
		left generateCode();
		if	(right){
			Project.outputFd printf(", ");
			right generateCode();
			}
		}
	}

computeBenefits:	dynamic (int) =
	{
	if	(left)
		left computeBenefits(0);
	if	(right)
		right computeBenefits(0);
	}

	};

auto_C:	type	inherit	auto_x {

generateCode:	dynamic	() =
	{
	if	(symbol &&
		 symbol->name)
		Project.outputFd printf("%S", symbol->name spelling());
	else
		Project.outputFd printf("A_%x", self);
	}

computeBenefits:	dynamic (int) =
	{
	if	(symbol &&
		 symbol->dtype)
		dtype emitNeededTypedefs(Project.outputFd);
	}

	};

block_C:	type	inherit	block_x {

generateCode:	dynamic	() =
	{
	s:	ref stmt_x;
	sym:	ref symbol_s;

	Project.outputFd printf("{\n");
	for	(sym = scope.symbols; sym; sym = sym->next){
		if	(sym->dtype == 0 || sym->name == 0)
			continue;
		sym->dtype outputHeaderPrefix(Project.outputFd);
		Project.outputFd printf(" %S", sym->name spelling());
		sym->dtype outputHeaderSuffix(Project.outputFd);
		Project.outputFd printf(";\n");
		}
	for	(s = stmts; s; s = s->next)
		s generateCode();
	Project.outputFd printf("}\n");
	}

computeBenefits:	dynamic (int) =
	{
	s:	ref stmt_x;
	sym:	ref symbol_s;

	for	(sym = scope.symbols; sym; sym = sym->next){
		if	(sym->dtype == 0 || sym->name == 0)
			continue;
		sym->dtype emitNeededTypedefs(Project.outputFd);
		}
	for	(s = stmts; s; s = s->next)
		s computeBenefits(0);
	}

	};

binary_C:	type	inherit	binary_x {

generateCode:	dynamic	() =
	{
	p:	char;
	pn, po:	char;

	p = Cprecedence[operator];
	if	(dtype &&
		 dtype->topType == T_REF){
		if	(operator == O_ADD ||
			 operator == O_SUB){
			Project.outputFd printf("(char*)");
			po = Cprecedence[left->operator];
			if	(Cprecedence[O_CAST] >= po)
				Project.outputFd printf("(");
			left generateCode();
			if	(Cprecedence[O_CAST] >= po)
				Project.outputFd printf(")");
			Project.outputFd printf(" %s ", Cspelling[operator]);
			po = Cprecedence[right->operator];
			if	(p >= po)
				Project.outputFd printf("(");
			right generateCode();
			if	(p >= po)
				Project.outputFd printf(")");
			return;
			}
		}
	if	(right){
		if	(left){
			po = Cprecedence[left->operator];
			if	(p >= po)
				Project.outputFd printf("(");
			left generateCode();
			if	(p >= po)
				Project.outputFd printf(")");
			}
		Project.outputFd printf(" %s ", Cspelling[operator]);
		if	(operator != O_INA &&
			 operator != O_DEA){
			po = Cprecedence[right->operator];
			if	(p >= po)
				Project.outputFd printf("(");
			right generateCode();
			if	(p >= po)
				Project.outputFd printf(")");
			}
		}
	else	{
		Project.outputFd printf(" %s ", Cspelling[operator]);
		if	(operator == O_IND){
			Project.outputFd printf("(");
			dtype outputHeaderPrefix(Project.outputFd);
			Project.outputFd printf("*");
			dtype outputHeaderSuffix(Project.outputFd);
			Project.outputFd printf(")");
			p = Cprecedence[O_CAST];
			}
		if	(left){
			po = Cprecedence[left->operator];
			if	(p >= po)
				Project.outputFd printf("(");
			left generateCode();
			if	(p >= po)
				Project.outputFd printf(")");
			}
		}		
	}

computeBenefits:	dynamic (int) =
	{
	if	(left)
		left computeBenefits(0);
	if	(right)
		right computeBenefits(0);
	}

	};

cast_C:	type	inherit	cast_x {

generateCode:	dynamic	() =
	{
	Project.outputFd printf("(");
	dtype outputHeaderPrefix(Project.outputFd);
	dtype outputHeaderSuffix(Project.outputFd);
	Project.outputFd printf(")");
	if	(opnd)
		opnd generateCode();
	}

computeBenefits:	dynamic (int) =
	{
	dtype emitNeededTypedefs(Project.outputFd);
	if	(opnd)
		opnd computeBenefits(0);
	}

	};

expr_C:	type	inherit expr_x {

generateCode:	dynamic	() =
	{
	expr generateCode();
	Project.outputFd printf(";\n");
	}

computeBenefits:	dynamic (int) =
	{
	expr computeBenefits(0);
	}

	};

icon_C:	type	inherit	icon_x {

generateCode:	dynamic	() =
	{
	Project.outputFd printf("0x%x", integer);
	}

	};

iden_C:	type	inherit	iden_x {

generateCode:	dynamic	() =
	{
	if	(adjust){
		Project.outputFd printf("*(");
		dtype outputHeaderPrefix(Project.outputFd);
		Project.outputFd printf("*");
		dtype outputHeaderSuffix(Project.outputFd);
		Project.outputFd printf(")((char *)&");
		}
	if	(symbol &&
		 symbol->storageClass != SC_REGISTER)
		symbol outputHeaderName(Project.outputFd);
	else
		Project.outputFd printf("%S", name spelling());
	if	(adjust)
		Project.outputFd printf("+0x%x)", adjust);
	}

computeBenefits:	dynamic (int) =
	{
	if	(symbol &&
		 symbol->storageClass != SC_REGISTER)
		symbol emitNeededDeclaration(Project.outputFd);
	}

	};

jump_C:	type	inherit	jump_x {

generateCode:	dynamic	() =
	{
	Project.outputFd printf("goto L_%x;\n", target);
	}

	};

label_C:	type	inherit	label_x {

generateCode:	dynamic	() =
	{
	Project.outputFd printf("L_%x:;\n", self);
	}

	};

staticCall_C:	type	inherit	staticCall_x {

generateCode:	dynamic	() =
	{
	if	(func)
		func generateCode();
	Project.outputFd printf("(");
	if	(args)
		args generateCode();
	Project.outputFd printf(")");
	}

computeBenefits:	dynamic (int) =
	{
	if	(func)
		func computeBenefits(0);
	if	(args)
		args computeBenefits(0);
	}

	};

test_C:	type	inherit	test_x {

generateCode:	dynamic	() =
	{
	Project.outputFd printf("if (");
	if	(test)
		test generateCode();
	Project.outputFd printf(") goto L_%x;\n", target);
	}

computeBenefits:	dynamic (int) =
	{
	if	(test)
		test computeBenefits(0);
	}

	};

Cprecedence:	[] char = [
	0,			//	O_ERROR,

	99,			//	O_ID,
	99,			//	O_ICON,
	99,			//	O_FCON,
	99,			//	O_SELF,
	99,			//	O_SUPER,
	99,			//	O_TOS,
/*
	O_REG,
 */
	99,			//	O_AUTO,
	99,			//	O_DYNAMIC,
	99,			//	O_REMOTE,		// remote call
	99,			//	O_TYPE,
	99,			//	O_SCONST,
	99,			//	O_LITERAL,
	99,			//	O_ELLIPSIS,

	    /* Binary operators */

	14,			//	O_ADD,			/* + */
	14,			//	O_SUB,			/* - */
	15,			//	O_MUL,			/* * */
	15,			//	O_DIV,			/* / */
	15,			//	O_MOD,			/* % */
	13,			//	O_LSH,			/* << */
	13,			//	O_RSH,			/* >> */
	10,			//	O_AND,			/* & */
	8,			//	O_OR,			/* | */
	9,			//	O_XOR,			/* ^ */
	3,			//	O_ASG,			/* = */
	3,			//	O_ADA,			/* += */
	3,			//	O_SBA,			/* -= */
	3,			//	O_MUA,			/* *= */
	3,			//	O_DVA,			/* /= */
	3,			//	O_MOA,			/* %= */
	3,			//	O_LSA,			/* <<= */
	3,			//	O_RSA,			/* >>= */
	3,			//	O_ANA,			/* &= */
	3,			//	O_ORA,			/* |= */
	3,			//	O_XRA,			/* ^= */
	11,			//	O_EQ,			/* == */
	11,			//	O_NE,			/* != */
	12,			//	O_GT,			/* > */
	12,			//	O_LT,			/* < */
	12,			//	O_GE,			/* >= */
	12,			//	O_LE,			/* <= */
	12,			//	O_ORD,			// <>=
	12,			//	O_UNORD,		// !<>=
	12,			//	O_NLT,			// !<
	12,			//	O_NLE,			// !<=
	12,			//	O_NGT,			// !>
	12,			//	O_NGE,			// !>=
	11,			//	O_LT_GT,		// <>
	11,			//	O_NLT_GT,		// !<>
	88,			//	O_INA,			/* increment after */
	88,			//	O_DEA,			/* decrement after */
	5,			//	O_QUES,			/* ?: */
	7,			//	O_LAND,			/* && */
	6,			//	O_LOR,			/* || */
//	O_LSEQ,			/* left-valued sequential execution */
	1,			//	O_SEQ,			/* sequential execution */
	2,			//	O_ARG,			/* function argument */
	4,			//	O_IOARROW,		/* <- */
	3,			//	O_INIT,			// auto initializer

	   /* Unary operators */


	77,			//	O_NEG,			/* - */
	77,			//	O_PLUS,			/* + (unary) */
	77,			//	O_COM,			/* ~ */
	77,			//	O_NOT,			/* ! */
	77,			//	O_IND,			/* * */
	77,			//	O_ADR,			/* & */

	   /* Special operators */

	77,			//	O_FLD,			/* bit field */
/*
	O_COPY,			/* structure copy */
 */
	77,			//	O_CAST,			/* type cast */
	88,			//	O_SCALL,			/* function call */
	88,			//	O_MCALL,		// member call
	88,			//	O_RCALL,		// member call
	88,			//	O_DOT,			/* . */
	88,			//	O_ARROW,		/* -> */
	88,			//	O_SUBSCRIPT,		/* x[y] */
	88,			//	O_SLICE,		// a[:n] and a[n1:n2] array slices
	77,			//	O_BOUND,		// |a
	77,			//	O_MBOUND,		// ||a
	77,			//	O_SIZEOF,		/* sizeof */

		/* Code generation operations */

	0,			//	O_INTRPT,		/* Interrupt instruction */
	0,			//	O_ABS,			/* Absolute value */
	0,			//	O_OUT,			/* OutportByte */
	0,			//	O_IN,			/* InportByte */
	0,			//	O_EMIT,			/* Emit */
	0,			//	O_MSCAN,		/* MemScan */
	0,			//	O_MCOPY,		/* MemCopy */
	0,			//	O_MSET,			/* MemSet */
	0,			//	O_ROL,			/* RotateLeft */
	0,			//	O_ROR,			/* RotateRight */
	0,			//	O_FABS,			/* Fabs */
	0,			//	O_XCHG,			/* exchange */
	0,			//	O_TEST,			/* test */
	0,			//	O_ALLOCTOS,		// allocate tos var
	0,			//	O_NEW
	0,			//	O_TYPELEN,		/* sizeof ref type */
	0,			//	O_OFFSETOF,		/* offsetof */
	0,			//	O_TYPEOF,		// typeof
	0,			//	O_SEND,			// send
	0,			//	O_BLOCK
	0,			//	O_DECL,			// declaration
	0,			//	O_GOTO,			// goto
	0,			//	O_ASSERT,		// assertion
	0,			//	O_LABEL,		// goto label
	0,			//	O_RETURN,		// return
	0,			//	O_ENDTRY,		// end of try clause
	0,			//	O_REPLY,		// reply
	0,			//	O_JUMP,			// jump instruction
	0,			//	O_TEST,			// test and jump
	0,			//	O_STMT,			// statement
	0,			//	O_SWITCH,		// switch statement
	0,			//	O_TRY,			// try statement
	0,			//	O_EXCEPT,		// except clause
	0,			//	O_ENDEX			// end of except clause
	0,			//	O_CONTEX
	0,			//	O_EXIT
	];

Cspelling:	[] * char = [
	"error",		//	O_ERROR,

	"id",			//	O_ID,
	"icon",			//	O_ICON,
	"fcon",			//	O_FCON,
	"self",			//	O_SELF,
	"super",		//	O_SUPER,
	"tos",			//	O_TOS,
	"reg",			//	O_REG,
	"auto",			//	O_AUTO,
	"dynamic",		//	O_DYNAMIC,
	"remote",		//	O_REMOTE,		// remote call
	"type",			//	O_TYPE,
	"sconst",		//	O_SCONST,
	"literal",		//	O_LITERAL,
	"ellipsis",		//	O_ELLIPSIS,

	    /* Binary operators */

	"+",			//	O_ADD,			/* + */
	"-",			//	O_SUB,			/* - */
	"*",			//	O_MUL,			/* * */
	"/",			//	O_DIV,			/* / */
	"%",			//	O_MOD,			/* % */
	"<<",			//	O_LSH,			/* << */
	">>",			//	O_RSH,			/* >> */
	"&",			//	O_AND,			/* & */
	"|",			//	O_OR,			/* | */
	"^",			//	O_XOR,			/* ^ */
	"=",			//	O_ASG,			/* = */
	"+=",			//	O_ADA,			/* += */
	"-=",			//	O_SBA,			/* -= */
	"*=",			//	O_MUA,			/* *= */
	"/=",			//	O_DVA,			/* /= */
	"%=",			//	O_MOA,			/* %= */
	"<<=",			//	O_LSA,			/* <<= */
	">>=",			//	O_RSA,			/* >>= */
	"&=",			//	O_ANA,			/* &= */
	"|=",			//	O_ORA,			/* |= */
	"^=",			//	O_XRA,			/* ^= */
	"==",			//	O_EQ,			/* == */
	"!=",			//	O_NE,			/* != */
	">",			//	O_GT,			/* > */
	"<",			//	O_LT,			/* < */
	">=",			//	O_GE,			/* >= */
	"<=",			//	O_LE,			/* <= */
	"<>=",			//	O_ORD,			// <>=
	"!<>=",			//	O_UNORD,		// !<>=
	">=",			//	O_NLT,			// !<
	">",			//	O_NLE,			// !<=
	"<=",			//	O_NGT,			// !>
	"<",			//	O_NGE,			// !>=
	"!=",			//	O_LT_GT,		// <>
	"==",			//	O_NLT_GT,		// !<>
	"++",			//	O_INA,			/* increment after */
	"--",			//	O_DEA,			/* decrement after */
	"?",			//	O_QUES,			/* ?: */
	"&&",			//	O_LAND,			/* && */
	"||",			//	O_LOR,			/* || */
//	O_LSEQ,			/* left-valued sequential execution */
	",",			//	O_SEQ,			/* sequential execution */
	",",			//	O_ARG,			/* function argument */
	"<-",			//	O_IOARROW,		/* <- */
	"=",			//	O_INIT,			// auto initializer

	   /* Unary operators */


	"-",			//	O_NEG,			/* - */
	"+",			//	O_PLUS,			/* + (unary) */
	"~",			//	O_COM,			/* ~ */
	"!",			//	O_NOT,			/* ! */
	"*",			//	O_IND,			/* * */
	"&",			//	O_ADR,			/* & */

	   /* Special operators */

	"fld",			//	O_FLD,			/* bit field */
/*
	O_COPY,			/* structure copy */
 */
	"()",			//	O_CAST,			/* type cast */
	"()",			//	O_SCALL,		/* function call */
	"id()",			//	O_MCALL,		// member call
	"rem()",		//	O_RCALL,		// member call
	".",			//	O_DOT,			/* . */
	"->",			//	O_ARROW,		/* -> */
	"[]",			//	O_SUBSCRIPT,		/* x[y] */
	"[:]",			//	O_SLICE,		// a[:n] and a[n1:n2] array slices
	"bound",		//	O_BOUND,		// |a
	"mbound",		//	O_MBOUND,		// ||a
	"sizeof",		//	O_SIZEOF,		/* sizeof */

		/* Code generation operations */

	"interrupt",		//	O_INTRPT,		/* Interrupt instruction */
	"abs",			//	O_ABS,			/* Absolute value */
	"out",			//	O_OUT,			/* OutportByte */
	"in",			//	O_IN,			/* InportByte */
	"emit",			//	O_EMIT,			/* Emit */
	"mscan",		//	O_MSCAN,		/* MemScan */
	"mcopy",		//	O_MCOPY,		/* MemCopy */
	"mset",			//	O_MSET,			/* MemSet */
	"rol",			//	O_ROL,			/* RotateLeft */
	"ror",			//	O_ROR,			/* RotateRight */
	"fabs",			//	O_FABS,			/* Fabs */
	"xchg",			//	O_XCHG,			/* exchange */
	"tst",			//	O_TEST,			/* test */

	"alloctos",		//	O_ALLOCTOS,		// allocate tos var
	"new",			//	O_NEW,
	"typelen",		//	O_TYPELEN,		/* sizeof ref type */
	"offsetof",		//	O_OFFSETOF,		/* offsetof */
	"typeof",		//	O_TYPEOF,		// typeof
	"send",			//	O_SEND,			// send
	"block",		//	O_BLOCK
	"decl",			//	O_DECL,			// declaration
	"goto",			//	O_GOTO,			// goto
	"assert",		//	O_ASSERT,		// assertion
	"label",		//	O_LABEL,		// goto label
	"return",		//	O_RETURN,		// return
	"endtry",		//	O_ENDTRY,		// end of try clause
	"reply",		//	O_REPLY,		// reply
	"jump",			//	O_JUMP,			// jump instruction
	"test",			//	O_TEST,			// test and jump
	"stmt",			//	O_STMT,			// statement
	"switch",		//	O_SWITCH,		// switch statement
	"try",			//	O_TRY,			// try statement
	"except",		//	O_EXCEPT,		// except clause
	"endex",		//	O_ENDEX			// end of except clause
	"contex",		//	O_CONTEX		// continue exception
	"exit",			//	O_EXIT
	];

