/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	hardware;
include	filesys;

NSIGNALS:	public	const	int = 32;
NLOCALS:	public	const	int = 32;

	// Local object slots:

FSYS_SLOT:	public	const int = 20;		// file system name context.
ENV_SLOT:	public	const int = 21;		// Process environment.
HOST_SLOT:	public	const int = 22;		// Host node.

Host:	public	ref far node = ref far node(HOST_SLOT);

/*
	The node structure is the main switchboard for the ALYS
	kernel.  All of the other local resources of the kernel are 
	accessible through this object.  By centralizing these attributes,
	the AlysNode object can be visible to the outside world for
	network inquiries and deep system management.
 */
node:	public	type	inherit	external {
	public:

	// Clock management calls

time:			gate	() time_t =
	{
	reject(ERRINVALIDFUNC);
	}

setTime:		gate	(time_t) =
	{
	reject(ERRINVALIDFUNC);
	}

	// Network interface calls

enableNetwork:		gate	(name: [:] char, net: int, node: int) int =
	{
	reject(ERRINVALIDFUNC);
	}

defineNode:		gate	(name: [:] char) int =
	{
	reject(ERRINVALIDFUNC);
	}

	// Driver management calls

loadDriver:		gate	(cmd: [:] char, args: [:] char) int =
	{
	reject(ERRINVALIDFUNC);
	}

unloadDriver:		gate	(i: int) int =
	{
	reject(ERRINVALIDFUNC);
	}

	// Process management calls

spawn:			gate	(cmd: [:] char, args: [:] char) 
							ref far external =
	{
	reject(ERRINVALIDFUNC);
	}

spawnDebug:		gate	(cmd: [:] char, args: [:] char) 
							debug_t =
	{
	reject(ERRINVALIDFUNC);
	}

nullDebug:		gate	() debug_t =
	{
	reject(ERRINVALIDFUNC);
	}

	// Information reporting calls

describe:		gate	() node_t =
	{
	reject(ERRINVALIDFUNC);
	}

getArena:		gate	(aid: int) arena_t =
	{
	reject(ERRINVALIDFUNC);
	}

getObject:		gate	(oid: ref far external) object_t =
	{
	reject(ERRINVALIDFUNC);
	}

getObjectName:		gate	(oid: ref far external) [] char = 
	{
	reject(ERRINVALIDFUNC);
	}

getMessage:		gate	(mid: messageId) message_t =
	{
	reject(ERRINVALIDFUNC);
	}

getProcess:		gate	(pid: int) process_t =
	{
	reject(ERRINVALIDFUNC);
	}

getDriver:		gate	(drid: int) driver_t =
	{
	reject(ERRINVALIDFUNC);
	}

getInterruptVector:	gate	(vid: int) interruptVector_t =
	{
	reject(ERRINVALIDFUNC);
	}

getSegment:		gate	(sid: int) segment_t =
	{
	reject(ERRINVALIDFUNC);
	}

getRoute:		gate	(rid: int) route_t =
	{
	reject(ERRINVALIDFUNC);
	}

	};

job:	public	type	inherit	external	{
	public:

broadcastAttention:	gate	() =
	{
	reject(ERRINVALIDFUNC);
	}

	};

newJob:	public	() ref far job =
	{
	_emit(0x9a, _null, _GDT_NEWJOB);
	}

myJob:	public	() ref far job =
	{
	_emit(0x9a, _null, _GDT_MYJOB);
	}
/*
process:	public	type	inherit	external {
	public:

	// Debugging interface

debug:			gate	() debug_t =
	{
	reject(ERRINVALIDFUNC);
	}

setRegisters:		gate	(task_t) int =
	{
	reject(ERRINVALIDFUNC);
	}

run:			gate	() state_t =
	{
	reject(ERRINVALIDFUNC);
	}

singleStep:		gate	() state_t =
	{
	reject(ERRINVALIDFUNC);
	}

flush:			gate	() int =
	{
	reject(ERRINVALIDFUNC);
	}

	// Process management functions

kill:			gate	() int =
	{
	reject(ERRINVALIDFUNC);
	}

	// Information reporting functions

describe:		gate	() process_t =
	{
	reject(ERRINVALIDFUNC);
	}

	};
 */
/*
segment:	public	type	inherit	external {
	public:

read:			gate	() [:] byte =
	{
	reject(ERRINVALIDFUNC);
	}

write:			gate	([:] byte) int =
	{
	reject(ERRINVALIDFUNC);
	}

seek:			gate	(long, seek_t) long =
	{
	reject(ERRINVALIDFUNC);
	}

exchangeByte:		gate	(location: vaddr_t, value: byte) unsigned =
	{
	reject(ERRINVALIDFUNC);
	}

fetchByte:		gate	(location: vaddr_t) unsigned =
	{
	reject(ERRINVALIDFUNC);
	}

describe:		gate	() segment_t =
	{
	reject(ERRINVALIDFUNC);
	}

	};
 */
node_t:	public	type	packed	{
	public:

	kernelVersion:	unsigned[16];
	name:		[33] char;
			byte;

	root:		ref far directory;

	userTime:	tick_t;
	sysTime:	tick_t;
	idleTime:	tick_t;

	diskRetries:	long;
	cacheHits:	long;
	cacheMisses:	long;

	availableRAM:	paddr_t;
	diskCache:	paddr_t;
	kernelCode:	paddr_t;
	kernelData:	paddr_t;
	dosMemory:	paddr_t;
	netBuffers:	paddr_t;
	};

arena_t:	public	type	packed	{
	};

object_t:	public	type	packed	{
	public:

	me:		ref far external;
	parent:		ref far external;
	myJob:		ref far external;
	user:		userId;
	group:		userId;
	jobRights:	accessRights_t;
	userRights:	accessRights_t;
	groupRights:	accessRights_t;
	worldRights:	accessRights_t;
	useCount:	int;
	isKernel:	boolean;
	alertable:	boolean;
	};

message_t:	public	type	packed	{
	};

driver_t:	public	type	packed	{
	};

process_t:	public	type	packed	{
	public:
	status:		pStatus_t;
	pid:		int;
	parent:		ref far external;
	basepriority:	priority_t;
	priority:	priority_t;
	exitStatus:	unsigned;
	times:		processTimes_t;
	childtimes:	processTimes_t;
//	code:		ref far segment;
//	data:		ref far segment;
	context:	ref far directory;
	};

processTimes_t:	public	type	packed	{ public:
	user:	tick_t;
	kernel:	tick_t;
	};

	/* Process priorities */

priority_t:	public	type    byte = {

	PR_NORMAL	= 35,	/* Normal user priority */

	PR_LOW		= 50,	/* Lowest system priority */

	PR_SWAPPER	= 78,	/* Swapper wait */

	PR_HIGH		= 80,	/* Unbreakable priorities */

	PR_DEVICE	= 90
	};

route_t:	public	type	packed	{
	public:
	name:		[33] char;
	state:		rState_t;
	hwa:		hwa_t;
	root:		ref far directory;
	};

debug_t:	public	type	packed	{
	public:
	proc:		ref far external;
	pid:		processId;
//	code:		ref far segment;
//	data:		ref far segment;
//	state:		state_t;
	task:		task_t;
	};
/*
state_t:	public	type	packed	{
	public:

	state:		dState_t;
			[3] byte;
	errorCode:	int;
	task:		task_t;
	};
 */
segment_t:	public	type	packed	{
	public:
	address:	vaddr_t;
	length:		vaddr_t;
	isCode:		boolean;
	status:		sStatus_t;
	};

pDisposition_t:	public	type	byte = {
	D_INCORE	= 0x01,
	D_IO		= 0x02,
	D_GIVEN		= 0x20,
	D_KILLABLE	= 0x80,
	};

pStatus_t:	public	type	byte = {
	PFREE,
	PNEW,
	PRUN,
	PSPIN,
	PWAIT,
	PDEAD,
	PSTOP,
	PINVALID
	};

processId:	public	type	unsigned[16];
userId:		public	type	unsigned[16];

MAX_HWA:	const	int = 14;

hwa_t:		public	type	{
	public:
	length:		char;
	address:	[MAX_HWA] byte;
	};

rState_t:	public	type	char = {
	ND_UNUSED,
	ND_UNKNOWN,
	ND_DOWN,
	ND_UP
	};
/*
dState_t:	public	type	byte =
	{
	DEB_STEP,			// after single step
	DEB_NEW,			// at start of debug session
	DEB_DEAD,			// after exit call
	DEB_BKPT,			// after break point was hit
	DEB_SIG,			// after signal raised
	DEB_TRAP,			// after hardware trap
	DEB_POSTMORTEM			// core dump
	};
 */
sStatus_t:	public	type	byte = {
	SG_INCORE	= 0x01,
	SG_LOCK		= 0x02
	};

seek_t:	public	type	byte = {
	SEEK_ABS,			// absolute seek
	SEEK_CUR,			// relative to current loc
	SEEK_END			// relative to end
	};

forkArena:	public	() int =
	{
	_emit(0x9a, _null, _GDT_FORKARENA);
	}

discardArena:	public	() int =
	{
	_emit(0x9a, _null, _GDT_DISCARDARENA);
	}
